/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.buffer.ByteBufUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpTLSTest;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.Assume;
import org.junit.Test;

public class Http1xTLSTest
extends HttpTLSTest {
    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTPS_PORT).setSsl(true);
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return new HttpClientOptions().setSsl(true).setProtocolVersion(HttpVersion.HTTP_1_1);
    }

    @Test
    public void testAlpn() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).serverUsesAlpn().clientUsesAlpn().pass();
    }

    @Test
    public void testClearClientRequestOptionsSetSSL() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTPS_PORT)).setURI("some-uri").setSsl(Boolean.valueOf(true));
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).requestOptions(options).pass();
    }

    @Test
    public void testSSLClientRequestOptionsSetSSL() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTPS_PORT)).setURI("some-uri").setSsl(Boolean.valueOf(true));
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).requestOptions(options).pass();
    }

    @Test
    public void testClearClientRequestOptionsSetClear() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(Integer.valueOf(DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(false));
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).serverSSL(false).requestOptions(options).pass();
    }

    @Test
    public void testSSLClientRequestOptionsSetClear() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(Integer.valueOf(DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(false));
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).serverSSL(false).requestOptions(options).pass();
    }

    @Test
    public void testClearClientRequestAbsSetSSL() throws Exception {
        String absoluteURI = "https://" + DEFAULT_HTTPS_HOST_AND_PORT + "/" + "some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).requestProvider(c -> c.request(new RequestOptions().setMethod(HttpMethod.POST).setAbsoluteURI(absoluteURI))).pass();
    }

    @Test
    public void testSSLClientRequestAbsSetSSL() throws Exception {
        String absoluteURI = "https://" + DEFAULT_HTTPS_HOST_AND_PORT + "/" + "some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).requestProvider(c -> c.request(new RequestOptions().setMethod(HttpMethod.POST).setAbsoluteURI(absoluteURI))).pass();
    }

    @Test
    public void testClearClientRequestAbsSetClear() throws Exception {
        String absoluteURI = "http://" + DEFAULT_HTTPS_HOST_AND_PORT + "/" + "some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).serverSSL(false).requestProvider(c -> c.request(new RequestOptions().setMethod(HttpMethod.POST).setAbsoluteURI(absoluteURI))).pass();
    }

    @Test
    public void testSSLClientRequestAbsSetClear() throws Exception {
        String absoluteURI = "http://" + DEFAULT_HTTPS_HOST_AND_PORT + "/" + "some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).serverSSL(false).requestProvider(c -> c.request(new RequestOptions().setMethod(HttpMethod.POST).setAbsoluteURI(absoluteURI))).pass();
    }

    @Test
    public void testRedirectToSSL() throws Exception {
        this.startServer(redirectServer);
        try (HttpServer redirectServer = this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(DEFAULT_HTTP_PORT)).requestHandler(req -> req.response().setStatusCode(303).putHeader("location", "https://" + DEFAULT_HTTPS_HOST_AND_PORT + "/" + "some-uri").end());){
            RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(Integer.valueOf(DEFAULT_HTTP_PORT));
            this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).serverSSL(true).requestOptions(options).followRedirects(true).pass();
        }
    }

    @Test
    public void testRedirectFromSSL() throws Exception {
        this.startServer(redirectServer);
        try (HttpServer redirectServer = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()).setHost("localhost").setPort(DEFAULT_HTTP_PORT)).requestHandler(req -> req.response().setStatusCode(303).putHeader("location", "http://" + DEFAULT_HTTPS_HOST_AND_PORT + "/" + "some-uri").end());){
            RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(Integer.valueOf(DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(false));
            this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.NONE, Trust.NONE).clientSSL(true).serverSSL(false).requestOptions(options).followRedirects(true).pass();
        }
    }

    @Test
    public void testAppendToHttpChunks() throws Exception {
        List<String> expected = Arrays.asList("chunk-1", "chunk-2", "chunk-3");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()).setHost("localhost").setPort(DEFAULT_HTTPS_PORT)).requestHandler(req -> {
            HttpServerResponse resp = req.response().setChunked(true);
            expected.forEach(arg_0 -> ((HttpServerResponse)resp).write(arg_0));
            resp.end();
        });
        this.startServer(this.server);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(true).setTrustAll(true));
        this.client.request(HttpMethod.GET, DEFAULT_HTTPS_PORT, "localhost", "some-uri", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            ArrayList chunks = new ArrayList();
            resp.handler(chunk -> {
                chunk.appendString("-suffix");
                chunks.add(chunk.toString());
            });
            resp.endHandler(v -> {
                this.assertEquals(expected.stream().map(s -> s + "-suffix").collect(Collectors.toList()), chunks);
                this.testComplete();
            });
        }))));
        this.await();
    }

    @Test
    public void testSharedServer() throws Exception {
        int num = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE;
        Assume.assumeTrue((num > 1 ? 1 : 0) != 0);
        final List<String> expected = Arrays.asList("chunk-1", "chunk-2", "chunk-3");
        HttpClientOptions options = new HttpClientOptions().setEnabledSecureTransportProtocols(Collections.singleton("TLSv1.2")).setMaxPoolSize(num).setSsl(true).setTrustAll(true);
        this.client.close();
        this.client = this.vertx.createHttpClient(options);
        AtomicInteger connCount = new AtomicInteger();
        List sessionIds = Collections.synchronizedList(new ArrayList());
        this.client.connectionHandler(conn -> {
            sessionIds.add(ByteBufUtil.hexDump((byte[])conn.sslSession().getId()));
            connCount.incrementAndGet();
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.vertx.deployVerticle(() -> new AbstractVerticle(){
            HttpServer server;

            public void start(Promise<Void> startPromise) {
                this.server = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()).setHost("localhost").setPort(HttpTestBase.DEFAULT_HTTPS_PORT)).requestHandler(req -> {
                    HttpServerResponse resp = req.response().setChunked(true);
                    expected.forEach(arg_0 -> ((HttpServerResponse)resp).write(arg_0));
                    resp.end();
                });
                this.server.listen(HttpTestBase.DEFAULT_HTTPS_PORT, "localhost").mapEmpty().onComplete(startPromise);
            }
        }, new DeploymentOptions().setInstances(num), this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        CountDownLatch connectionLatch = new CountDownLatch(num);
        for (int i = 0; i < num; ++i) {
            this.client.request(HttpMethod.GET, DEFAULT_HTTPS_PORT, "localhost", "some-uri").onComplete(this.onSuccess(request -> connectionLatch.countDown()));
            if (i != 0) continue;
            Http1xTLSTest.waitUntil(() -> connectionLatch.getCount() == (long)(num - 1));
        }
        this.awaitLatch(connectionLatch);
        this.assertEquals(num, sessionIds.size());
        this.assertEquals(1L, new HashSet(sessionIds).size());
    }
}

