/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpTest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.Http1xOrH2CHandler;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xUpgradeToH2CHandler;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.CheckingSender;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.TestUtils;
import io.vertx.test.tls.Cert;
import io.vertx.test.verticles.SimpleServer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class Http1xTest
extends HttpTest {
    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host0\n127.0.0.1 host1\n127.0.0.1 host2\n"));
        return options;
    }

    @Test
    public void testClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals((Object)TimeUnit.SECONDS, (Object)options.getIdleTimeoutUnit());
        this.assertEquals(options, options.setIdleTimeout(10));
        this.assertEquals(options, options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS));
        this.assertEquals(10L, options.getIdleTimeout());
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getIdleTimeoutUnit());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertFalse(options.isTrustAll());
        this.assertEquals(options, options.setTrustAll(true));
        this.assertTrue(options.isTrustAll());
        this.assertTrue(options.isVerifyHost());
        this.assertEquals(options, options.setVerifyHost(false));
        this.assertFalse(options.isVerifyHost());
        this.assertEquals(5L, options.getMaxPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxPoolSize(rand));
        this.assertEquals(rand, options.getMaxPoolSize());
        TestUtils.assertIllegalArgumentException(() -> options.setMaxPoolSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setMaxPoolSize(-1));
        this.assertTrue(options.isKeepAlive());
        this.assertEquals(options, options.setKeepAlive(false));
        this.assertFalse(options.isKeepAlive());
        this.assertFalse(options.isPipelining());
        this.assertEquals(options, options.setPipelining(true));
        this.assertTrue(options.isPipelining());
        this.assertEquals(10L, options.getPipeliningLimit());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setPipeliningLimit(rand));
        this.assertEquals(rand, options.getPipeliningLimit());
        TestUtils.assertIllegalArgumentException(() -> options.setPipeliningLimit(0));
        TestUtils.assertIllegalArgumentException(() -> options.setPipeliningLimit(-1));
        this.assertEquals(1L, options.getHttp2MaxPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2MaxPoolSize(rand));
        this.assertEquals(rand, options.getHttp2MaxPoolSize());
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2MaxPoolSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2MaxPoolSize(-1));
        this.assertEquals(-1L, options.getHttp2MultiplexingLimit());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2MultiplexingLimit(rand));
        this.assertEquals(rand, options.getHttp2MultiplexingLimit());
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2MultiplexingLimit(0));
        this.assertEquals(options, options.setHttp2MultiplexingLimit(-1));
        this.assertEquals(-1L, options.getHttp2MultiplexingLimit());
        this.assertEquals(65536L, options.getHttp2UpgradeMaxContentLength());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2UpgradeMaxContentLength(rand));
        this.assertEquals(rand, options.getHttp2UpgradeMaxContentLength());
        this.assertEquals(options, options.setHttp2UpgradeMaxContentLength(-1));
        this.assertEquals(-1L, options.getHttp2UpgradeMaxContentLength());
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(rand));
        this.assertEquals(rand, options.getHttp2ConnectionWindowSize());
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(-1));
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        this.assertEquals(60000L, options.getConnectTimeout());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setConnectTimeout(rand));
        this.assertEquals(rand, options.getConnectTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setConnectTimeout(-2));
        this.assertFalse(options.isDecompressionSupported());
        this.assertEquals(options, options.setDecompressionSupported(true));
        this.assertEquals(true, options.isDecompressionSupported());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(HttpVersion.HTTP_1_1, options.getProtocolVersion());
        this.assertEquals(options, options.setProtocolVersion(HttpVersion.HTTP_1_0));
        this.assertEquals(HttpVersion.HTTP_1_0, options.getProtocolVersion());
        TestUtils.assertIllegalArgumentException(() -> options.setProtocolVersion(null));
        this.assertEquals(8192L, options.getMaxChunkSize());
        this.assertEquals(options, options.setMaxChunkSize(100));
        this.assertEquals(100L, options.getMaxChunkSize());
        this.assertEquals(4096L, options.getMaxInitialLineLength());
        this.assertEquals(options, options.setMaxInitialLineLength(100));
        this.assertEquals(100L, options.getMaxInitialLineLength());
        this.assertEquals(8192L, options.getMaxHeaderSize());
        this.assertEquals(options, options.setMaxHeaderSize(100));
        this.assertEquals(100L, options.getMaxHeaderSize());
        this.assertEquals(-1L, options.getMaxWaitQueueSize());
        this.assertEquals(options, options.setMaxWaitQueueSize(100));
        this.assertEquals(100L, options.getMaxWaitQueueSize());
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        this.assertEquals(new Http2Settings(), options.getInitialSettings());
        this.assertEquals(options, options.setInitialSettings(initialSettings));
        this.assertEquals(initialSettings, options.getInitialSettings());
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setJdkSslEngineOptions(new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.HTTP_1_1);
        this.assertEquals(HttpClientOptions.DEFAULT_ALPN_VERSIONS, options.getAlpnVersions());
        this.assertEquals(options, options.setAlpnVersions(alpnVersions));
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(true, options.isHttp2ClearTextUpgrade());
        this.assertEquals(options, options.setHttp2ClearTextUpgrade(false));
        this.assertEquals(false, options.isHttp2ClearTextUpgrade());
        this.assertEquals(null, options.getLocalAddress());
        this.assertEquals(false, options.isSendUnmaskedFrames());
        this.assertEquals(options, options.setSendUnmaskedFrames(true));
        this.assertEquals(true, options.isSendUnmaskedFrames());
        this.assertEquals(128L, options.getDecoderInitialBufferSize());
        this.assertEquals(options, options.setDecoderInitialBufferSize(256));
        this.assertEquals(256L, options.getDecoderInitialBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setDecoderInitialBufferSize(-1));
        this.assertEquals(60L, options.getKeepAliveTimeout());
        this.assertEquals(options, options.setKeepAliveTimeout(10));
        this.assertEquals(10L, options.getKeepAliveTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setKeepAliveTimeout(-1));
        this.assertEquals(60L, options.getHttp2KeepAliveTimeout());
        this.assertEquals(options, options.setHttp2KeepAliveTimeout(10));
        this.assertEquals(10L, options.getHttp2KeepAliveTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2KeepAliveTimeout(-1));
    }

    @Test
    public void testServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(10));
        this.assertEquals(10L, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(-1L, options.getAcceptBacklog());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setAcceptBacklog(rand));
        this.assertEquals(rand, options.getAcceptBacklog());
        this.assertFalse(options.isCompressionSupported());
        this.assertEquals(options, options.setCompressionSupported(true));
        this.assertTrue(options.isCompressionSupported());
        this.assertEquals(65536L, options.getMaxWebSocketFrameSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxWebSocketFrameSize(rand));
        this.assertEquals(rand, options.getMaxWebSocketFrameSize());
        this.assertEquals(80L, options.getPort());
        this.assertEquals(options, options.setPort(1234));
        this.assertEquals(1234L, options.getPort());
        TestUtils.assertIllegalArgumentException(() -> options.setPort(65536));
        this.assertEquals("0.0.0.0", options.getHost());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHost(randString));
        this.assertEquals(randString, options.getHost());
        this.assertNull(options.getWebSocketSubProtocols());
        this.assertEquals(options, options.setWebSocketSubProtocols(Collections.singletonList("foo")));
        this.assertEquals(Collections.singletonList("foo"), options.getWebSocketSubProtocols());
        HttpServerOptions optionsCopy = new HttpServerOptions(options);
        this.assertEquals(options.toJson(), optionsCopy.setWebSocketSubProtocols(options.getWebSocketSubProtocols()).toJson());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertFalse(options.isHandle100ContinueAutomatically());
        this.assertEquals(options, options.setHandle100ContinueAutomatically(true));
        this.assertTrue(options.isHandle100ContinueAutomatically());
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setJdkSslEngineOptions(new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        this.assertEquals(new Http2Settings().setMaxConcurrentStreams(100L), options.getInitialSettings());
        this.assertEquals(options, options.setInitialSettings(initialSettings));
        this.assertEquals(initialSettings, options.getInitialSettings());
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.HTTP_1_1);
        this.assertEquals(HttpServerOptions.DEFAULT_ALPN_VERSIONS, options.getAlpnVersions());
        this.assertEquals(options, options.setAlpnVersions(alpnVersions));
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(rand));
        this.assertEquals(rand, options.getHttp2ConnectionWindowSize());
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(-1));
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        this.assertFalse(options.isDecompressionSupported());
        this.assertEquals(options, options.setDecompressionSupported(true));
        this.assertTrue(options.isDecompressionSupported());
        this.assertEquals(128L, options.getDecoderInitialBufferSize());
        this.assertEquals(options, options.setDecoderInitialBufferSize(256));
        this.assertEquals(256L, options.getDecoderInitialBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setDecoderInitialBufferSize(-1));
    }

    @Test
    public void testCopyClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        KeyCertOptions keyCertOptions = TestUtils.randomKeyCertOptions();
        TrustOptions trustOptions = TestUtils.randomTrustOptions();
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int keepAliveTimeout = TestUtils.randomPositiveInt();
        int http2KeepAliveTimeout = TestUtils.randomPositiveInt();
        boolean verifyHost = rand.nextBoolean();
        int maxPoolSize = TestUtils.randomPositiveInt();
        boolean keepAlive = rand.nextBoolean();
        boolean pipelining = rand.nextBoolean();
        int pipeliningLimit = TestUtils.randomPositiveInt();
        int http2MaxPoolSize = TestUtils.randomPositiveInt();
        int http2MultiplexingLimit = TestUtils.randomPositiveInt();
        int http2ConnectionWindowSize = TestUtils.randomPositiveInt();
        int http2UpgradeMaxContentLength = TestUtils.randomPositiveInt();
        boolean decompressionSupported = rand.nextBoolean();
        HttpVersion protocolVersion = HttpVersion.HTTP_1_0;
        int maxChunkSize = TestUtils.randomPositiveInt();
        int maxInitialLineLength = TestUtils.randomPositiveInt();
        int maxHeaderSize = TestUtils.randomPositiveInt();
        int maxWaitQueueSize = TestUtils.randomPositiveInt();
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean h2cUpgrade = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        boolean sendUnmaskedFrame = rand.nextBoolean();
        String localAddress = TestUtils.randomAlphaString(10);
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setSsl(ssl);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setIdleTimeout(idleTimeout);
        options.setKeyCertOptions(keyCertOptions);
        options.setTrustOptions(trustOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.setConnectTimeout(connectTimeout);
        options.setTrustAll(trustAll);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setVerifyHost(verifyHost);
        options.setMaxPoolSize(maxPoolSize);
        options.setKeepAlive(keepAlive);
        options.setPipelining(pipelining);
        options.setPipeliningLimit(pipeliningLimit);
        options.setHttp2MaxPoolSize(http2MaxPoolSize);
        options.setHttp2MultiplexingLimit(http2MultiplexingLimit);
        options.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
        options.setDecompressionSupported(decompressionSupported);
        options.setProtocolVersion(protocolVersion);
        options.setMaxChunkSize(maxChunkSize);
        options.setMaxInitialLineLength(maxInitialLineLength);
        options.setMaxHeaderSize(maxHeaderSize);
        options.setMaxWaitQueueSize(maxWaitQueueSize);
        options.setInitialSettings(initialSettings);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setAlpnVersions(alpnVersions);
        options.setHttp2ClearTextUpgrade(h2cUpgrade);
        options.setLocalAddress(localAddress);
        options.setSendUnmaskedFrames(sendUnmaskedFrame);
        options.setDecoderInitialBufferSize(decoderInitialBufferSize);
        options.setKeepAliveTimeout(keepAliveTimeout);
        options.setHttp2KeepAliveTimeout(http2KeepAliveTimeout);
        options.setHttp2UpgradeMaxContentLength(http2UpgradeMaxContentLength);
        HttpClientOptions copy = new HttpClientOptions(options);
        this.checkCopyHttpClientOptions(options, copy);
        HttpClientOptions copy2 = new HttpClientOptions(options.toJson());
        this.checkCopyHttpClientOptions(options, copy2);
    }

    private void checkCopyHttpClientOptions(HttpClientOptions options, HttpClientOptions copy) {
        this.assertEquals(options.toJson(), copy.toJson());
        this.assertNotSame(options.getKeyCertOptions(), copy.getKeyCertOptions());
        this.assertNotSame(options.getTrustOptions(), copy.getTrustOptions());
        if (copy.getTrustOptions() instanceof PemTrustOptions) {
            this.assertEquals(((PemTrustOptions)options.getTrustOptions()).getCertValues(), ((PemTrustOptions)copy.getTrustOptions()).getCertValues());
        } else if (copy.getTrustOptions() instanceof JksOptions) {
            JksOptions a = (JksOptions)options.getTrustOptions();
            JksOptions b = (JksOptions)copy.getTrustOptions();
            this.assertEquals(a.getPath(), b.getPath());
            this.assertEquals(a.getPassword(), b.getPassword());
            this.assertEquals(a.getValue(), b.getValue());
        } else if (copy.getTrustOptions() instanceof PfxOptions) {
            PfxOptions a = (PfxOptions)options.getTrustOptions();
            PfxOptions b = (PfxOptions)copy.getTrustOptions();
            this.assertEquals(a.getPath(), b.getPath());
            this.assertEquals(a.getPassword(), b.getPassword());
            this.assertEquals(a.getValue(), b.getValue());
        }
    }

    @Test
    public void testDefaultClientOptionsJson() {
        HttpClientOptions def = new HttpClientOptions();
        HttpClientOptions json = new HttpClientOptions(new JsonObject());
        this.assertEquals(def.getMaxPoolSize(), json.getMaxPoolSize());
        this.assertEquals(def.isKeepAlive(), json.isKeepAlive());
        this.assertEquals(def.isPipelining(), json.isPipelining());
        this.assertEquals(def.getPipeliningLimit(), json.getPipeliningLimit());
        this.assertEquals(def.getHttp2MaxPoolSize(), json.getHttp2MaxPoolSize());
        this.assertEquals(def.getHttp2MultiplexingLimit(), json.getHttp2MultiplexingLimit());
        this.assertEquals(def.getHttp2ConnectionWindowSize(), json.getHttp2ConnectionWindowSize());
        this.assertEquals(def.isVerifyHost(), json.isVerifyHost());
        this.assertEquals(def.isDecompressionSupported(), json.isDecompressionSupported());
        this.assertEquals(def.isTrustAll(), json.isTrustAll());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getConnectTimeout(), json.getConnectTimeout());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.getProtocolVersion(), json.getProtocolVersion());
        this.assertEquals(def.getMaxWaitQueueSize(), json.getMaxWaitQueueSize());
        this.assertEquals(def.getMaxChunkSize(), json.getMaxChunkSize());
        this.assertEquals(def.getMaxInitialLineLength(), json.getMaxInitialLineLength());
        this.assertEquals(def.getMaxHeaderSize(), json.getMaxHeaderSize());
        this.assertEquals(def.getInitialSettings(), json.getInitialSettings());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.getAlpnVersions(), json.getAlpnVersions());
        this.assertEquals(def.isHttp2ClearTextUpgrade(), json.isHttp2ClearTextUpgrade());
        this.assertEquals(def.getLocalAddress(), json.getLocalAddress());
        this.assertEquals(def.getDecoderInitialBufferSize(), json.getDecoderInitialBufferSize());
        this.assertEquals(def.getKeepAliveTimeout(), json.getKeepAliveTimeout());
        this.assertEquals(def.getHttp2KeepAliveTimeout(), json.getHttp2KeepAliveTimeout());
        this.assertEquals(def.getHttp2UpgradeMaxContentLength(), json.getHttp2UpgradeMaxContentLength());
    }

    @Test
    public void testClientOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        boolean verifyHost = rand.nextBoolean();
        int maxPoolSize = TestUtils.randomPositiveInt();
        boolean keepAlive = rand.nextBoolean();
        boolean pipelining = rand.nextBoolean();
        int pipeliningLimit = TestUtils.randomPositiveInt();
        int http2MaxPoolSize = TestUtils.randomPositiveInt();
        int http2MultiplexingLimit = TestUtils.randomPositiveInt();
        int http2ConnectionWindowSize = TestUtils.randomPositiveInt();
        boolean decompressionSupported = rand.nextBoolean();
        HttpVersion protocolVersion = HttpVersion.HTTP_1_1;
        int maxChunkSize = TestUtils.randomPositiveInt();
        int maxInitialLineLength = TestUtils.randomPositiveInt();
        int maxHeaderSize = TestUtils.randomPositiveInt();
        int maxWaitQueueSize = TestUtils.randomPositiveInt();
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean h2cUpgrade = rand.nextBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        String localAddress = TestUtils.randomAlphaString(10);
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        int keepAliveTimeout = TestUtils.randomPositiveInt();
        int http2KeepAliveTimeout = TestUtils.randomPositiveInt();
        int http2UpgradeMaxContentLength = TestUtils.randomPositiveInt();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", (Object)sendBufferSize).put("receiveBufferSize", (Object)receiverBufferSize).put("reuseAddress", (Object)reuseAddress).put("trafficClass", (Object)trafficClass).put("tcpNoDelay", (Object)tcpNoDelay).put("tcpKeepAlive", (Object)tcpKeepAlive).put("soLinger", (Object)soLinger).put("idleTimeout", (Object)idleTimeout).put("ssl", (Object)ssl).put("enabledCipherSuites", (Object)new JsonArray().add((Object)enabledCipher)).put("connectTimeout", (Object)connectTimeout).put("trustAll", (Object)trustAll).put("crlPaths", (Object)new JsonArray().add((Object)crlPath)).put("keyStoreOptions", (Object)new JsonObject().put("password", (Object)ksPassword).put("path", (Object)ksPath)).put("trustStoreOptions", (Object)new JsonObject().put("password", (Object)tsPassword).put("path", (Object)tsPath)).put("verifyHost", (Object)verifyHost).put("maxPoolSize", (Object)maxPoolSize).put("keepAlive", (Object)keepAlive).put("pipelining", (Object)pipelining).put("pipeliningLimit", (Object)pipeliningLimit).put("http2MaxPoolSize", (Object)http2MaxPoolSize).put("http2MultiplexingLimit", (Object)http2MultiplexingLimit).put("http2ConnectionWindowSize", (Object)http2ConnectionWindowSize).put("decompressionSupported", (Object)decompressionSupported).put("protocolVersion", (Object)protocolVersion.name()).put("maxChunkSize", (Object)maxChunkSize).put("maxInitialLineLength", (Object)maxInitialLineLength).put("maxHeaderSize", (Object)maxHeaderSize).put("maxWaitQueueSize", (Object)maxWaitQueueSize).put("initialSettings", (Object)new JsonObject().put("pushEnabled", (Object)initialSettings.isPushEnabled()).put("headerTableSize", (Object)initialSettings.getHeaderTableSize()).put("maxHeaderListSize", (Object)initialSettings.getMaxHeaderListSize()).put("maxConcurrentStreams", (Object)initialSettings.getMaxConcurrentStreams()).put("initialWindowSize", (Object)initialSettings.getInitialWindowSize()).put("maxFrameSize", (Object)initialSettings.getMaxFrameSize())).put("useAlpn", (Object)useAlpn).put(sslEngine, (Object)new JsonObject()).put("alpnVersions", (Object)new JsonArray().add((Object)alpnVersions.get(0).name())).put("http2ClearTextUpgrade", (Object)h2cUpgrade).put("openSslSessionCacheEnabled", (Object)openSslSessionCacheEnabled).put("localAddress", (Object)localAddress).put("decoderInitialBufferSize", (Object)decoderInitialBufferSize).put("keepAliveTimeout", (Object)keepAliveTimeout).put("http2KeepAliveTimeout", (Object)http2KeepAliveTimeout).put("http2UpgradeMaxContentLength", (Object)http2UpgradeMaxContentLength);
        HttpClientOptions options = new HttpClientOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, options.getConnectTimeout());
        this.assertEquals(trustAll, options.isTrustAll());
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(verifyHost, options.isVerifyHost());
        this.assertEquals(maxPoolSize, options.getMaxPoolSize());
        this.assertEquals(keepAlive, options.isKeepAlive());
        this.assertEquals(pipelining, options.isPipelining());
        this.assertEquals(pipeliningLimit, options.getPipeliningLimit());
        this.assertEquals(http2MaxPoolSize, options.getHttp2MaxPoolSize());
        this.assertEquals(http2MultiplexingLimit, options.getHttp2MultiplexingLimit());
        this.assertEquals(http2ConnectionWindowSize, options.getHttp2ConnectionWindowSize());
        this.assertEquals(decompressionSupported, options.isDecompressionSupported());
        this.assertEquals(protocolVersion, options.getProtocolVersion());
        this.assertEquals(maxChunkSize, options.getMaxChunkSize());
        this.assertEquals(maxInitialLineLength, options.getMaxInitialLineLength());
        this.assertEquals(maxHeaderSize, options.getMaxHeaderSize());
        this.assertEquals(maxWaitQueueSize, options.getMaxWaitQueueSize());
        this.assertEquals(initialSettings, options.getInitialSettings());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(h2cUpgrade, options.isHttp2ClearTextUpgrade());
        this.assertEquals(localAddress, options.getLocalAddress());
        this.assertEquals(decoderInitialBufferSize, options.getDecoderInitialBufferSize());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", (Object)new JsonObject().put("password", (Object)ksPassword)).put("pfxTrustOptions", (Object)new JsonObject().put("password", (Object)tsPassword));
        options = new HttpClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", (Object)new JsonObject()).put("pemTrustOptions", (Object)new JsonObject());
        options = new HttpClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
        json.put("protocolVersion", (Object)"invalidProtocolVersion");
        TestUtils.assertIllegalArgumentException(() -> new HttpClientOptions(json));
        this.assertEquals(keepAliveTimeout, options.getKeepAliveTimeout());
        this.assertEquals(http2KeepAliveTimeout, options.getHttp2KeepAliveTimeout());
    }

    @Test
    public void testCopyServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        KeyCertOptions keyCertOptions = TestUtils.randomKeyCertOptions();
        TrustOptions trustOptions = TestUtils.randomTrustOptions();
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean compressionSupported = rand.nextBoolean();
        int maxWebSocketFrameSize = TestUtils.randomPositiveInt();
        List<String> wsSubProtocols = Arrays.asList(TestUtils.randomAlphaString(10));
        boolean is100ContinueHandledAutomatically = rand.nextBoolean();
        int maxChunkSize = rand.nextInt(10000);
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        int http2ConnectionWindowSize = TestUtils.randomInt();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean decompressionSupported = rand.nextBoolean();
        boolean acceptUnmaskedFrames = rand.nextBoolean();
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setIdleTimeout(idleTimeout);
        options.setSsl(ssl);
        options.setKeyCertOptions(keyCertOptions);
        options.setTrustOptions(trustOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setPort(port);
        options.setHost(host);
        options.setAcceptBacklog(acceptBacklog);
        options.setCompressionSupported(compressionSupported);
        options.setMaxWebSocketFrameSize(maxWebSocketFrameSize);
        options.setWebSocketSubProtocols(wsSubProtocols);
        options.setHandle100ContinueAutomatically(is100ContinueHandledAutomatically);
        options.setMaxChunkSize(maxChunkSize);
        options.setUseAlpn(useAlpn);
        options.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setInitialSettings(initialSettings);
        options.setAlpnVersions(alpnVersions);
        options.setDecompressionSupported(decompressionSupported);
        options.setAcceptUnmaskedFrames(acceptUnmaskedFrames);
        options.setDecoderInitialBufferSize(decoderInitialBufferSize);
        HttpServerOptions copy = new HttpServerOptions(options);
        this.checkCopyHttpServerOptions(options, copy);
        HttpServerOptions copy2 = new HttpServerOptions(options.toJson());
        this.checkCopyHttpServerOptions(options, copy2);
    }

    private void checkCopyHttpServerOptions(HttpServerOptions options, HttpServerOptions copy) {
        this.assertEquals(options.toJson(), copy.toJson());
        this.assertNotSame(options.getKeyCertOptions(), copy.getKeyCertOptions());
        this.assertNotSame(options.getTrustOptions(), copy.getTrustOptions());
        if (copy.getTrustOptions() instanceof PemTrustOptions) {
            this.assertEquals(((PemTrustOptions)options.getTrustOptions()).getCertValues(), ((PemTrustOptions)copy.getTrustOptions()).getCertValues());
        } else if (copy.getTrustOptions() instanceof JksOptions) {
            JksOptions a = (JksOptions)options.getTrustOptions();
            JksOptions b = (JksOptions)copy.getTrustOptions();
            this.assertEquals(a.getPath(), b.getPath());
            this.assertEquals(a.getPassword(), b.getPassword());
            this.assertEquals(a.getValue(), b.getValue());
        } else if (copy.getTrustOptions() instanceof PfxOptions) {
            PfxOptions a = (PfxOptions)options.getTrustOptions();
            PfxOptions b = (PfxOptions)copy.getTrustOptions();
            this.assertEquals(a.getPath(), b.getPath());
            this.assertEquals(a.getPassword(), b.getPassword());
            this.assertEquals(a.getValue(), b.getValue());
        }
    }

    @Test
    public void testDefaultServerOptionsJson() {
        HttpServerOptions def = new HttpServerOptions();
        HttpServerOptions json = new HttpServerOptions(new JsonObject());
        this.assertEquals(def.getMaxWebSocketFrameSize(), json.getMaxWebSocketFrameSize());
        this.assertEquals(def.getWebSocketSubProtocols(), json.getWebSocketSubProtocols());
        this.assertEquals(def.isCompressionSupported(), json.isCompressionSupported());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isHandle100ContinueAutomatically(), json.isHandle100ContinueAutomatically());
        this.assertEquals(def.getMaxChunkSize(), json.getMaxChunkSize());
        this.assertEquals(def.getMaxInitialLineLength(), json.getMaxInitialLineLength());
        this.assertEquals(def.getMaxHeaderSize(), json.getMaxHeaderSize());
        this.assertEquals(def.getInitialSettings(), json.getInitialSettings());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.getAlpnVersions(), json.getAlpnVersions());
        this.assertEquals(def.getHttp2ConnectionWindowSize(), json.getHttp2ConnectionWindowSize());
        this.assertEquals(def.isDecompressionSupported(), json.isDecompressionSupported());
        this.assertEquals(def.isAcceptUnmaskedFrames(), json.isAcceptUnmaskedFrames());
        this.assertEquals(def.getDecoderInitialBufferSize(), json.getDecoderInitialBufferSize());
    }

    @Test
    public void testServerOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean compressionSupported = rand.nextBoolean();
        int maxWebSocketFrameSize = TestUtils.randomPositiveInt();
        List<String> wsSubProtocols = Collections.singletonList(TestUtils.randomAlphaString(10));
        boolean is100ContinueHandledAutomatically = rand.nextBoolean();
        int maxChunkSize = rand.nextInt(10000);
        int maxInitialLineLength = rand.nextInt(10000);
        int maxHeaderSize = rand.nextInt(10000);
        HttpVersion enabledProtocol = HttpVersion.values()[rand.nextInt(HttpVersion.values().length)];
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        int http2ConnectionWindowSize = TestUtils.randomInt();
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean openSslSessionCacheEnabled = TestUtils.randomBoolean();
        boolean decompressionSupported = TestUtils.randomBoolean();
        boolean acceptUnmaskedFrames = TestUtils.randomBoolean();
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", (Object)sendBufferSize).put("receiveBufferSize", (Object)receiverBufferSize).put("reuseAddress", (Object)reuseAddress).put("trafficClass", (Object)trafficClass).put("tcpNoDelay", (Object)tcpNoDelay).put("tcpKeepAlive", (Object)tcpKeepAlive).put("soLinger", (Object)soLinger).put("idleTimeout", (Object)idleTimeout).put("ssl", (Object)ssl).put("enabledCipherSuites", (Object)new JsonArray().add((Object)enabledCipher)).put("crlPaths", (Object)new JsonArray().add((Object)crlPath)).put("keyStoreOptions", (Object)new JsonObject().put("password", (Object)ksPassword).put("path", (Object)ksPath)).put("trustStoreOptions", (Object)new JsonObject().put("password", (Object)tsPassword).put("path", (Object)tsPath)).put("port", (Object)port).put("host", (Object)host).put("acceptBacklog", (Object)acceptBacklog).put("compressionSupported", (Object)compressionSupported).put("maxWebSocketFrameSize", (Object)maxWebSocketFrameSize).put("webSocketSubProtocols", wsSubProtocols).put("handle100ContinueAutomatically", (Object)is100ContinueHandledAutomatically).put("maxChunkSize", (Object)maxChunkSize).put("maxInitialLineLength", (Object)maxInitialLineLength).put("maxHeaderSize", (Object)maxHeaderSize).put("enabledProtocols", (Object)new JsonArray().add((Object)enabledProtocol.name())).put("initialSettings", (Object)new JsonObject().put("pushEnabled", (Object)initialSettings.isPushEnabled()).put("headerTableSize", (Object)initialSettings.getHeaderTableSize()).put("maxHeaderListSize", (Object)initialSettings.getMaxHeaderListSize()).put("maxConcurrentStreams", (Object)initialSettings.getMaxConcurrentStreams()).put("initialWindowSize", (Object)initialSettings.getInitialWindowSize()).put("maxFrameSize", (Object)initialSettings.getMaxFrameSize())).put("useAlpn", (Object)useAlpn).put("http2ConnectionWindowSize", (Object)http2ConnectionWindowSize).put(sslEngine, (Object)new JsonObject()).put("alpnVersions", (Object)new JsonArray().add((Object)alpnVersions.get(0).name())).put("openSslSessionCacheEnabled", (Object)openSslSessionCacheEnabled).put("decompressionSupported", (Object)decompressionSupported).put("acceptUnmaskedFrames", (Object)acceptUnmaskedFrames).put("decoderInitialBufferSize", (Object)decoderInitialBufferSize);
        HttpServerOptions options = new HttpServerOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(port, options.getPort());
        this.assertEquals(host, options.getHost());
        this.assertEquals(acceptBacklog, options.getAcceptBacklog());
        this.assertEquals(compressionSupported, options.isCompressionSupported());
        this.assertEquals(maxWebSocketFrameSize, options.getMaxWebSocketFrameSize());
        this.assertEquals(wsSubProtocols, options.getWebSocketSubProtocols());
        this.assertEquals(is100ContinueHandledAutomatically, options.isHandle100ContinueAutomatically());
        this.assertEquals(maxChunkSize, options.getMaxChunkSize());
        this.assertEquals(maxInitialLineLength, options.getMaxInitialLineLength());
        this.assertEquals(maxHeaderSize, options.getMaxHeaderSize());
        this.assertEquals(initialSettings, options.getInitialSettings());
        this.assertEquals(useAlpn, options.isUseAlpn());
        this.assertEquals(http2ConnectionWindowSize, options.getHttp2ConnectionWindowSize());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(decompressionSupported, options.isDecompressionSupported());
        this.assertEquals(acceptUnmaskedFrames, options.isAcceptUnmaskedFrames());
        this.assertEquals(decoderInitialBufferSize, options.getDecoderInitialBufferSize());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", (Object)new JsonObject().put("password", (Object)ksPassword)).put("pfxTrustOptions", (Object)new JsonObject().put("password", (Object)tsPassword));
        options = new HttpServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", (Object)new JsonObject()).put("pemTrustOptions", (Object)new JsonObject());
        options = new HttpServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Override
    @Test
    public void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd() throws Exception {
        this.testCloseHandlerNotCalledWhenConnectionClosedAfterEnd(0);
    }

    @Test
    public void testPipeliningOrder() throws Exception {
        Assume.assumeTrue((boolean)((VertxInternal)this.vertx).transport().getClass().getName().startsWith("io.vertx.core"));
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setKeepAlive(true).setPipelining(true).setMaxPoolSize(1));
        int requests = 100;
        AtomicInteger reqCount = new AtomicInteger(0);
        this.server.requestHandler(req -> {
            this.assertSame(Vertx.currentContext(), ((HttpServerRequestInternal)req).context());
            int theCount = reqCount.get();
            this.assertEquals(theCount, Integer.parseInt(req.headers().get("count")));
            reqCount.incrementAndGet();
            req.response().setChunked(true);
            req.body().onComplete(this.onSuccess(buff -> {
                this.assertEquals("This is content " + theCount, buff.toString());
                this.vertx.setTimer(1L + (long)(10.0 * Math.random()), id -> {
                    req.response().headers().set("count", String.valueOf(theCount));
                    req.response().write(buff);
                    req.response().end();
                });
            }));
        });
        CountDownLatch latch = new CountDownLatch(requests);
        RequestOptions options = new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT);
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            int count = 0;
            while (count < requests) {
                int theCount = count++;
                this.client.request(options).onComplete(this.onSuccess(req -> {
                    req.putHeader("count", String.valueOf(theCount));
                    req.send(Buffer.buffer((String)("This is content " + theCount)), this.onSuccess(resp -> {
                        this.assertEquals(theCount, Integer.parseInt(resp.headers().get("count")));
                        resp.body().onComplete(this.onSuccess(buff -> {
                            this.assertEquals("This is content " + theCount, buff.toString());
                            latch.countDown();
                        }));
                    }));
                }));
            }
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPipeliningLimit() throws Exception {
        int limit = 25;
        int requests = limit * 4;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setPipeliningLimit(limit).setMaxPoolSize(1));
        AtomicInteger count = new AtomicInteger();
        String data = "GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n";
        NetServer server = this.vertx.createNetServer(new NetServerOptions().setPort(DEFAULT_HTTP_PORT).setHost("localhost"));
        server.connectHandler(so -> {
            StringBuilder total = new StringBuilder();
            so.handler(buff -> {
                total.append(buff);
                while (total.indexOf(data) == 0) {
                    total.delete(0, data.length());
                    if (count.incrementAndGet() != limit) continue;
                    this.vertx.setTimer(100L, timerID -> {
                        this.assertEquals(limit, count.get());
                        count.set(0);
                        for (int i = 0; i < limit; ++i) {
                            so.write("HTTP/1.1 200 OK\r\nContent-Length : 0\r\n\r\n");
                        }
                    });
                }
            });
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        server.listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        AtomicInteger responses = new AtomicInteger();
        for (int i = 0; i < requests; ++i) {
            this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                if (responses.incrementAndGet() == requests) {
                    this.testComplete();
                }
            }));
        }
        this.await();
    }

    @Test
    @Repeat(times=10)
    public void testCloseServerConnectionWithPendingMessages() throws Exception {
        AtomicBoolean completed = new AtomicBoolean();
        int n = 5;
        this.server.requestHandler(req -> this.vertx.setTimer(100L, id -> req.response().close()));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.httpClientBuilder().with(this.createBaseClientOptions().setMaxPoolSize(n).setPipelining(true)).withConnectHandler(conn -> conn.closeHandler(v -> {
            if (completed.compareAndSet(false, true)) {
                this.testComplete();
            }
        })).build();
        for (int i = 0; i < n * 2; ++i) {
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onFailure(resp -> {}));
        }
        this.await();
    }

    @Test
    public void testPipeliningFailure() throws Exception {
        int n = 5;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setPipeliningLimit(n).setMaxPoolSize(1));
        AtomicBoolean first = new AtomicBoolean(true);
        CompletableFuture latch = new CompletableFuture();
        this.server.requestHandler(req -> {
            if (first.compareAndSet(true, false)) {
                latch.whenComplete((v, err) -> req.response().close());
            } else {
                req.response().end();
            }
        });
        this.startServer(this.testAddress);
        AtomicInteger succeeded = new AtomicInteger();
        CopyOnWriteArrayList requests = new CopyOnWriteArrayList();
        Consumer<HttpClientRequest> checkEnd = req -> {
            requests.remove(req);
            if (requests.isEmpty() && succeeded.get() == n) {
                this.testComplete();
            }
        };
        for (int i = 0; i < n * 2; ++i) {
            boolean countDown = i + 1 == n;
            this.client.request(new RequestOptions(this.requestOptions).setURI("/" + i)).onComplete(this.onSuccess(req -> {
                req.send(ar -> {
                    if (ar.succeeded()) {
                        succeeded.incrementAndGet();
                    }
                    checkEnd.accept((HttpClientRequest)req);
                });
                requests.add(req);
                if (countDown) {
                    latch.complete(null);
                }
            }));
        }
        this.await();
    }

    @Test
    public void testPipelineStress() throws Exception {
        this.vertx.exceptionHandler(err -> this.fail((Throwable)err));
        this.server.requestHandler(req -> Vertx.currentContext().runOnContext(v -> req.response().end("Hello World")));
        this.startServer(this.testAddress);
        NetClient tcpClient = this.vertx.createNetClient(new NetClientOptions().setSoLinger(0));
        int numConn = 32;
        this.waitFor(numConn);
        for (int i = 0; i < numConn; ++i) {
            tcpClient.connect(this.testAddress, this.onSuccess(so -> {
                class Client {
                    private final NetSocket so;
                    private StringBuilder received;
                    private int curr;
                    private int count;
                    private boolean closed;

                    Client(NetSocket so) {
                        this.so = so;
                    }

                    private void close() {
                        this.closed = true;
                    }

                    private void receiveChunk(Buffer chunk) {
                        int c;
                        this.received.append(chunk);
                        while ((c = this.received.indexOf("\r\n\r\n", this.curr)) != -1) {
                            this.curr = c + 4;
                            ++this.count;
                        }
                        if (this.count == 16 && !this.closed) {
                            this.send();
                        }
                    }

                    private void send() {
                        this.received = new StringBuilder();
                        this.curr = 0;
                        this.count = 0;
                        for (int i = 0; i < 16; ++i) {
                            this.so.write((Object)Buffer.buffer((String)"GET / HTTP/1.1\r\ncontent-length:0\r\n\r\n"));
                        }
                    }

                    void run() {
                        this.so.handler(this::receiveChunk);
                        this.so.closeHandler(v -> {
                            this.close();
                            Http1xTest.this.complete();
                        });
                        this.send();
                        Http1xTest.this.vertx.setTimer(1000L, id -> this.so.close());
                    }
                }
                Client client = new Client((NetSocket)so);
                client.run();
            }));
        }
        this.await();
    }

    @Test
    public void testPipeliningPauseRequest() throws Exception {
        int n = 10;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setMaxPoolSize(1));
        this.server.requestHandler(req -> {
            AtomicBoolean paused = new AtomicBoolean();
            paused.set(true);
            req.pause();
            req.bodyHandler(buff -> {
                this.assertFalse(paused.get());
                req.response().end();
            });
            this.vertx.setTimer(30L, id -> {
                paused.set(false);
                req.resume();
            });
        });
        this.startServer(this.testAddress);
        AtomicInteger remaining = new AtomicInteger(n);
        for (int i = 0; i < n; ++i) {
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(Buffer.buffer((String)TestUtils.randomAlphaString(16)), this.onSuccess(resp -> resp.endHandler(v -> {
                if (remaining.decrementAndGet() == 0) {
                    this.testComplete();
                }
            })))));
        }
        this.await();
    }

    @Test
    public void testServerPipeliningConnectionConcurrency() throws Exception {
        int n = 5;
        boolean[] processing = new boolean[]{false};
        int[] count = new int[]{0};
        this.server.requestHandler(req -> {
            count[0] = count[0] + 1;
            this.assertFalse(processing[0]);
            processing[0] = true;
            this.vertx.setTimer(20L, id -> {
                processing[0] = false;
                HttpServerResponse resp = req.response();
                resp.end();
                if (count[0] == n) {
                    resp.close();
                }
            });
        });
        this.startServer(this.testAddress);
        Buffer requests = Buffer.buffer();
        for (int i = 0; i < n; ++i) {
            requests.appendString("GET some-uri HTTP/1.1\r\n\r\n");
        }
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, this.onSuccess(so -> {
            so.closeHandler(v -> this.testComplete());
            so.write((Object)requests);
        }));
        this.await();
    }

    @Test
    public void testServerConnectionCloseBeforeRequestEnded() throws Exception {
        this.testServerConnectionClose(true);
    }

    @Test
    public void testServerConnectionCloseAfterRequestEnded() throws Exception {
        this.testServerConnectionClose(false);
    }

    private void testServerConnectionClose(boolean sendEarlyResponse) throws Exception {
        CompletableFuture requestLatch = new CompletableFuture();
        this.server.requestHandler(requestLatch::complete);
        this.startServer(this.testAddress);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, this.onSuccess(so -> {
            so.write("PUT / HTTP/1.1\r\nconnection: close\r\ncontent-length: 1\r\n\r\n");
            requestLatch.whenComplete((req, err) -> {
                if (sendEarlyResponse) {
                    req.response().end();
                } else {
                    req.endHandler(v -> req.response().end());
                }
                so.write("A");
            });
            Buffer response = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)response).appendBuffer(arg_0));
            so.closeHandler(v -> {
                this.assertTrue("Expected <" + response + "> to start with HTTP/1.1 200 OK", response.toString().startsWith("HTTP/1.1 200 OK"));
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testServerConnectionCloseDoesNotProcessHTTPMessages() throws Exception {
        AtomicInteger requestCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            requestCount.incrementAndGet();
            req.response().end();
        });
        this.startServer(this.testAddress);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, this.onSuccess(so -> {
            so.write("PUT / HTTP/1.1 \r\nconnection: close\r\ncontent-length: 0\r\n\r\nPUT / HTTP/1.1 \r\ncontent-length: 0\r\n\r\n");
            Buffer response = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)response).appendBuffer(arg_0));
            so.closeHandler(v -> {
                String s = response.toString();
                String predicate = "HTTP/1.1 200 OK";
                this.assertEquals(s.indexOf(predicate), s.lastIndexOf("HTTP/1.1 200 OK"));
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testKeepAlive() throws Exception {
        this.testKeepAlive(true, 5, 10, 5);
    }

    @Test
    public void testNoKeepAlive() throws Exception {
        this.testKeepAlive(false, 5, 10, 10);
    }

    private void testKeepAlive(boolean keepAlive, int poolSize, int numServers, int expectedConnectedServers) throws Exception {
        this.client.close();
        CountDownLatch firstCloseLatch = new CountDownLatch(1);
        this.server.close(this.onSuccess(v -> firstCloseLatch.countDown()));
        this.awaitLatch(firstCloseLatch);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setKeepAlive(keepAlive).setPipelining(false).setMaxPoolSize(poolSize));
        int requests = 100;
        HttpServer[] servers = new HttpServer[numServers];
        CountDownLatch startServerLatch = new CountDownLatch(numServers);
        ConcurrentHashSet connectedServers = new ConcurrentHashSet();
        for (int i = 0; i < numServers; ++i) {
            HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(DEFAULT_HTTP_PORT));
            server.requestHandler(arg_0 -> Http1xTest.lambda$testKeepAlive$75((Set)connectedServers, server, arg_0));
            server.listen(this.testAddress, this.onSuccess(s -> startServerLatch.countDown()));
            servers[i] = server;
        }
        this.awaitLatch(startServerLatch);
        CountDownLatch reqLatch = new CountDownLatch(requests);
        this.vertx.runOnContext(v -> {
            for (int count = 0; count < requests; ++count) {
                this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    reqLatch.countDown();
                }));
            }
        });
        this.awaitLatch(reqLatch);
        this.assertEquals(expectedConnectedServers, connectedServers.size());
        CountDownLatch serverCloseLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(this.onSuccess(s -> serverCloseLatch.countDown()));
        }
        this.awaitLatch(serverCloseLatch);
    }

    @Test
    public void testPoolingKeepAliveAndPipelining() {
        this.testPooling(true, true);
    }

    @Test
    public void testPoolingKeepAliveNoPipelining() {
        this.testPooling(true, false);
    }

    @Test
    public void testPoolingNoKeepAliveNoPipelining() {
        this.testPooling(false, false);
    }

    private void testPooling(boolean keepAlive, boolean pipelining) {
        String path = "foo.txt";
        int numGets = 100;
        int maxPoolSize = 10;
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setKeepAlive(keepAlive).setPipelining(pipelining).setMaxPoolSize(maxPoolSize));
        this.server.requestHandler(req -> {
            String cnt = req.headers().get("count");
            req.response().headers().set("count", cnt);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            AtomicInteger cnt = new AtomicInteger(0);
            int i = 0;
            while (i < numGets) {
                int theCount = i++;
                this.client.request(new RequestOptions(this.requestOptions).setURI(path)).compose(req -> req.putHeader("count", String.valueOf(theCount)).send()).onComplete(this.onSuccess(resp -> {
                    resp.exceptionHandler(this::fail);
                    this.assertEquals(200L, resp.statusCode());
                    this.assertEquals(theCount, Integer.parseInt(resp.headers().get("count")));
                    if (cnt.incrementAndGet() == numGets) {
                        this.testComplete();
                    }
                }));
            }
        }));
        this.await();
    }

    @Test
    public void testPoolingNoKeepAliveAndPipelining() {
        try {
            this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false).setPipelining(true));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxWaitQueueSizeIsRespected() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setPipelining(false).setMaxWaitQueueSize(0).setMaxPoolSize(1));
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals("/1", req.path());
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setURI("/1")).onComplete(this.onSuccess(req -> this.client.request(new RequestOptions(this.requestOptions).setURI("/1")).onComplete(this.onFailure(err -> {
            req.end();
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testServerWebSocketIdleTimeout() {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setIdleTimeout(1).setPort(DEFAULT_HTTP_PORT).setHost("localhost"));
        this.server.webSocketHandler(ws -> {}).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.webSocket(DEFAULT_HTTP_PORT, "localhost", "/", this.onSuccess(ws -> ws.closeHandler(v -> this.testComplete())));
        });
        this.await();
    }

    @Test
    public void testClientWebSocketIdleTimeout() {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setIdleTimeout(1));
        this.server.webSocketHandler(ws -> {}).listen(ar -> this.client.webSocket(DEFAULT_HTTP_PORT, "localhost", "/", this.onSuccess(ws -> ws.closeHandler(v -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        this.client.close();
        this.server.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(false));
        int numServers = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE / 2 - 1;
        int numRequests = numServers * 100;
        List<HttpServer> servers = Collections.synchronizedList(new ArrayList());
        Set connectedServers = Collections.newSetFromMap(new ConcurrentHashMap());
        ConcurrentHashMap requestCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numRequests);
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        for (int i2 = 0; i2 < numServers; ++i2) {
            HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(DEFAULT_HTTP_PORT));
            servers.add(theServer);
            AtomicReference context = new AtomicReference();
            theServer.requestHandler(arg_0 -> this.lambda$testSharedServersRoundRobin$95(context, (Set)contexts, connectedServers, theServer, requestCount, latchConns, arg_0)).listen(this.testAddress, this.onSuccess(s -> {
                if (s.actualPort() > 0) {
                    this.assertEquals(DEFAULT_HTTP_PORT, s.actualPort());
                }
                latchListen.countDown();
            }));
        }
        this.awaitLatch(latchListen);
        CountDownLatch latchClient = new CountDownLatch(numRequests);
        for (int i3 = 0; i3 < numRequests; ++i3) {
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(res -> latchClient.countDown());
        }
        this.assertTrue(latchClient.await(30L, TimeUnit.SECONDS));
        this.assertTrue(latchConns.await(30L, TimeUnit.SECONDS));
        this.assertEquals(numServers, connectedServers.size());
        for (HttpServer server : servers) {
            this.assertTrue(connectedServers.contains(server));
        }
        this.assertEquals(numServers, requestCount.size());
        this.assertEquals(requestCount.values().stream().mapToInt(i -> i).sum(), numRequests);
        this.assertEquals(IntStream.range(0, requestCount.size()).mapToObj(i -> numRequests / numServers).collect(Collectors.toList()), new ArrayList(requestCount.values()));
        this.assertEquals(numServers, contexts.size());
        CountDownLatch closeLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                closeLatch.countDown();
            });
        }
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(DEFAULT_HTTP_PORT + 1));
        theServer.requestHandler(req -> this.fail("Should not process request")).listen(this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(DEFAULT_HTTP_PORT));
        theServer.requestHandler(req -> this.fail("Should not process request")).listen(this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        theServer.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        Thread.sleep(500L);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testDefaultHttpVersion() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).compose(HttpClientResponse::body).onComplete(this.onSuccess(v -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testIncorrectHttpVersion() throws Exception {
        NetServer server = this.vertx.createNetServer();
        CountDownLatch listenLatch = new CountDownLatch(1);
        server.connectHandler(so -> {
            Buffer content = Buffer.buffer();
            so.handler(buff -> {
                content.appendBuffer(buff);
                if (content.toString().endsWith("\r\n\r\n")) {
                    so.write((Object)Buffer.buffer((String)"HTTP/1.2 200 OK\r\nContent-Length:5\r\n\r\nHELLO"));
                }
            });
        }).listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        AtomicBoolean a = new AtomicBoolean();
        this.client.connectionHandler(conn -> conn.closeHandler(v -> this.testComplete()));
        this.client.request(this.requestOptions).compose(req -> req.putHeader("connection", "close").send()).onComplete(this.onFailure(err -> {
            if (a.compareAndSet(false, true)) {
                this.assertTrue("message " + err.getMessage() + " should contain HTTP/1.2", err.getMessage().contains("HTTP/1.2"));
            }
        }));
        this.await();
    }

    @Test
    public void testHttp11PersistentConnectionNotClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            this.assertNull(req.getHeader("Connection"));
            req.response().end();
            this.assertFalse(req.response().closed());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setProtocolVersion(HttpVersion.HTTP_1_1).setKeepAlive(true));
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> resp.endHandler(v -> {
                this.assertNull(resp.getHeader("Connection"));
                this.assertEquals(resp.getHeader("Content-Length"), "0");
                this.testComplete();
            })));
        }));
        this.await();
    }

    @Test
    public void testHttp11NonPersistentConnectionClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            this.assertEquals(req.getHeader("Connection"), "close");
            req.response().end();
            this.assertTrue(req.response().closed());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setProtocolVersion(HttpVersion.HTTP_1_1).setKeepAlive(false));
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> resp.endHandler(v -> {
                this.assertEquals(resp.getHeader("Connection"), "close");
                this.testComplete();
            })));
        }));
        this.await();
    }

    @Test
    public void testHttp10KeepAliveConnectionNotClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_0, req.version());
            this.assertEquals(req.getHeader("Connection"), "keep-alive");
            req.response().end();
            this.assertFalse(req.response().closed());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setProtocolVersion(HttpVersion.HTTP_1_0).setKeepAlive(true));
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> resp.endHandler(v -> {
                this.assertEquals(resp.getHeader("Connection"), "keep-alive");
                this.assertEquals(resp.getHeader("Content-Length"), "0");
                this.testComplete();
            })));
        }));
        this.await();
    }

    @Test
    public void testHttp10RequestNonKeepAliveConnectionClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_0, req.version());
            this.assertNull(req.getHeader("Connection"));
            req.response().end();
            this.assertTrue(req.response().closed());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setProtocolVersion(HttpVersion.HTTP_1_0).setKeepAlive(false));
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> resp.endHandler(v -> {
                this.assertNull(resp.getHeader("Connection"));
                this.testComplete();
            })));
        }));
        this.await();
    }

    @Test
    public void testHttp10ResponseNonKeepAliveConnectionClosed() throws Exception {
        this.waitFor(3);
        this.server.close();
        NetServer server = this.vertx.createNetServer().connectHandler(so -> {
            StringBuilder request = new StringBuilder();
            so.handler(buff -> {
                request.append(buff);
                if (request.toString().endsWith("\r\n\r\n")) {
                    request.setLength(0);
                    so.write("HTTP/1.0 200 OK\r\nContent-Length: 0\r\n\r\n");
                    so.close();
                }
            });
        });
        server.listen(this.testAddress, this.onSuccess(v1 -> {
            this.client.close();
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setKeepAlive(true).setMaxPoolSize(1));
            for (int i = 0; i < 3; ++i) {
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v2 -> this.complete())))));
            }
        }));
        this.await();
    }

    @Test
    public void requestAbsNoPort() {
        this.client.request(new RequestOptions().setAbsoluteURI("http://www.google.com")).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.testComplete()));
        this.await();
    }

    @Test
    public void testServerOptionsCopiedBeforeUse() {
        this.server.close();
        HttpServerOptions options = new HttpServerOptions().setHost("localhost").setPort(DEFAULT_HTTP_PORT);
        HttpServer server = this.vertx.createHttpServer(options);
        options.setPort(DEFAULT_HTTP_PORT + 1);
        server.requestHandler(req -> req.response().end());
        server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(res -> {
            this.assertEquals(200L, res.statusCode());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testClientOptionsCopiedBeforeUse() {
        this.client.close();
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            HttpClientOptions options = new HttpClientOptions();
            this.client = this.vertx.createHttpClient(options);
            options.setSsl(true);
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(res -> {
                this.assertEquals(200L, res.statusCode());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testRequestExceptionHandlerContext() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().close());
        this.startServer(this.testAddress);
        Context clientCtx = this.vertx.getOrCreateContext();
        this.client.close();
        clientCtx.runOnContext(v -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.exceptionHandler(err -> {
                this.assertSameEventLoop(clientCtx, Vertx.currentContext());
                this.complete();
            }).response(this.onFailure(err -> {
                this.assertSameEventLoop(clientCtx, Vertx.currentContext());
                this.complete();
            })).sendHead()));
        });
        this.await();
    }

    private void fill(Buffer buffer, WriteStream<Buffer> ws, LongConsumer done) {
        this.fill(0L, buffer, ws, done);
    }

    private void fill(long amount, Buffer buffer, WriteStream<Buffer> ws, LongConsumer done) {
        if (ws.writeQueueFull()) {
            done.accept(amount);
        } else {
            ws.write((Object)buffer);
            this.vertx.setTimer(1L, v -> this.fill(amount + (long)buffer.length(), buffer, ws, done));
        }
    }

    @Test
    public void testContexts() throws Exception {
        int numReqs = 4;
        Buffer data = TestUtils.randomBuffer(16384);
        AtomicInteger cnt = new AtomicInteger();
        Context serverCtx = this.vertx.getOrCreateContext();
        CountDownLatch latch = new CountDownLatch(1);
        List requests = Collections.synchronizedList(new ArrayList());
        HashMap requestResumeMap = new HashMap();
        HashMap responseResumeMap = new HashMap();
        serverCtx.runOnContext(v1 -> {
            this.server.requestHandler(req -> {
                req.pause();
                this.assertSameEventLoop(serverCtx, Vertx.currentContext());
                Buffer body = Buffer.buffer();
                ((CompletionStage)requestResumeMap.get(req.path())).thenAccept(amount -> {
                    req.resume();
                    req.endHandler(v2 -> {
                        this.assertSameEventLoop(serverCtx, Vertx.currentContext());
                        this.assertEquals((long)amount, body.length());
                        requests.add(req);
                        if (requests.size() == numReqs) {
                            requests.forEach(req_ -> {
                                HttpServerResponse resp = req_.response();
                                CompletableFuture cf = new CompletableFuture();
                                responseResumeMap.put(req_.path(), cf);
                                resp.setChunked(true);
                                this.fill(data, (WriteStream<Buffer>)resp, sent -> {
                                    cf.complete(null);
                                    resp.drainHandler(v -> {
                                        this.assertSameEventLoop(serverCtx, Vertx.currentContext());
                                        resp.end();
                                    });
                                });
                            });
                        }
                    });
                });
                req.handler(chunk -> {
                    this.assertSameEventLoop(serverCtx, Vertx.currentContext());
                    body.appendBuffer(chunk);
                });
            });
            this.server.listen(this.testAddress, this.onSuccess(s -> {
                this.assertSameEventLoop(serverCtx, Vertx.currentContext());
                latch.countDown();
            }));
        });
        this.awaitLatch(latch);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.client.close();
        this.client = null;
        Context clientCtx = this.vertx.getOrCreateContext();
        clientCtx.runOnContext(v -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(numReqs));
        });
        Http1xTest.waitUntil(() -> this.client != null);
        List contexts = Stream.generate(() -> ((VertxInternal)this.vertx).createEventLoopContext()).limit(numReqs).collect(Collectors.toList());
        HashSet expectedThreads = new HashSet();
        for (Context ctx : contexts) {
            CompletableFuture th = new CompletableFuture();
            ctx.runOnContext(v -> th.complete(Thread.currentThread()));
            expectedThreads.add(th.get());
        }
        ConcurrentHashSet threads = new ConcurrentHashSet();
        for (int i = 0; i < numReqs; ++i) {
            Context requestCtx = (Context)contexts.get(i);
            CompletableFuture cf = new CompletableFuture();
            String path = "/" + i;
            requestResumeMap.put(path, cf);
            requestCtx.runOnContext(arg_0 -> this.lambda$testContexts$171(path, requestCtx, (Set)threads, responseResumeMap, cnt, numReqs, expectedThreads, latch2, data, cf, arg_0));
        }
        this.awaitLatch(latch2, 40L, TimeUnit.SECONDS);
        new Thread(() -> {
            this.server.close(this.onSuccess(v -> {
                ContextInternal closeContext = ((VertxInternal)this.vertx).getContext();
                this.assertFalse(contexts.contains(closeContext));
                this.assertNotSame(serverCtx, closeContext);
                this.assertFalse(contexts.contains(serverCtx));
                this.testComplete();
            }));
            this.server = null;
        }).start();
        this.await();
    }

    @Test
    public void testRequestHandlerNotCalledInvalidRequest() {
        this.server.requestHandler(req -> this.fail());
        this.server.listen(this.testAddress, this.onSuccess(s -> this.vertx.createNetClient(new NetClientOptions()).connect(this.testAddress, this.onSuccess(socket -> {
            socket.closeHandler(r -> this.testComplete());
            socket.write("GET HTTP1/1\r\n");
            socket.write("X-Header: test\r\n");
        }))));
        this.await();
    }

    @Test
    public void testTwoServersSameAddressDifferentContext() throws Exception {
        this.vertx.deployVerticle(SimpleServer.class.getName(), new DeploymentOptions().setInstances(2), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testPauseResumeClientResponse() {
        byte[] data = new byte[0x4000000];
        new Random().nextBytes(data);
        Buffer buffer = Buffer.buffer((byte[])data);
        Buffer readBuffer = Buffer.buffer((int)0x4000000);
        this.server.requestHandler(request -> {
            request.response().setChunked(true);
            for (int i = 0; i < buffer.length() / 8192; ++i) {
                request.response().write((Object)buffer.slice(i * 8192, (i + 1) * 8192));
            }
            request.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(hs -> {
            HttpClient httpClient = this.vertx.createHttpClient();
            httpClient.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.handler(b -> {
                readBuffer.appendBuffer(b);
                for (int i = 0; i < 64; ++i) {
                    this.vertx.setTimer(1L, n -> {
                        try {
                            Thread.sleep(0L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    });
                }
                resp.endHandler(v -> {
                    byte[] expectedData = buffer.getBytes();
                    byte[] actualData = readBuffer.getBytes();
                    this.assertTrue(Arrays.equals(expectedData, actualData));
                    this.testComplete();
                });
            })))));
        }));
        this.await();
    }

    @Test
    public void testPauseResumeServerRequestFromAnotherThread() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Buffer buffer = TestUtils.randomBuffer(0x4000000);
        Buffer readBuffer = Buffer.buffer((int)0x4000000);
        this.server.requestHandler(request -> {
            request.handler(b -> {
                readBuffer.appendBuffer(b);
                request.pause();
                exec.execute(() -> {
                    try {
                        Thread.sleep(0L, 100);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    request.resume();
                });
            });
            request.endHandler(v -> {
                byte[] expectedData = buffer.getBytes();
                byte[] actualData = readBuffer.getBytes();
                this.assertTrue(Arrays.equals(expectedData, actualData));
                this.testComplete();
            });
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onFailure(err -> {})).setChunked(true);
            int times = buffer.length() / 8192;
            this.send((HttpClientRequest)req, buffer, 0, times);
        }));
        this.await();
    }

    private void send(HttpClientRequest req, Buffer buffer, int count, int times) {
        if (count < times) {
            req.write((Object)buffer.slice(count * 8192, (count + 1) * 8192));
            this.vertx.runOnContext(v -> this.send(req, buffer, count + 1, times));
        } else {
            req.end();
        }
    }

    @Test
    public void testAckHttpClientResponseReadWindowOnEnd() throws Exception {
        int highWaterMark = 65536;
        int numRequests = 10;
        this.waitFor(numRequests);
        Buffer buffer = TestUtils.randomBuffer(highWaterMark);
        this.server.requestHandler(req -> req.response().end(buffer));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions(), new PoolOptions().setHttp1MaxSize(1));
        ArrayList responses = new ArrayList();
        for (int i = 0; i < numRequests; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> {
                ArrayList responsesToResume;
                resp.pause();
                resp.endHandler(v -> this.complete());
                List list = responses;
                synchronized (list) {
                    responses.add(resp);
                    if (responses.size() < 10) {
                        return;
                    }
                    responsesToResume = new ArrayList(responses);
                }
                for (HttpClientResponse responseToResume : responsesToResume) {
                    responseToResume.resume();
                }
            }))));
        }
        this.await();
    }

    @Test
    public void testEndServerResponseResumeTheConnection() throws Exception {
        this.server.requestHandler(req -> req.endHandler(v -> {
            req.pause();
            req.response().end();
        }));
        this.startServer(this.testAddress);
        this.client.close();
        this.waitFor(2);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setMaxPoolSize(1));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testEndServerRequestResumeTheConnection() throws Exception {
        this.server.requestHandler(req -> {
            req.response().end();
            req.endHandler(v -> req.pause());
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.waitFor(2);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setKeepAlive(true).setMaxPoolSize(1));
        for (int i = 0; i < 2; ++i) {
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(Buffer.buffer((String)"1"), this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.complete();
            }))));
        }
        this.await();
    }

    @Test
    public void testMultipleRecursiveCallsAndPipelining() throws Exception {
        int sendRequests = 100;
        AtomicInteger receivedRequests = new AtomicInteger();
        this.server.requestHandler(x -> x.response().end("hello")).listen(this.testAddress, r -> {
            if (r.succeeded()) {
                HttpClient client = this.vertx.createHttpClient(this.createBaseClientOptions().setKeepAlive(true).setPipelining(true));
                IntStream.range(0, 5).forEach(i -> this.recursiveCall(client, receivedRequests, sendRequests));
            }
        });
        this.await();
    }

    private void recursiveCall(HttpClient client, AtomicInteger receivedRequests, int sendRequests) {
        client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(r -> {
            int numRequests = receivedRequests.incrementAndGet();
            if (numRequests == sendRequests) {
                this.testComplete();
            } else if (numRequests < sendRequests) {
                this.recursiveCall(client, receivedRequests, sendRequests);
            }
        });
    }

    @Ignore
    @Test
    public void testUnsupportedHttpVersion() throws Exception {
        this.testUnsupported("GET /someuri HTTP/1.7\r\nHost: localhost\r\n\r\n", false);
    }

    private void testUnsupported(String rawReq, boolean method) throws Exception {
        this.server.requestHandler(req -> this.fail()).listen(this.testAddress, this.onSuccess(s -> {
            NetClient client = this.vertx.createNetClient();
            client.connect(this.testAddress, this.onSuccess(conn -> {
                conn.write(rawReq);
                Buffer respBuff = Buffer.buffer();
                conn.handler(arg_0 -> ((Buffer)respBuff).appendBuffer(arg_0));
                conn.closeHandler(v -> {
                    this.assertTrue("Unexpected response " + respBuff, respBuff.toString().contains("501 Not Implemented"));
                    client.close();
                    this.testComplete();
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testTwoServersDifferentEventLoopsCloseOne() throws Exception {
        int i;
        CountDownLatch latch1 = new CountDownLatch(2);
        AtomicInteger server1Count = new AtomicInteger();
        AtomicInteger server2Count = new AtomicInteger();
        this.server.requestHandler(req -> {
            server1Count.incrementAndGet();
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(s -> latch1.countDown()));
        HttpServer server2 = this.vertx.createHttpServer().requestHandler(req -> {
            server2Count.incrementAndGet();
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(s -> latch1.countDown()));
        this.awaitLatch(latch1);
        HttpClient[] clients = new HttpClient[5];
        for (i = 0; i < 5; ++i) {
            clients[i] = this.vertx.createHttpClient(this.createBaseClientOptions());
        }
        for (i = 0; i < 2; ++i) {
            CountDownLatch latch2 = new CountDownLatch(1);
            clients[i].request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                latch2.countDown();
            }));
            this.awaitLatch(latch2);
        }
        CountDownLatch latch3 = new CountDownLatch(1);
        server2.close(this.onSuccess(v -> latch3.countDown()));
        this.awaitLatch(latch3);
        for (int i2 = 0; i2 < 2; ++i2) {
            CountDownLatch latch2 = new CountDownLatch(1);
            clients[2 + i2].request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                latch2.countDown();
            }));
            this.awaitLatch(latch2);
        }
        this.assertEquals(3L, server1Count.get());
        this.assertEquals(1L, server2Count.get());
    }

    @Test
    public void testSetWriteQueueMaxSize() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setWriteQueueMaxSize(262144);
            resp.setWriteQueueMaxSize(524288);
            resp.setWriteQueueMaxSize(131072);
            resp.setWriteQueueMaxSize(132096);
            resp.end();
        }).listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testServerMaxInitialLineLength() {
        this.testServerMaxInitialLineLength(4096);
    }

    @Test
    public void testServerMaxInitialLineLengthOption() {
        this.testServerMaxInitialLineLength(5018);
    }

    private void testServerMaxInitialLineLength(int maxInitialLength) {
        String longParam = TestUtils.randomAlphaString(5000);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setMaxInitialLineLength(maxInitialLength)).requestHandler(req -> {
            this.assertEquals(req.getParam("t"), longParam);
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(res -> this.vertx.createHttpClient().request(new RequestOptions(this.requestOptions).setURI("/?t=" + longParam)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            if (maxInitialLength > 4096) {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            } else {
                this.assertEquals(414L, resp.statusCode());
                resp.request().connection().closeHandler(v -> this.testComplete());
            }
        }))));
        this.await();
    }

    @Test
    public void testServerInvalidHttpMessage() {
        this.server.requestHandler(req -> this.fail()).listen(this.testAddress, this.onSuccess(res -> this.vertx.createHttpClient().request(new RequestOptions(this.requestOptions).setURI("/?ab c=1")).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(400L, resp.statusCode());
            resp.request().connection().closeHandler(v -> this.testComplete());
        }))));
        this.await();
    }

    @Test
    public void testClientMaxInitialLineLengthOption() {
        String longParam = TestUtils.randomAlphaString(5000);
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> so.write("HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\nA; name=\"" + longParam + "\"\r\n0123456789\r\n0\r\n\r\n"));
        try {
            server.listen(this.testAddress, this.onSuccess(v -> this.vertx.createHttpClient(new HttpClientOptions().setMaxInitialLineLength(6000)).request(new RequestOptions(this.requestOptions).setURI("/?t=" + longParam)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> resp.bodyHandler(body -> {
                this.assertEquals("0123456789", body.toString());
                this.testComplete();
            })))));
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testClientMaxHeaderSizeOption() {
        String longHeader = TestUtils.randomAlphaString(9000);
        this.vertx.createHttpServer(this.createBaseServerOptions()).requestHandler(req -> req.response().putHeader("t", longHeader).end()).listen(this.testAddress, this.onSuccess(res -> this.vertx.createHttpClient(new HttpClientOptions().setMaxHeaderSize(10000)).request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals(resp.getHeader("t"), longHeader);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testServerMaxHeaderSize() {
        this.testServerMaxHeaderSize(8192);
    }

    @Test
    public void testServerMaxHeaderSizeOption() {
        this.testServerMaxHeaderSize(10000);
    }

    private void testServerMaxHeaderSize(int maxHeaderSize) {
        String longHeader = TestUtils.randomAlphaString(9000);
        this.vertx.createHttpServer(this.createBaseServerOptions().setMaxHeaderSize(maxHeaderSize)).requestHandler(req -> {
            this.assertEquals(req.getHeader("t"), longHeader);
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(res -> this.vertx.createHttpClient(new HttpClientOptions()).request(this.requestOptions).compose(req -> req.putHeader("t", longHeader).send()).onComplete(this.onSuccess(resp -> {
            if (maxHeaderSize > 8192) {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            } else {
                this.assertEquals(431L, resp.statusCode());
                resp.request().connection().closeHandler(v -> this.testComplete());
            }
        }))));
        this.await();
    }

    @Test
    public void testPipelinedInvalidHttpResponse() {
        this.waitFor(2);
        AtomicInteger count = new AtomicInteger(0);
        NetServer server = this.vertx.createNetServer();
        String match = "GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n";
        server.connectHandler(so -> {
            StringBuilder content = new StringBuilder();
            so.handler(buff -> {
                content.append(buff);
                block4: while (content.toString().startsWith(match)) {
                    content.delete(0, match.length());
                    switch (count.getAndIncrement()) {
                        case 0: {
                            continue block4;
                        }
                        case 1: {
                            Buffer resp1 = Buffer.buffer((String)(TestUtils.randomAlphaString(40) + "\r\n"));
                            Buffer resp2 = Buffer.buffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n");
                            so.write((Object)Buffer.buffer().appendBuffer(resp1).appendBuffer(resp2));
                            continue block4;
                        }
                    }
                    this.fail();
                }
            });
        }).listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setKeepAlive(true).setPipelining(true).setMaxPoolSize(1));
            for (int i = 0; i < 2; ++i) {
                AtomicBoolean failed = new AtomicBoolean();
                this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).compose(HttpClientRequest::send).onComplete(this.onFailure(err -> {
                    if (failed.compareAndSet(false, true)) {
                        this.assertEquals(IllegalArgumentException.class, err.getClass());
                        this.complete();
                    }
                }));
            }
        }));
        this.await();
    }

    @Test
    public void testConnectionCloseHttp_1_0_NoClose() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)req -> {
            req.putHeader("Connection", "close");
            req.end();
        }), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.0 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 4\r\nConnection: keep-alive\r\n\r\nxxx\n");
                } else {
                    socket.write("HTTP/1.0 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 1\r\n\r\n\n");
                }
            }));
        }));
    }

    @Test
    public void testConnectionCloseHttp_1_0_Close() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)req -> {
            req.putHeader("Connection", "close");
            req.end();
        }), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.0 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 4\r\nConnection: keep-alive\r\n\nxxx\n");
                } else {
                    socket.write("HTTP/1.0 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 1\r\n\r\n\n");
                    socket.close();
                }
            }));
        }));
    }

    @Test
    public void testConnectionCloseHttp_1_1_NoClose() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)HttpClientRequest::end), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 4\r\n\r\nxxx\n");
                } else {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 1\r\nConnection: close\r\n\r\n\n");
                }
            }));
        }));
    }

    @Test
    public void testConnectionCloseHttp_1_1_Close() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)HttpClientRequest::end), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 3\r\n\r\nxxx");
                } else {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 1\r\nConnection: close\r\n\r\n\n");
                    socket.close();
                }
            }));
        }));
    }

    private void testConnectionClose(Handler<HttpClientRequest> clientRequest, Handler<NetSocket> connectHandler) throws Exception {
        this.client.close();
        this.server.close();
        NetServerOptions serverOptions = new NetServerOptions();
        CountDownLatch serverLatch = new CountDownLatch(1);
        this.vertx.createNetServer(serverOptions).connectHandler(connectHandler).listen(this.testAddress, result -> {
            if (result.succeeded()) {
                serverLatch.countDown();
            } else {
                this.fail();
            }
        });
        this.awaitLatch(serverLatch);
        int poolSize = 5;
        HttpClientOptions clientOptions = new HttpClientOptions().setMaxPoolSize(poolSize).setDefaultHost("localhost").setKeepAlive(true).setPipelining(false);
        this.client = this.vertx.createHttpClient(clientOptions);
        int requests = poolSize * 2 + 1;
        AtomicInteger count = new AtomicInteger(requests);
        for (int i = 0; i < requests; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
                req.response(this.onSuccess(resp -> {
                    resp.handler(buffer -> {});
                    resp.endHandler(v -> {
                        if (count.decrementAndGet() == 0) {
                            this.complete();
                        }
                    });
                    resp.exceptionHandler(this::fail);
                }));
                clientRequest.handle(req);
            }));
        }
        this.await();
    }

    @Test
    public void testDoNotReuseConnectionWhenResponseEndsBeforeRequest() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(true).setKeepAlive(true));
        AtomicBoolean req1Ended = new AtomicBoolean();
        this.server.requestHandler(req -> {
            switch (req.path()) {
                case "/1": {
                    this.assertFalse(req1Ended.get());
                    break;
                }
                case "/2": {
                    this.assertTrue(req1Ended.get());
                }
            }
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setURI("/1")).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> resp.endHandler(v1 -> this.vertx.setTimer(100L, v2 -> {
                req1Ended.set(true);
                req.end();
            }))));
            req.setChunked(true).sendHead();
        }));
        this.client.request(new RequestOptions(this.requestOptions).setURI("/2")).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.testComplete()));
        this.await();
    }

    @Test
    public void testRecyclePipelinedConnection() throws Exception {
        CountDownLatch listenLatch = new CountDownLatch(1);
        CountDownLatch doneLatch = new CountDownLatch(2);
        ArrayList responses = new ArrayList();
        this.server.requestHandler(req -> {
            responses.add(req.path());
            req.response().end();
            doneLatch.countDown();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setPipelining(true).setKeepAlive(true));
        AtomicInteger connCount = new AtomicInteger();
        this.client.connectionHandler(conn -> connCount.incrementAndGet());
        CountDownLatch respLatch = new CountDownLatch(2);
        this.client.request(new RequestOptions(this.requestOptions).setURI("/first")).onComplete(this.onSuccess(req1 -> {
            req1.response(this.onFailure(err -> {}));
            this.assertTrue(req1.reset(0L));
            this.client.request(new RequestOptions(this.requestOptions).setURI("/second")).onComplete(this.onSuccess(req2 -> req2.send(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.endHandler(v -> respLatch.countDown());
            }))));
            this.client.request(new RequestOptions(this.requestOptions).setURI("/third")).onComplete(this.onSuccess(req3 -> req3.send(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.endHandler(v -> respLatch.countDown());
            }))));
        }));
        this.awaitLatch(doneLatch);
        this.assertEquals(Arrays.asList("/second", "/third"), responses);
        this.awaitLatch(respLatch);
        this.server.close();
        this.assertEquals(1L, connCount.get());
    }

    @Test
    public void testClientConnectionExceptionHandler() throws Exception {
        NetServer server = this.vertx.createNetServer();
        CountDownLatch listenLatch = new CountDownLatch(1);
        server.connectHandler(so -> so.write((Object)Buffer.buffer((String)(TestUtils.randomAlphaString(40) + "\r\n")))).listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client.connectionHandler(conn -> conn.exceptionHandler(err -> this.testComplete()));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::sendHead));
        this.await();
    }

    @Test
    public void testServerConnectionExceptionHandler() throws Exception {
        this.server.connectionHandler(conn -> conn.exceptionHandler(err -> {
            this.assertTrue(err instanceof TooLongFrameException);
            this.testComplete();
        }));
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(resp1 -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.putHeader("the_header", TestUtils.randomAlphaString(10000));
            req.sendHead();
        })));
        this.await();
    }

    @Test
    public void testServerExceptionHandler() throws Exception {
        Context serverCtx = this.vertx.getOrCreateContext();
        this.server.exceptionHandler(err -> {
            this.assertSame(serverCtx, Vertx.currentContext());
            this.assertTrue(err instanceof TooLongFrameException);
            this.testComplete();
        });
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress, serverCtx);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.putHeader("the_header", TestUtils.randomAlphaString(10000)).sendHead()));
        this.await();
    }

    @Test
    public void testRandomPorts() {
        int numServers = 10;
        Set ports = Collections.synchronizedSet(new HashSet());
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < numServers; ++i) {
            this.vertx.createHttpServer().requestHandler(req -> req.response().end()).listen(0, "localhost", this.onSuccess(s -> {
                int port = s.actualPort();
                ports.add(port);
                this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(port))).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                    if (count.incrementAndGet() == numServers) {
                        this.assertEquals(numServers, ports.size());
                        this.testComplete();
                    }
                }))));
            }));
        }
        this.await();
    }

    @Test
    public void testContentDecompression() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(DEFAULT_HTTP_PORT).setDecompressionSupported(true));
        String expected = TestUtils.randomAlphaString(1000);
        byte[] dataGzipped = TestUtils.compressGzip(expected);
        this.server.requestHandler(req -> {
            this.assertEquals(DEFAULT_HTTP_HOST_AND_PORT, req.headers().get("host"));
            req.bodyHandler(buffer -> {
                this.assertEquals(expected, buffer.toString());
                req.response().end();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.putHeader("Content-Encoding", "gzip").send(Buffer.buffer((byte[])dataGzipped), this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testResetClientRequestNotYetSent() throws Exception {
        this.testResetClientRequestNotYetSent(false, false);
    }

    @Test
    public void testResetKeepAliveClientRequestNotYetSent() throws Exception {
        this.testResetClientRequestNotYetSent(true, false);
    }

    @Test
    public void testResetPipelinedClientRequestNotYetSent() throws Exception {
        this.testResetClientRequestNotYetSent(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testResetClientRequestNotYetSent(boolean keepAlive, boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger numReq = new AtomicInteger();
            server.connectHandler(conn -> {
                this.assertEquals(0L, numReq.getAndIncrement());
                StringBuilder sb = new StringBuilder();
                conn.handler(buff -> {
                    sb.append(buff);
                    String content = sb.toString();
                    if (content.startsWith("GET some-uri HTTP/1.1\r\n") && content.endsWith("\r\n\r\n")) {
                        conn.write("HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n");
                        this.complete();
                    }
                });
            });
            CountDownLatch latch = new CountDownLatch(1);
            server.listen(this.testAddress, this.onSuccess(v -> latch.countDown()));
            this.awaitLatch(latch);
            this.client.close();
            this.vertx.runOnContext(v -> {
                this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(keepAlive).setPipelining(pipelined));
                this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
                    req.response(this.onFailure(err -> {}));
                    this.assertTrue(req.reset());
                    this.client.request(new RequestOptions(this.requestOptions).setURI("some-uri")).compose(HttpClientRequest::send).onComplete(resp -> {
                        this.assertEquals(1L, numReq.get());
                        this.complete();
                    });
                }));
            });
            this.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetKeepAliveClientRequest() throws Exception {
        this.waitFor(3);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger count = new AtomicInteger();
            server.connectHandler(so -> {
                this.assertEquals(0L, count.getAndIncrement());
                Buffer total = Buffer.buffer();
                so.handler(buff -> {
                    total.appendBuffer(buff);
                    if (total.toString().equals("GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                        so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                        so.closeHandler(v -> this.complete());
                    }
                });
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(false).setKeepAlive(true));
            AtomicInteger status = new AtomicInteger();
            this.client.connectionHandler(conn -> conn.closeHandler(v -> {
                this.assertEquals(1L, status.getAndIncrement());
                this.complete();
            }));
            this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).onComplete(this.onSuccess(req1 -> {
                req1.send(this.onSuccess(resp -> this.assertEquals(0L, status.getAndIncrement())));
                this.client.request(this.requestOptions).onSuccess(req2 -> req2.response(this.onFailure(err -> this.complete())).sendHead(v -> this.assertTrue(req2.reset())));
            }));
            this.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetPipelinedClientRequest() throws Exception {
        this.waitFor(3);
        CompletableFuture doReset = new CompletableFuture();
        this.server.close();
        NetServer server = this.vertx.createNetServer();
        AtomicInteger count = new AtomicInteger();
        server.connectHandler(so -> {
            this.assertEquals(0L, count.getAndIncrement());
            Buffer total = Buffer.buffer();
            so.handler(buff -> {
                total.appendBuffer(buff);
                if (total.toString().equals("GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\nPOST /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                    doReset.complete(null);
                    so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                }
            });
            so.closeHandler(v -> this.complete());
        });
        try {
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setPipelining(true).setKeepAlive(true));
            this.client.connectionHandler(conn -> conn.closeHandler(v -> this.complete()));
            this.vertx.runOnContext(v1 -> {
                this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).compose(HttpClientRequest::send);
                this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath").setMethod(HttpMethod.POST)).onComplete(this.onSuccess(req2 -> {
                    req2.response(this.onFailure(resp -> this.complete()));
                    req2.sendHead();
                    doReset.thenAccept(v2 -> this.assertTrue(req2.reset()));
                }));
            });
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testCloseTheConnectionAfterResetKeepAliveClientRequest() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientRequest(false);
    }

    @Test
    public void testCloseTheConnectionAfterResetPipelinedClientRequest() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientRequest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseTheConnectionAfterResetPersistentClientRequest(boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean closed = new AtomicBoolean();
            server.connectHandler(so -> {
                Buffer total = Buffer.buffer();
                switch (count.getAndIncrement()) {
                    case 0: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                                so.closeHandler(v -> closed.set(true));
                            }
                        });
                        break;
                    }
                    case 1: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                                so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                                this.complete();
                            }
                        });
                        break;
                    }
                    default: {
                        this.fail("Invalid count");
                    }
                }
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(pipelined).setKeepAlive(true));
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req1 -> {
                if (pipelined) {
                    HttpConnection conn = req1.connection();
                    conn.closeHandler(v2 -> this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        resp.bodyHandler(body -> {
                            this.assertEquals("Hello world", body.toString());
                            this.complete();
                        });
                    })))));
                    req1.sendHead(v -> this.assertTrue(req1.reset()));
                } else {
                    req1.sendHead(v -> this.assertTrue(req1.reset()));
                    this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        resp.bodyHandler(body -> {
                            this.assertEquals("Hello world", body.toString());
                            this.complete();
                        });
                    }))));
                }
            }));
            this.await();
        }
    }

    @Test
    public void testCloseTheConnectionAfterResetKeepAliveClientResponse() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientResponse(false);
    }

    @Test
    public void testCloseTheConnectionAfterResetPipelinedClientResponse() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientResponse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseTheConnectionAfterResetPersistentClientResponse(boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean closed = new AtomicBoolean();
            server.connectHandler(so -> {
                Buffer total = Buffer.buffer();
                switch (count.getAndIncrement()) {
                    case 0: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                                so.write((Object)Buffer.buffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 200\r\n\r\nSome-Buffer"));
                                so.closeHandler(v -> closed.set(true));
                            }
                        });
                        break;
                    }
                    case 1: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                                so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                                this.complete();
                            }
                        });
                        break;
                    }
                    default: {
                        this.fail("Invalid count");
                    }
                }
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setPipelining(pipelined).setKeepAlive(true));
            if (pipelined) {
                this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).onComplete(this.onSuccess(req1 -> req1.send(this.onSuccess(resp1 -> resp1.handler(buff -> {
                    resp1.request().connection().closeHandler(v -> this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).onComplete(this.onSuccess(req2 -> req2.send(this.onSuccess(resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        resp.bodyHandler(body -> {
                            this.assertEquals("Hello world", body.toString());
                            this.complete();
                        });
                    })))));
                    resp1.request().reset();
                })))));
            } else {
                this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.handler(buff -> resp.request().reset())))));
                this.client.request(new RequestOptions(this.requestOptions).setURI("/somepath")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    resp.bodyHandler(body -> {
                        this.assertEquals("Hello world", body.toString());
                        this.complete();
                    });
                }))));
            }
            this.await();
        }
    }

    @Test
    public void testCloseTheConnectionAfterResetBeforePipelinedResponseReceived() throws Exception {
        this.testCloseTheConnectionAfterResetBeforeResponseReceived(true);
    }

    @Test
    public void testCloseTheConnectionAfterResetBeforeKeepAliveResponseReceived() throws Exception {
        this.testCloseTheConnectionAfterResetBeforeResponseReceived(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseTheConnectionAfterResetBeforeResponseReceived(boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        NetServer server = this.vertx.createNetServer();
        CompletableFuture requestReceived = new CompletableFuture();
        CompletableFuture sendResponse = new CompletableFuture();
        try {
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean closed = new AtomicBoolean();
            server.connectHandler(so -> {
                Buffer total = Buffer.buffer();
                switch (count.getAndIncrement()) {
                    case 0: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /1 HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                                requestReceived.complete(null);
                                sendResponse.whenComplete((v, err) -> so.write((Object)Buffer.buffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 11\r\n\r\nSome-Buffer")));
                                so.closeHandler(v -> closed.set(true));
                            }
                        });
                        break;
                    }
                    case 1: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /2 HTTP/1.1\r\nhost: " + DEFAULT_HTTP_HOST_AND_PORT + "\r\n\r\n")) {
                                so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                                this.complete();
                            }
                        });
                        break;
                    }
                    default: {
                        this.fail("Invalid count");
                    }
                }
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setPipelining(pipelined).setKeepAlive(true));
            this.client.request(new RequestOptions(this.requestOptions).setURI("/1")).onComplete(this.onSuccess(req1 -> {
                requestReceived.thenAccept(v -> req1.reset());
                if (pipelined) {
                    HttpConnection conn = req1.connection();
                    conn.closeHandler(v2 -> this.client.request(new RequestOptions(this.requestOptions).setURI("/2")).compose(HttpClientRequest::send).compose(resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        return resp.body();
                    }).onComplete(this.onSuccess(body -> {
                        this.assertEquals("Hello world", body.toString());
                        this.complete();
                    })));
                    req1.end();
                } else {
                    req1.end();
                    this.client.request(new RequestOptions(this.requestOptions).setURI("/2")).compose(HttpClientRequest::send).compose(resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        return resp.body();
                    }).onComplete(this.onSuccess(body -> {
                        this.assertEquals("Hello world", body.toString());
                        this.complete();
                    }));
                }
            }));
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testTooLongContentInHttpServerRequest() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.server.connectionHandler(conn -> conn.exceptionHandler(error -> {
            this.assertEquals(IllegalArgumentException.class, error.getClass());
            this.testComplete();
        }));
        this.startServer(this.testAddress);
        try (NetClient client = this.vertx.createNetClient();){
            client.connect(this.testAddress, this.onSuccess(so -> so.write("POST / HTTP/1.1\r\nContent-Length: 4\r\n\r\ntoolong\r\n")));
            this.await();
        }
    }

    @Test
    public void testInvalidTrailerInHttpServerRequest() throws Exception {
        this.testHttpServerRequestDecodeError((Handler<NetSocket>)((Handler)so -> {
            so.write("0\r\n");
            for (int i = 0; i < 2000; ++i) {
                so.write("01234567");
            }
        }), (Handler<List<Throwable>>)((Handler)errors -> {
            this.assertEquals(2L, errors.size());
            this.assertEquals(TooLongHttpHeaderException.class, ((Throwable)errors.get(0)).getClass());
        }));
    }

    @Test
    public void testInvalidChunkInHttpServerRequest() throws Exception {
        this.testHttpServerRequestDecodeError((Handler<NetSocket>)((Handler)so -> so.write("invalid\r\n")), (Handler<List<Throwable>>)((Handler)errors -> {
            this.assertEquals(2L, errors.size());
            this.assertEquals(NumberFormatException.class, ((Throwable)errors.get(0)).getClass());
        }));
    }

    private void testHttpServerRequestDecodeError(Handler<NetSocket> bodySender, Handler<List<Throwable>> errorsChecker) throws Exception {
        AtomicReference current = new AtomicReference();
        this.server.requestHandler(req -> {
            ArrayList errors = new ArrayList();
            Handler handler = err -> {
                errors.add(err);
                if (errors.size() == 2) {
                    errorsChecker.handle((Object)errors);
                    this.testComplete();
                }
            };
            req.exceptionHandler(handler);
            bodySender.handle(current.get());
        });
        this.startServer(this.testAddress);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, this.onSuccess(so -> {
            current.set(so);
            so.write("POST /somepath HTTP/1.1\r\n");
            so.write("Transfer-Encoding: chunked\r\n");
            so.write("\r\n");
        }));
        this.await();
    }

    @Test
    public void testInvalidChunkInHttpClientResponse() throws Exception {
        NetServer server = this.vertx.createNetServer();
        CountDownLatch listenLatch = new CountDownLatch(1);
        CompletableFuture cont = new CompletableFuture();
        server.connectHandler(so -> {
            so.handler(buff -> {
                so.handler(null);
                so.write("HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n");
            });
            cont.whenComplete((v, e) -> so.write("invalid\r\n"));
        }).listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        AtomicInteger status = new AtomicInteger();
        this.testHttpClientResponseDecodeError((Handler<Void>)((Handler)cont::complete), (Handler<Throwable>)((Handler)err -> {
            switch (status.incrementAndGet()) {
                case 1: {
                    this.assertTrue(err instanceof NumberFormatException);
                    break;
                }
                case 2: {
                    this.assertTrue(err instanceof VertxException);
                    this.assertTrue(err.getMessage().equals("Connection was closed"));
                    this.testComplete();
                }
            }
        }));
    }

    @Test
    public void testInvalidTrailersInHttpClientResponse() throws Exception {
        NetServer server = this.vertx.createNetServer();
        CountDownLatch listenLatch = new CountDownLatch(1);
        CompletableFuture cont = new CompletableFuture();
        server.connectHandler(so -> {
            so.handler(buff -> {
                so.handler(null);
                so.write("HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n");
            });
            cont.whenComplete((v, e) -> {
                for (int i = 0; i < 2000; ++i) {
                    so.write("01234567");
                }
            });
        }).listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        AtomicInteger status = new AtomicInteger();
        this.testHttpClientResponseDecodeError((Handler<Void>)((Handler)cont::complete), (Handler<Throwable>)((Handler)err -> {
            switch (status.incrementAndGet()) {
                case 1: {
                    this.assertTrue(err instanceof TooLongFrameException);
                    break;
                }
                case 2: {
                    this.assertTrue(err instanceof VertxException);
                    this.assertTrue(err.getMessage().equals("Connection was closed"));
                    this.testComplete();
                }
            }
        }));
    }

    private void testHttpClientResponseDecodeError(Handler<Void> continuation, Handler<Throwable> errorHandler) throws Exception {
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            resp.exceptionHandler(errorHandler);
            continuation.handle(null);
        }))));
        this.await();
    }

    @Test
    public void testEmptyHttpVersion() throws Exception {
        try {
            io.netty.handler.codec.http.HttpVersion.valueOf((String)"");
            this.fail();
            return;
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = e.getMessage();
            this.server.requestHandler(req -> req.response().end());
            this.server.connectionHandler(conn -> conn.exceptionHandler(error -> {
                this.assertEquals(expectedMessage, error.getMessage());
                this.assertEquals(IllegalArgumentException.class, error.getClass());
                this.testComplete();
            }));
            this.startServer(this.testAddress);
            try (NetClient client = this.vertx.createNetClient();){
                client.connect(this.testAddress, this.onSuccess(so -> so.write("GET /\r\n\r\n")));
                this.await();
            }
            return;
        }
    }

    @Test
    public void testReceiveResponseWithNoRequestInProgress() throws Exception {
        NetServer server = this.vertx.createNetServer();
        CountDownLatch listenLatch = new CountDownLatch(1);
        Promise promise = Promise.promise();
        server.connectHandler(so -> promise.future().onSuccess(v -> so.write("HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n"))).listen(this.testAddress, this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client.connectionHandler(conn -> {
            AtomicBoolean failed = new AtomicBoolean();
            conn.exceptionHandler(err -> failed.set(true));
            conn.closeHandler(v -> {
                this.assertTrue(failed.get());
                this.testComplete();
            });
        });
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> promise.complete()));
        this.await();
    }

    @Test
    public void testPerHostPooling() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true).setPipelining(false));
        this.testPerXXXPooling(i -> this.client.request(new RequestOptions().setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setHost("host" + i).setURI("/somepath")).onSuccess(req -> req.putHeader("key", "host" + i)), req -> req.getHeader("key"));
    }

    @Test
    public void testPerPeerPooling() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true).setPipelining(false));
        this.testPerXXXPooling(i -> this.client.request(new RequestOptions().setServer(SocketAddress.inetSocketAddress((int)DEFAULT_HTTP_PORT, (String)"localhost")).setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setHost("host" + i).setURI("/somepath")), HttpServerRequest::host);
    }

    @Test
    public void testPerPeerPoolingWithProxy() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true).setPipelining(false).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(DEFAULT_HTTP_PORT)));
        this.testPerXXXPooling(i -> this.client.request(new RequestOptions().setPort(Integer.valueOf(80)).setHost("host" + i).setURI("/somepath")), HttpServerRequest::host);
    }

    private void testPerXXXPooling(Function<Integer, Future<HttpClientRequest>> requestProvider, Function<HttpServerRequest, String> keyExtractor) throws Exception {
        this.waitFor(2);
        int numPeers = 3;
        int numRequests = 5;
        HashMap map = new HashMap();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            String key = (String)keyExtractor.apply((HttpServerRequest)req);
            this.assertFalse(map.containsKey(key));
            map.put(key, req.response());
            if (map.size() == numPeers) {
                map.values().forEach(HttpServerResponse::end);
                map.clear();
                if (count.incrementAndGet() == numRequests) {
                    this.complete();
                }
            }
        });
        this.startServer();
        AtomicInteger remaining = new AtomicInteger(numPeers * numRequests);
        for (int i = 0; i < numPeers; ++i) {
            for (int j = 0; j < numRequests; ++j) {
                Future<HttpClientRequest> request = requestProvider.apply(i);
                request.onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    if (remaining.decrementAndGet() == 0) {
                        this.complete();
                    }
                }))));
            }
        }
        this.await();
    }

    @Test
    public void testSendFileFailsWhenClientClosesConnection() throws Exception {
        File f = this.setupFile("file.pdf", TestUtils.randomUnicodeString(0xA00000));
        this.server.requestHandler(req -> {
            try {
                req.response().sendFile(f.getAbsolutePath(), ar -> {
                    if (ar.failed()) {
                        this.testComplete();
                    } else {
                        this.fail(new Exception("It should not reach this point"));
                    }
                });
            }
            catch (Exception e) {
                this.fail(e);
            }
        });
        this.startServer(this.testAddress);
        this.vertx.createNetClient().connect(this.testAddress, this.onSuccess(socket -> {
            socket.write("GET / HTTP/1.1\r\n\r\n");
            socket.close();
        }));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiMap checkEmptyHttpResponse(HttpMethod method, int sc, MultiMap reqHeaders) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setStatusCode(sc);
            resp.headers().addAll(reqHeaders);
            resp.end();
        });
        this.startServer(this.testAddress);
        try (NetClient client = this.vertx.createNetClient();){
            CompletableFuture result = new CompletableFuture();
            client.connect(this.testAddress, ar -> {
                if (ar.succeeded()) {
                    NetSocket so = (NetSocket)ar.result();
                    so.write(method.name() + " / HTTP/1.1\r\nConnection: close\r\n\r\n");
                    Buffer body = Buffer.buffer();
                    so.exceptionHandler(result::completeExceptionally);
                    so.handler(arg_0 -> ((Buffer)body).appendBuffer(arg_0));
                    so.endHandler(v -> {
                        String content = body.toString();
                        int idx = content.indexOf("\r\n\r\n");
                        if (idx == content.length() - 4) {
                            LinkedList<String> records = new LinkedList<String>(Arrays.asList(content.substring(0, idx).split("\\r\\n")));
                            String statusLine = records.removeFirst();
                            this.assertEquals("HTTP/1.1 " + sc, statusLine.substring(0, statusLine.indexOf(32, 9)));
                            this.assertEquals("", content.substring(idx + 4));
                            MultiMap respHeaders = HttpHeaders.headers();
                            records.forEach(record -> {
                                int index = record.indexOf(":");
                                String value = record.substring(0, index);
                                respHeaders.add(value.trim(), record.substring(index + 1).trim());
                            });
                            result.complete(respHeaders);
                        } else {
                            result.completeExceptionally(new Exception());
                        }
                    });
                } else {
                    result.completeExceptionally(ar.cause());
                }
            });
            MultiMap multiMap = (MultiMap)result.get(20L, TimeUnit.SECONDS);
            return multiMap;
        }
    }

    @Test
    public void testUnknownContentLengthIsSetToZeroWithHTTP_1_0() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.write("Some-String");
            resp.end();
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_1_0));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertNull(resp.getHeader("Content-Length"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPartialH2CAmbiguousRequest() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.POST, req.method());
            this.testComplete();
        });
        Buffer fullRequest = Buffer.buffer((String)"POST /whatever HTTP/1.1\r\n\r\n");
        this.startServer(this.testAddress);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, this.onSuccess(so -> {
            so.write((Object)fullRequest.slice(0, 1));
            this.vertx.setTimer(1000L, id -> so.write((Object)fullRequest.slice(1, fullRequest.length())));
        }));
        this.await();
    }

    @Test
    public void testIdleTimeoutWithPartialH2CRequest() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(DEFAULT_HTTP_PORT).setHost("localhost").setIdleTimeout(1));
        this.server.requestHandler(req -> this.testComplete());
        this.startServer(this.testAddress);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, this.onSuccess(so -> so.closeHandler(v -> this.testComplete())));
        this.await();
    }

    @Test
    public void testTLSDisablesH2CHandlers() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get())).connectionHandler(conn -> {
            Channel channel = ((Http1xServerConnection)conn).channel();
            for (Map.Entry stringChannelHandlerEntry : channel.pipeline()) {
                ChannelHandler handler = (ChannelHandler)stringChannelHandlerEntry.getValue();
                this.assertFalse(handler instanceof Http1xUpgradeToH2CHandler);
                this.assertFalse(handler instanceof Http1xOrH2CHandler);
            }
        }).requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setTrustAll(true).setSsl(true));
        this.client.request(this.requestOptions).compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testIdleTimeoutInfiniteSkipOfControlCharactersState() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setIdleTimeout(1));
        this.server.requestHandler(req -> this.testComplete());
        this.startServer(this.testAddress);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, this.onSuccess(so -> {
            long id = this.vertx.setPeriodic(1L, timerID -> so.write((Object)Buffer.buffer().setInt(0, 13)));
            so.closeHandler(v -> {
                this.vertx.cancelTimer(id);
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testCompressedResponseWithConnectionCloseAndNoCompressionHeader() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setCompressionSupported(true));
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.putHeader("Connection", "close").send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
            this.assertEquals(expected, body);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testKeepAliveTimeoutHeader() throws Exception {
        AtomicBoolean sent = new AtomicBoolean();
        this.server.requestHandler(req -> {
            if (sent.compareAndSet(false, true)) {
                req.response().putHeader("keep-alive", "timeout=3").end();
            }
        });
        this.testKeepAliveTimeout(new HttpClientOptions().setMaxPoolSize(1).setKeepAliveTimeout(30), 1);
    }

    @Test
    public void testKeepAliveTimeoutHeaderReusePrevious() throws Exception {
        AtomicBoolean sent = new AtomicBoolean();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (sent.compareAndSet(false, true)) {
                resp.putHeader("keep-alive", "timeout=3");
            }
            resp.end();
        });
        this.testKeepAliveTimeout(new HttpClientOptions().setMaxPoolSize(1).setKeepAliveTimeout(30), 2);
    }

    @Test
    public void testKeepAliveTimeoutHeaderOverwritePrevious() throws Exception {
        AtomicBoolean sent = new AtomicBoolean();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            int timeout = sent.compareAndSet(false, true) ? 15 : 3;
            resp.putHeader("keep-alive", "timeout=" + timeout);
            resp.end();
        });
        this.testKeepAliveTimeout(new HttpClientOptions().setMaxPoolSize(1).setKeepAliveTimeout(30), 2);
    }

    @Test
    public void testPausedHttpServerRequestPauseTheConnectionAtRequestEnd() throws Exception {
        int numRequests = 20;
        this.waitFor(numRequests);
        this.server.requestHandler(req -> {
            int[] paused = new int[1];
            req.handler(buff -> {
                this.assertEquals("small", buff.toString());
                req.pause();
                paused[0] = paused[0] + 1;
                this.vertx.setTimer(10L, id -> {
                    paused[0] = paused[0] - 1;
                    req.resume();
                });
            });
            req.endHandler(v -> {
                this.assertEquals(0L, paused[0]);
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        for (int i = 0; i < numRequests; ++i) {
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(Buffer.buffer((String)"small"), resp -> this.complete())));
        }
        this.await();
    }

    @Test
    public void testPausedHttpClientResponseUnpauseTheConnectionAtRequestEnd() throws Exception {
        this.testHttpClientResponsePause((Handler<HttpClientResponse>)((Handler)resp -> resp.handler(buff -> {
            this.assertEquals("ok", buff.toString());
            resp.pause();
        })));
    }

    @Test
    public void testHttpClientResponsePauseIsIgnoredAtRequestEnd() throws Exception {
        this.testHttpClientResponsePause((Handler<HttpClientResponse>)((Handler)resp -> resp.endHandler(v -> resp.pause())));
    }

    private void testHttpClientResponsePause(Handler<HttpClientResponse> h) throws Exception {
        this.server.requestHandler(req -> req.response().end("ok"));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp1 -> {
            h.handle(resp1);
            this.vertx.setTimer(10L, timerId -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp2 -> {
                this.assertSame(resp1.request().connection(), resp2.request().connection());
                resp2.endHandler(v -> this.testComplete());
            })));
        }))));
        this.await();
    }

    @Test
    public void testPoolLIFOPolicy() throws Exception {
        ArrayList requests = new ArrayList();
        this.server.requestHandler(req -> {
            requests.add(req);
            switch (requests.size()) {
                case 2: {
                    requests.forEach(r -> r.response().end());
                    break;
                }
                case 3: {
                    req.response().end();
                }
            }
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(2));
        List connections = Collections.synchronizedList(new ArrayList());
        CountDownLatch latch = new CountDownLatch(2);
        this.vertx.runOnContext(v0 -> {
            for (int i = 0; i < 2; ++i) {
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v1 -> this.vertx.runOnContext(v2 -> {
                    connections.add(resp.request().connection());
                    latch.countDown();
                }))))));
            }
        });
        this.awaitLatch(latch);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertSame(resp.request().connection(), connections.get(1));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHttpClientResponseThrowsExceptionInResponseHandler() throws Exception {
        this.testHttpClientResponseThrowsExceptionInHandler(null, (resp, failure) -> {
            throw failure;
        });
    }

    @Test
    public void testHttpClientResponseThrowsExceptionInChunkHandler() throws Exception {
        this.testHttpClientResponseThrowsExceptionInHandler("blah", (resp, failure) -> resp.handler(chunk -> {
            throw failure;
        }));
    }

    @Test
    public void testHttpClientResponseThrowsExceptionInEndHandler() throws Exception {
        this.testHttpClientResponseThrowsExceptionInHandler(null, (resp, failure) -> resp.endHandler(v -> {
            throw failure;
        }));
    }

    private void testHttpClientResponseThrowsExceptionInHandler(String chunk, BiConsumer<HttpClientResponse, RuntimeException> handler) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (chunk != null) {
                resp.end(chunk);
            } else {
                resp.end();
            }
        });
        this.startServer(this.testAddress);
        int num = 50;
        this.waitFor(num);
        RuntimeException failure = new RuntimeException();
        for (int i = 0; i < num; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
                ctx.exceptionHandler(err -> {
                    if (err == failure) {
                        this.complete();
                    }
                });
                handler.accept((HttpClientResponse)resp, failure);
            }))));
        }
        this.await();
    }

    @Test
    public void testConnectionCloseDuringShouldCallHandleExceptionOnlyOnce() throws Exception {
        CompletableFuture continuation = new CompletableFuture();
        this.server.requestHandler(req -> {
            req.response().setChunked(true).write("chunk");
            continuation.thenAccept(v -> req.connection().close());
        });
        AtomicInteger count = new AtomicInteger();
        this.startServer(this.testAddress);
        CountDownLatch latch = new CountDownLatch(1);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(put -> {
            put.response(this.onSuccess(res -> continuation.complete(null)));
            put.setChunked(true);
            put.write((Object)TestUtils.randomBuffer(10000));
            put.exceptionHandler(x -> {
                if (count.incrementAndGet() == 1) {
                    this.vertx.setTimer(100L, id -> latch.countDown());
                }
            });
        }));
        this.awaitLatch(latch);
        this.assertEquals(count.get(), 1L);
    }

    @Test
    public void testDeferredRequestEnd() throws Exception {
        this.server.requestHandler(req -> {
            req.pause();
            req.bodyHandler(body -> {
                this.assertTrue(req.isEnded());
                req.response().end(body);
            });
            this.vertx.setTimer(10L, v -> {
                this.assertFalse(req.isEnded());
                req.resume();
            });
        });
        this.startServer(this.testAddress);
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(1024));
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(expected, this.onSuccess(resp -> resp.bodyHandler(body -> {
            this.assertEquals(expected, body);
            this.testComplete();
        })))));
        this.await();
    }

    @Test
    public void testPipelinedWithResponseSent() throws Exception {
        int numReq = 10;
        this.waitFor(numReq * 2);
        AtomicInteger inflight = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            int val = count.getAndIncrement();
            this.assertEquals(val + 1, inflight.incrementAndGet());
            req.pause();
            req.response().end("" + val);
            req.bodyHandler(body -> {
                if (inflight.decrementAndGet() == 0) {
                    this.assertEquals(numReq, count.get());
                }
                this.complete();
            });
            this.vertx.setTimer(1000L, v -> req.resume());
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setPipelining(true).setMaxPoolSize(1).setKeepAlive(true));
        this.vertx.runOnContext(v -> {
            for (int i = 0; i < numReq; ++i) {
                String expected = "" + i;
                this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(Buffer.buffer((String)TestUtils.randomAlphaString(1024)), this.onSuccess(resp -> resp.bodyHandler(body -> {
                    this.assertEquals(expected, body.toString());
                    this.complete();
                })))));
            }
        });
        this.await();
    }

    @Test
    public void testPipelinedWithPendingResponse() throws Exception {
        int numReq = 10;
        this.waitFor(numReq);
        AtomicInteger inflight = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            int val = count.getAndIncrement();
            this.assertEquals(0L, inflight.getAndIncrement());
            this.vertx.setTimer(100L, v -> {
                inflight.decrementAndGet();
                req.response().end("" + val);
            });
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setPipelining(true).setMaxPoolSize(1).setKeepAlive(true));
        this.vertx.runOnContext(v -> {
            for (int i = 0; i < numReq; ++i) {
                String expected = "" + i;
                this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(Buffer.buffer((String)TestUtils.randomAlphaString(1024)), this.onSuccess(resp -> resp.bodyHandler(body -> {
                    this.assertEquals(expected, body.toString());
                    this.complete();
                })))));
            }
        });
        this.await();
    }

    @Test
    public void testPipelinedPostRequestStartedByResponseSent() throws Exception {
        String chunk1 = TestUtils.randomAlphaString(1024);
        String chunk2 = TestUtils.randomAlphaString(1024);
        Promise latch2 = Promise.promise();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            switch (count.getAndIncrement()) {
                case 0: {
                    req.pause();
                    this.vertx.setTimer(500L, id -> req.resume());
                    req.endHandler(v -> req.response().end());
                    break;
                }
                case 1: {
                    latch2.complete();
                    req.bodyHandler(body -> {
                        this.assertEquals(chunk1 + chunk2, body.toString());
                        req.response().end();
                    });
                }
            }
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setPipelining(true).setMaxPoolSize(1).setKeepAlive(true));
        CountDownLatch latch1 = new CountDownLatch(1);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.end(TestUtils.randomAlphaString(1024), this.onSuccess(v -> latch1.countDown()))));
        this.awaitLatch(latch1);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(resp -> this.testComplete()).setChunked(true);
            req.write(chunk1);
            latch2.future().onComplete(this.onSuccess(v -> req.end(chunk2)));
        }));
        this.await();
    }

    @Test
    public void testBeginPipelinedRequestByResponseSentOnRequestCompletion() throws Exception {
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                req.pause();
                this.vertx.setTimer(100L, id -> req.resume());
            }
            req.endHandler(v -> req.response().end());
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setPipelining(true).setMaxPoolSize(1).setKeepAlive(true));
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).onComplete(this.onSuccess(req -> req.end(Buffer.buffer((String)TestUtils.randomAlphaString(1024)))));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testBeginPipelinedRequestByResponseSentBeforeRequestCompletion() throws Exception {
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.PUT) {
                req.pause();
                this.vertx.setTimer(100L, id1 -> {
                    req.response().end();
                    this.vertx.setTimer(100L, id2 -> req.resume());
                });
            } else if (req.method() == HttpMethod.GET) {
                req.response().end();
            }
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setPipelining(true).setMaxPoolSize(1).setKeepAlive(true));
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.end(Buffer.buffer((String)TestUtils.randomAlphaString(1024)))));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testPipeliningQueueDelayed() throws Exception {
        this.waitFor(3);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setPipelining(true).setMaxPoolSize(1).setKeepAlive(true));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> this.complete()));
            req.sendHead();
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(resp -> this.complete());
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(resp -> this.complete());
            this.vertx.setTimer(300L, id -> req.end());
        }));
        this.await();
    }

    @Test
    public void testHttpClientResponseBufferedWithPausedEnd() throws Exception {
        AtomicInteger i = new AtomicInteger();
        this.server.requestHandler(req -> req.response().end("HelloWorld" + i.incrementAndGet()));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        this.client.request(this.requestOptions, this.onSuccess(req1 -> req1.send(this.onSuccess(resp1 -> {
            resp1.pause();
            this.client.request(this.requestOptions, this.onSuccess(req2 -> req2.send(this.onSuccess(resp2 -> resp2.bodyHandler(body2 -> {
                this.assertEquals("HelloWorld2", body2.toString());
                resp1.bodyHandler(body1 -> {
                    this.assertEquals("HelloWorld1", body1.toString());
                    this.testComplete();
                });
                resp1.resume();
            })))));
        }))));
        this.await();
    }

    @Test
    public void testHttpClientResumeConnectionOnResponseOnLastMessage() throws Exception {
        this.server.requestHandler(req -> req.response().end("ok"));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setMaxPoolSize(1));
        this.client.request(this.requestOptions, this.onSuccess(req1 -> req1.send(this.onSuccess(resp1 -> {
            resp1.pause();
            resp1.resume();
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp2 -> this.testComplete()));
        }))));
        this.await();
    }

    @Test
    public void testSetChunkedToFalse() throws Exception {
        this.server.requestHandler(req -> req.response().setChunked(false).end());
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.setChunked(false).send(this.onSuccess(resp -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testHttpServerRequestShouldCallExceptionHandlerWhenTheClosedHandlerIsCalled() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(DEFAULT_HTTP_PORT)).requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)resp);
            sender.send();
            resp.closeHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.testComplete();
                }
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.vertx.setTimer(1000L, id -> resp.request().connection().close())))));
        this.await();
    }

    @Test
    public void testHttpClientRequestShouldCallExceptionHandlerWhenTheClosedHandlerIsCalled() throws Exception {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(DEFAULT_HTTP_PORT)).requestHandler(req -> this.vertx.setTimer(1000L, id -> req.response().close()));
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.setChunked(true);
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)req);
            AtomicBoolean connected = new AtomicBoolean();
            AtomicBoolean done = new AtomicBoolean();
            req.exceptionHandler(err -> {
                this.assertTrue(connected.get());
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else if (done.compareAndSet(false, true)) {
                    this.testComplete();
                }
            });
            req.sendHead(v -> {
                connected.set(true);
                sender.send();
            });
        }));
        this.await();
    }

    @Test
    public void testHeaderNameValidation() {
        for (char c : "\u001c\u001d\u001e\u001f\u0000\t\n\u000b\f\r ,:;=\u0080".toCharArray()) {
            try {
                HttpUtils.validateHeaderName((CharSequence)Character.toString(c));
                this.fail("Char 0x" + Integer.toHexString(c) + " should not be valid");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static List<String> invalidCharsForHeaders() {
        return Arrays.asList("\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\u000b", "\f", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "\u007f");
    }

    @Test
    public void testHeaderValueValidation() {
        ArrayList<String> invalid = new ArrayList<String>(Http1xTest.invalidCharsForHeaders());
        invalid.addAll(Arrays.asList("\r\n3", "\r3", "\n3", "\n\r"));
        for (String test : invalid) {
            try {
                HttpUtils.validateHeaderValue((CharSequence)test);
                this.fail("String \"" + test + "\" should not be valid");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        List<String> valid = Arrays.asList("\r\n\t", "\r\n ", "\n\t", "\n ");
        for (String test : valid) {
            HttpUtils.validateHeaderValue((CharSequence)test);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeaderNameStartsOrEndsWithControlChars() throws Exception {
        AtomicInteger invalidRequests = new AtomicInteger();
        this.server.invalidRequestHandler(req -> {
            invalidRequests.incrementAndGet();
            req.connection().close();
        });
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        try (NetClient client = this.vertx.createNetClient();){
            boolean[] positions;
            ArrayList<String> chars = new ArrayList<String>(Http1xTest.invalidCharsForHeaders());
            chars.addAll(Arrays.asList("\"", "(", ")", ",", "/", ";", "<", ">", "=", "?", "@", "[", "]", "\\", "{", "}", "\u0080", "\u0090", "\u00a0", "\u00b0", "\u00c0", "\u00d0", "\u00e0", "\u00f0", "\u00ff"));
            for (boolean position : positions = new boolean[]{true, false}) {
                for (String invalid : chars) {
                    int current = invalidRequests.get();
                    CountDownLatch latch = new CountDownLatch(1);
                    client.connect(this.testAddress, this.onSuccess(so -> {
                        so.write("GET /some/path HTTP/1.1\r\nHost: vertx.io\r\n" + (position ? invalid : "") + "Transfer-encoding" + (position ? "" : invalid) + ": chunked\r\n\r\n");
                        so.closeHandler(v -> latch.countDown());
                    }));
                    this.awaitLatch(latch);
                    Http1xTest.waitUntil(() -> invalidRequests.get() == current + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidHttpRequestHeaderResponse() throws Exception {
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        try (NetClient client = this.vertx.createNetClient();){
            CountDownLatch latch = new CountDownLatch(1);
            Buffer response = Buffer.buffer();
            client.connect(this.testAddress, this.onSuccess(so -> {
                so.write("GET /some/path HTTP/1.1\r\nHost: vertx.io\r\n\ud83d\ude31: val\r\n\r\n");
                so.handler(arg_0 -> ((Buffer)response).appendBuffer(arg_0));
                so.closeHandler(v -> latch.countDown());
            }));
            this.awaitLatch(latch);
            this.assertTrue(response.toString().startsWith("HTTP/1.1 400 Bad Request\r\n"));
        }
    }

    @Test
    public void testInvalidHttpResponseHeader() throws Exception {
        this.waitFor(2);
        NetServer server = this.vertx.createNetServer().connectHandler(so -> {
            AtomicBoolean sent = new AtomicBoolean();
            so.handler(buff -> {
                if (sent.compareAndSet(false, true)) {
                    so.write("HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\ud83d\ude31: val\r\n\r\n");
                }
            });
        });
        CountDownLatch latch = new CountDownLatch(1);
        server.listen(this.testAddress, this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.connection().exceptionHandler(err -> {
                this.assertEquals(IllegalArgumentException.class, err.getClass());
                this.complete();
            });
            req.send(this.onFailure(err -> {
                this.assertEquals(IllegalArgumentException.class, err.getClass());
                this.complete();
            }));
        }));
        this.await();
    }

    @Test
    public void testChunkedServerResponse() {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            this.assertTrue(resp.isChunked());
            resp.write("the-chunk");
            this.vertx.setTimer(1L, id -> resp.end());
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).compose(req -> req.send().compose(resp -> {
            this.assertEquals("chunked", resp.getHeader("transfer-encoding"));
            return resp.body();
        })).onComplete(this.onSuccess(body -> {
            this.assertEquals("the-chunk", body.toString());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testChunkedClientRequest() {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            this.assertEquals("chunked", req.getHeader("transfer-encoding"));
            req.bodyHandler(body -> {
                this.assertEquals("the-chunk", body.toString());
                req.response().end();
            });
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> this.testComplete())).setChunked(true);
            req.write("the-chunk");
            this.vertx.setTimer(1L, id -> req.end());
        }))));
        this.await();
    }

    @Test
    public void testClosingVertxCloseSharedServers() throws Exception {
        int numServers = 2;
        Vertx vertx = Vertx.vertx();
        ArrayList<HttpServerImpl> servers = new ArrayList<HttpServerImpl>();
        for (int i = 0; i < numServers; ++i) {
            HttpServer server2 = vertx.createHttpServer(this.createBaseServerOptions()).requestHandler(req -> {});
            this.startServer(server2);
            servers.add((HttpServerImpl)server2);
        }
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        servers.forEach(server -> this.assertTrue(server.isClosed()));
    }

    @Test
    public void testRandomSharedPortInVerticle() {
        this.testRandomPortInVerticle(3, new int[]{-1}, 1);
    }

    @Test
    public void testRandomSharedPortsInVerticle() {
        this.testRandomPortInVerticle(3, new int[]{-1, -2}, 2);
    }

    @Test
    public void testRandomPortsInVerticle1() {
        this.testRandomPortInVerticle(3, new int[]{0}, 3);
    }

    @Test
    public void testRandomPortsInVerticle2() {
        this.testRandomPortInVerticle(3, new int[]{0, 0}, 6);
    }

    private void testRandomPortInVerticle(int instances, final int[] bindPorts, int expectedPorts) {
        Assume.assumeTrue((String)"Domain socket don't pass this test", (boolean)this.testAddress.isInetSocket());
        this.waitFor(instances);
        final Set ports = Collections.synchronizedSet(new HashSet());
        this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start(Promise<Void> startFuture) {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (int bindPort : bindPorts) {
                    futures.add(this.vertx.createHttpServer().requestHandler(req -> req.response().end()).listen(bindPort, "localhost"));
                }
                CompositeFuture.all(futures).onComplete(Http1xTest.this.onSuccess(cf -> {
                    futures.stream().map(Future::result).map(HttpServer::actualPort).forEach(port -> {
                        Http1xTest.this.assertTrue(port > 0);
                        ports.add(port);
                    });
                    startFuture.complete();
                }));
            }
        }, new DeploymentOptions().setInstances(instances), this.onSuccess(id -> {
            this.assertEquals(expectedPorts, ports.size());
            int port = (Integer)ports.iterator().next();
            for (int i = 0; i < instances; ++i) {
                this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(port))).onComplete(this.onSuccess(req -> req.send(this.onSuccess(v -> this.complete()))));
            }
        }));
        this.await();
    }

    @Test
    public void testHttpServerWithIdleTimeoutSendChunkedFile() throws Exception {
        Assume.assumeTrue((!this.vertx.isNativeTransportEnabled() && !Utils.isWindows() ? 1 : 0) != 0);
        int expected = 0x2000000;
        File file = TestUtils.tmpFile(".dat", expected);
        int delay = this.retrieveFileFromServer(file, this.createBaseServerOptions());
        int timeout = delay / 2;
        delay = this.retrieveFileFromServer(file, this.createBaseServerOptions().setIdleTimeout(timeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS));
        this.assertTrue(delay > timeout);
    }

    private int retrieveFileFromServer(File file, HttpServerOptions options) throws Exception {
        this.server.close().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        this.server = this.vertx.createHttpServer(options).requestHandler(req -> req.response().sendFile(file.getAbsolutePath()));
        this.startServer(this.testAddress);
        long now = System.currentTimeMillis();
        Integer len = (Integer)this.getFile().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        this.assertEquals(len.intValue(), file.length());
        return (int)(System.currentTimeMillis() - now);
    }

    private Future<Integer> getFile() {
        int[] length = new int[]{0};
        return this.client.request(this.requestOptions).compose(req -> req.send().compose(resp -> {
            resp.handler(buff -> {
                length[0] = length[0] + buff.length();
                resp.pause();
                this.vertx.setTimer(1L, id -> resp.resume());
            });
            resp.exceptionHandler(this::fail);
            return resp.end();
        })).map(v -> length[0]);
    }

    @Test
    public void testSendFilePipelined() throws Exception {
        int n = 2;
        this.waitFor(n);
        File sent = TestUtils.tmpFile(".dat", 16384L);
        this.server.requestHandler(req -> req.response().sendFile(sent.getAbsolutePath()));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setPipelining(true).setMaxPoolSize(1));
        for (int i = 0; i < n; ++i) {
            this.client.request(this.requestOptions).compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> this.complete()));
        }
        this.await();
    }

    @Test
    public void testSendFileWithConnectionCloseHeader() throws Exception {
        String content = TestUtils.randomUnicodeString(0x200000);
        this.sendFile("test-send-file.html", content, false, () -> this.client.request(this.requestOptions).map(req -> req.putHeader(HttpHeaders.CONNECTION, (CharSequence)"close")));
    }

    @Test
    public void testResponseEndHandlersConnectionClose() {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.response().endHandler(v -> this.complete());
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.putHeader(HttpHeaders.CONNECTION, (CharSequence)"close");
            req.send(this.onSuccess(res -> {
                this.assertEquals(200L, res.statusCode());
                this.complete();
            }));
        }))));
        this.await();
    }

    @Test
    public void testUnsolicitedHttpResponse() throws Exception {
        this.waitFor(2);
        NetServer server = this.vertx.createNetServer().connectHandler(so -> {
            AtomicBoolean sent = new AtomicBoolean();
            so.handler(buff -> {
                if (sent.compareAndSet(false, true)) {
                    so.write("HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\nHTTP/1.1 200 OK\r\n\r\n");
                    so.close();
                }
            });
        });
        CountDownLatch latch = new CountDownLatch(1);
        server.listen(this.testAddress, this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.connectionHandler(conn -> {
            AtomicBoolean failed = new AtomicBoolean();
            conn.exceptionHandler(err -> failed.set(true));
            conn.closeHandler(v -> {
                this.assertTrue(failed.get());
                this.complete();
            });
        });
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.body(this.onSuccess(v2 -> this.complete()))))));
        this.await();
    }

    @Test
    public void testClientConnectionGracefulShutdown() throws Exception {
        this.waitFor(2);
        int numReq = 3;
        AtomicReference clientConnection = new AtomicReference();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (count.getAndIncrement() == 0) {
                ((HttpConnection)clientConnection.get()).shutdown().onComplete(this.onSuccess(v -> this.complete()));
            }
            req.response().end();
        });
        this.startServer(this.testAddress);
        AtomicInteger responses = new AtomicInteger();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setPipelining(true));
        this.vertx.runOnContext(v1 -> {
            this.client.connectionHandler(conn -> {
                conn.closeHandler(v2 -> {
                    this.assertEquals(3L, responses.get());
                    this.complete();
                });
                clientConnection.set(conn);
            });
            for (int i = 0; i < numReq; ++i) {
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> responses.incrementAndGet()))));
            }
        });
        this.await();
    }

    @Test
    public void testClientConnectionGracefulShutdownWhenRequestCompletedAfterResponse() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.response(this.onSuccess(resp -> {
            AtomicBoolean requestEnded = new AtomicBoolean();
            HttpConnection conn = req.connection();
            conn.closeHandler(v -> {
                this.assertTrue(requestEnded.get());
                this.complete();
            });
            conn.shutdown().onComplete(this.onSuccess(v -> this.complete()));
            resp.endHandler(v -> this.vertx.runOnContext(v2 -> {
                requestEnded.set(true);
                req.end();
            }));
        })).setChunked(true).sendHead()));
        this.await();
    }

    @Test
    public void testClientConnectionShutdownTimedOut() throws Exception {
        AtomicReference clientConnectionRef = new AtomicReference();
        int numReq = 3;
        this.waitFor(numReq + 2);
        this.server.requestHandler(req -> {
            HttpConnection clientConnection = clientConnectionRef.getAndSet(null);
            if (clientConnection != null) {
                long now = System.currentTimeMillis();
                clientConnection.shutdown(500L).onComplete(this.onSuccess(v -> {
                    this.assertTrue(System.currentTimeMillis() - now >= 500L);
                    this.complete();
                }));
            }
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setPipelining(true));
        this.client.connectionHandler(conn -> {
            clientConnectionRef.set(conn);
            long now = System.currentTimeMillis();
            conn.closeHandler(v -> {
                this.assertTrue(System.currentTimeMillis() - now >= 500L);
                this.complete();
            });
        });
        for (int i = 0; i < numReq; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> this.complete()))));
        }
        this.await();
    }

    @Test
    public void testClientConnectionShutdownNow() throws Exception {
        AtomicReference clientConnectionRef = new AtomicReference();
        this.waitFor(2);
        this.server.requestHandler(req -> {
            long now = System.currentTimeMillis();
            ((HttpConnection)clientConnectionRef.get()).shutdown(0L).onComplete(this.onSuccess(v -> {
                this.assertTrue(System.currentTimeMillis() - now <= 2000L);
                this.complete();
            }));
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setPipelining(true));
        this.client.connectionHandler(clientConnectionRef::set);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> this.complete()))));
        this.await();
    }

    @Test
    public void testClientNetSocketPooling() {
        int maxPoolSize = 5;
        int num = 6;
        this.waitFor(num);
        this.server.requestHandler(req -> req.toNetSocket(this.onSuccess(so -> this.vertx.setTimer(200L, id -> so.close()))));
        this.server.listen(this.onSuccess(s -> {
            AtomicInteger count = new AtomicInteger();
            for (int i = 0; i < num; ++i) {
                this.client.request(new RequestOptions().setMethod(HttpMethod.CONNECT).setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setHost("localhost").setURI("some-uri")).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
                    NetSocket sock = resp.netSocket();
                    int val = count.incrementAndGet();
                    this.assertTrue("Expected " + val + " <= " + maxPoolSize, val <= maxPoolSize);
                    sock.closeHandler(v -> {
                        count.decrementAndGet();
                        this.complete();
                    });
                }))));
            }
        }));
        this.await();
    }

    @Test
    public void testHttpUpgrade() {
        this.testHttpConnect(new RequestOptions(this.requestOptions).setMethod(HttpMethod.GET).addHeader(HttpHeaders.CONNECTION, (CharSequence)"UpGrAdE"), 101);
    }

    @Test
    public void testServerResponseReset() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().reset());
        this.startServer(this.testAddress);
        this.client.connectionHandler(conn -> conn.closeHandler(v -> this.complete()));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onFailure(err -> this.complete()));
        this.await();
    }

    @Test
    public void testNetSocketUpgradeSuccess() {
        this.testNetSocketUpgradeSuccess(null);
    }

    @Test
    public void testNetSocketUpgradeSuccessWithPayload() {
        this.testNetSocketUpgradeSuccess(Buffer.buffer((String)"the-payload"));
    }

    private void testNetSocketUpgradeSuccess(Buffer payload) {
        this.server.requestHandler(req -> req.body(this.onSuccess(body -> {
            if (payload != null) {
                this.assertEquals(payload, body);
            }
            req.response().setStatusCode(101);
            req.toNetSocket().onComplete(this.onSuccess(so -> so.handler(buff -> {
                this.assertEquals("ping", buff.toString());
                so.write("pong");
                so.close();
            })));
        })));
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            RequestOptions request = new RequestOptions(this.requestOptions).setMethod(HttpMethod.GET).addHeader(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE);
            if (payload != null) {
                request.addHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)("" + payload.length()));
            }
            this.client.request(request).onComplete(this.onSuccess(req -> {
                req.connect(this.onSuccess(resp -> {
                    NetSocket so = resp.netSocket();
                    so.write("ping");
                    so.handler(buff -> {
                        this.assertEquals("pong", buff.toString());
                        so.close(this.onSuccess(v -> this.testComplete()));
                    });
                }));
                if (payload != null) {
                    req.end(payload);
                }
            }));
        }));
        this.await();
    }

    @Test
    public void testClientEventLoopSize() throws Exception {
        Assume.assumeTrue((String)"Domain socket don't pass this test", (boolean)this.testAddress.isInetSocket());
        int size = 4;
        int maxPoolSize = size + 2;
        ArrayList requests = new ArrayList();
        this.server.requestHandler(req -> {
            requests.add(req);
            if (requests.size() == maxPoolSize) {
                requests.forEach(_req -> _req.response().end());
            } else if (requests.size() > maxPoolSize) {
                req.response().end();
            }
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(maxPoolSize).setPoolEventLoopSize(size));
        List eventLoops = Collections.synchronizedList(new ArrayList());
        this.client.connectionHandler(conn -> eventLoops.add(((ContextInternal)Vertx.currentContext()).nettyEventLoop()));
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < size * 2; ++i) {
            futures.add(this.client.request(this.requestOptions).compose(request -> request.send().compose(HttpClientResponse::body)));
        }
        CompositeFuture.all(futures).onComplete(this.onSuccess(v -> {
            this.assertEquals(maxPoolSize, eventLoops.size());
            this.assertEquals(size, new HashSet(eventLoops).size());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testServerResponseChunkedSend() throws Exception {
        this.testServerResponseSend(true);
    }

    @Test
    public void testEmptyHostHeader() throws Exception {
        this.testEmptyHostPortionOfHostHeader("", -1);
    }

    @Test
    public void testEmptyHostPortionOfHostHeader() throws Exception {
        this.testEmptyHostPortionOfHostHeader(":" + DEFAULT_HTTP_PORT, DEFAULT_HTTP_PORT);
    }

    private void testEmptyHostPortionOfHostHeader(String hostHeader, int expectedPort) throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(hostHeader, req.host());
            this.assertTrue(((HttpServerRequestInternal)req).isValidAuthority());
            this.assertEquals("", req.authority().host());
            this.assertEquals(expectedPort, req.authority().port());
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions().setServer(this.testAddress).putHeader((CharSequence)HttpHeaderNames.HOST, (CharSequence)hostHeader)).compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testServerMissingHostHeader() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(null, req.host());
            this.assertFalse(((HttpServerRequestInternal)req).isValidAuthority());
            this.assertNull(req.authority());
            this.testComplete();
        });
        this.startServer(this.testAddress);
        NetClient nc = this.vertx.createNetClient();
        nc.connect(this.testAddress).onComplete(this.onSuccess(so -> so.write("GET / HTTP/1.1\r\n\r\n")));
        this.await();
    }

    @Test
    public void testClientMissingHostHeader() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(null, req.authority());
            this.assertFalse(((HttpServerRequestInternal)req).isValidAuthority());
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(request -> request.authority(null).send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::end)).toCompletionStage().toCompletableFuture().get(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testCanUpgradeToWebSocket() throws Exception {
        UnaryOperator config = ro -> ro.setMethod(HttpMethod.GET).putHeader(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE).putHeader(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET);
        this.doTestCanUpgradeToWebSocket(config, true);
    }

    @Test
    public void testCanUpgradeToWebSocketFirefox() throws Exception {
        UnaryOperator config = ro -> ro.setMethod(HttpMethod.GET).putHeader(HttpHeaders.CONNECTION, (CharSequence)(HttpHeaders.KEEP_ALIVE + ", " + HttpHeaders.UPGRADE)).putHeader(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET);
        this.doTestCanUpgradeToWebSocket(config, true);
    }

    @Test
    public void testCannotUpgradePostRequestToWebSocket() throws Exception {
        UnaryOperator config = ro -> ro.setMethod(HttpMethod.POST).putHeader(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE).putHeader(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET);
        this.doTestCanUpgradeToWebSocket(config, false);
    }

    @Test
    public void testCannotUpgradeToWebSocketIfConnectionHeaderIsMissing() throws Exception {
        UnaryOperator config = ro -> ro.setMethod(HttpMethod.GET).putHeader(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET);
        this.doTestCanUpgradeToWebSocket(config, false);
    }

    @Test
    public void testCannotUpgradeToWebSocketIfUpgradeDoesNotContainWebsocket() throws Exception {
        UnaryOperator config = ro -> ro.setMethod(HttpMethod.GET).putHeader(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE).putHeader(HttpHeaders.UPGRADE, (CharSequence)"foo");
        this.doTestCanUpgradeToWebSocket(config, false);
    }

    private void doTestCanUpgradeToWebSocket(UnaryOperator<RequestOptions> config, boolean shouldSucceed) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (HttpUtils.canUpgradeToWebSocket((HttpServerRequest)req)) {
                resp.headers().set(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE).set(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET);
                req.toNetSocket().onComplete(this.onSuccess(sock -> sock.write((Object)Buffer.buffer((String)"foo"))));
            } else {
                resp.setStatusCode(500).end();
            }
        });
        this.startServer(this.testAddress);
        this.client.request((RequestOptions)config.apply(new RequestOptions(this.requestOptions))).onComplete(this.onSuccess(req -> {
            req.response().onComplete(this.onSuccess(resp -> {
                if (shouldSucceed) {
                    this.assertEquals(101L, resp.statusCode());
                    resp.netSocket().handler(buffer -> {
                        this.assertEquals("foo", buffer.toString());
                        this.testComplete();
                    });
                } else {
                    this.assertEquals(500L, resp.statusCode());
                    this.testComplete();
                }
            }));
            req.send();
        }));
        this.await();
    }

    @Test
    public void testDoNotRecycleWhenRequestIsNotEnded() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(request -> {
            HttpServerResponse resp = request.response();
            resp.end().onComplete(this.onSuccess(v -> request.connection().close()));
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new PoolOptions().setHttp1MaxSize(1));
        int i = 0;
        while (i < 2) {
            int val = i++;
            Future fut = this.client.request(this.requestOptions);
            fut.onComplete(ar -> {
                switch (val) {
                    case 0: {
                        this.assertTrue(ar.succeeded());
                        HttpClientRequest req = (HttpClientRequest)ar.result();
                        req.sendHead();
                        req.response().onComplete(this.onSuccess(resp -> this.complete()));
                        break;
                    }
                    case 1: {
                        this.assertTrue(ar.succeeded());
                        this.complete();
                    }
                }
            });
        }
        this.await();
    }

    @Test
    public void testRecycleConnectionOnRequestEnd() throws Exception {
        int numRequests = 10;
        this.waitFor(numRequests);
        this.server.requestHandler(request -> request.response().end());
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new PoolOptions().setHttp1MaxSize(1));
        for (int i = 0; i < numRequests; ++i) {
            Future fut = this.client.request(this.requestOptions);
            fut.onComplete(this.onSuccess(request -> {
                request.setChunked(true).sendHead();
                request.response().compose(HttpClientResponse::body).onComplete(this.onSuccess(v -> {
                    this.vertx.setTimer(10L, id -> request.end());
                    this.complete();
                }));
            }));
        }
        this.await();
    }

    @Test
    public void testFailPendingRequestAllocationWhenConnectionIsClosed() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(request -> {
            HttpServerResponse resp = request.response();
            resp.end().onComplete(this.onSuccess(v -> request.connection().close()));
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setPipelining(true), new PoolOptions().setHttp1MaxSize(1));
        int i = 0;
        while (i < 2) {
            int val = i++;
            Future fut = this.client.request(this.requestOptions);
            fut.onComplete(ar -> {
                switch (val) {
                    case 0: {
                        this.assertTrue(ar.succeeded());
                        HttpClientRequest req = (HttpClientRequest)ar.result();
                        req.sendHead();
                        req.response().onComplete(this.onSuccess(resp -> this.complete()));
                        break;
                    }
                    case 1: {
                        this.assertTrue(ar.failed());
                        this.complete();
                    }
                }
            });
        }
        this.await();
    }

    @Test
    public void testUnsolicitedMessagesAreTreatedAsInvalid() throws Exception {
        NetServer server = this.vertx.createNetServer().connectHandler(so -> so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello World"));
        server.listen(this.testAddress).toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        HttpClient client = this.vertx.httpClientBuilder().withConnectHandler(conn -> {
            ArrayList invalidMessages = new ArrayList();
            ((HttpClientConnection)conn).invalidMessageHandler(invalidMessages::add);
            conn.exceptionHandler(err -> {});
            conn.closeHandler(v -> {
                this.assertEquals(2L, invalidMessages.size());
                this.assertTrue(invalidMessages.get(0) instanceof HttpResponse);
                this.assertTrue(invalidMessages.get(1) instanceof LastHttpContent);
                this.testComplete();
            });
        }).build();
        client.request(this.requestOptions);
        this.await();
    }

    private /* synthetic */ void lambda$testContexts$171(String path, Context requestCtx, Set threads, Map responseResumeMap, AtomicInteger cnt, int numReqs, Set expectedThreads, CountDownLatch latch2, Buffer data, CompletableFuture cf, Void v) {
        Thread t = Thread.currentThread();
        this.client.request(new RequestOptions(this.requestOptions).setURI(path)).onComplete(this.onSuccess(req -> {
            this.assertSame(t, Thread.currentThread());
            req.response(this.onSuccess(resp -> {
                this.assertSameEventLoop(requestCtx, Vertx.currentContext());
                this.assertEquals(200L, resp.statusCode());
                threads.add(Thread.currentThread());
                resp.pause();
                ((CompletionStage)responseResumeMap.get(path)).thenAccept(v2 -> resp.resume());
                resp.handler(chunk -> this.assertSameEventLoop(requestCtx, Vertx.currentContext()));
                resp.exceptionHandler(this::fail);
                resp.endHandler(v2 -> {
                    this.assertSameEventLoop(requestCtx, Vertx.currentContext());
                    if (cnt.incrementAndGet() == numReqs) {
                        this.assertEquals(expectedThreads, new HashSet(threads));
                        latch2.countDown();
                    }
                });
            })).setChunked(true).exceptionHandler(this::fail);
            req.drainHandler(v2 -> {
                this.assertSameEventLoop(requestCtx, Vertx.currentContext());
                req.end();
            });
            req.sendHead(version -> {
                this.assertSameEventLoop(requestCtx, Vertx.currentContext());
                this.fill(data, (WriteStream<Buffer>)req, cf::complete);
            });
        }));
    }

    private /* synthetic */ void lambda$testSharedServersRoundRobin$95(AtomicReference context, Set contexts, Set connectedServers, HttpServer theServer, Map requestCount, CountDownLatch latchConns, HttpServerRequest req) {
        Context ctx = Vertx.currentContext();
        if (context.get() != null) {
            this.assertSameEventLoop(ctx, (Context)context.get());
        } else {
            context.set(ctx);
            contexts.add(ctx);
        }
        connectedServers.add(theServer);
        Integer cnt = (Integer)requestCount.get(theServer);
        int icnt = cnt == null ? 0 : cnt;
        requestCount.put(theServer, ++icnt);
        latchConns.countDown();
        req.response().end();
    }

    private static /* synthetic */ void lambda$testKeepAlive$75(Set connectedServers, HttpServer server, HttpServerRequest req) {
        connectedServers.add(server);
        req.response().end();
    }
}

