/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.junit.Test;

public class Http2MYRServerTest
extends Http2TestBase {
    @Test
    public void testMYR() throws Exception {
        final int maxConcurrentStreams = 10;
        int maxRstFramePerWindow = 15;
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setHttp2RstFloodMaxRstFramePerWindow(maxRstFramePerWindow).setInitialSettings(new Http2Settings().setMaxConcurrentStreams((long)maxConcurrentStreams)).setHttp2ClearTextEnabled(true));
        AtomicInteger inflightRequests = new AtomicInteger();
        AtomicInteger maxInflightRequests = new AtomicInteger();
        final AtomicInteger receivedRstFrames = new AtomicInteger();
        final CompletableFuture goAway = new CompletableFuture();
        server.requestHandler(req -> {
            int val = inflightRequests.incrementAndGet();
            if (val > maxInflightRequests.get()) {
                maxInflightRequests.set(val);
            }
            req.exceptionHandler(err -> inflightRequests.decrementAndGet());
        });
        server.listen(8080, "localhost").toCompletionStage().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        class Http2Bootstrap {
            Http2Bootstrap() {
            }

            protected ChannelInitializer<?> channelInitializer(final BiConsumer<ChannelHandlerContext, Http2ConnectionHandler> handler) {
                return new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        class Builder
                        extends AbstractHttp2ConnectionHandlerBuilder<Http2ConnectionHandler, Builder> {
                            private Http2ConnectionHandler connectionHandler;

                            Builder() {
                            }

                            protected Http2ConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, io.netty.handler.codec.http2.Http2Settings initialSettings) throws Exception {
                                this.connectionHandler = new Http2ConnectionHandler(decoder, encoder, initialSettings){};
                                return this.connectionHandler;
                            }

                            public Http2ConnectionHandler build() {
                                DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader((Http2HeadersDecoder)new DefaultHttp2HeadersDecoder(this.isValidateHeaders(), 8192L, -1)){

                                    public void readFrame(ChannelHandlerContext ctx, ByteBuf input, Http2FrameListener listener) throws Http2Exception {
                                        super.readFrame(ctx, input, (Http2FrameListener)new Http2FrameListenerDecorator(listener){

                                            public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
                                                receivedRstFrames.incrementAndGet();
                                                try {
                                                    super.onRstStreamRead(ctx, streamId, errorCode);
                                                }
                                                catch (Http2Exception http2Exception) {
                                                    // empty catch block
                                                }
                                            }
                                        });
                                    }
                                };
                                DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter(this.headerSensitivityDetector());
                                DefaultHttp2Connection connection = new DefaultHttp2Connection(false, maxConcurrentStreams);
                                DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)connection, (Http2FrameWriter)writer);
                                DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader, this.promisedRequestVerifier(), this.isAutoAckSettingsFrame(), this.isAutoAckPingFrame(), this.isValidateHeaders());
                                this.codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder);
                                this.frameListener((Http2FrameListener)new Http2EventAdapter(){
                                    private boolean initialSettings = true;

                                    public void onSettingsRead(ChannelHandlerContext ctx, io.netty.handler.codec.http2.Http2Settings settings) throws Http2Exception {
                                        if (this.initialSettings) {
                                            this.initialSettings = false;
                                            handler.accept(ctx, connectionHandler);
                                        }
                                    }

                                    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                                        goAway.complete(null);
                                    }
                                });
                                return super.build();
                            }
                        }
                        Builder clientHandlerBuilder = new Builder();
                        Http2ConnectionHandler clientHandler = clientHandlerBuilder.build();
                        ch.pipeline().addLast(new ChannelHandler[]{clientHandler});
                    }
                };
            }

            public ChannelFuture connect(int port, String host, BiConsumer<ChannelHandlerContext, Http2ConnectionHandler> handler) {
                Bootstrap bootstrap = new Bootstrap();
                NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
                Http2MYRServerTest.this.eventLoopGroups.add(eventLoopGroup);
                bootstrap.channel(NioSocketChannel.class);
                bootstrap.group((EventLoopGroup)eventLoopGroup);
                bootstrap.handler(this.channelInitializer(handler));
                return bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
            }
        }
        Http2Bootstrap bootstrap = new Http2Bootstrap();
        bootstrap.connect(8080, "localhost", (chctx, connectionHandler) -> {
            int numStreams = maxConcurrentStreams + 100;
            Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"GET").scheme((CharSequence)"http").path((CharSequence)"/").authority((CharSequence)"localhost:8080");
            Http2FrameWriter frameWriter = connectionHandler.encoder().frameWriter();
            for (int i = 0; i < numStreams; ++i) {
                int id = connectionHandler.connection().local().incrementAndGetNextStreamId();
                frameWriter.writeHeaders(chctx, id, headers, 0, true, chctx.newPromise());
                frameWriter.writeWindowUpdate(chctx, id, 0, chctx.newPromise());
            }
            chctx.flush();
        }).sync();
        goAway.get(10L, TimeUnit.SECONDS);
        this.assertEquals(receivedRstFrames.get(), maxRstFramePerWindow + 1);
        this.assertEquals(maxInflightRequests.get(), maxRstFramePerWindow + 1);
    }
}

