/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.buffer.Unpooled;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientInternal;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.SocketAddress;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public abstract class HttpClientConnectionTest
extends HttpTestBase {
    private File tmp;
    protected HttpClientInternal client;
    protected SocketAddress peerAddress;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = (HttpClientInternal)((HttpTestBase)this).client;
        this.peerAddress = SocketAddress.inetSocketAddress((int)this.requestOptions.getPort(), (String)this.requestOptions.getHost());
    }

    @Test
    public void testGet() throws Exception {
        this.server.requestHandler(req -> req.response().end("Hello World"));
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress, this.peerAddress).compose(conn -> conn.createRequest((ContextInternal)this.vertx.getOrCreateContext())).compose(request -> request.send().andThen(this.onSuccess(resp -> this.assertEquals(200L, resp.statusCode()))).compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
            this.assertEquals("Hello World", body.toString());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStreamGet() throws Exception {
        this.waitFor(3);
        this.server.requestHandler(req -> req.response().end("Hello World"));
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress, this.peerAddress).onComplete(this.onSuccess(conn -> conn.createStream((ContextInternal)this.vertx.getOrCreateContext(), this.onSuccess(stream -> {
            stream.writeHead(new HttpRequestHead(HttpMethod.GET, "/", MultiMap.caseInsensitiveMultiMap(), DEFAULT_HTTP_HOST_AND_PORT, "", null), false, Unpooled.EMPTY_BUFFER, true, new StreamPriority(), false, this.onSuccess(v -> {}));
            stream.headHandler(resp -> {
                this.assertEquals(200L, resp.statusCode);
                this.complete();
            });
            stream.endHandler(headers -> {
                this.assertEquals(0L, headers.size());
                this.complete();
            });
            stream.closeHandler(v -> this.complete());
        }))));
        this.await();
    }

    @Test
    public void testConnectionClose() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().close());
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress, this.peerAddress).onComplete(this.onSuccess(conn -> {
            AtomicInteger evictions = new AtomicInteger();
            conn.evictionHandler(v -> {
                this.assertEquals(1L, evictions.incrementAndGet());
                this.complete();
            });
            conn.createStream((ContextInternal)this.vertx.getOrCreateContext(), this.onSuccess(stream -> {
                stream.writeHead(new HttpRequestHead(HttpMethod.GET, "/", MultiMap.caseInsensitiveMultiMap(), DEFAULT_HTTP_HOST_AND_PORT, "", null), false, Unpooled.EMPTY_BUFFER, true, new StreamPriority(), false, this.onSuccess(v -> {}));
                stream.headHandler(resp -> this.fail());
                stream.endHandler(headers -> this.fail());
                stream.closeHandler(v -> {
                    this.assertEquals(1L, evictions.get());
                    this.complete();
                });
            }));
        }));
        this.await();
    }
}

