/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Future;
import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClientResponse;
import org.junit.Test;

public class Http2StreamByteDistributorTest
extends Http2TestBase {
    @Test
    public void smokeTest() throws Exception {
        System.setProperty("vertx.h2StreamByteDistributor", "uniform");
        try {
            this.server.requestHandler(req -> req.response().end("Hello World"));
            this.startServer(this.testAddress);
            Future response = this.client.request(this.requestOptions).compose(req -> req.send().andThen(this.onSuccess(resp -> this.assertEquals(200L, resp.statusCode()))).compose(HttpClientResponse::body));
            response.onComplete(this.onSuccess(body -> {
                this.assertEquals("Hello World", body.toString());
                this.testComplete();
            }));
            this.await();
        }
        finally {
            System.clearProperty("vertx.h2StreamByteDistributor");
        }
    }
}

