/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.PooledByteBufAllocator;
import io.vertx.core.buffer.impl.PartialPooledByteBufAllocator;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import javax.net.ssl.SSLContext;
import org.junit.Test;

public class SSLAllocatorTest
extends VertxTestBase {
    @Test
    public void testUsePartialPooledByteBufAllocatorInstanceWhenNotSpecified() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpClientOptions().setSsl(true).setKeyStoreOptions((JksOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            this.assertTrue(provider.jdkSSLProvider());
            this.assertSame(PartialPooledByteBufAllocator.INSTANCE, helper.clientByteBufAllocator(provider));
            this.assertSame(PartialPooledByteBufAllocator.INSTANCE, helper.serverByteBufAllocator(provider));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUsePartialPooledByteBufAllocatorInstanceIfDefaultJDKSSLIsConfigured() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()).setKeyStoreOptions((JksOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            this.assertTrue(provider.jdkSSLProvider());
            this.assertSame(PartialPooledByteBufAllocator.INSTANCE, helper.clientByteBufAllocator(provider));
            this.assertSame(PartialPooledByteBufAllocator.INSTANCE, helper.serverByteBufAllocator(provider));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUsePooledByteBufAllocatorDefaultIfJDKSSLPooledHeapBufferConfigured() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions().setPooledHeapBuffers(true)).setKeyStoreOptions((JksOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            this.assertTrue(provider.jdkSSLProvider());
            this.assertSame(PooledByteBufAllocator.DEFAULT, helper.clientByteBufAllocator(provider));
            this.assertSame(PooledByteBufAllocator.DEFAULT, helper.serverByteBufAllocator(provider));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testClientUsePartialPooledByteBufAllocatorInstanceIfSSLNotConfigured() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpClientOptions().setSsl(false).setKeyStoreOptions((JksOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            this.assertSame(PartialPooledByteBufAllocator.INSTANCE, helper.clientByteBufAllocator(provider));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testServerUsePooledByteBufAllocatorInstanceIfSSLNotConfigured() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpServerOptions().setSsl(false).setKeyStoreOptions((JksOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            this.assertSame(PooledByteBufAllocator.DEFAULT, helper.serverByteBufAllocator(provider));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUsePooledByteBufAllocatorDefaultIfOpenSSLIsConfigured() {
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpClientOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions()).setSsl(true).setPemKeyCertOptions((PemKeyCertOptions)Cert.CLIENT_PEM.get()).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_PEM.get()).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            this.assertFalse(provider.jdkSSLProvider());
            this.assertSame(PartialPooledByteBufAllocator.INSTANCE, helper.clientByteBufAllocator(provider));
            this.assertSame(PartialPooledByteBufAllocator.INSTANCE, helper.serverByteBufAllocator(provider));
            this.testComplete();
        }));
        this.await();
    }
}

