/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.proxy;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public abstract class TestProxyBase<P extends TestProxyBase<P>> {
    private Supplier<String> username;
    protected int port;
    protected String lastUri;
    protected String forceUri;
    protected List<String> localAddresses = Collections.synchronizedList(new ArrayList());
    protected long successDelayMillis = 0L;

    public TestProxyBase() {
        this.port = this.defaultPort();
    }

    public P username(String username) {
        this.username = () -> username;
        return (P)this;
    }

    public P username(Supplier<String> username) {
        this.username = username;
        return (P)this;
    }

    public P username(Collection<String> username) {
        Iterator<String> it = username.iterator();
        this.username = () -> it.hasNext() ? (String)it.next() : null;
        return (P)this;
    }

    public String nextUserName() {
        return this.username != null ? this.username.get() : null;
    }

    public P port(int port) {
        this.port = port;
        return (P)this;
    }

    public int port() {
        return this.port;
    }

    public abstract int defaultPort();

    public String lastLocalAddress() {
        int idx = this.localAddresses.size();
        return idx == 0 ? null : this.localAddresses.get(idx - 1);
    }

    public List<String> localAddresses() {
        return this.localAddresses;
    }

    public String getLastUri() {
        return this.lastUri;
    }

    public HttpMethod getLastMethod() {
        throw new UnsupportedOperationException();
    }

    public void setForceUri(String uri) {
        this.forceUri = uri;
    }

    public MultiMap getLastRequestHeaders() {
        throw new UnsupportedOperationException();
    }

    public abstract TestProxyBase start(Vertx var1) throws Exception;

    public abstract void stop();

    public void successDelayMillis(long delayMillis) {
        this.successDelayMillis = delayMillis;
    }
}

