/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.internal.PlatformDependent;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SelfSignedCertificate;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.HAProxyMessageCompletionHandler;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.tls.SslContextFactory;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.CheckingSender;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.netty.TestLoggerFactory;
import io.vertx.test.proxy.HAProxy;
import io.vertx.test.proxy.HttpProxy;
import io.vertx.test.proxy.Socks4Proxy;
import io.vertx.test.proxy.SocksProxy;
import io.vertx.test.proxy.TestProxyBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NetTest
extends VertxTestBase {
    private static final Logger log = LoggerFactory.getLogger(NetTest.class);
    private SocketAddress testAddress;
    private NetServer server;
    private NetClient client;
    private TestProxyBase proxy;
    private File tmp;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (USE_DOMAIN_SOCKETS) {
            this.assertTrue("Native transport not enabled", USE_NATIVE_TRANSPORT);
            this.tmp = TestUtils.tmpFile(".sock");
            this.testAddress = SocketAddress.domainSocketAddress((String)this.tmp.getAbsolutePath());
        } else {
            this.testAddress = SocketAddress.inetSocketAddress((int)1234, (String)"localhost");
        }
        this.client = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1000));
        this.server = this.vertx.createNetServer();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host1\n127.0.0.1 host2.com\n127.0.0.1 example.com"));
        return options;
    }

    protected void awaitClose(NetServer server) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        server.close(asyncResult -> latch.countDown());
        this.awaitLatch(latch);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.tmp != null) {
            this.tmp.delete();
        }
        if (this.proxy != null) {
            this.proxy.stop();
        }
        super.tearDown();
    }

    @Test
    public void testClientOptions() {
        NetClientOptions options = new NetClientOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(rand));
        this.assertEquals(rand, options.getIdleTimeout());
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertFalse(options.isTrustAll());
        this.assertEquals(options, options.setTrustAll(true));
        this.assertTrue(options.isTrustAll());
        String randomAlphaString = TestUtils.randomAlphaString(10);
        this.assertTrue(options.getHostnameVerificationAlgorithm().isEmpty());
        this.assertEquals(options, options.setHostnameVerificationAlgorithm(randomAlphaString));
        this.assertEquals(randomAlphaString, options.getHostnameVerificationAlgorithm());
        this.assertEquals(0L, options.getReconnectAttempts());
        TestUtils.assertIllegalArgumentException(() -> options.setReconnectAttempts(-2));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReconnectAttempts(rand));
        this.assertEquals(rand, options.getReconnectAttempts());
        this.assertEquals(1000L, options.getReconnectInterval());
        TestUtils.assertIllegalArgumentException(() -> options.setReconnectInterval(0L));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReconnectInterval((long)rand));
        this.assertEquals(rand, options.getReconnectInterval());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        this.assertEquals(10L, options.getSslHandshakeTimeout());
        long randLong = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setSslHandshakeTimeout(randLong));
        this.assertEquals(randLong, options.getSslHandshakeTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setSslHandshakeTimeout(-123L));
        this.testComplete();
    }

    @Test
    public void testServerOptions() {
        NetServerOptions options = new NetServerOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(rand));
        this.assertEquals(rand, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(-1L, options.getAcceptBacklog());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setAcceptBacklog(rand));
        this.assertEquals(rand, options.getAcceptBacklog());
        this.assertEquals(0L, options.getPort());
        this.assertEquals(options, options.setPort(1234));
        this.assertEquals(1234L, options.getPort());
        TestUtils.assertIllegalArgumentException(() -> options.setPort(65536));
        this.assertEquals("0.0.0.0", options.getHost());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHost(randString));
        this.assertEquals(randString, options.getHost());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        this.assertFalse(options.isSni());
        this.assertEquals(options, options.setSni(true));
        this.assertTrue(options.isSni());
        this.assertEquals(10L, options.getSslHandshakeTimeout());
        long randomSslTimeout = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setSslHandshakeTimeout(randomSslTimeout));
        this.assertEquals(randomSslTimeout, options.getSslHandshakeTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setSslHandshakeTimeout(-123L));
        this.assertFalse(options.isUseProxyProtocol());
        this.assertEquals(options, options.setUseProxyProtocol(true));
        this.assertTrue(options.isUseProxyProtocol());
        this.assertEquals((Object)NetServerOptions.DEFAULT_PROXY_PROTOCOL_TIMEOUT_TIME_UNIT, (Object)options.getProxyProtocolTimeoutUnit());
        long randomProxyTimeout = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setProxyProtocolTimeout(randomProxyTimeout));
        this.assertEquals(randomProxyTimeout, options.getProxyProtocolTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setProxyProtocolTimeout(-123L));
        this.testComplete();
    }

    @Test
    public void testCopyClientOptions() {
        NetClientOptions options = new NetClientOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        String hostnameVerificationAlgorithm = TestUtils.randomAlphaString(10);
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int reconnectAttempts = TestUtils.randomPositiveInt();
        long reconnectInterval = TestUtils.randomPositiveInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setSsl(ssl);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setIdleTimeout(idleTimeout);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.setConnectTimeout(connectTimeout);
        options.setTrustAll(trustAll);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setReconnectAttempts(reconnectAttempts);
        options.setReconnectInterval(reconnectInterval);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        options.setSslHandshakeTimeout(sslHandshakeTimeout);
        NetClientOptions copy = new NetClientOptions(options);
        this.assertEquals(options.toJson(), copy.toJson());
    }

    @Test
    public void testDefaultClientOptionsJson() {
        NetClientOptions def = new NetClientOptions();
        NetClientOptions json = new NetClientOptions(new JsonObject());
        this.assertEquals(def.getReconnectAttempts(), json.getReconnectAttempts());
        this.assertEquals(def.getReconnectInterval(), json.getReconnectInterval());
        this.assertEquals(def.isTrustAll(), json.isTrustAll());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getConnectTimeout(), json.getConnectTimeout());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.getHostnameVerificationAlgorithm(), json.getHostnameVerificationAlgorithm());
        this.assertEquals(def.getSslHandshakeTimeout(), json.getSslHandshakeTimeout());
    }

    @Test
    public void testClientOptionsJson() {
        JsonObject sslEngineOptions;
        String sslEngine;
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        int reconnectAttempts = TestUtils.randomPositiveInt();
        long reconnectInterval = TestUtils.randomPositiveInt();
        boolean useAlpn = TestUtils.randomBoolean();
        String hostnameVerificationAlgorithm = TestUtils.randomAlphaString(10);
        if (TestUtils.randomBoolean()) {
            sslEngine = "jdkSslEngineOptions";
            sslEngineOptions = new JsonObject();
        } else {
            sslEngine = "openSslEngineOptions";
            boolean sessionCacheEnabled = rand.nextBoolean();
            sslEngineOptions = new JsonObject().put("sessionCacheEnabled", (Object)sessionCacheEnabled).put("useWorkerThread", (Object)false);
        }
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", (Object)sendBufferSize).put("receiveBufferSize", (Object)receiverBufferSize).put("reuseAddress", (Object)reuseAddress).put("trafficClass", (Object)trafficClass).put("tcpNoDelay", (Object)tcpNoDelay).put("tcpKeepAlive", (Object)tcpKeepAlive).put("soLinger", (Object)soLinger).put("idleTimeout", (Object)idleTimeout).put("ssl", (Object)ssl).put("enabledCipherSuites", (Object)new JsonArray().add((Object)enabledCipher)).put("connectTimeout", (Object)connectTimeout).put("trustAll", (Object)trustAll).put("crlPaths", (Object)new JsonArray().add((Object)crlPath)).put("keyStoreOptions", (Object)new JsonObject().put("password", (Object)ksPassword).put("path", (Object)ksPath)).put("trustStoreOptions", (Object)new JsonObject().put("password", (Object)tsPassword).put("path", (Object)tsPath)).put("reconnectAttempts", (Object)reconnectAttempts).put("reconnectInterval", (Object)reconnectInterval).put("useAlpn", (Object)useAlpn).put(sslEngine, (Object)sslEngineOptions).put("hostnameVerificationAlgorithm", (Object)hostnameVerificationAlgorithm).put("sslHandshakeTimeout", (Object)sslHandshakeTimeout);
        JsonObject converted = new NetClientOptions(json).toJson();
        for (Map.Entry entry : json) {
            this.assertEquals(entry.getValue(), converted.getValue((String)entry.getKey()));
        }
        NetClientOptions options = new NetClientOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertEquals(sslHandshakeTimeout, options.getSslHandshakeTimeout());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, options.getConnectTimeout());
        this.assertEquals(trustAll, options.isTrustAll());
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(reconnectAttempts, options.getReconnectAttempts());
        this.assertEquals(reconnectInterval, options.getReconnectInterval());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(hostnameVerificationAlgorithm, options.getHostnameVerificationAlgorithm());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", (Object)new JsonObject().put("password", (Object)ksPassword)).put("pfxTrustOptions", (Object)new JsonObject().put("password", (Object)tsPassword));
        options = new NetClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", (Object)new JsonObject()).put("pemTrustOptions", (Object)new JsonObject());
        options = new NetClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testCopyServerOptions() {
        NetServerOptions options = new NetServerOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        boolean sni = TestUtils.randomBoolean();
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        boolean useProxyProtocol = TestUtils.randomBoolean();
        long proxyProtocolTimeout = TestUtils.randomPositiveLong();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setIdleTimeout(idleTimeout);
        options.setSsl(ssl);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setPort(port);
        options.setHost(host);
        options.setAcceptBacklog(acceptBacklog);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setSni(sni);
        options.setSslHandshakeTimeout(sslHandshakeTimeout);
        options.setUseProxyProtocol(useProxyProtocol);
        options.setProxyProtocolTimeout(proxyProtocolTimeout);
        NetServerOptions copy = new NetServerOptions(options);
        this.assertEquals(options.toJson(), copy.toJson());
    }

    @Test
    public void testDefaultServerOptionsJson() {
        NetServerOptions def = new NetServerOptions();
        NetServerOptions json = new NetServerOptions(new JsonObject());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.isSni(), json.isSni());
        this.assertEquals(def.getSslHandshakeTimeout(), json.getSslHandshakeTimeout());
        this.assertEquals((Object)def.getSslHandshakeTimeoutUnit(), (Object)json.getSslHandshakeTimeoutUnit());
        this.assertEquals(def.isUseProxyProtocol(), json.isUseProxyProtocol());
        this.assertEquals(def.getProxyProtocolTimeout(), json.getProxyProtocolTimeout());
        this.assertEquals((Object)def.getProxyProtocolTimeoutUnit(), (Object)json.getProxyProtocolTimeoutUnit());
    }

    @Test
    public void testServerOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPositiveInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        boolean sni = TestUtils.randomBoolean();
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        boolean useProxyProtocol = TestUtils.randomBoolean();
        long proxyProtocolTimeout = TestUtils.randomPositiveLong();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", (Object)sendBufferSize).put("receiveBufferSize", (Object)receiverBufferSize).put("reuseAddress", (Object)reuseAddress).put("trafficClass", (Object)trafficClass).put("tcpNoDelay", (Object)tcpNoDelay).put("tcpKeepAlive", (Object)tcpKeepAlive).put("soLinger", (Object)soLinger).put("usePooledBuffers", (Object)usePooledBuffers).put("idleTimeout", (Object)idleTimeout).put("ssl", (Object)ssl).put("enabledCipherSuites", (Object)new JsonArray().add((Object)enabledCipher)).put("crlPaths", (Object)new JsonArray().add((Object)crlPath)).put("keyStoreOptions", (Object)new JsonObject().put("password", (Object)ksPassword).put("path", (Object)ksPath)).put("trustStoreOptions", (Object)new JsonObject().put("password", (Object)tsPassword).put("path", (Object)tsPath)).put("port", (Object)port).put("host", (Object)host).put("acceptBacklog", (Object)acceptBacklog).put("useAlpn", (Object)useAlpn).put(sslEngine, (Object)new JsonObject()).put("openSslSessionCacheEnabled", (Object)openSslSessionCacheEnabled).put("sni", (Object)sni).put("sslHandshakeTimeout", (Object)sslHandshakeTimeout).put("useProxyProtocol", (Object)useProxyProtocol).put("proxyProtocolTimeout", (Object)proxyProtocolTimeout);
        NetServerOptions options = new NetServerOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertEquals(sslHandshakeTimeout, options.getSslHandshakeTimeout());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(port, options.getPort());
        this.assertEquals(host, options.getHost());
        this.assertEquals(acceptBacklog, options.getAcceptBacklog());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(sni, options.isSni());
        this.assertEquals(useProxyProtocol, options.isUseProxyProtocol());
        this.assertEquals(proxyProtocolTimeout, options.getProxyProtocolTimeout());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", (Object)new JsonObject().put("password", (Object)ksPassword)).put("pfxTrustOptions", (Object)new JsonObject().put("password", (Object)tsPassword));
        options = new NetServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", (Object)new JsonObject()).put("pemTrustOptions", (Object)new JsonObject());
        options = new NetServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testWriteHandlerSuccess() throws Exception {
        CompletableFuture close = new CompletableFuture();
        this.server.connectHandler(socket -> {
            socket.pause();
            close.thenAccept(v -> socket.resume());
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> this.writeUntilFull((NetSocket)so, (Handler<Void>)((Handler)v -> {
            so.write(Buffer.buffer((String)"lost buffer"), this.onSuccess(ack -> this.testComplete()));
            close.complete(null);
        }))));
        this.await();
    }

    @Test
    public void testWriteHandlerFailure() throws Exception {
        CompletableFuture close = new CompletableFuture();
        this.server.connectHandler(socket -> {
            socket.pause();
            close.thenAccept(v -> socket.close());
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> this.writeUntilFull((NetSocket)so, (Handler<Void>)((Handler)v -> {
            so.write(Buffer.buffer((String)"lost buffer"), this.onFailure(err -> this.testComplete()));
            close.complete(null);
        }))));
        this.await();
    }

    private void writeUntilFull(NetSocket so, Handler<Void> handler) {
        if (so.writeQueueFull()) {
            handler.handle(null);
        } else {
            so.write((Object)TestUtils.randomBuffer(16384));
            this.vertx.setTimer(10L, id -> this.writeUntilFull(so, handler));
        }
    }

    @Test
    public void testEchoBytes() {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testEcho(sock -> sock.write((Object)sent), buff -> this.assertEquals(sent, buff), sent.length());
    }

    @Test
    public void testEchoString() {
        String sent = TestUtils.randomUnicodeString(100);
        Buffer buffSent = Buffer.buffer((String)sent);
        this.testEcho(sock -> sock.write(sent), buff -> this.assertEquals(buffSent, buff), buffSent.length());
    }

    @Test
    public void testEchoStringUTF8() {
        this.testEchoStringWithEncoding("UTF-8");
    }

    @Test
    public void testEchoStringUTF16() {
        this.testEchoStringWithEncoding("UTF-16");
    }

    void testEchoStringWithEncoding(String encoding) {
        String sent = TestUtils.randomUnicodeString(100);
        Buffer buffSent = Buffer.buffer((String)sent, (String)encoding);
        this.testEcho(sock -> sock.write(sent, encoding), buff -> this.assertEquals(buffSent, buff), buffSent.length());
    }

    void testEcho(Consumer<NetSocket> writer, Consumer<Buffer> dataChecker, int length) {
        Handler clientHandler = asyncResult -> {
            if (asyncResult.succeeded()) {
                NetSocket sock = (NetSocket)asyncResult.result();
                Buffer buff = Buffer.buffer();
                sock.handler(buffer -> {
                    buff.appendBuffer(buffer);
                    if (buff.length() == length) {
                        dataChecker.accept(buff);
                        this.testComplete();
                    }
                    if (buff.length() > length) {
                        this.fail("Too many bytes received");
                    }
                });
                writer.accept(sock);
            } else {
                this.fail("failed to connect");
            }
        };
        this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, clientHandler)));
        this.await();
    }

    void startEchoServer(SocketAddress address, Handler<AsyncResult<NetServer>> listenHandler) {
        Handler serverHandler = socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0));
        this.server.connectHandler(serverHandler).listen(address, listenHandler);
    }

    @Test
    public void testConnectLocalHost() {
        this.connect(this.testAddress);
    }

    void connect(SocketAddress address) {
        this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> {
            int numConnections = 100;
            AtomicInteger connCount = new AtomicInteger(0);
            for (int i = 0; i < 100; ++i) {
                Handler handler = res -> {
                    if (res.succeeded()) {
                        ((NetSocket)res.result()).close();
                        if (connCount.incrementAndGet() == 100) {
                            this.testComplete();
                        }
                    }
                };
                this.client.connect(address, handler);
            }
        }));
        this.await();
    }

    @Test
    public void testConnectInvalidPort() {
        TestUtils.assertIllegalArgumentException(() -> this.client.connect(-1, "localhost", res -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.client.connect(65536, "localhost", res -> {}));
        this.client.connect(9998, "localhost", res -> {
            this.assertTrue(res.failed());
            this.assertFalse(res.succeeded());
            this.assertNotNull(res.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testConnectInvalidHost() {
        TestUtils.assertNullPointerException(() -> this.client.connect(80, null, res -> {}));
        this.client.connect(1234, "127.0.0.2", res -> {
            this.assertTrue(res.failed());
            this.assertFalse(res.succeeded());
            this.assertNotNull(res.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testConnectInvalidConnectHandler() throws Exception {
        TestUtils.assertNullPointerException(() -> this.client.connect(80, "localhost", (Handler)null));
    }

    @Test
    public void testListenInvalidPort() {
        int port = 9090;
        try (HttpServer httpServer = this.vertx.createHttpServer();){
            httpServer.requestHandler(ignore -> {}).listen(9090, this.onSuccess(s -> this.vertx.createNetServer().connectHandler(ignore -> {}).listen(9090, this.onFailure(error -> {
                this.assertNotNull(error);
                this.testComplete();
            }))));
            this.await();
        }
    }

    @Test
    public void testListenInvalidHost() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("uhqwduhqwudhqwuidhqwiudhqwudqwiuhd"));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertTrue(ar.failed());
            this.assertFalse(ar.succeeded());
            this.assertNotNull(ar.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenOnWildcardPort() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(0));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertFalse(ar.failed());
            this.assertTrue(ar.succeeded());
            this.assertNull(ar.cause());
            this.assertTrue(this.server.actualPort() > 1024);
            this.assertEquals(this.server, ar.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testClientCloseHandlersCloseFromClient() {
        this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.clientCloseHandlers(true)));
        this.await();
    }

    @Test
    public void testClientCloseHandlersCloseFromServer() {
        this.server.connectHandler(NetSocket::close).listen(this.testAddress, s -> this.clientCloseHandlers(false));
        this.await();
    }

    void clientCloseHandlers(boolean closeFromClient) {
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            AtomicInteger counter = new AtomicInteger(0);
            so.endHandler(v -> this.assertEquals(1L, counter.incrementAndGet()));
            so.closeHandler(v -> {
                this.assertEquals(2L, counter.incrementAndGet());
                this.testComplete();
            });
            if (closeFromClient) {
                so.close();
            }
        }));
    }

    @Test
    public void testServerCloseHandlersCloseFromClient() {
        this.serverCloseHandlers(false, (Handler<NetServer>)((Handler)s -> this.client.connect(this.testAddress, ar -> ((NetSocket)ar.result()).close())));
        this.await();
    }

    @Test
    public void testServerCloseHandlersCloseFromServer() {
        this.serverCloseHandlers(true, (Handler<NetServer>)((Handler)s -> this.client.connect(this.testAddress, ar -> {})));
        this.await();
    }

    void serverCloseHandlers(boolean closeFromServer, Handler<NetServer> listenHandler) {
        this.server.connectHandler(sock -> {
            AtomicInteger counter = new AtomicInteger(0);
            sock.endHandler(v -> this.assertEquals(1L, counter.incrementAndGet()));
            sock.closeHandler(v -> {
                this.assertEquals(2L, counter.incrementAndGet());
                this.testComplete();
            });
            if (closeFromServer) {
                sock.close();
            }
        }).listen(this.testAddress, this.onSuccess(arg_0 -> listenHandler.handle(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientClose() throws Exception {
        int num = 3;
        ArrayList<NetServer> servers = new ArrayList<NetServer>();
        try {
            for (int i = 0; i < num; ++i) {
                NetServer server = this.vertx.createNetServer();
                server.connectHandler(so -> {});
                this.startServer(SocketAddress.inetSocketAddress((int)(1234 + i), (String)"localhost"), server);
                servers.add(server);
            }
            NetClient client = this.vertx.createNetClient();
            AtomicInteger inflight = new AtomicInteger();
            for (int i = 0; i < num; ++i) {
                client.connect(1234 + i, "localhost", this.onSuccess(so -> {
                    inflight.incrementAndGet();
                    so.closeHandler(v -> inflight.decrementAndGet());
                }));
            }
            NetTest.assertWaitUntil(() -> inflight.get() == 3);
            CountDownLatch latch = new CountDownLatch(1);
            client.close(this.onSuccess(v -> latch.countDown()));
            this.awaitLatch(latch);
            NetTest.assertWaitUntil(() -> inflight.get() == 0);
        }
        finally {
            servers.forEach(NetServer::close);
        }
    }

    @Test
    public void testReceiveMessageAfterExplicitClose() throws Exception {
        this.server.connectHandler(so -> so.write("Hello World"));
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.channelHandlerContext().pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter((NetSocket)so){
                final /* synthetic */ NetSocket val$so;
                {
                    this.val$so = netSocket;
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    this.val$so.close();
                    super.channelRead(ctx, msg);
                }
            }});
            so.handler(buff -> {
                this.assertEquals("Hello World", buff.toString());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testClientDrainHandler() {
        this.pausingServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, this.onSuccess(sock -> {
            this.assertFalse(sock.writeQueueFull());
            sock.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                sock.write((Object)buff.copy());
                if (sock.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    sock.drainHandler(v -> {
                        this.assertFalse(sock.writeQueueFull());
                        this.testComplete();
                    });
                    this.vertx.eventBus().send("server_resume", (Object)"");
                }
            });
        }))));
        this.await();
    }

    void pausingServer(Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            sock.pause();
            Handler resumeHandler = m -> sock.resume();
            MessageConsumer reg = this.vertx.eventBus().consumer("server_resume").handler(resumeHandler);
            sock.closeHandler(v -> reg.unregister());
        }).listen(this.testAddress, listenHandler);
    }

    @Test
    public void testServerDrainHandler() {
        this.drainingServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, this.onSuccess(sock -> {
            sock.pause();
            this.setHandlers((NetSocket)sock);
            sock.handler(buf -> {});
        }))));
        this.await();
    }

    void setHandlers(NetSocket sock) {
        Handler resumeHandler = m -> sock.resume();
        MessageConsumer reg = this.vertx.eventBus().consumer("client_resume").handler(resumeHandler);
        sock.closeHandler(v -> reg.unregister());
    }

    void drainingServer(Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            this.assertFalse(sock.writeQueueFull());
            sock.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                sock.write((Object)buff.copy());
                if (sock.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    sock.drainHandler(v -> {
                        this.assertFalse(sock.writeQueueFull());
                        this.vertx.setTimer(100L, id2 -> this.testComplete());
                    });
                    this.vertx.eventBus().send("client_resume", (Object)"");
                }
            });
        }).listen(this.testAddress, listenHandler);
    }

    @Test
    public void testReconnectAttemptsInfinite() {
        this.reconnectAttempts(-1);
    }

    @Test
    public void testReconnectAttemptsMany() {
        this.reconnectAttempts(100000);
    }

    private void reconnectAttempts(int attempts) {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setReconnectAttempts(attempts).setReconnectInterval(10L));
        this.client.connect(this.testAddress, this.onSuccess(so -> this.testComplete()));
        this.vertx.setTimer(2000L, id -> this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> {})));
        this.await();
    }

    @Test
    public void testReconnectAttemptsNotEnough() {
        Assume.assumeFalse((boolean)Utils.isWindows());
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setReconnectAttempts(100).setReconnectInterval(10L));
        this.client.connect(this.testAddress, res -> {
            this.assertFalse(res.succeeded());
            this.assertTrue(res.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testServerIdleTimeout1() {
        this.testTimeout(new NetClientOptions(), new NetServerOptions().setIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), received -> this.assertEquals("0123456789", received.toString()), true);
    }

    @Test
    public void testServerIdleTimeout2() {
        this.testTimeout(new NetClientOptions(), new NetServerOptions().setReadIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), received -> this.assertEquals("0123456789", received.toString()), true);
    }

    @Test
    public void testServerIdleTimeout3() {
        this.testTimeout(new NetClientOptions(), new NetServerOptions().setWriteIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), received -> this.assertFalse("0123456789".equals(received.toString())), true);
    }

    @Test
    public void testServerIdleTimeout4() {
        this.testTimeout(new NetClientOptions(), new NetServerOptions().setIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), received -> this.assertEquals("0123456789", received.toString()), false);
    }

    @Test
    public void testServerIdleTimeout5() {
        this.testTimeout(new NetClientOptions(), new NetServerOptions().setReadIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), received -> this.assertFalse("0123456789".equals(received.toString())), false);
    }

    @Test
    public void testServerIdleTimeout6() {
        this.testTimeout(new NetClientOptions(), new NetServerOptions().setWriteIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), received -> this.assertEquals("0123456789", received.toString()), false);
    }

    @Test
    public void testClientIdleTimeout1() {
        this.testTimeout(new NetClientOptions().setIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), new NetServerOptions(), received -> this.assertEquals("0123456789", received.toString()), true);
    }

    @Test
    public void testClientIdleTimeout2() {
        this.testTimeout(new NetClientOptions().setWriteIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), new NetServerOptions(), received -> this.assertEquals("0123456789", received.toString()), true);
    }

    @Test
    public void testClientIdleTimeout3() {
        this.testTimeout(new NetClientOptions().setReadIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), new NetServerOptions(), received -> this.assertFalse("0123456789".equals(received.toString())), true);
    }

    @Test
    public void testClientIdleTimeout4() {
        this.testTimeout(new NetClientOptions().setIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), new NetServerOptions(), received -> this.assertEquals("0123456789", received.toString()), false);
    }

    @Test
    public void testClientIdleTimeout5() {
        this.testTimeout(new NetClientOptions().setWriteIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), new NetServerOptions(), received -> this.assertFalse("0123456789".equals(received.toString())), false);
    }

    @Test
    public void testClientIdleTimeout6() {
        this.testTimeout(new NetClientOptions().setReadIdleTimeout(500).setIdleTimeoutUnit(TimeUnit.MILLISECONDS), new NetServerOptions(), received -> this.assertEquals("0123456789", received.toString()), false);
    }

    private void testTimeout(NetClientOptions clientOptions, NetServerOptions serverOptions, Consumer<Buffer> check, boolean clientSends) {
        this.server.close();
        this.server = this.vertx.createNetServer(serverOptions);
        this.client.close();
        this.client = this.vertx.createNetClient(clientOptions);
        Buffer received = Buffer.buffer();
        AtomicInteger idleEvents = new AtomicInteger();
        Handler receiver = so -> {
            ((NetSocketInternal)so).eventHandler(evt -> {
                if (evt instanceof IdleStateEvent) {
                    idleEvents.incrementAndGet();
                }
            });
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
        };
        Handler sender = so -> {
            AtomicInteger times = new AtomicInteger();
            this.vertx.setPeriodic(100L, id -> {
                int val = times.getAndIncrement();
                if (val < 10) {
                    so.write("" + val);
                } else {
                    this.vertx.cancelTimer(id.longValue());
                }
            });
            ((NetSocketInternal)so).eventHandler(evt -> {
                if (evt instanceof IdleStateEvent) {
                    idleEvents.incrementAndGet();
                }
            });
            so.closeHandler(v -> {
                check.accept(received);
                this.assertEquals(1L, idleEvents.get());
                this.testComplete();
            });
        };
        Handler clientHandler = clientSends ? sender : receiver;
        Handler serverHandler = clientSends ? receiver : sender;
        this.server.connectHandler(serverHandler).listen(this.testAddress, this.onSuccess(s -> this.client.connect(this.testAddress, this.onSuccess(arg_0 -> ((Handler)clientHandler).handle(arg_0)))));
        this.await();
    }

    @Test
    public void testStartTLSClientTrustAll() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, true);
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, false);
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, false, false, true, false);
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, false, false);
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, false, false, true, false);
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, true, false);
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false);
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, true, false, false, false);
    }

    @Test
    public void testStartTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, true);
    }

    @Test
    public void testTLSCipherSuites() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, false, ENABLED_CIPHER_SUITES);
    }

    @Test
    public void testInvalidTlsProtocolVersion() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, false, false, new String[0], new String[]{"TLSv1.999"});
    }

    @Test
    public void testSpecificTlsProtocolVersion() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, false, new String[0], new String[]{"TLSv1.2"});
    }

    @Test
    public void testTLSTrailingDotHost() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() < 9 ? 1 : 0) != 0);
        SelfSignedCertificate cert = SelfSignedCertificate.create((String)"host2.com");
        TLSTest test = new TLSTest().clientTrust(() -> ((SelfSignedCertificate)cert).trustOptions()).connectAddress(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host2.com.")).bindAddress(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host2.com")).serverCert(() -> ((SelfSignedCertificate)cert).keyCertOptions());
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertNull(test.indicatedServerName);
    }

    @Test
    public void testSniWithoutServerNameUsesTheFirstKeyStoreEntry1() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SERVER_JKS).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("localhost", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithoutServerNameUsesTheFirstKeyStoreEntry2() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).serverCert(Cert.SNI_JKS).sni(true);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniImplicitServerName() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).address(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host2.com")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertEquals("host2.com", test.indicatedServerName);
    }

    @Test
    public void testSniImplicitServerNameDisabledForShortname1() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).address(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host1")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniImplicitServerNameDisabledForShortname2() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SERVER_JKS).address(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host1")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("localhost", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniForceShortname() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).address(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host1")).serverName("host1").serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host1", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniOverrideServerName() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).address(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"example.com")).serverName("host2.com").serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithUnknownServer1() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SERVER_JKS).serverCert(Cert.SNI_JKS).sni(true).serverName("unknown");
        test.run(true);
        this.await();
        this.assertEquals("localhost", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithUnknownServer2() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).serverCert(Cert.SNI_JKS).sni(true).serverName("unknown");
        test.run(false);
        this.await();
    }

    @Test
    public void testSniWithServerNameStartTLS() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).startTLS(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host1");
        test.run(true);
        this.await();
        this.assertEquals("host1", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithServerNameTrust() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_ROOT_CA_AND_OTHER_CA_1);
        test.run(true);
        this.await();
    }

    @Test
    public void testSniWithServerNameTrustFallback() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_ROOT_CA_FALLBACK);
        test.run(true);
        this.await();
    }

    @Test
    public void testSniWithServerNameTrustFallbackFail() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_OTHER_CA_FALLBACK);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniWithServerNameTrustFail() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_ROOT_CA_AND_OTHER_CA_2);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniWithTrailingDotHost() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).connectAddress(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host2.com.")).bindAddress(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"host2.com")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertEquals("host2.com", test.indicatedServerName);
    }

    @Test
    public void testServerCertificateMultiple() throws Exception {
        TLSTest test = new TLSTest().serverCert(Cert.MULTIPLE_JKS).clientTrustAll(true);
        test.run(true);
        this.await();
        this.assertEquals("precious", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testServerCertificateMultipleWrongAlias() throws Exception {
        TLSTest test = new TLSTest().serverCert(Cert.MULTIPLE_JKS_WRONG_ALIAS).clientTrustAll(true);
        test.setupServer(true);
        this.server.listen(test.bindAddress, this.onFailure(t -> {
            this.assertThat(t, CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class)));
            this.assertThat(t.getMessage(), CoreMatchers.containsString((String)"alias does not exist in the keystore"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testServerCertificateMultipleWithKeyPassword() throws Exception {
        TLSTest test = new TLSTest().serverCert(Cert.MULTIPLE_JKS_ALIAS_PASSWORD).clientTrustAll(true);
        test.run(true);
        this.await();
        this.assertEquals("fonky", TestUtils.cnOf(test.clientPeerCert()));
    }

    void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, clientTrustAll, shouldPass, startTLS, new String[0], new String[0]);
    }

    void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS, String[] enabledCipherSuites) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, clientTrustAll, shouldPass, startTLS, enabledCipherSuites, new String[0]);
    }

    void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS, String[] enabledCipherSuites, String[] enabledSecureTransportProtocols) throws Exception {
        TLSTest test = new TLSTest().clientCert(clientCert).clientTrust(clientTrust).serverCert(serverCert).serverTrust(serverTrust).requireClientAuth(requireClientAuth).clientTrustAll(clientTrustAll).startTLS(startTLS).enabledCipherSuites(enabledCipherSuites).enabledSecureTransportProtocols(enabledSecureTransportProtocols);
        test.run(shouldPass);
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenDomainSocketAddress() throws Exception {
        VertxInternal vx = (VertxInternal)Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true));
        Assume.assumeTrue((String)"Transport must support domain sockets", (boolean)vx.transport().supportsDomainSockets());
        int len = 3;
        this.waitFor(len * len);
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        for (int i = 0; i < len; ++i) {
            File sockFile = TestUtils.tmpFile(".sock");
            SocketAddress sockAddress = SocketAddress.domainSocketAddress((String)sockFile.getAbsolutePath());
            NetServer server = vx.createNetServer().connectHandler(so -> so.end((Object)Buffer.buffer((String)sockAddress.path())));
            this.startServer(sockAddress, server);
            addresses.add(sockAddress);
        }
        NetClient client = vx.createNetClient();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                SocketAddress sockAddress = (SocketAddress)addresses.get(i);
                client.connect(sockAddress, this.onSuccess(so -> {
                    Buffer received = Buffer.buffer();
                    so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
                    so.closeHandler(v -> {
                        this.assertEquals(received.toString(), sockAddress.path());
                        this.complete();
                    });
                }));
            }
        }
        try {
            this.await();
        }
        finally {
            vx.close();
        }
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        boolean domainSocket = this.testAddress.isDomainSocket();
        int numServers = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE / 2 - 1;
        int numConnections = numServers * (domainSocket ? 10 : 20);
        ArrayList<NetServer> servers = new ArrayList<NetServer>();
        ConcurrentHashMap connectCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numConnections);
        for (int i = 0; i < numServers; ++i) {
            NetServer theServer = this.vertx.createNetServer();
            servers.add(theServer);
            theServer.connectHandler(sock -> {
                connectCount.compute(theServer, (s, cur) -> cur == null ? 1 : cur + 1);
                latchConns.countDown();
            }).listen(this.testAddress, this.onSuccess(s -> latchListen.countDown()));
        }
        this.assertTrue(latchListen.await(10L, TimeUnit.SECONDS));
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions());
        CountDownLatch latchClient = new CountDownLatch(numConnections);
        AtomicInteger connecting = new AtomicInteger(10);
        for (int i = 0; i < numConnections; ++i) {
            connecting.decrementAndGet();
            this.client.connect(this.testAddress, res -> {
                connecting.incrementAndGet();
                if (res.succeeded()) {
                    latchClient.countDown();
                } else {
                    res.cause().printStackTrace();
                    this.fail("Failed to connect");
                }
            });
            NetTest.assertWaitUntil(() -> connecting.get() >= 0);
        }
        this.awaitLatch(latchClient);
        this.awaitLatch(latchConns);
        this.assertEquals(numServers, connectCount.size());
        for (NetServer server : servers) {
            this.assertTrue(connectCount.containsKey(server));
        }
        this.assertEquals(numServers, connectCount.size());
        Iterator<Object> iterator = connectCount.values().iterator();
        while (iterator.hasNext()) {
            int cnt = (Integer)iterator.next();
            this.assertEquals(numConnections / numServers, cnt);
        }
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(4321));
        this.server.connectHandler(sock -> this.fail("Should not connect")).listen(ar2 -> {
            if (ar2.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        this.server.close();
        CountDownLatch latch = new CountDownLatch(1);
        this.server = this.vertx.createNetServer();
        this.server.connectHandler(sock -> this.fail("Should not connect")).listen(this.testAddress, ar -> {
            if (ar.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        this.server.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        Thread.sleep(500L);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testClosingVertxCloseSharedServers() throws Exception {
        int numServers = 2;
        Vertx vertx = Vertx.vertx((VertxOptions)this.getOptions());
        ArrayList<NetServerImpl> servers = new ArrayList<NetServerImpl>();
        for (int i = 0; i < numServers; ++i) {
            NetServer server2 = vertx.createNetServer().connectHandler(so -> this.fail());
            this.startServer(server2);
            servers.add((NetServerImpl)server2);
        }
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        servers.forEach(server -> this.assertTrue(server.isClosed()));
    }

    @Test
    public void testWriteHandlerIdNullByDefault() throws Exception {
        Buffer hello = Buffer.buffer((String)"hello");
        Buffer bye = Buffer.buffer((String)"bye");
        this.server.connectHandler(socket -> {
            this.assertNull(socket.writeHandlerID());
            socket.handler(data -> {
                this.assertEquals(hello, data);
                socket.end((Object)bye);
            });
        });
        this.startServer();
        this.waitFor(2);
        this.client.connect(this.testAddress, this.onSuccess(socket -> {
            this.assertNull(socket.writeHandlerID());
            socket.closeHandler(v -> this.complete()).handler(data -> {
                this.assertEquals(bye, data);
                this.complete();
            }).write((Object)hello);
        }));
        this.await();
    }

    @Test
    public void testFanout() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setRegisterWriteHandler(true));
        int numConnections = 10;
        ConcurrentHashSet connections = new ConcurrentHashSet();
        this.server.connectHandler(arg_0 -> this.lambda$testFanout$145((Set)connections, numConnections, arg_0));
        this.startServer();
        CountDownLatch receivedLatch = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.connect(this.testAddress, this.onSuccess(socket -> socket.handler(data -> receivedLatch.countDown())));
        }
        this.assertTrue(receivedLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSocketAddress() {
        this.server.connectHandler(socket -> {
            SocketAddress addr = socket.localAddress();
            if (addr.isInetSocket()) {
                this.assertEquals("127.0.0.1", addr.host());
                this.assertEquals(null, addr.hostName());
                this.assertEquals("127.0.0.1", addr.hostAddress());
            } else {
                this.assertEquals(this.testAddress.path(), addr.path());
                this.assertEquals(this.testAddress.path(), socket.remoteAddress().path());
            }
            socket.close();
        }).listen(1234, "localhost").onComplete(this.onSuccess(v -> this.vertx.createNetClient(new NetClientOptions()).connect(1234, "localhost").onComplete(this.onSuccess(socket -> {
            SocketAddress addr = socket.remoteAddress();
            if (addr.isInetSocket()) {
                this.assertEquals("localhost", addr.host());
                this.assertEquals("localhost", addr.hostName());
                this.assertEquals("127.0.0.1", addr.hostAddress());
                this.assertEquals(addr.port(), 1234L);
            } else {
                this.assertEquals(this.testAddress.path(), addr.path());
                this.assertEquals(this.testAddress.path(), socket.localAddress().path());
            }
            socket.closeHandler(v2 -> this.testComplete());
        }))));
        this.await();
    }

    @Test
    public void testWriteSameBufferMoreThanOnce() throws Exception {
        this.server.connectHandler(socket -> {
            Buffer received = Buffer.buffer();
            socket.handler(buff -> {
                received.appendBuffer(buff);
                if (received.toString().equals("foofoo")) {
                    this.testComplete();
                }
            });
        }).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, result -> {
                NetSocket socket = (NetSocket)result.result();
                Buffer buff = Buffer.buffer((String)"foo");
                socket.write((Object)buff);
                socket.write((Object)buff);
            });
        });
        this.await();
    }

    @Test
    public void sendFileClientToServer() throws Exception {
        File fDir = this.testFolder.newFolder();
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile(fDir.toString(), "some-file.txt", content);
        Buffer expected = Buffer.buffer((String)content);
        Buffer received = Buffer.buffer();
        this.server.connectHandler(sock -> {
            sock.handler(buff -> {
                received.appendBuffer(buff);
                if (received.length() == expected.length()) {
                    this.assertEquals(expected, received);
                    this.testComplete();
                }
            });
            sock.write("foo");
        });
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket sock = (NetSocket)ar2.result();
                sock.handler(buf -> sock.sendFile(file.getAbsolutePath()));
            });
        });
        this.await();
    }

    @Test
    public void sendFileServerToClient() throws Exception {
        File fDir = this.testFolder.newFolder();
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile(fDir.toString(), "some-file.txt", content);
        Buffer expected = Buffer.buffer((String)content);
        Buffer received = Buffer.buffer();
        this.server.connectHandler(sock -> sock.handler(buf -> sock.sendFile(file.getAbsolutePath())));
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket sock = (NetSocket)ar2.result();
                sock.handler(buff -> {
                    received.appendBuffer(buff);
                    if (received.length() == expected.length()) {
                        this.assertEquals(expected, received);
                        this.testComplete();
                    }
                });
                sock.write("foo");
            });
        });
        this.await();
    }

    @Test
    public void testSendFileDirectory() throws Exception {
        File fDir = this.testFolder.newFolder();
        this.server.connectHandler(socket -> socket.handler(buff -> this.fail("Should not receive any data"))).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, result -> {
                this.assertTrue(result.succeeded());
                NetSocket socket = (NetSocket)result.result();
                try {
                    socket.sendFile(fDir.getAbsolutePath().toString());
                    this.fail("Should throw exception");
                }
                catch (IllegalArgumentException e) {
                    this.testComplete();
                }
            });
        });
        this.await();
    }

    @Test
    public void testServerOptionsCopiedBeforeUse() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234);
        this.server = this.vertx.createNetServer(options);
        options.setPort(1235);
        this.server.connectHandler(sock -> this.testComplete());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testClientOptionsCopiedBeforeUse() {
        this.client.close();
        NetClientOptions options = new NetClientOptions();
        this.client = this.vertx.createNetClient(options);
        options.setSsl(true);
        this.server.connectHandler(sock -> this.testComplete());
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testListenWithNoHandler() {
        try {
            this.server.listen(this.testAddress);
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testListenWithNoHandler2() {
        try {
            this.server.listen(this.testAddress, ar -> this.assertFalse(ar.succeeded()));
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSetHandlerAfterListen() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, this.onSuccess(v -> this.testComplete()));
        try {
            this.server.connectHandler(sock -> {});
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.await();
    }

    @Test
    public void testSetHandlerAfterListen2() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            try {
                this.server.connectHandler(sock -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenTwice() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            try {
                this.server.listen(this.testAddress, res -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException e) {
                this.testComplete();
            }
            catch (Exception e) {
                this.fail(e.getMessage());
            }
        }));
        this.await();
    }

    @Test
    public void testListenOnPortNoHandler() {
        this.server.connectHandler(NetSocket::close);
        this.server.listen(1234, this.onSuccess(ns -> this.client.connect(1234, "localhost", this.onSuccess(so -> so.closeHandler(v -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testListen() {
        this.server.connectHandler(NetSocket::close);
        this.server.listen(this.testAddress, this.onSuccess(ns -> this.client.connect(this.testAddress, this.onSuccess(so -> so.closeHandler(v -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testListenTwice2() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            try {
                this.server.listen(this.testAddress, sock -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseTwice() {
        this.client.close();
        this.client.close();
    }

    @Test
    public void testAttemptConnectAfterClose() {
        this.client.close();
        try {
            this.client.connect(this.testAddress, ar -> {});
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseWithHandler() {
        this.waitFor(2);
        this.server.connectHandler(so -> so.closeHandler(v -> this.complete())).listen(this.testAddress, this.onSuccess(s -> this.client.connect(this.testAddress, this.onSuccess(so -> so.close(this.onSuccess(v -> this.complete()))))));
        this.await();
    }

    @Test
    public void testClientMultiThreaded() throws Exception {
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        CountDownLatch latch = new CountDownLatch(numThreads);
        this.server.connectHandler(socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0))).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            for (int i = 0; i < numThreads; ++i) {
                threads[i] = new Thread(() -> this.client.connect(this.testAddress, result -> {
                    this.assertTrue(result.succeeded());
                    Buffer buff = TestUtils.randomBuffer(100000);
                    NetSocket sock = (NetSocket)result.result();
                    sock.write((Object)buff);
                    Buffer received = Buffer.buffer();
                    sock.handler(rec -> {
                        received.appendBuffer(rec);
                        if (received.length() == buff.length()) {
                            this.assertEquals(buff, received);
                            latch.countDown();
                        }
                    });
                }));
                threads[i].start();
            }
        });
        this.awaitLatch(latch);
        for (int i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testInVerticle() throws Exception {
        this.testInVerticle(false);
    }

    private void testInVerticle(final boolean worker) throws Exception {
        this.client.close();
        this.server.close();
        class MyVerticle
        extends AbstractVerticle {
            Context ctx;

            MyVerticle() {
            }

            public void start() {
                this.ctx = this.context;
                if (worker) {
                    NetTest.this.assertTrue(this.ctx.isWorkerContext());
                } else {
                    NetTest.this.assertTrue(this.ctx.isEventLoopContext());
                }
                Thread thr = Thread.currentThread();
                NetTest.this.server = this.vertx.createNetServer();
                NetTest.this.server.connectHandler(sock -> {
                    sock.handler(buff -> sock.write(buff));
                    NetTest.this.assertSame(this.ctx, this.context);
                    if (!worker) {
                        NetTest.this.assertSame(thr, Thread.currentThread());
                    }
                });
                NetTest.this.server.listen(NetTest.this.testAddress, ar -> {
                    NetTest.this.assertTrue(ar.succeeded());
                    NetTest.this.assertSame(this.ctx, this.context);
                    if (!worker) {
                        NetTest.this.assertSame(thr, Thread.currentThread());
                    }
                    NetTest.this.client = this.vertx.createNetClient(new NetClientOptions());
                    NetTest.this.client.connect(NetTest.this.testAddress, ar2 -> {
                        NetTest.this.assertSame(this.ctx, this.context);
                        if (!worker) {
                            NetTest.this.assertSame(thr, Thread.currentThread());
                        }
                        NetTest.this.assertTrue(ar2.succeeded());
                        NetSocket sock = (NetSocket)ar2.result();
                        Buffer buff = TestUtils.randomBuffer(10000);
                        sock.write((Object)buff);
                        Buffer brec = Buffer.buffer();
                        sock.handler(rec -> {
                            NetTest.this.assertSame(this.ctx, this.context);
                            if (!worker) {
                                NetTest.this.assertSame(thr, Thread.currentThread());
                            }
                            brec.appendBuffer(rec);
                            if (brec.length() == buff.length()) {
                                NetTest.this.testComplete();
                            }
                        });
                    });
                });
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(worker));
        this.await();
    }

    @Test
    public void testContexts() throws Exception {
        int numConnections = 10;
        CountDownLatch serverLatch = new CountDownLatch(numConnections);
        AtomicReference serverConnectContext = new AtomicReference();
        this.server.connectHandler(sock -> {
            Context serverContext = Vertx.currentContext();
            if (serverConnectContext.get() != null) {
                this.assertSame(serverConnectContext.get(), serverContext);
            } else {
                serverConnectContext.set(serverContext);
            }
            serverLatch.countDown();
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        AtomicReference listenContext = new AtomicReference();
        this.server.listen(this.testAddress, this.onSuccess(v -> {
            listenContext.set(Vertx.currentContext());
            listenLatch.countDown();
        }));
        this.awaitLatch(listenLatch);
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        AtomicInteger connectCount = new AtomicInteger();
        CountDownLatch clientLatch = new CountDownLatch(1);
        for (int i = 0; i < numConnections; ++i) {
            ContextInternal context = ((VertxInternal)this.vertx).createEventLoopContext();
            context.runOnContext(arg_0 -> this.lambda$testContexts$209((Set)contexts, connectCount, numConnections, clientLatch, arg_0));
        }
        this.awaitLatch(clientLatch);
        this.awaitLatch(serverLatch);
        this.server.close(arg_0 -> this.lambda$testContexts$210((Set)contexts, serverConnectContext, listenContext, arg_0));
        this.await();
    }

    @Test
    public void testReadStreamPauseResume() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setAcceptBacklog(1));
        ReadStream socketStream = this.server.connectStream();
        AtomicBoolean paused = new AtomicBoolean();
        socketStream.handler(so -> {
            this.assertTrue(!paused.get());
            so.write("hello");
            so.close();
        });
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            paused.set(true);
            socketStream.pause();
            this.client.connect(this.testAddress, ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket so2 = (NetSocket)ar2.result();
                so2.handler(buffer -> this.fail());
                so2.closeHandler(v -> {
                    paused.set(false);
                    socketStream.resume();
                    this.client.connect(this.testAddress, ar3 -> {
                        this.assertTrue(ar3.succeeded());
                        NetSocket so3 = (NetSocket)ar3.result();
                        Buffer buffer = Buffer.buffer();
                        so3.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                        so3.closeHandler(v3 -> {
                            this.assertEquals("hello", buffer.toString("utf-8"));
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createNetServer();
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.connectStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testInWorker() {
        this.waitFor(2);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                NetTest.this.assertTrue(Context.isOnWorkerThread());
                Context context = Vertx.currentContext();
                NetServer server1 = this.vertx.createNetServer();
                server1.connectHandler(conn -> {
                    NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    NetTest.this.assertSame(context, Vertx.currentContext());
                    conn.handler(buff -> {
                        NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        NetTest.this.assertSame(context, Vertx.currentContext());
                        conn.write(buff);
                    });
                    conn.closeHandler(v -> {
                        NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        NetTest.this.assertSame(context, Vertx.currentContext());
                        NetTest.this.complete();
                    });
                    conn.endHandler(v -> {
                        NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        NetTest.this.assertSame(context, Vertx.currentContext());
                        NetTest.this.complete();
                    });
                }).listen(NetTest.this.testAddress, NetTest.this.onSuccess(s -> {
                    NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    NetTest.this.assertSame(context, Vertx.currentContext());
                    NetClient client = this.vertx.createNetClient();
                    client.connect(NetTest.this.testAddress, NetTest.this.onSuccess(res -> {
                        NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        NetTest.this.assertSame(context, Vertx.currentContext());
                        res.write("foo");
                        res.handler(buff -> {
                            NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                            NetTest.this.assertTrue(Context.isOnWorkerThread());
                            NetTest.this.assertSame(context, Vertx.currentContext());
                            res.close();
                        });
                    }));
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncWriteIsFlushed() throws Exception {
        int num = 128;
        Buffer expected = TestUtils.randomBuffer(1024);
        ExecutorService exec = Executors.newFixedThreadPool(1);
        try {
            this.server.connectHandler(so -> so.handler(buff -> {
                this.assertEquals(256L, buff.length());
                CountDownLatch latch = new CountDownLatch(1);
                exec.execute(() -> {
                    latch.countDown();
                    so.write((Object)expected);
                });
                try {
                    this.awaitLatch(latch);
                }
                catch (InterruptedException e) {
                    this.fail(e);
                }
            }));
            this.startServer();
            AtomicInteger done = new AtomicInteger();
            for (int i = 0; i < num; ++i) {
                this.client.connect(this.testAddress, ar -> {
                    if (ar.succeeded()) {
                        NetSocket so = (NetSocket)ar.result();
                        so.handler(buff -> {
                            this.assertEquals(expected, buff);
                            so.close();
                            int val = done.incrementAndGet();
                            if (val == num) {
                                this.testComplete();
                            }
                        });
                        so.write((Object)TestUtils.randomBuffer(256));
                    } else {
                        ar.cause().printStackTrace();
                    }
                });
            }
            this.await();
        }
        finally {
            exec.shutdown();
        }
    }

    private File setupFile(String testDir, String fileName, String content) throws Exception {
        File file = new File(testDir, fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write(content);
        out.close();
        return file;
    }

    @Test
    public void testServerWorkerMissBufferWhenBufferArriveBeforeConnectCallback() throws Exception {
        int size = this.getOptions().getWorkerPoolSize();
        List<Context> workers = this.createWorkers(size + 1);
        CountDownLatch latch1 = new CountDownLatch(workers.size() - 1);
        workers.get(0).runOnContext(v -> {
            NetServer server = this.vertx.createNetServer();
            server.connectHandler(so -> so.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            }));
            server.listen(this.testAddress, ar -> {
                this.assertTrue(ar.succeeded());
                for (int i = 1; i < workers.size(); ++i) {
                    ((Context)workers.get(i)).runOnContext(v2 -> {
                        latch1.countDown();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    });
                }
            });
        });
        this.awaitLatch(latch1);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            NetSocket so = (NetSocket)ar.result();
            so.write((Object)Buffer.buffer((String)"hello"));
        });
        this.await();
    }

    @Test
    public void testClientWorkerMissBufferWhenBufferArriveBeforeConnectCallback() throws Exception {
        int size = this.getOptions().getWorkerPoolSize();
        List<Context> workers = this.createWorkers(size + 1);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(size);
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> {
            try {
                this.awaitLatch(latch2);
            }
            catch (InterruptedException e) {
                this.fail(e.getMessage());
                return;
            }
            so.write((Object)Buffer.buffer((String)"hello"));
        });
        server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        workers.get(0).runOnContext(v -> {
            NetClient client = this.vertx.createNetClient();
            client.connect(this.testAddress, ar -> {
                this.assertTrue(ar.succeeded());
                NetSocket so = (NetSocket)ar.result();
                so.handler(buf -> {
                    this.assertEquals("hello", buf.toString());
                    this.testComplete();
                });
            });
            for (int i = 1; i < workers.size(); ++i) {
                ((Context)workers.get(i)).runOnContext(v2 -> {
                    latch2.countDown();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
            }
        });
        this.await();
    }

    @Test
    public void testHostVerificationHttpsNotMatching() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions(new JksOptions().setPath("tls/mim-server-keystore.jks").setPassword("wibble"));
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true).setHostnameVerificationAlgorithm("HTTPS");
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.failed());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testHostVerificationHttpsMatching() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions(new JksOptions().setPath("tls/server-keystore.jks").setPassword("wibble"));
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true).setHostnameVerificationAlgorithm("HTTPS");
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testNoLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging();
        this.assertFalse(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testServerLogging() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testClientLogging() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    private TestLoggerFactory testLogging() throws Exception {
        return TestUtils.testLogging(() -> {
            this.server.connectHandler(so -> so.end((Object)Buffer.buffer((String)"fizzbuzz")));
            this.server.listen(this.testAddress, this.onSuccess(v1 -> this.client.connect(this.testAddress, this.onSuccess(so -> so.closeHandler(v2 -> this.testComplete())))));
            this.await();
        });
    }

    @Test
    public void testWithSocks5Proxy() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new SocksProxy();
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks5ProxyAuth() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setPort(11080).setUsername("username").setPassword("username"));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new SocksProxy().username("username");
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testConnectSSLWithSocks5Proxy() throws Exception {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get());
        this.server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setSsl(true).setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("127.0.0.1").setPort(11080)).setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new SocksProxy();
        this.proxy.start(this.vertx);
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testUpgradeSSLWithSocks5Proxy() throws Exception {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get());
        this.server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("127.0.0.1").setPort(11080)).setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new SocksProxy();
        this.proxy.start(this.vertx);
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket ns = (NetSocket)ar2.result();
                ns.upgradeToSsl(this.onSuccess(v2 -> this.testComplete()));
            });
        });
        this.await();
    }

    @Test
    public void testWithHttpConnectProxy() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setPort(13128));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new HttpProxy();
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks4aProxy() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy();
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks4aProxyAuth() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080).setUsername("username"));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy().username("username");
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks4LocalResolver() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy().start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "127.0.0.1", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("127.0.0.1:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testNonProxyHosts() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().addNonProxyHost("example.com").setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setPort(13128));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new HttpProxy();
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", this.onSuccess(s -> client.connect(1234, "example.com", this.onSuccess(so -> {
            this.assertNull(this.proxy.getLastUri());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testTLSHostnameCertCheckCorrect() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setSsl(true).setPort(HttpTestBase.DEFAULT_HTTPS_PORT).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()));
        this.server.connectHandler(netSocket -> netSocket.close()).listen(ar -> {
            NetClientOptions options = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
            NetClient client = this.vertx.createNetClient(options);
            client.connect(HttpTestBase.DEFAULT_HTTPS_PORT, "localhost", arSocket -> {
                if (arSocket.succeeded()) {
                    NetSocket ns = (NetSocket)arSocket.result();
                    ns.upgradeToSsl(this.onSuccess(v -> this.testComplete()));
                } else {
                    this.fail(ar.cause());
                }
            });
        });
        this.await();
    }

    @Test
    public void testTLSHostnameCertCheckIncorrect() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setSsl(true).setPort(HttpTestBase.DEFAULT_HTTPS_PORT).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()));
        this.server.connectHandler(netSocket -> netSocket.close()).listen(ar -> {
            NetClientOptions options = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
            NetClient client = this.vertx.createNetClient(options);
            client.connect(HttpTestBase.DEFAULT_HTTPS_PORT, "127.0.0.1", arSocket -> {
                if (arSocket.succeeded()) {
                    NetSocket ns = (NetSocket)arSocket.result();
                    ns.upgradeToSsl(this.onFailure(err -> this.testComplete()));
                } else {
                    this.fail(ar.cause());
                }
            });
        });
        this.await();
    }

    @Test
    public void testUpgradeToSSLIncorrectClientOptions() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setSsl(true).setPort(HttpTestBase.DEFAULT_HTTPS_PORT).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()));
        NetClient client = this.vertx.createNetClient();
        this.server.connectHandler(ns -> {}).listen(this.onSuccess(v -> client.connect(HttpTestBase.DEFAULT_HTTPS_PORT, "127.0.0.1", this.onSuccess(ns -> ns.upgradeToSsl(this.onFailure(err -> client.close(this.onSuccess(s -> this.testComplete()))))))));
        this.await();
    }

    @Test
    public void testClientLocalAddress() {
        String expectedAddress = TestUtils.loopbackAddress();
        NetClientOptions clientOptions = new NetClientOptions().setLocalAddress(expectedAddress);
        this.client.close();
        this.client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {
            this.assertEquals(expectedAddress, sock.remoteAddress().host());
            sock.close();
        });
        this.server.listen(1234, "localhost", this.onSuccess(v -> this.client.connect(1234, "localhost", this.onSuccess(socket -> socket.closeHandler(v2 -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testSelfSignedCertificate() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() < 9 ? 1 : 0) != 0);
        CountDownLatch latch = new CountDownLatch(2);
        SelfSignedCertificate certificate = SelfSignedCertificate.create();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)certificate.keyCertOptions()).setTrustOptions((TrustOptions)certificate.trustOptions());
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)certificate.keyCertOptions()).setTrustOptions((TrustOptions)certificate.trustOptions());
        NetClientOptions clientTrustAllOptions = new NetClientOptions().setSsl(true).setTrustAll(true);
        this.server = this.vertx.createNetServer(serverOptions).connectHandler(socket -> socket.end((Object)Buffer.buffer((String)"123"))).listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createNetClient(clientOptions);
            this.client.connect(this.testAddress, this.onSuccess(socket -> socket.handler(buffer -> {
                this.assertEquals("123", buffer.toString());
                latch.countDown();
            })));
            this.client = this.vertx.createNetClient(clientTrustAllOptions);
            this.client.connect(this.testAddress, this.onSuccess(socket -> socket.handler(buffer -> {
                this.assertEquals("123", buffer.toString());
                latch.countDown();
            })));
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testWorkerClient() throws Exception {
        final String expected = TestUtils.randomAlphaString(2000);
        this.server.connectHandler(so -> {
            so.write(expected);
            so.close();
        });
        this.startServer();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                NetClient client = this.vertx.createNetClient();
                client.connect(NetTest.this.testAddress, NetTest.this.onSuccess(so -> {
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    Buffer received = Buffer.buffer();
                    so.handler(buff -> {
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        received.appendBuffer(buff);
                    });
                    so.closeHandler(v -> {
                        NetTest.this.assertEquals(expected, received.toString());
                        NetTest.this.testComplete();
                    });
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testWorkerServer() {
        final String expected = TestUtils.randomAlphaString(2000);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                NetServer server = this.vertx.createNetServer();
                server.connectHandler(so -> {
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    Buffer received = Buffer.buffer();
                    so.handler(buffer -> {
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        received.appendBuffer(buffer);
                    });
                    so.closeHandler(v -> {
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        NetTest.this.assertEquals(expected, received.toString());
                        NetTest.this.testComplete();
                    });
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
                server.listen(NetTest.this.testAddress, ar -> startPromise.handle(ar.mapEmpty()));
            }
        }, new DeploymentOptions().setWorker(true), this.onSuccess(v -> this.client.connect(this.testAddress, this.onSuccess(so -> {
            so.write(expected);
            so.close();
        }))));
        this.await();
    }

    @Test
    public void testNetServerInternal() throws Exception {
        this.testNetServerInternal_(new HttpClientOptions(), false);
    }

    @Test
    public void testNetServerInternalTLS() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()));
        this.testNetServerInternal_(new HttpClientOptions().setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()), true);
    }

    private void testNetServerInternal_(HttpClientOptions clientOptions, boolean expectSSL) throws Exception {
        this.waitFor(2);
        this.server.connectHandler(so -> {
            NetSocketInternal internal = (NetSocketInternal)so;
            this.assertEquals(expectSSL, internal.isSsl());
            ChannelHandlerContext chctx = internal.channelHandlerContext();
            ChannelPipeline pipeline = chctx.pipeline();
            pipeline.addBefore("handler", "http", (ChannelHandler)new HttpServerCodec());
            internal.handler(buff -> this.fail());
            internal.messageHandler(obj -> {
                if (obj instanceof LastHttpContent) {
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)StandardCharsets.UTF_8));
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"11");
                    internal.writeMessage((Object)response, this.onSuccess(v -> this.complete()));
                }
            });
        });
        this.startServer(SocketAddress.inetSocketAddress((int)1234, (String)"localhost"));
        HttpClient client = this.vertx.createHttpClient(clientOptions);
        client.request(io.vertx.core.http.HttpMethod.GET, 1234, "localhost", "/somepath", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.body(this.onSuccess(body -> {
                this.assertEquals("Hello World", body.toString());
                this.complete();
            }));
        }))));
        this.await();
    }

    @Test
    public void testNetClientInternal() throws Exception {
        this.testNetClientInternal_(new HttpServerOptions().setHost("localhost").setPort(1234), false);
    }

    @Test
    public void testNetClientInternalTLS() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()));
        this.testNetClientInternal_(new HttpServerOptions().setHost("localhost").setPort(1234).setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()), true);
    }

    @Test
    public void testNetClientInternalTLSWithSuppliedSSLContext() throws Exception {
        TrustManagerFactory tmFactory;
        this.client.close();
        Buffer trust = this.vertx.fileSystem().readFileBlocking(((JksOptions)Trust.SERVER_JKS.get()).getPath());
        try (ByteArrayInputStream trustStoreStream = new ByteArrayInputStream(trust.getBytes());){
            KeyStore trustStore = KeyStore.getInstance("jks");
            trustStore.load(trustStoreStream, ((JksOptions)Trust.SERVER_JKS.get()).getPassword().toCharArray());
            tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmFactory.init(trustStore);
        }
        final SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmFactory.getTrustManagers(), null);
        this.client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions(){

            public SslContextFactory sslContextFactory() {
                return new SslContextFactory(){

                    public SslContext create() {
                        return new JdkSslContext(sslContext, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, null, false);
                    }
                };
            }
        }));
        this.testNetClientInternal_(new HttpServerOptions().setHost("localhost").setPort(1234).setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()), true);
    }

    private void testNetClientInternal_(HttpServerOptions options, boolean expectSSL) throws Exception {
        this.waitFor(2);
        HttpServer server = this.vertx.createHttpServer(options);
        server.requestHandler(req -> req.response().end("Hello World"));
        CountDownLatch latch = new CountDownLatch(1);
        server.listen(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.connect(1234, "localhost", this.onSuccess(so -> {
            NetSocketInternal soInt = (NetSocketInternal)so;
            this.assertEquals(expectSSL, soInt.isSsl());
            ChannelHandlerContext chctx = soInt.channelHandlerContext();
            ChannelPipeline pipeline = chctx.pipeline();
            pipeline.addBefore("handler", "http", (ChannelHandler)new HttpClientCodec());
            AtomicInteger status = new AtomicInteger();
            soInt.handler(buff -> this.fail());
            soInt.messageHandler(obj -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertTrue(obj instanceof HttpResponse);
                        HttpResponse resp = (HttpResponse)obj;
                        this.assertEquals(200L, resp.status().code());
                        break;
                    }
                    case 1: {
                        this.assertTrue(obj instanceof LastHttpContent);
                        ByteBuf content = ((LastHttpContent)obj).content();
                        this.assertEquals(!expectSSL, content.isDirect());
                        this.assertEquals(1L, content.refCnt());
                        String val = content.toString(StandardCharsets.UTF_8);
                        this.assertTrue(content.release());
                        this.assertEquals("Hello World", val);
                        this.complete();
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            soInt.writeMessage((Object)new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/somepath"), this.onSuccess(v -> this.complete()));
        }));
        this.await();
    }

    @Test
    public void testNetSocketInternalBuffer() throws Exception {
        this.server.connectHandler(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.handler(msg -> {
                ByteBuf byteBuf = msg.getByteBuf();
                this.assertFalse(byteBuf.isDirect());
                this.assertEquals(1L, byteBuf.refCnt());
                this.assertFalse(byteBuf.release());
                this.assertEquals(1L, byteBuf.refCnt());
                soi.write(msg);
            });
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.write((Object)Buffer.buffer((String)"Hello World"));
            soi.handler(msg -> {
                ByteBuf byteBuf = msg.getByteBuf();
                this.assertFalse(byteBuf.isDirect());
                this.assertEquals(1L, byteBuf.refCnt());
                this.assertFalse(byteBuf.release());
                this.assertEquals(1L, byteBuf.refCnt());
                this.assertEquals("Hello World", msg.toString());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testNetSocketInternalDirectBuffer() throws Exception {
        this.waitFor(2);
        this.server.connectHandler(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.messageHandler(msg -> {
                ByteBuf byteBuf = (ByteBuf)msg;
                this.assertTrue(byteBuf.isDirect());
                this.assertEquals(1L, byteBuf.refCnt());
                soi.writeMessage(msg).onSuccess(v -> {
                    this.assertEquals(0L, byteBuf.refCnt());
                    this.complete();
                });
            });
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.write((Object)Buffer.buffer((String)"Hello World"));
            soi.messageHandler(msg -> {
                ByteBuf byteBuf = (ByteBuf)msg;
                this.assertTrue(byteBuf.isDirect());
                this.assertEquals(1L, byteBuf.refCnt());
                this.assertEquals("Hello World", byteBuf.toString(StandardCharsets.UTF_8));
                this.assertTrue(byteBuf.release());
                this.assertEquals(0L, byteBuf.refCnt());
                this.complete();
            });
        }));
        this.await();
    }

    @Test
    public void testNetSocketInternalRemoveVertxHandler() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1000).setRegisterWriteHandler(true));
        this.server.connectHandler(so -> so.closeHandler(v -> this.testComplete()));
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            String id = soi.writeHandlerID();
            ChannelHandlerContext ctx = soi.channelHandlerContext();
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove(VertxHandler.class);
            this.vertx.eventBus().request(id, (Object)"test", this.onFailure(what -> ctx.close()));
        }));
        this.await();
    }

    @Test
    public void testCloseCompletionHandlerNotCalledWhenActualServerFailed() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setSsl(true).setPemKeyCertOptions(new PemKeyCertOptions().setKeyPath("invalid"))).connectHandler(c -> {});
        this.server.listen(10000, this.onFailure(err -> this.server.close(this.onSuccess(v -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testServerNetSocketShouldBeClosedWhenTheClosedHandlerIsCalled() throws Exception {
        this.waitFor(2);
        this.server.connectHandler(so -> {
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), 2, (WriteStream<Buffer>)so);
            sender.send();
            so.closeHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.complete();
                }
            });
            so.endHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.complete();
                }
            });
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> this.vertx.setTimer(1000L, id -> so.close())));
        this.await();
    }

    @Test
    public void testNetSocketInternalEvent() throws Exception {
        this.server.connectHandler(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            final Object expectedEvent = new Object();
            soi.eventHandler(event -> {
                this.assertSame(expectedEvent, event);
                soi.close();
            });
            ChannelPipeline pipeline = soi.channelHandlerContext().pipeline();
            pipeline.addFirst(new ChannelHandler[]{new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    super.handlerAdded(ctx);
                    ctx.executor().schedule(() -> ctx.fireUserEventTriggered(expectedEvent), 10L, TimeUnit.MILLISECONDS);
                }
            }});
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> so.closeHandler(v -> this.testComplete())));
        this.await();
    }

    @Test
    public void testServerWithIdleTimeoutSendChunkedFile() throws Exception {
        this.testIdleTimeoutSendChunkedFile(true);
    }

    @Test
    public void testClientWithIdleTimeoutSendChunkedFile() throws Exception {
        this.testIdleTimeoutSendChunkedFile(false);
    }

    private void testIdleTimeoutSendChunkedFile(boolean idleOnServer) throws Exception {
        int expected = 0x1000000;
        File sent = TestUtils.tmpFile(".dat", expected);
        this.server.close();
        AtomicReference sendResult = new AtomicReference();
        AtomicReference remaining = new AtomicReference();
        AtomicLong now = new AtomicLong();
        Runnable testChecker = () -> {
            if (sendResult.get() != null && remaining.get() != null) {
                if ((Integer)remaining.get() > 0) {
                    this.assertTrue(((AsyncResult)sendResult.get()).failed());
                } else {
                    this.assertTrue(((AsyncResult)sendResult.get()).succeeded());
                    this.assertTrue(System.currentTimeMillis() - now.get() > 200L);
                }
                this.testComplete();
            }
        };
        Consumer<NetSocket> sender = so -> so.sendFile(sent.getAbsolutePath(), ar -> {
            sendResult.set(ar);
            testChecker.run();
        });
        Consumer<NetSocket> receiver = so -> {
            now.set(System.currentTimeMillis());
            int[] len = new int[]{0};
            so.handler(buff -> {
                len[0] = len[0] + buff.length();
                so.pause();
                this.vertx.setTimer(1L, id -> so.resume());
            });
            so.exceptionHandler(this::fail);
            so.endHandler(v -> {
                remaining.set(expected - len[0]);
                testChecker.run();
            });
        };
        this.server = this.vertx.createNetServer(new NetServerOptions().setIdleTimeout(200).setIdleTimeoutUnit(TimeUnit.MILLISECONDS)).connectHandler((idleOnServer ? sender : receiver)::accept);
        this.startServer();
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setIdleTimeout(200).setIdleTimeoutUnit(TimeUnit.MILLISECONDS));
        this.client.connect(this.testAddress, this.onSuccess(idleOnServer ? receiver : sender));
        this.await();
    }

    @Test
    public void testHalfCloseCallsEndHandlerAfterBuffersAreDelivered() throws Exception {
        StringBuffer expected = new StringBuffer();
        this.server.connectHandler(so -> {
            Context ctx = this.vertx.getOrCreateContext();
            int i = 0;
            while (i < 8) {
                int val = i++;
                ctx.runOnContext(v -> {
                    String chunk = "chunk-" + val + "\r\n";
                    so.write(chunk);
                    expected.append(chunk);
                });
            }
            ctx.runOnContext(v -> so.close());
        });
        this.startServer();
        this.client.connect(this.testAddress, "localhost", this.onSuccess(so -> {
            so.pause();
            AtomicBoolean closed = new AtomicBoolean();
            AtomicBoolean ended = new AtomicBoolean();
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.closeHandler(v -> {
                this.assertFalse(ended.get());
                this.assertEquals(Buffer.buffer(), received);
                closed.set(true);
                so.resume();
            });
            so.endHandler(v -> {
                this.assertEquals(expected.toString(), received.toString());
                ended.set(true);
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testSslHandshakeTimeoutHappenedOnServer() throws Exception {
        this.testSslHandshakeTimeoutHappened(false, false);
    }

    @Test
    public void testSslHandshakeTimeoutHappenedOnSniServer() throws Exception {
        this.testSslHandshakeTimeoutHappened(false, true);
    }

    public void testSslHandshakeTimeoutHappened(boolean onClient, boolean sni) throws Exception {
        this.server.close();
        this.client.close();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(!onClient).setSslHandshakeTimeout(200L).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()).setSni(sni).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.server = this.vertx.createNetServer(serverOptions);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(onClient).setTrustAll(true).setSslHandshakeTimeout(200L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.client = this.vertx.createNetClient(clientOptions);
        Consumer<Throwable> checker = err -> {
            this.assertTrue(err instanceof SSLException);
            this.assertEquals("handshake timed out after 200ms", err.getMessage());
            this.testComplete();
        };
        if (!onClient) {
            this.server.exceptionHandler(checker::accept);
        }
        this.server.connectHandler(s -> {}).listen(this.testAddress, this.onSuccess(s -> this.client.connect(this.testAddress, ar -> {
            if (onClient) {
                this.assertTrue(ar.failed());
                checker.accept(ar.cause());
            }
        })));
        this.await();
    }

    @Test
    public void testSslHandshakeTimeoutNotHappened() throws Exception {
        this.server.close();
        this.client.close();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()).setSslHandshakeTimeout(100L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.server = this.vertx.createNetServer(serverOptions);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true);
        this.client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(s -> {}).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, res -> {
                this.assertTrue(res.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSslHandshakeTimeoutHappenedWhenUpgradeSsl() {
        this.server.close();
        this.client.close();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(false);
        this.server = this.vertx.createNetServer(serverOptions);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(false).setTrustAll(true).setSslHandshakeTimeout(200L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(s -> {}).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, res -> {
                this.assertTrue(res.succeeded());
                NetSocket socket = (NetSocket)res.result();
                this.assertFalse(socket.isSsl());
                socket.upgradeToSsl(this.onFailure(err -> {
                    this.assertTrue(err instanceof SSLException);
                    this.assertEquals("handshake timed out after 200ms", err.getMessage());
                    this.testComplete();
                }));
            });
        });
        this.await();
    }

    protected void startServer(SocketAddress remoteAddress) throws Exception {
        this.startServer(remoteAddress, this.vertx.getOrCreateContext());
    }

    protected void startServer(SocketAddress remoteAddress, NetServer server) throws Exception {
        this.startServer(remoteAddress, this.vertx.getOrCreateContext(), server);
    }

    protected void startServer(SocketAddress remoteAddress, Context context) throws Exception {
        this.startServer(remoteAddress, context, this.server);
    }

    protected void startServer(SocketAddress remoteAddress, Context context, NetServer server) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        context.runOnContext(v -> server.listen(remoteAddress, this.onSuccess(s -> latch.countDown())));
        this.awaitLatch(latch);
    }

    @Test
    public void testPausedDuringLastChunk() throws Exception {
        this.server.connectHandler(so -> {
            AtomicBoolean paused = new AtomicBoolean();
            paused.set(true);
            so.pause();
            so.closeHandler(v -> {
                paused.set(false);
                so.resume();
            });
            so.endHandler(v -> {
                this.assertFalse(paused.get());
                this.testComplete();
            });
        });
        this.startServer();
        this.client.connect(this.testAddress, "localhost", this.onSuccess(so -> so.close()));
        this.await();
    }

    protected void startServer() throws Exception {
        this.startServer(this.testAddress, this.vertx.getOrCreateContext());
    }

    protected void startServer(NetServer server) throws Exception {
        this.startServer(this.testAddress, this.vertx.getOrCreateContext(), server);
    }

    protected void startServer(Context context) throws Exception {
        this.startServer(this.testAddress, context, this.server);
    }

    protected void startServer(Context context, NetServer server) throws Exception {
        this.startServer(this.testAddress, context, server);
    }

    @Test
    public void testUnresolvedSocketAddress() {
        InetSocketAddress a = InetSocketAddress.createUnresolved("localhost", 8080);
        SocketAddress converted = ((VertxInternal)this.vertx).transport().convert((java.net.SocketAddress)a);
        this.assertEquals(8080L, converted.port());
        this.assertEquals("localhost", converted.host());
    }

    @Test
    public void testNetSocketHandlerFailureReportedToContextExceptionHandler() throws Exception {
        this.server.connectHandler(so -> {
            Context ctx = Vertx.currentContext();
            ArrayList reported = new ArrayList();
            ctx.exceptionHandler(reported::add);
            NullPointerException err1 = new NullPointerException();
            so.handler(buff -> {
                throw err1;
            });
            NullPointerException err2 = new NullPointerException();
            so.endHandler(v -> {
                throw err2;
            });
            NullPointerException err3 = new NullPointerException();
            so.closeHandler(v1 -> {
                ctx.runOnContext(v2 -> {
                    this.assertEquals(Arrays.asList(err1, err2, err3), reported);
                    this.testComplete();
                });
                throw err3;
            });
        });
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            so.write("ping");
            so.close();
        }));
        this.await();
    }

    @Test
    public void testHAProxyProtocolIdleTimeout() throws Exception {
        HAProxy proxy = new HAProxy(this.testAddress, Buffer.buffer());
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setProxyProtocolTimeout(2L).setUseProxyProtocol(true)).connectHandler(u -> this.fail("Should not be called"));
        this.startServer();
        this.client.connect(proxy.getPort(), proxy.getHost()).onSuccess(so -> so.closeHandler(event -> this.testComplete())).onFailure(this::fail);
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAProxyProtocolIdleTimeoutNotHappened() throws Exception {
        this.waitFor(2);
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setProxyProtocolTimeout(100L).setProxyProtocolTimeoutUnit(TimeUnit.MILLISECONDS).setUseProxyProtocol(true)).connectHandler(u -> this.complete());
        this.startServer();
        this.client.connect(proxy.getPort(), proxy.getHost()).onSuccess(so -> {
            so.close();
            this.complete();
        }).onFailure(this::fail);
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAProxyProtocolConnectSSL() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        this.waitFor(2);
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        NetServerOptions options = new NetServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()).setUseProxyProtocol(true);
        this.server = this.vertx.createNetServer(options).connectHandler(event -> {
            this.assertAddresses(remote, event.remoteAddress());
            this.assertAddresses(remote, event.remoteAddress(false));
            this.assertAddresses(proxy.getConnectionLocalAddress(), event.remoteAddress(true));
            this.assertAddresses(local, event.localAddress());
            this.assertAddresses(local, event.localAddress(false));
            this.assertAddresses(USE_DOMAIN_SOCKETS ? null : SocketAddress.inetSocketAddress((int)this.server.actualPort(), (String)"127.0.0.1"), event.localAddress(true));
            this.complete();
        });
        this.startServer();
        NetClientOptions clientOptions = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setSsl(true).setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
        this.vertx.createNetClient(clientOptions).connect(proxy.getPort(), proxy.getHost()).onSuccess(so -> {
            so.close();
            this.complete();
        }).onFailure(this::fail);
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testHAProxyProtocolVersion1TCP4() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion1TCP6() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"2001:db8:85a3:0:0:8a2e:370:7334");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion1TCP6ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion1Unknown() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        Buffer header = HAProxy.createVersion1UnknownProtocolHeader();
        this.testHAProxyProtocolAccepted(header, null, null);
    }

    @Test
    public void testHAProxyProtocolVersion2TCP4() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion2TCP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion2TCP6() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"2001:db8:85a3:0:0:8a2e:370:7334");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion2TCP6ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion2UnixSocket() throws Exception {
        SocketAddress remote = SocketAddress.domainSocketAddress((String)"/tmp/remoteSocket");
        SocketAddress local = SocketAddress.domainSocketAddress((String)"/tmp/localSocket");
        Buffer header = HAProxy.createVersion2UnixStreamProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion2Unknown() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        Buffer header = HAProxy.createVersion2UnknownProtocolHeader();
        this.testHAProxyProtocolAccepted(header, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHAProxyProtocolAccepted(Buffer header, SocketAddress remote, SocketAddress local) throws Exception {
        this.waitFor(2);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setUseProxyProtocol(true)).connectHandler(so -> {
            this.assertAddresses(remote == null && this.testAddress.isInetSocket() ? proxy.getConnectionLocalAddress() : remote, so.remoteAddress());
            this.assertAddresses(local == null && this.testAddress.isInetSocket() ? proxy.getConnectionRemoteAddress() : local, so.localAddress());
            this.complete();
        });
        this.startServer();
        this.client.connect(proxy.getPort(), proxy.getHost()).onSuccess(so -> {
            so.close();
            this.complete();
        }).onFailure(this::fail);
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testHAProxyProtocolVersion2UDP4() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion2UDP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolRejected(header);
    }

    @Test
    public void testHAProxyProtocolVersion2UDP6() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"2001:db8:85a3:0:0:8a2e:370:7334");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion2UDP6ProtocolHeader(remote, local);
        this.testHAProxyProtocolRejected(header);
    }

    @Test
    public void testHAProxyProtocolVersion2UnixDataGram() throws Exception {
        SocketAddress remote = SocketAddress.domainSocketAddress((String)"/tmp/remoteSocket");
        SocketAddress local = SocketAddress.domainSocketAddress((String)"/tmp/localSocket");
        Buffer header = HAProxy.createVersion2UnixDatagramProtocolHeader(remote, local);
        this.testHAProxyProtocolRejected(header);
    }

    private void testHAProxyProtocolRejected(Buffer header) throws Exception {
        this.waitFor(2);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setUseProxyProtocol(true)).exceptionHandler(ex -> {
            if (ex.equals(HAProxyMessageCompletionHandler.UNSUPPORTED_PROTOCOL_EXCEPTION)) {
                this.complete();
            }
        }).connectHandler(so -> this.fail());
        this.startServer();
        this.client.connect(proxy.getPort(), proxy.getHost()).onSuccess(so -> {
            so.close();
            this.complete();
        }).onFailure(this::fail);
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testHAProxyProtocolIllegalHeader1() throws Exception {
        this.testHAProxyProtocolIllegal(Buffer.buffer((String)"This is an illegal HA PROXY protocol header\r\n"));
    }

    @Test
    public void testHAProxyProtocolIllegalHeader2() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolIllegal(header);
    }

    private void testHAProxyProtocolIllegal(Buffer header) throws Exception {
        this.waitFor(2);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setUseProxyProtocol(true)).connectHandler(u -> this.fail("Should not be called")).exceptionHandler(exception -> {
            if (exception instanceof HAProxyProtocolException) {
                this.complete();
            }
        });
        this.startServer();
        this.client.connect(proxy.getPort(), proxy.getHost()).onSuccess(so -> {
            so.close();
            this.complete();
        }).onFailure(this::fail);
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    private void assertAddresses(SocketAddress address1, SocketAddress address2) {
        if (address1 == null || address2 == null) {
            this.assertEquals(address1, address2);
        } else {
            this.assertEquals(address1.hostAddress(), address2.hostAddress());
            this.assertEquals(address1.port(), address2.port());
        }
    }

    @Test
    public void testConnectTimeout() {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1));
        this.client.connect(1234, "10.0.0.0").onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof ConnectTimeoutException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testInvalidPort() {
        try {
            this.server.connectHandler(so -> {}).listen(65536);
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private /* synthetic */ void lambda$testContexts$210(Set contexts, AtomicReference serverConnectContext, AtomicReference listenContext, AsyncResult ar) {
        this.assertTrue(ar.succeeded());
        Context closeContext = Vertx.currentContext();
        this.assertFalse(contexts.contains(closeContext));
        this.assertSame(serverConnectContext.get(), closeContext);
        this.assertFalse(contexts.contains(listenContext.get()));
        this.assertSame(serverConnectContext.get(), listenContext.get());
        this.testComplete();
    }

    private /* synthetic */ void lambda$testContexts$209(Set contexts, AtomicInteger connectCount, int numConnections, CountDownLatch clientLatch, Void v) {
        this.client.connect(this.testAddress, conn -> {
            contexts.add(Vertx.currentContext());
            if (connectCount.incrementAndGet() == numConnections) {
                this.assertEquals(numConnections, contexts.size());
                clientLatch.countDown();
            }
        });
    }

    private /* synthetic */ void lambda$testFanout$145(Set connections, int numConnections, NetSocket socket) {
        connections.add(socket.writeHandlerID());
        if (connections.size() == numConnections) {
            for (String actorID : connections) {
                this.vertx.eventBus().publish(actorID, (Object)Buffer.buffer((String)"some data"));
            }
        }
        socket.closeHandler(v -> connections.remove(socket.writeHandlerID()));
    }

    class TLSTest {
        Cert<?> clientCert = Cert.NONE;
        Trust<?> clientTrust = Trust.NONE;
        Cert<?> serverCert = Cert.NONE;
        Trust<?> serverTrust = Trust.NONE;
        boolean requireClientAuth;
        boolean clientTrustAll;
        boolean startTLS;
        String[] enabledCipherSuites = new String[0];
        String[] enabledSecureTransportProtocols = new String[0];
        boolean sni;
        SocketAddress bindAddress;
        SocketAddress connectAddress = this.bindAddress = SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTPS_PORT, (String)"localhost");
        String serverName;
        Certificate clientPeerCert;
        String indicatedServerName;

        TLSTest() {
        }

        public TLSTest clientCert(Cert<?> clientCert) {
            this.clientCert = clientCert;
            return this;
        }

        public TLSTest clientTrust(Trust<?> clientTrust) {
            this.clientTrust = clientTrust;
            return this;
        }

        public TLSTest serverCert(Cert<?> serverCert) {
            this.serverCert = serverCert;
            return this;
        }

        public TLSTest serverTrust(Trust<?> serverTrust) {
            this.serverTrust = serverTrust;
            return this;
        }

        public TLSTest requireClientAuth(boolean requireClientAuth) {
            this.requireClientAuth = requireClientAuth;
            return this;
        }

        public TLSTest clientTrustAll(boolean clientTrustAll) {
            this.clientTrustAll = clientTrustAll;
            return this;
        }

        public TLSTest startTLS(boolean startTLS) {
            this.startTLS = startTLS;
            return this;
        }

        public TLSTest enabledCipherSuites(String[] enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
            return this;
        }

        public TLSTest enabledSecureTransportProtocols(String[] enabledSecureTransportProtocols) {
            this.enabledSecureTransportProtocols = enabledSecureTransportProtocols;
            return this;
        }

        public TLSTest address(SocketAddress address) {
            this.bindAddress = address;
            this.connectAddress = address;
            return this;
        }

        public TLSTest bindAddress(SocketAddress address) {
            this.bindAddress = address;
            return this;
        }

        public TLSTest connectAddress(SocketAddress address) {
            this.connectAddress = address;
            return this;
        }

        public TLSTest serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public TLSTest sni(boolean sni) {
            this.sni = sni;
            return this;
        }

        public Certificate clientPeerCert() {
            return this.clientPeerCert;
        }

        void setupServer(boolean shouldPass) {
            NetTest.this.server.close();
            NetServerOptions options = new NetServerOptions();
            if (!this.startTLS) {
                options.setSsl(true);
            }
            options.setTrustOptions((TrustOptions)this.serverTrust.get());
            options.setKeyCertOptions((KeyCertOptions)this.serverCert.get());
            if (this.requireClientAuth) {
                options.setClientAuth(io.vertx.core.http.ClientAuth.REQUIRED);
            }
            for (String suite : this.enabledCipherSuites) {
                options.addEnabledCipherSuite(suite);
            }
            if (this.enabledSecureTransportProtocols.length > 0) {
                options.getEnabledSecureTransportProtocols().forEach(arg_0 -> ((NetServerOptions)options).removeEnabledSecureTransportProtocol(arg_0));
            }
            for (String protocol : this.enabledSecureTransportProtocols) {
                options.addEnabledSecureTransportProtocol(protocol);
            }
            options.setSni(this.sni);
            Consumer<NetSocket> certificateChainChecker = socket -> {
                try {
                    List certs = socket.peerCertificates();
                    if (this.clientCert != Cert.NONE) {
                        NetTest.this.assertNotNull(certs);
                        NetTest.this.assertEquals(1L, certs.size());
                    } else {
                        NetTest.this.assertNull(certs);
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    NetTest.this.assertTrue(this.clientTrust.get() != Trust.NONE || this.clientTrustAll);
                }
            };
            NetTest.this.server = NetTest.this.vertx.createNetServer(options);
            if (!shouldPass) {
                NetTest.this.waitForMore(1);
            }
            NetTest.this.server.exceptionHandler(err -> NetTest.this.complete());
            Handler serverHandler = socket -> {
                this.indicatedServerName = socket.indicatedServerName();
                SSLSession sslSession = socket.sslSession();
                if (socket.isSsl()) {
                    NetTest.this.assertNotNull(sslSession);
                    certificateChainChecker.accept((NetSocket)socket);
                } else {
                    NetTest.this.assertNull(sslSession);
                }
                AtomicBoolean upgradedServer = new AtomicBoolean();
                AtomicInteger upgradedServerCount = new AtomicInteger();
                socket.handler(buff -> {
                    socket.write(buff);
                    if (this.startTLS) {
                        if (upgradedServer.compareAndSet(false, true)) {
                            this.indicatedServerName = socket.indicatedServerName();
                            NetTest.this.assertFalse(socket.isSsl());
                            Context ctx = Vertx.currentContext();
                            Handler handler = shouldPass ? NetTest.this.onSuccess(v -> {
                                NetTest.this.assertSame(ctx, Vertx.currentContext());
                                certificateChainChecker.accept((NetSocket)socket);
                                upgradedServerCount.incrementAndGet();
                                NetTest.this.assertTrue(socket.isSsl());
                            }) : NetTest.this.onFailure(err -> {
                                NetTest.this.assertSame(ctx, Vertx.currentContext());
                                NetTest.this.complete();
                            });
                            socket.upgradeToSsl(handler);
                        } else {
                            NetTest.this.assertTrue(socket.isSsl());
                            NetTest.this.assertEquals(1L, upgradedServerCount.get());
                        }
                    } else {
                        NetTest.this.assertTrue(socket.isSsl());
                    }
                });
            };
            NetTest.this.server.connectHandler(serverHandler);
        }

        void run(boolean shouldPass) {
            this.setupServer(shouldPass);
            NetTest.this.server.listen(this.bindAddress, NetTest.this.onSuccess(ar -> {
                NetTest.this.client.close();
                NetClientOptions clientOptions = new NetClientOptions();
                if (!this.startTLS) {
                    clientOptions.setSsl(true);
                }
                if (this.clientTrustAll) {
                    clientOptions.setTrustAll(true);
                }
                clientOptions.setTrustOptions((TrustOptions)this.clientTrust.get());
                clientOptions.setKeyCertOptions((KeyCertOptions)this.clientCert.get());
                for (String suite : this.enabledCipherSuites) {
                    clientOptions.addEnabledCipherSuite(suite);
                }
                if (this.enabledSecureTransportProtocols.length > 0) {
                    clientOptions.getEnabledSecureTransportProtocols().forEach(arg_0 -> ((NetClientOptions)clientOptions).removeEnabledSecureTransportProtocol(arg_0));
                }
                for (String protocol : this.enabledSecureTransportProtocols) {
                    clientOptions.addEnabledSecureTransportProtocol(protocol);
                }
                NetTest.this.client = NetTest.this.vertx.createNetClient(clientOptions);
                Future f = NetTest.this.client.connect(this.connectAddress, this.serverName).compose(socket -> {
                    Promise result = Promise.promise();
                    int numChunks = 100;
                    int chunkSize = 100;
                    ArrayList<Buffer> toSend = new ArrayList<Buffer>();
                    Buffer expected = Buffer.buffer();
                    for (int i = 0; i < 100; ++i) {
                        Buffer chunk = TestUtils.randomBuffer(100);
                        toSend.add(chunk);
                        expected.appendBuffer(chunk);
                    }
                    Buffer received = Buffer.buffer();
                    if (socket.isSsl()) {
                        try {
                            this.clientPeerCert = (Certificate)socket.peerCertificates().get(0);
                        }
                        catch (SSLPeerUnverifiedException chunk) {
                            // empty catch block
                        }
                    }
                    AtomicBoolean upgradedClient = new AtomicBoolean();
                    socket.exceptionHandler(arg_0 -> ((Promise)result).tryFail(arg_0));
                    socket.handler(buffer -> {
                        received.appendBuffer(buffer);
                        if (received.length() == expected.length()) {
                            NetTest.this.assertEquals(expected, received);
                            NetTest.this.complete();
                        }
                        if (this.startTLS && !upgradedClient.get()) {
                            upgradedClient.set(true);
                            NetTest.this.assertFalse(socket.isSsl());
                            Future fut = this.serverName != null ? socket.upgradeToSsl(this.serverName) : socket.upgradeToSsl();
                            if (shouldPass) {
                                fut.onSuccess(v -> {
                                    NetTest.this.assertTrue(socket.isSsl());
                                    try {
                                        this.clientPeerCert = (Certificate)socket.peerCertificates().get(0);
                                    }
                                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                                        // empty catch block
                                    }
                                    for (int i = 1; i < 100; ++i) {
                                        socket.write(toSend.get(i));
                                    }
                                });
                            }
                            fut.onFailure(arg_0 -> ((Promise)result).tryFail(arg_0));
                        } else {
                            NetTest.this.assertTrue(socket.isSsl());
                        }
                    });
                    int numToSend = this.startTLS ? 1 : 100;
                    for (int i = 0; i < numToSend; ++i) {
                        socket.write(toSend.get(i));
                    }
                    return result.future();
                });
                if (shouldPass) {
                    f.onComplete(NetTest.this.onSuccess(v -> NetTest.this.complete()));
                } else {
                    f.onComplete(NetTest.this.onFailure(v -> NetTest.this.complete()));
                }
            }));
        }
    }
}

