/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Test;

public class StressTest
extends VertxTestBase {
    @Test
    public void testStress() throws InterruptedException {
        int i;
        int numActors = 16;
        int numConnections = 1000;
        FakeConnectionPool mgr = new FakeConnectionPool(-1, numActors);
        Thread[] actors = new Thread[numActors];
        for (i = 0; i < numActors; ++i) {
            actors[i] = new Thread(() -> {
                final CountDownLatch latch = new CountDownLatch(numConnections);
                for (int i1 = 0; i1 < numConnections; ++i1) {
                    mgr.getConnection(new FakeWaiter(){

                        @Override
                        protected void onFailure() {
                            latch.countDown();
                        }

                        @Override
                        protected void onSuccess(FakeConnection conn) {
                            int action = ThreadLocalRandom.current().nextInt(100);
                            if (action < -1) {
                                this.recycle();
                                latch.countDown();
                            } else {
                                StressTest.this.vertx.setTimer(10L, id -> {
                                    if (action < 15) {
                                        conn.close();
                                    } else {
                                        this.recycle();
                                    }
                                    latch.countDown();
                                });
                            }
                        }
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }, "actor-" + i);
            actors[i].start();
        }
        for (i = 0; i < actors.length; ++i) {
            try {
                actors[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        mgr.pool.close(ar -> {
            if (ar.succeeded()) {
                // empty if block
            }
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertEquals(0L, mgr.pool.requests());
        this.assertEquals(0L, mgr.pool.size());
        this.assertEquals(0L, mgr.pool.capacity());
        this.assertEquals(0L, mgr.pool.waiters());
    }

    private static class FakeConnection {
        private static final int DISCONNECTED = 0;
        private static final int CONNECTING = 1;
        private static final int CONNECTED = 2;
        private static final int CLOSED = 3;
        private final ContextInternal context;
        private final PoolConnector.Listener listener;
        private final Promise<ConnectResult<FakeConnection>> future;
        private long concurrency = 1L;
        private int status = 0;

        FakeConnection(ContextInternal context, PoolConnector.Listener listener, Promise<ConnectResult<FakeConnection>> future) {
            this.context = context;
            this.listener = listener;
            this.future = future;
        }

        synchronized void close() {
            if (this.status != 2) {
                throw new IllegalStateException();
            }
            this.status = 3;
            this.listener.onRemove();
        }

        synchronized FakeConnection connect() {
            if (this.status != 0) {
                throw new IllegalStateException();
            }
            this.status = 1;
            this.context.nettyEventLoop().execute(() -> {
                FakeConnection fakeConnection = this;
                synchronized (fakeConnection) {
                    this.status = 2;
                    this.future.complete((Object)new ConnectResult((Object)this, this.concurrency, 0L));
                }
            });
            return this;
        }

        void fail(Throwable err) {
            this.context.nettyEventLoop().execute(() -> this.future.tryFail(err));
        }
    }

    class FakeWaiter {
        protected final ContextInternal context;
        private Object result;

        FakeWaiter() {
            this.context = (ContextInternal)StressTest.this.vertx.getOrCreateContext();
        }

        protected void onSuccess(FakeConnection conn) {
        }

        protected void onFailure() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void handleFailure(Throwable failure) {
            FakeWaiter fakeWaiter = this;
            synchronized (fakeWaiter) {
                StressTest.this.assertNull(this.result);
                this.result = failure;
            }
            this.onFailure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void handleConnection(Lease<FakeConnection> lease) {
            FakeWaiter fakeWaiter = this;
            synchronized (fakeWaiter) {
                StressTest.this.assertNull(this.result);
                this.result = lease;
            }
            this.onSuccess((FakeConnection)lease.get());
        }

        void recycle() {
            Lease conn = (Lease)this.result;
            conn.recycle();
        }
    }

    class FakeConnectionPool
    implements PoolConnector<FakeConnection> {
        private ConnectionPool<FakeConnection> pool;

        FakeConnectionPool(int queueMaxSize, int poolMaxSize) {
            this.pool = ConnectionPool.pool((PoolConnector)this, (int[])new int[]{poolMaxSize}, (int)queueMaxSize);
        }

        void getConnection(FakeWaiter waiter) {
            this.pool.acquire(waiter.context, 0, ar -> {
                if (ar.succeeded()) {
                    waiter.handleConnection((Lease<FakeConnection>)((Lease)ar.result()));
                } else {
                    waiter.handleFailure(ar.cause());
                }
            });
        }

        public void connect(ContextInternal context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<FakeConnection>>> handler) {
            int i = ThreadLocalRandom.current().nextInt(100);
            Promise promise = Promise.promise();
            Future future = promise.future();
            future.onComplete(handler);
            FakeConnection conn = new FakeConnection(context, listener, (Promise<ConnectResult<FakeConnection>>)promise);
            if (i < 10) {
                conn.fail(new Exception("Could not connect"));
            } else {
                conn.connect();
            }
        }

        public boolean isValid(FakeConnection connection) {
            return true;
        }
    }
}

