/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.ServiceHelper;
import io.vertx.test.core.TestUtils;
import io.vertx.test.spi.FakeFactory;
import io.vertx.test.spi.NotImplementedSPI;
import io.vertx.test.spi.SomeFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ServiceHelperTest {
    private final File serviceHelperFile = new File(new File(TestUtils.MAVEN_TARGET_DIR, "classpath"), "servicehelper");

    @Test
    public void loadFactory() {
        FakeFactory factory = (FakeFactory)ServiceHelper.loadFactory(FakeFactory.class);
        Assertions.assertThat((Object)factory.classloader()).isEqualTo((Object)ServiceHelperTest.class.getClassLoader());
    }

    @Test(expected=IllegalStateException.class)
    public void loadNotImplementedSPI() {
        ServiceHelper.loadFactory(NotImplementedSPI.class);
    }

    @Test
    public void loadFactoryOrNull() {
        NotImplementedSPI factory = (NotImplementedSPI)ServiceHelper.loadFactoryOrNull(NotImplementedSPI.class);
        Assertions.assertThat((Object)factory).isNull();
        FakeFactory fake = (FakeFactory)ServiceHelper.loadFactoryOrNull(FakeFactory.class);
        Assertions.assertThat((Object)fake).isNotNull();
        Assertions.assertThat((Object)fake.classloader()).isEqualTo((Object)ServiceHelperTest.class.getClassLoader());
    }

    @Test
    public void loadFactories() {
        Collection factories = ServiceHelper.loadFactories(FakeFactory.class);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(2);
        Collection impl = ServiceHelper.loadFactories(NotImplementedSPI.class);
        Assertions.assertThat((Iterable)impl).isNotNull().hasSize(0);
    }

    @Test
    public void loadFactoriesWithClassloader() throws Exception {
        URLClassLoader custom = new URLClassLoader(new URL[]{this.serviceHelperFile.toURI().toURL()});
        Collection factories = ServiceHelper.loadFactories(SomeFactory.class);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(0);
        factories = ServiceHelper.loadFactories(SomeFactory.class, (ClassLoader)custom);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(1);
        Assertions.assertThat((Object)((SomeFactory)factories.iterator().next()).classloader()).isEqualTo((Object)custom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadFactoriesFromTCCL() throws Exception {
        URLClassLoader custom = new URLClassLoader(new URL[]{this.serviceHelperFile.toURI().toURL()});
        Collection factories = ServiceHelper.loadFactories(SomeFactory.class);
        Assertions.assertThat((Iterable)factories).isNotNull().hasSize(0);
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(custom);
            factories = ServiceHelper.loadFactories(SomeFactory.class);
            Assertions.assertThat((Iterable)factories).isNotNull().hasSize(1);
            Assertions.assertThat((Object)((SomeFactory)factories.iterator().next()).classloader()).isEqualTo((Object)custom);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    @Test
    public void loadFactoriesWithVertxClassloader() throws Exception {
        URLClassLoader custom = new URLClassLoader(new URL[]{new File(TestUtils.MAVEN_TARGET_DIR, "classes").toURI().toURL(), new File(TestUtils.MAVEN_TARGET_DIR, "test-classes").toURI().toURL(), this.serviceHelperFile.toURI().toURL()}, null);
        Class<?> serviceHelperClass = custom.loadClass(ServiceHelper.class.getName());
        Class<?> someFactoryClass = custom.loadClass(SomeFactory.class.getName());
        Assertions.assertThat((Object)serviceHelperClass.getClassLoader()).isEqualTo((Object)custom);
        Assertions.assertThat((Object)someFactoryClass.getClassLoader()).isEqualTo((Object)custom);
        Method method = serviceHelperClass.getMethod("loadFactories", Class.class);
        Collection collection = (Collection)method.invoke(null, someFactoryClass);
        Assertions.assertThat((Iterable)collection).hasSize(1);
    }
}

