/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.Future;
import io.vertx.core.VirtualThreadDeploymentTest;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerExecutor;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class VirtualThreadContextTest
extends VertxTestBase {
    VertxInternal vertx;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.vertx = (VertxInternal)((VertxTestBase)this).vertx;
    }

    @Test
    public void testContext() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            Thread thread = Thread.currentThread();
            this.assertTrue(VirtualThreadDeploymentTest.isVirtual(thread));
            ContextInternal context = this.vertx.getOrCreateContext();
            Executor executor = context.executor();
            this.assertTrue(executor instanceof WorkerExecutor);
            context.runOnContext(v2 -> {
                this.assertSame(context, this.vertx.getOrCreateContext());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAwaitFutureSuccess() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        Object result = new Object();
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            ContextInternal context = this.vertx.getOrCreateContext();
            PromiseInternal promise = context.promise();
            new Thread(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                promise.complete(result);
            }).start();
            this.assertSame(result, Future.await((Future)promise.future()));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAwaitFutureFailure() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        Exception failure = new Exception();
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            ContextInternal context = this.vertx.getOrCreateContext();
            PromiseInternal promise = context.promise();
            new Thread(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                promise.fail((Throwable)failure);
            }).start();
            try {
                Future.await((Future)promise.future());
            }
            catch (Exception e) {
                this.assertSame(failure, e);
                this.testComplete();
                return;
            }
            this.fail();
        });
        this.await();
    }

    @Test
    public void testAwaitCompoundFuture() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        Object result = new Object();
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            ContextInternal context = this.vertx.getOrCreateContext();
            PromiseInternal promise = context.promise();
            new Thread(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                promise.complete(result);
            }).start();
            this.assertSame("HELLO", Future.await((Future)promise.future().map(res -> "HELLO")));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDuplicateUseSameThread() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        int num = 1000;
        this.waitFor(num);
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            ContextInternal context = this.vertx.getOrCreateContext();
            Thread th = Thread.currentThread();
            for (int i = 0; i < num; ++i) {
                ContextInternal duplicate = context.duplicate();
                duplicate.runOnContext(v2 -> this.complete());
            }
        });
        this.await();
    }

    @Test
    public void testDuplicateConcurrentAwait() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        int num = 1000;
        this.waitFor(num);
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            ContextInternal context = this.vertx.getOrCreateContext();
            Object lock = new Object();
            ArrayList list = new ArrayList();
            for (int i = 0; i < num; ++i) {
                ContextInternal duplicate = context.duplicate();
                duplicate.runOnContext(v2 -> {
                    boolean complete;
                    PromiseInternal promise = duplicate.promise();
                    Object object = lock;
                    synchronized (object) {
                        list.add(promise);
                        complete = list.size() == num;
                    }
                    if (complete) {
                        context.runOnContext(v3 -> {
                            Object object = lock;
                            synchronized (object) {
                                list.forEach(p -> p.complete(null));
                            }
                        });
                    }
                    Future f = promise.future();
                    Future.await((Future)f);
                    this.complete();
                });
            }
        });
        this.await();
    }

    @Test
    public void testTimer() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            ContextInternal context = this.vertx.getOrCreateContext();
            PromiseInternal promise = context.promise();
            this.vertx.setTimer(100L, id -> promise.complete((Object)"foo"));
            String res = (String)Future.await((Future)promise);
            this.assertEquals("foo", res);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testInThread() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        this.vertx.createVirtualThreadContext().runOnContext(v1 -> {
            ContextInternal context = this.vertx.getOrCreateContext();
            this.assertTrue(context.inThread());
            new Thread(() -> {
                boolean wasNotInThread = !context.inThread();
                context.runOnContext(v2 -> {
                    this.assertTrue(wasNotInThread);
                    this.assertTrue(context.inThread());
                    this.testComplete();
                });
            }).start();
        });
        this.await();
    }

    private void sleep(AtomicInteger inflight) {
        this.assertEquals(0L, inflight.getAndIncrement());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            inflight.decrementAndGet();
        }
    }

    @Test
    public void testSerializeBlocking() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        AtomicInteger inflight = new AtomicInteger();
        this.vertx.createVirtualThreadContext().runOnContext(v1 -> {
            ContextInternal ctx = this.vertx.getOrCreateContext();
            for (int i = 0; i < 10; ++i) {
                ctx.runOnContext(v2 -> this.sleep(inflight));
            }
            ctx.runOnContext(v -> this.testComplete());
        });
        this.await();
    }

    @Test
    public void testVirtualThreadsNotAvailable() {
        Assume.assumeFalse((boolean)this.isVirtualThreadAvailable());
        try {
            this.vertx.createVirtualThreadContext();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

