/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.Vertx;
import io.vertx.it.CustomExecutorService;
import io.vertx.it.CustomExecutorServiceFactory;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class ExecutorServiceFactoryTest
extends VertxTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteBlocking() throws Exception {
        int initialValue = CustomExecutorServiceFactory.NUM.get();
        Vertx vertx = Vertx.vertx();
        try {
            this.assertEquals(initialValue + 2, CustomExecutorServiceFactory.NUM.get());
            int num = 10;
            CountDownLatch latch = new CountDownLatch(num);
            for (int i = 0; i < num; ++i) {
                vertx.executeBlocking(p -> {
                    this.assertTrue(CustomExecutorService.executing.get());
                    p.complete();
                }, this.onSuccess(v -> latch.countDown()));
            }
            this.awaitLatch(latch);
        }
        finally {
            vertx.close().toCompletionStage().toCompletableFuture().get(30L, TimeUnit.SECONDS);
        }
        this.assertEquals(initialValue, CustomExecutorServiceFactory.NUM.get());
    }
}

