/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.util.AsciiString;
import io.vertx.core.http.impl.HttpUtils;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=20, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
public class HttpUtilsAsciiToLowerCaseBenchmark {
    @Param(value={"ascii", "string", "builder"})
    public String type;
    @Param(value={"false", "true"})
    public boolean lowerCase;
    private CharSequence sequence;

    @Setup
    public void init() {
        this.sequence = this.create(this.type, this.lowerCase ? "content-length" : "Content-Length");
    }

    private CharSequence create(String type, String content) {
        switch (type) {
            case "ascii": {
                return new AsciiString((CharSequence)content);
            }
            case "string": {
                return content;
            }
            case "builder": {
                return new StringBuilder(content);
            }
        }
        throw new IllegalStateException();
    }

    @Benchmark
    public CharSequence toLowerCase() {
        return HttpUtils.toLowerCase((CharSequence)this.sequence);
    }
}

