/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.FutureTestBase;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.FutureImpl;
import io.vertx.core.impl.future.Listener;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class FutureInternalTest
extends FutureTestBase {
    @Test
    public void testAddListener() {
        FutureImpl future = (FutureImpl)Promise.promise();
        final AtomicInteger successes = new AtomicInteger();
        final AtomicInteger failures = new AtomicInteger();
        Listener<Void> listener = new Listener<Void>(){

            public void onSuccess(Void value) {
                successes.incrementAndGet();
            }

            public void onFailure(Throwable failure) {
                failures.incrementAndGet();
            }
        };
        future.addListener((Listener)listener);
        future.tryComplete(null);
        this.assertEquals(1L, successes.get());
        this.assertEquals(0L, failures.get());
    }

    @Test
    public void testRemoveListener1() {
        this.testRemoveListener((FutureImpl<Void>)((FutureImpl)Promise.promise()));
    }

    @Test
    public void testRemoveListener2() {
        FutureImpl fut = (FutureImpl)Promise.promise();
        fut.onComplete(ar -> {});
        this.testRemoveListener((FutureImpl<Void>)fut);
    }

    private void testRemoveListener(FutureImpl<Void> future) {
        final AtomicInteger count = new AtomicInteger();
        Listener<Void> listener = new Listener<Void>(){

            public void onSuccess(Void value) {
                count.incrementAndGet();
            }

            public void onFailure(Throwable failure) {
                count.incrementAndGet();
            }
        };
        future.addListener((Listener)listener);
        future.removeListener((Listener)listener);
        future.tryComplete(null);
        this.assertEquals(0L, count.get());
    }
}

