/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.FutureTestBase;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.test.core.Repeat;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.Test;

public class FutureTest
extends FutureTestBase {
    private final RuntimeException failure = new RuntimeException();

    @Test
    public void testCreateWithHandler() {
        AtomicInteger count = new AtomicInteger();
        AtomicReference ref = new AtomicReference();
        Future f2 = Future.future(p1 -> {
            this.assertFalse(p1.future().isComplete());
            count.incrementAndGet();
            ref.set(p1);
        });
        this.assertSame(f2, ((Promise)ref.get()).future());
        this.assertEquals(1L, count.get());
        new FutureTestBase.Checker(f2).assertNotCompleted();
        ref.set(null);
        count.set(0);
        f2 = Future.future(f1 -> {
            count.incrementAndGet();
            ref.set(f1);
            f1.complete((Object)"the-value");
        });
        this.assertSame(f2, ((Promise)ref.get()).future());
        this.assertEquals(1L, count.get());
        new FutureTestBase.Checker<String>(f2).assertSucceeded("the-value");
        ref.set(null);
        count.set(0);
        RuntimeException cause = new RuntimeException();
        f2 = Future.future(f1 -> {
            count.incrementAndGet();
            ref.set(f1);
            f1.fail((Throwable)cause);
        });
        this.assertSame(f2, ((Promise)ref.get()).future());
        this.assertEquals(1L, count.get());
        new FutureTestBase.Checker(f2).assertFailed(cause);
        Future f3 = Future.future(f -> {
            throw cause;
        });
        this.assertSame(cause, f3.cause());
    }

    @Test
    public void testStateAfterCompletion() {
        Object foo = new Object();
        Future future = Future.succeededFuture((Object)foo);
        this.assertTrue(future.succeeded());
        this.assertFalse(future.failed());
        this.assertTrue(future.isComplete());
        this.assertEquals(foo, future.result());
        this.assertNull(future.cause());
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        this.assertFalse(future.succeeded());
        this.assertTrue(future.failed());
        this.assertTrue(future.isComplete());
        this.assertNull(future.result());
        this.assertEquals(cause, future.cause());
    }

    @Test
    public void testCallSetHandlerBeforeCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Promise promise = Promise.promise();
        promise.future().onComplete(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertFalse(called.get());
        promise.complete(null);
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        promise = Promise.promise();
        promise.future().onComplete(result -> {
            called.set(true);
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
        });
        this.assertFalse(called.get());
        promise.complete(foo);
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        promise = Promise.promise();
        promise.future().onComplete(result -> {
            called.set(true);
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
        });
        this.assertFalse(called.get());
        promise.fail((Throwable)cause);
        this.assertTrue(called.get());
    }

    @Test
    public void testCallSetHandlerAfterCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.succeededFuture();
        future.onComplete(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.succeededFuture((Object)foo);
        future.onComplete(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        future.onComplete(result -> {
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
    }

    @Test
    public void testResolveFutureToHandler() {
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.succeededFuture((Object)"the-result"));
        Promise promise = Promise.promise();
        consumer.accept((Handler)promise);
        this.assertTrue(promise.future().isComplete());
        this.assertTrue(promise.future().succeeded());
        this.assertEquals("the-result", promise.future().result());
    }

    @Test
    public void testFailFutureToHandler() {
        Throwable cause = new Throwable();
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.failedFuture((Throwable)cause));
        Promise promise = Promise.promise();
        consumer.accept((Handler)promise);
        this.assertTrue(promise.future().isComplete());
        this.assertTrue(promise.future().failed());
        this.assertEquals(cause, promise.future().cause());
    }

    @Test
    public void testCreateFailedWithNullFailure() {
        Future future = Future.failedFuture((Throwable)null);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(future);
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testFailureFutureWithNullFailure() {
        Promise promise = Promise.promise();
        promise.fail((Throwable)null);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(promise.future());
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testCompleteCause() {
        RuntimeException object = new RuntimeException();
        Promise promise = Promise.promise();
        AtomicReference r1 = new AtomicReference();
        AtomicReference r2 = new AtomicReference();
        promise.future().onSuccess(v -> r1.set(true)).onFailure(v -> r1.set(false));
        FutureTestBase.Checker<RuntimeException> checker = new FutureTestBase.Checker<RuntimeException>(promise.future());
        promise.complete((Object)object);
        checker.assertSucceeded(object);
        promise.future().onSuccess(v -> r2.set(true)).onFailure(v -> r2.set(false));
        this.assertTrue((Boolean)r1.get());
        this.assertTrue((Boolean)r2.get());
    }

    @Test
    public void testComposeSuccessToSuccess() {
        AtomicReference ref = new AtomicReference();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> {
            ref.set(string);
            return c;
        });
        FutureTestBase.Checker<Integer> checker = new FutureTestBase.Checker<Integer>(f4);
        p3.complete((Object)"abcdef");
        checker.assertNotCompleted();
        this.assertEquals("abcdef", ref.get());
        p.complete((Object)6);
        checker.assertSucceeded(6);
    }

    @Test
    public void testComposeSuccessToFailure() {
        Throwable cause = new Throwable();
        AtomicReference ref = new AtomicReference();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> {
            ref.set(string);
            return c;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(f4);
        p3.complete((Object)"abcdef");
        p.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFailure() {
        Exception cause = new Exception();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> Future.succeededFuture((Object)string.length()));
        FutureTestBase.Checker checker = new FutureTestBase.Checker(f4);
        p3.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFails() {
        RuntimeException cause = new RuntimeException();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> {
            throw cause;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(f4);
        p3.complete((Object)"foo");
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeWithNullFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        try {
            f.compose((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testTransformSuccessToSuccess() {
        this.testTransformToSuccess(p -> p.complete((Object)"abcdef"));
    }

    @Test
    public void testTransformFailureToSuccess() {
        this.testTransformToSuccess(p -> p.fail("it-failed"));
    }

    private void testTransformToSuccess(Consumer<Promise<String>> consumer) {
        AtomicInteger cnt = new AtomicInteger();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.transform(ar -> {
            this.assertSame(f3.succeeded(), ar.succeeded());
            this.assertSame(f3.failed(), ar.failed());
            this.assertSame(f3.result(), ar.result());
            this.assertSame(f3.cause(), ar.cause());
            cnt.incrementAndGet();
            return c;
        });
        FutureTestBase.Checker<Integer> checker = new FutureTestBase.Checker<Integer>(f4);
        consumer.accept((Promise<String>)p3);
        checker.assertNotCompleted();
        this.assertEquals(1L, cnt.get());
        p.complete((Object)6);
        checker.assertSucceeded(6);
    }

    @Test
    public void testTransformSuccessToFailure() {
        this.testTransformToFailure(p -> p.complete((Object)"abcdef"));
    }

    @Test
    public void testTransformFailureToFailure() {
        this.testTransformToFailure(p -> p.fail("it-failed"));
    }

    private void testTransformToFailure(Consumer<Promise<String>> consumer) {
        Throwable cause = new Throwable();
        AtomicInteger cnt = new AtomicInteger();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.transform(ar -> {
            this.assertSame(f3.succeeded(), ar.succeeded());
            this.assertSame(f3.failed(), ar.failed());
            this.assertSame(f3.result(), ar.result());
            this.assertSame(f3.cause(), ar.cause());
            cnt.incrementAndGet();
            return c;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(f4);
        consumer.accept((Promise<String>)p3);
        checker.assertNotCompleted();
        this.assertEquals(1L, cnt.get());
        p.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testTransformFails() {
        RuntimeException cause = new RuntimeException();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.transform(string -> {
            throw cause;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(f4);
        p3.complete((Object)"foo");
        checker.assertFailed(cause);
    }

    @Test
    public void testTransformWithNullFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        try {
            f.transform(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEventuallyFunctionSuccessToSuccess() {
        this.testEventuallySuccessTo(p -> p.complete((Object)6), (f, s) -> f.eventually(arg_0 -> FutureTest.lambda$null$28((Supplier)s, arg_0)));
    }

    @Test
    public void testEventuallyFunctionSuccessToFailure() {
        this.testEventuallySuccessTo(p -> p.fail("it-failed"), (f, s) -> f.eventually(arg_0 -> FutureTest.lambda$null$31((Supplier)s, arg_0)));
    }

    @Test
    public void testEventuallySupplierSuccessToSuccess() {
        this.testEventuallySuccessTo(p -> p.complete((Object)6), Future::eventually);
    }

    @Test
    public void testEventuallySupplierSuccessToFailure() {
        this.testEventuallySuccessTo(p -> p.fail("it-failed"), Future::eventually);
    }

    private void testEventuallySuccessTo(Consumer<Promise<Integer>> op, BiFunction<Future<String>, Supplier<Future<Integer>>, Future<String>> impl) {
        AtomicInteger cnt = new AtomicInteger();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future<String> f4 = impl.apply((Future<String>)f3, () -> {
            cnt.incrementAndGet();
            return c;
        });
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(f4);
        checker.assertNotCompleted();
        p3.complete((Object)"abcdef");
        this.assertEquals(1L, cnt.get());
        checker.assertNotCompleted();
        op.accept((Promise<Integer>)p);
        checker.assertSucceeded("abcdef");
    }

    @Test
    public void testEventuallyFailureToSuccess() {
        this.testEventuallyFailureTo(p -> p.complete((Object)6));
    }

    @Test
    public void testEventuallyFailureToFailure() {
        this.testEventuallyFailureTo(p -> p.fail("it-failed"));
    }

    private void testEventuallyFailureTo(Consumer<Promise<Integer>> op) {
        AtomicInteger cnt = new AtomicInteger();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.eventually(v -> {
            cnt.incrementAndGet();
            return c;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(f4);
        checker.assertNotCompleted();
        RuntimeException expected = new RuntimeException();
        p3.fail((Throwable)expected);
        this.assertEquals(1L, cnt.get());
        checker.assertNotCompleted();
        op.accept((Promise<Integer>)p);
        checker.assertFailed(expected);
    }

    @Test
    public void testMapSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map(Object::toString);
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(mapped);
        checker.assertNotCompleted();
        p.complete((Object)3);
        checker.assertSucceeded("3");
    }

    @Test
    public void testMapValueSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map((Object)"5");
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(mapped);
        checker.assertNotCompleted();
        p.complete((Object)3);
        checker.assertSucceeded("5");
    }

    @Test
    public void testMapValueAlreadySuccess() {
        Future f = Future.succeededFuture((Object)3);
        Future mapped = f.map((Object)"5");
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(mapped);
        checker.assertSucceeded("5");
    }

    @Test
    public void testMapFailure() {
        Throwable cause = new Throwable();
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map(Object::toString);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(mapped);
        checker.assertNotCompleted();
        p.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapAlreadyFailure() {
        Throwable cause = new Throwable();
        Future f = Future.failedFuture((Throwable)cause);
        Future mapped = f.map(Object::toString);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(mapped);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapValueFailure() {
        Throwable cause = new Throwable();
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map((Object)"5");
        FutureTestBase.Checker checker = new FutureTestBase.Checker(mapped);
        checker.assertNotCompleted();
        p.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapValueAlreadyFailure() {
        Throwable cause = new Throwable();
        Future f = Future.failedFuture((Throwable)cause);
        Future mapped = f.map((Object)"5");
        FutureTestBase.Checker checker = new FutureTestBase.Checker(mapped);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapFails() {
        RuntimeException cause = new RuntimeException();
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map(i -> {
            throw cause;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(mapped);
        p.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapWithNullFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        try {
            f.map((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.asyncResult(f).map((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testMapEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.mapEmpty();
        FutureTestBase.Checker checker = new FutureTestBase.Checker(mapped);
        checker.assertNotCompleted();
        p.complete((Object)3);
        checker.assertSucceeded(null);
    }

    @Test
    public void testRecoverSuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> {
            called.set(true);
            throw new AssertionError();
        });
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testRecoverFailureWithSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertSucceeded("recovered");
    }

    @Test
    public void testRecoverFailureWithFailure() {
        Throwable cause = new Throwable();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.failedFuture((Throwable)cause));
        FutureTestBase.Checker checker = new FutureTestBase.Checker(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testRecoverFailureFails() {
        RuntimeException cause = new RuntimeException("throw");
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> {
            throw cause;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testRecoverWithNullFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        try {
            f.recover(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testExpectingSuccessWithValidSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.expecting(t -> {
            called.set(true);
            return true;
        });
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertTrue(called.get());
    }

    @Test
    public void testExpectingFailureWithInvalidSuccess() {
        final AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        final Throwable err = new Throwable();
        Future r = f.expecting((Expectation)new Expectation<String>(){

            public boolean test(String value) {
                called.set(true);
                return false;
            }

            public Throwable describe(String value) {
                return err;
            }
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertFalse(r.succeeded());
        checker.assertFailed(err);
        this.assertTrue(called.get());
    }

    @Test
    public void testExpectingFailureWithFailure() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.expecting(t -> {
            called.set(true);
            return true;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(r);
        checker.assertNotCompleted();
        Throwable err = new Throwable();
        p.fail(err);
        this.assertTrue(r.failed());
        checker.assertFailed(err);
        this.assertFalse(called.get());
    }

    @Test
    public void testExpectingThrowingError() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        RuntimeException err = new RuntimeException();
        Future r = f.expecting(t -> {
            called.set(true);
            throw err;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertTrue(r.failed());
        checker.assertFailed(err);
        this.assertTrue(called.get());
    }

    @Test
    public void testOtherwiseSuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise(t -> {
            called.set(true);
            throw new AssertionError();
        });
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testOtherwiseAlreadySuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Future f = Future.succeededFuture((Object)"yeah");
        Future r = f.otherwise(t -> {
            called.set(true);
            throw new AssertionError();
        });
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testOtherwiseValueSuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise((Object)"other");
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testOtherwiseValueAlreadySuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Future f = Future.succeededFuture((Object)"yeah");
        Future r = f.otherwise((Object)"other");
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testOtherwiseFailureWithSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise(Throwable::getMessage);
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertSucceeded("recovered");
    }

    @Test
    public void testOtherwiseValueFailureWithSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise((Object)"other");
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertSucceeded("other");
    }

    @Test
    public void testOtherwiseValueAlreadyFailureWithSuccess() {
        Future f = Future.failedFuture((String)"recovered");
        Future r = f.otherwise((Object)"other");
        FutureTestBase.Checker<String> checker = new FutureTestBase.Checker<String>(r);
        checker.assertSucceeded("other");
    }

    @Test
    public void testOtherwiseFails() {
        RuntimeException cause = new RuntimeException("throw");
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise(t -> {
            throw cause;
        });
        FutureTestBase.Checker checker = new FutureTestBase.Checker(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testHandlerFailureWithContext() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        promise.complete((Object)"abc");
        RuntimeException failure = new RuntimeException();
        ctx.exceptionHandler(err -> {
            this.assertSame(failure, err);
            this.testComplete();
        });
        promise.future().onComplete(ar -> {
            throw failure;
        });
        this.await();
    }

    @Test
    public void testHandlerFailureWithoutContext() {
        Promise promise = Promise.promise();
        promise.complete((Object)"abc");
        RuntimeException failure = new RuntimeException();
        try {
            promise.future().onComplete(ar -> {
                throw failure;
            });
            this.fail();
        }
        catch (Exception e) {
            this.assertSame(failure, e);
        }
    }

    @Test
    public void testDefaultCompleter() {
        AsyncResult<Object> succeededAsyncResult = new AsyncResult<Object>(){
            Object result = new Object();

            public Object result() {
                return this.result;
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> AsyncResult<U> map(Function<Object, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> AsyncResult<V> map(V value) {
                throw new UnsupportedOperationException();
            }
        };
        AsyncResult<Object> failedAsyncResult = new AsyncResult<Object>(){
            Throwable cause = new Throwable();

            public Object result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                return this.cause;
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> AsyncResult<U> map(Function<Object, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> AsyncResult<V> map(V value) {
                throw new UnsupportedOperationException();
            }
        };
        class DefaultCompleterTestFuture<T>
        implements Future<T> {
            boolean succeeded;
            boolean failed;
            T result;
            Throwable cause;

            DefaultCompleterTestFuture() {
            }

            public boolean isComplete() {
                throw new UnsupportedOperationException();
            }

            public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
                throw new UnsupportedOperationException();
            }

            public void complete(T result) {
                if (!this.tryComplete(result)) {
                    throw new IllegalStateException();
                }
            }

            public void complete() {
                if (!this.tryComplete()) {
                    throw new IllegalStateException();
                }
            }

            public void fail(Throwable cause) {
                if (!this.tryFail(cause)) {
                    throw new IllegalStateException();
                }
            }

            public void fail(String failureMessage) {
                if (!this.tryFail(failureMessage)) {
                    throw new IllegalStateException();
                }
            }

            public boolean tryComplete(T result) {
                if (this.succeeded || this.failed) {
                    return false;
                }
                this.succeeded = true;
                this.result = result;
                return true;
            }

            public boolean tryComplete() {
                throw new UnsupportedOperationException();
            }

            public boolean tryFail(Throwable cause) {
                if (this.succeeded || this.failed) {
                    return false;
                }
                this.failed = true;
                this.cause = cause;
                return true;
            }

            public Future<T> expecting(Expectation<? super T> expectation) {
                throw new UnsupportedOperationException();
            }

            public boolean tryFail(String failureMessage) {
                throw new UnsupportedOperationException();
            }

            public T result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                throw new UnsupportedOperationException();
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> Future<U> compose(Function<T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
                throw new UnsupportedOperationException();
            }

            public <U> Future<U> transform(Function<AsyncResult<T>, Future<U>> mapper) {
                throw new UnsupportedOperationException();
            }

            public <U> Future<T> eventually(Function<Void, Future<U>> function) {
                throw new UnsupportedOperationException();
            }

            public <U> Future<U> map(Function<T, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> Future<V> map(V value) {
                throw new UnsupportedOperationException();
            }

            public Future<T> otherwise(Function<Throwable, T> mapper) {
                throw new UnsupportedOperationException();
            }

            public Future<T> otherwise(T value) {
                throw new UnsupportedOperationException();
            }

            public Future<T> timeout(long delay, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }

            public void handle(AsyncResult<T> asyncResult) {
                if (asyncResult.succeeded()) {
                    this.complete(asyncResult.result());
                } else {
                    this.fail(asyncResult.cause());
                }
            }
        }
        DefaultCompleterTestFuture<Object> successFuture = new DefaultCompleterTestFuture<Object>();
        successFuture.handle(succeededAsyncResult);
        this.assertTrue(successFuture.succeeded);
        this.assertEquals(succeededAsyncResult.result(), successFuture.result);
        DefaultCompleterTestFuture<Object> failureFuture = new DefaultCompleterTestFuture<Object>();
        failureFuture.handle(failedAsyncResult);
        this.assertTrue(failureFuture.failed);
        this.assertEquals(failedAsyncResult.cause(), failureFuture.cause);
    }

    @Test
    public void testUncompletedAsyncResultMap() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        this.assertNull(map1.result());
        this.assertNull(map1.cause());
        this.assertNull(map2.result());
        this.assertNull(map2.cause());
    }

    @Test
    public void testSucceededAsyncResultMap() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        p.complete((Object)"foobar");
        this.assertEquals(6L, ((Integer)map1.result()).intValue());
        this.assertNull(map1.cause());
        this.assertEquals(17L, ((Integer)map2.result()).intValue());
        this.assertNull(map2.cause());
    }

    @Test
    public void testFailedAsyncResultMap() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        Throwable cause = new Throwable();
        p.fail(cause);
        this.assertNull(map1.result());
        this.assertSame(cause, map1.cause());
        this.assertNull(map2.result());
        this.assertSame(cause, map2.cause());
    }

    @Test
    public void testAsyncResultMapEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map = res.mapEmpty();
        p.complete((Object)"foobar");
        this.assertNull(null, map.result());
        this.assertNull(map.cause());
    }

    @Test
    public void testSucceededFutureRecover() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        this.assertEquals(r.result(), "yeah");
    }

    @Test
    public void testFailedFutureRecover() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        p.fail("recovered");
        this.assertTrue(r.succeeded());
        this.assertEquals(r.result(), "recovered");
    }

    @Test
    public void testFailedMapperFutureRecover() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> {
            throw new RuntimeException("throw");
        });
        p.fail("recovered");
        this.assertTrue(r.failed());
        this.assertEquals(r.cause().getMessage(), "throw");
    }

    @Test
    public void testUncompletedAsyncResultOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testUncompletedAsyncResultOtherwise(res);
    }

    @Test
    public void testUncompletedFutureOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testUncompletedAsyncResultOtherwise((AsyncResult<String>)f);
    }

    private void testUncompletedAsyncResultOtherwise(AsyncResult<String> res) {
        AsyncResult ar1 = res.otherwise((Object)"something-else");
        this.assertFalse(ar1.succeeded());
        this.assertFalse(ar1.failed());
        this.assertNull(ar1.result());
        this.assertNull(ar1.cause());
    }

    @Test
    public void testUncompletedAsyncResultOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testUncompletedOtherwiseApplyFunction(res);
    }

    @Test
    public void testUncompletedFutureOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testUncompletedOtherwiseApplyFunction((AsyncResult<String>)f);
    }

    private void testUncompletedOtherwiseApplyFunction(AsyncResult<String> res) {
        AsyncResult ar1 = res.otherwise(Throwable::getMessage);
        this.assertFalse(ar1.succeeded());
        this.assertFalse(ar1.failed());
        this.assertNull(ar1.result());
        this.assertNull(ar1.cause());
    }

    @Test
    public void testSucceededAsyncResultOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testSucceededOtherwise(res, (Promise<String>)p);
    }

    @Test
    public void testSucceededFutureOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testSucceededOtherwise((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testSucceededOtherwise(AsyncResult<String> res, Promise<String> p) {
        AsyncResult ar = res.otherwise(Throwable::getMessage);
        p.complete((Object)"foobar");
        this.assertTrue(ar.succeeded());
        this.assertFalse(ar.failed());
        this.assertEquals("foobar", ar.result());
        this.assertNull(ar.cause());
    }

    @Test
    public void testSucceededAsyncResultOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testSucceededOtherwiseApplyFunction(res, (Promise<String>)p);
    }

    @Test
    public void testSucceededFutureOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testSucceededOtherwiseApplyFunction((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testSucceededOtherwiseApplyFunction(AsyncResult<String> res, Promise<String> p) {
        AsyncResult ar = res.otherwise((Object)"whatever");
        p.complete((Object)"foobar");
        this.assertTrue(ar.succeeded());
        this.assertFalse(ar.failed());
        this.assertEquals("foobar", ar.result());
        this.assertNull(ar.cause());
    }

    @Test
    public void testFailedAsyncResultOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testFailedOtherwise(res, (Promise<String>)p);
    }

    @Test
    public void testFailedFutureOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testFailedOtherwise((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testFailedOtherwise(AsyncResult<String> res, Promise<String> p) {
        AsyncResult map1 = res.otherwise((Object)"something-else");
        Throwable cause = new Throwable("the-failure");
        p.fail(cause);
        this.assertTrue(map1.succeeded());
        this.assertFalse(map1.failed());
        this.assertEquals("something-else", map1.result());
        this.assertNull(map1.cause());
    }

    @Test
    public void testFailedAsyncResultOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testFailedOtherwiseApplyFunction(res, (Promise<String>)p);
    }

    @Test
    public void testFailedFutureOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testFailedOtherwiseApplyFunction((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testFailedOtherwiseApplyFunction(AsyncResult<String> res, Promise<String> p) {
        AsyncResult map1 = res.otherwise(Throwable::getMessage);
        Throwable cause = new Throwable("the-failure");
        p.fail(cause);
        this.assertTrue(map1.succeeded());
        this.assertFalse(map1.failed());
        this.assertEquals("the-failure", map1.result());
        this.assertNull(map1.cause());
    }

    @Test
    public void testOtherwiseWithNullFunction() {
        Promise p = Promise.promise();
        Future fut = p.future();
        try {
            fut.otherwise((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.asyncResult(fut).otherwise((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAsyncResultOtherwiseEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testOtherwiseEmpty(res, (Promise<String>)p);
    }

    @Test
    public void testFutureOtherwiseEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testOtherwiseEmpty((AsyncResult<String>)f, (Promise<String>)p);
    }

    @Test
    public void testToString() {
        this.assertEquals("Future{unresolved}", Promise.promise().future().toString());
        this.assertEquals("Future{result=abc}", Future.succeededFuture((Object)"abc").toString());
        this.assertEquals("Future{cause=It's like that, and that's the way it is}", Future.failedFuture((String)"It's like that, and that's the way it is").toString());
        Promise p = Promise.promise();
        Future f = p.future();
        p.complete((Object)"abc");
        this.assertEquals("Future{result=abc}", f.toString());
        p = Promise.promise();
        f = p.future();
        p.fail("abc");
        this.assertEquals("Future{cause=abc}", f.toString());
    }

    @Test
    public void testReleaseListenerAfterCompletion() throws Exception {
        Promise promise = Promise.promise();
        Future f = promise.future();
        Field handlerField = f.getClass().getSuperclass().getDeclaredField("listener");
        handlerField.setAccessible(true);
        f.onComplete(ar -> {});
        promise.complete();
        this.assertNull(handlerField.get(f));
        f.onComplete(ar -> {});
        this.assertNull(handlerField.get(f));
        promise = Promise.promise();
        f = promise.future();
        f.onComplete(ar -> {});
        promise.fail("abc");
        this.assertNull(handlerField.get(f));
        f.onComplete(ar -> {});
        this.assertNull(handlerField.get(f));
    }

    @Test
    public void testSetNullHandler() throws Exception {
        Promise promise = Promise.promise();
        try {
            promise.future().onComplete(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        promise.complete();
        try {
            promise.future().onComplete(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSucceedOnContext() throws Exception {
        this.waitFor(4);
        Object result = new Object();
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        CompletableFuture latch = new CompletableFuture();
        ctx.runOnContext(v -> latch.complete(Thread.currentThread()));
        Thread elThread = (Thread)latch.get(10L, TimeUnit.SECONDS);
        CountDownLatch latch1 = new CountDownLatch(1);
        PromiseInternal promise1 = ctx.promise();
        this.vertx.runOnContext(arg_0 -> FutureTest.lambda$testSucceedOnContext$61((Promise)promise1, result, latch1, arg_0));
        this.awaitLatch(latch1);
        promise1.future().onComplete(ar -> {
            this.assertSame(elThread, Thread.currentThread());
            this.assertTrue(ar.succeeded());
            this.assertSame(result, ar.result());
            this.complete();
        });
        PromiseInternal promise2 = ctx.promise();
        promise2.future().onComplete(ar -> {
            this.assertSame(elThread, Thread.currentThread());
            this.assertTrue(ar.succeeded());
            this.assertSame(result, ar.result());
            this.complete();
        });
        this.vertx.runOnContext(arg_0 -> FutureTest.lambda$testSucceedOnContext$64((Promise)promise2, result, arg_0));
        PromiseInternal promise3 = ctx.promise();
        promise3.complete(result);
        promise3.future().onComplete(ar -> {
            this.assertSame(elThread, Thread.currentThread());
            this.assertTrue(ar.succeeded());
            this.assertSame(result, ar.result());
            this.complete();
        });
        PromiseInternal promise4 = ctx.promise();
        promise4.future().onComplete(ar -> {
            this.assertSame(elThread, Thread.currentThread());
            this.assertTrue(ar.succeeded());
            this.assertSame(result, ar.result());
            this.complete();
        });
        promise4.complete(result);
        this.await();
    }

    private void testOtherwiseEmpty(AsyncResult<String> res, Promise<String> p) {
        AsyncResult otherwise = res.otherwiseEmpty();
        Throwable cause = new Throwable("the-failure");
        p.fail(cause);
        this.assertTrue(otherwise.succeeded());
        this.assertFalse(otherwise.failed());
        this.assertEquals(null, otherwise.result());
        this.assertNull(otherwise.cause());
    }

    private <T> AsyncResult<T> asyncResult(final Future<T> fut) {
        return new AsyncResult<T>(){

            public T result() {
                return fut.result();
            }

            public Throwable cause() {
                return fut.cause();
            }

            public boolean succeeded() {
                return fut.succeeded();
            }

            public boolean failed() {
                return fut.failed();
            }
        };
    }

    @Test
    public void testSeveralHandlers1() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        fut.onComplete(ar -> this.complete());
        fut.onComplete(ar -> this.complete());
        promise.complete();
        this.await();
    }

    @Test
    public void testSeveralHandlers2() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        promise.complete();
        Future fut = promise.future();
        fut.onComplete(ar -> this.complete());
        fut.onComplete(ar -> this.complete());
        this.await();
    }

    @Test
    public void testSeveralHandlers3() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        fut.onComplete(ar -> this.complete());
        promise.complete();
        fut.onComplete(ar -> this.complete());
        this.await();
    }

    @Test
    public void testSuccessNotification() {
        this.waitFor(3);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        fut.onComplete(this.onSuccess(res -> {
            this.assertEquals("foo", res);
            this.complete();
        }));
        fut.onComplete(res -> {
            this.assertEquals("foo", res);
            this.complete();
        }, err -> this.fail());
        fut.onSuccess(res -> {
            this.assertEquals("foo", res);
            this.complete();
        });
        fut.onFailure(err -> this.fail());
        promise.complete((Object)"foo");
        this.await();
    }

    @Test
    public void testFailureNotification() {
        this.waitFor(3);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        Throwable failure = new Throwable();
        fut.onComplete(this.onFailure(err -> {
            this.assertEquals(failure, err);
            this.complete();
        }));
        fut.onComplete(res -> this.fail(), err -> {
            this.assertEquals(failure, err);
            this.complete();
        });
        fut.onSuccess(res -> this.fail());
        fut.onFailure(err -> {
            this.assertEquals(failure, err);
            this.complete();
        });
        promise.fail(failure);
        this.await();
    }

    @Test
    public void testVoidFuture() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        promise.complete();
        List<Future> promises = Arrays.asList(promise.future(), Future.succeededFuture());
        promises.forEach(fut -> fut.map(v -> "null").onComplete(this.onSuccess(s -> {
            this.assertEquals("null", s);
            this.complete();
        })));
        this.await();
    }

    @Test
    public void testPromiseUsedAsHandler() {
        Promise promise1 = Promise.promise();
        Promise promise2 = Promise.promise();
        promise1.future().onComplete((Handler)promise2);
        promise2.future().onComplete(this.onSuccess(v -> this.testComplete()));
        promise1.complete();
        this.await();
    }

    @Test
    public void testToCompletionStageTrampolining() {
        this.waitFor(2);
        Thread mainThread = Thread.currentThread();
        Future success = Future.succeededFuture((Object)"Yo");
        success.toCompletionStage().thenAccept(str -> {
            this.assertEquals("Yo", str);
            this.assertSame(mainThread, Thread.currentThread());
            this.complete();
        });
        Future failed = Future.failedFuture((Throwable)new RuntimeException("Woops"));
        failed.toCompletionStage().whenComplete((str, err) -> {
            this.assertNull(str);
            this.assertTrue(err instanceof RuntimeException);
            this.assertEquals("Woops", err.getMessage());
            this.assertSame(mainThread, Thread.currentThread());
            this.complete();
        });
        this.await();
    }

    @Test
    public void testToCompletionStageDelayedCompletion() {
        this.waitFor(2);
        Thread mainThread = Thread.currentThread();
        Promise willSucceed = Promise.promise();
        Promise willFail = Promise.promise();
        willSucceed.future().toCompletionStage().whenComplete((str, err) -> {
            this.assertEquals("Yo", str);
            this.assertNull(err);
            this.assertNotSame(mainThread, Thread.currentThread());
            this.complete();
        });
        willFail.future().toCompletionStage().whenComplete((str, err) -> {
            this.assertNull(str);
            this.assertTrue(err instanceof RuntimeException);
            this.assertEquals("Woops", err.getMessage());
            this.assertNotSame(mainThread, Thread.currentThread());
            this.complete();
        });
        this.disableThreadChecks();
        new Thread(() -> willSucceed.complete((Object)"Yo")).start();
        new Thread(() -> willFail.fail((Throwable)new RuntimeException("Woops"))).start();
        this.await();
    }

    @Test
    public void testFromCompletionStageTrampolining() {
        this.waitFor(2);
        this.disableThreadChecks();
        AtomicReference successSupplierThread = new AtomicReference();
        CompletableFuture willSucceed = new CompletableFuture();
        AtomicReference failureSupplierThread = new AtomicReference();
        CompletableFuture willFail = new CompletableFuture();
        Future.fromCompletionStage(willSucceed).onSuccess(str -> {
            this.assertEquals("Ok", str);
            this.assertSame(successSupplierThread.get(), Thread.currentThread());
            this.complete();
        });
        Future.fromCompletionStage(willFail).onFailure(err -> {
            this.assertTrue(err instanceof RuntimeException);
            this.assertEquals("Woops", err.getMessage());
            this.assertSame(failureSupplierThread.get(), Thread.currentThread());
            this.complete();
        });
        ForkJoinPool fjp = ForkJoinPool.commonPool();
        fjp.execute(() -> {
            successSupplierThread.set(Thread.currentThread());
            willSucceed.complete("Ok");
        });
        fjp.execute(() -> {
            failureSupplierThread.set(Thread.currentThread());
            willFail.completeExceptionally(new RuntimeException("Woops"));
        });
        this.await();
    }

    @Test
    public void testFromCompletionStageWithContext() {
        this.waitFor(2);
        Context context = this.vertx.getOrCreateContext();
        AtomicReference successSupplierThread = new AtomicReference();
        CompletableFuture willSucceed = new CompletableFuture();
        AtomicReference failureSupplierThread = new AtomicReference();
        CompletableFuture willFail = new CompletableFuture();
        Future.fromCompletionStage(willSucceed, (Context)context).onSuccess(str -> {
            this.assertEquals("Ok", str);
            this.assertNotSame(successSupplierThread.get(), Thread.currentThread());
            this.assertEquals(context, this.vertx.getOrCreateContext());
            this.assertTrue(Thread.currentThread().getName().startsWith("vert.x-eventloop-thread"));
            this.complete();
        });
        Future.fromCompletionStage(willFail, (Context)context).onFailure(err -> {
            this.assertTrue(err instanceof RuntimeException);
            this.assertEquals("Woops", err.getMessage());
            this.assertNotSame(failureSupplierThread.get(), Thread.currentThread());
            this.assertEquals(context, this.vertx.getOrCreateContext());
            this.assertTrue(Thread.currentThread().getName().startsWith("vert.x-eventloop-thread"));
            this.complete();
        });
        ForkJoinPool fjp = ForkJoinPool.commonPool();
        fjp.execute(() -> {
            successSupplierThread.set(Thread.currentThread());
            willSucceed.complete("Ok");
        });
        fjp.execute(() -> {
            failureSupplierThread.set(Thread.currentThread());
            willFail.completeExceptionally(new RuntimeException("Woops"));
        });
        this.await();
    }

    @Test
    public void testCompletedFuturesContext() throws Exception {
        this.waitFor(4);
        Thread testThread = Thread.currentThread();
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        CompletableFuture cf = new CompletableFuture();
        context.runOnContext(v -> cf.complete(Thread.currentThread()));
        Thread contextThread = (Thread)cf.get();
        Future.succeededFuture().onSuccess(v -> {
            this.assertSame(testThread, Thread.currentThread());
            this.assertNull(Vertx.currentContext());
            this.complete();
        });
        context.succeededFuture().onSuccess(v -> {
            this.assertNotSame(testThread, Thread.currentThread());
            this.assertSame(context, Vertx.currentContext());
            this.assertSame(contextThread, Thread.currentThread());
            this.complete();
        });
        Future.failedFuture((Throwable)new Exception()).onFailure(v -> {
            this.assertSame(testThread, Thread.currentThread());
            this.assertNull(Vertx.currentContext());
            this.complete();
        });
        context.failedFuture((Throwable)new Exception()).onFailure(v -> {
            this.assertNotSame(testThread, Thread.currentThread());
            this.assertSame(context, Vertx.currentContext());
            this.assertSame(contextThread, Thread.currentThread());
            this.complete();
        });
        this.await();
    }

    @Test
    public void testOnXXXReportsFailureOnContext() {
        this.testListenersReportFailureOnContext((ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onComplete(ignore -> task.run()), Promise::complete);
        this.testListenersReportFailureOnContext((ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()), Promise::complete);
        this.testListenersReportFailureOnContext((ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onSuccess(ignore -> task.run()), Promise::complete);
        this.testListenersReportFailureOnContext((ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onSuccess(ignore -> task.run()), Promise::complete);
        this.testListenersReportFailureOnContext((ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()), promise -> promise.fail("failure"));
        this.testListenersReportFailureOnContext((ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()), promise -> promise.fail("failure"));
        this.testListenersReportFailureOnContext((ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onFailure(ignore -> task.run()), promise -> promise.fail("failure"));
        this.testListenersReportFailureOnContext((ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onFailure(ignore -> task.run()), promise -> promise.fail("failure"));
    }

    private void testListenersReportFailureOnContext(BiConsumer<ContextInternal, Runnable> runner, BiConsumer<Future<String>, Runnable> subscriber, Consumer<Promise<?>> completer) {
        this.testListenersReportFailureOnContext(runner, subscriber, completer, 1);
        this.testListenersReportFailureOnContext(runner, subscriber, completer, 2);
    }

    private void testListenersReportFailureOnContext(BiConsumer<ContextInternal, Runnable> runner, BiConsumer<Future<String>, Runnable> subscriber, Consumer<Promise<?>> completer, int size) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        List caught = Collections.synchronizedList(new ArrayList());
        ctx.exceptionHandler(caught::add);
        runner.accept(ctx, () -> {
            PromiseInternal promise = ctx.promise();
            for (int i = 0; i < size; ++i) {
                subscriber.accept(promise.future(), () -> {
                    throw this.failure;
                });
            }
            try {
                completer.accept((Promise<?>)promise);
            }
            catch (Exception e) {
                this.fail("Was not expecting exception to bubble up");
            }
        });
        FutureTest.waitUntil(() -> caught.size() == size && caught.get(0) == this.failure);
    }

    @Test
    public void testCompletedFutureOnXXXReportsFailureOnContext() {
        Function<ContextInternal, Future<String>> succeededFutureProvider1 = ContextInternal::succeededFuture;
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider1, (ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider1, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider1, (ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onSuccess(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider1, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onSuccess(ignore -> task.run()));
        Function<ContextInternal, Future<String>> succeededFutureProvider2 = ctx -> {
            PromiseInternal promise = ctx.promise();
            promise.complete();
            return promise.future();
        };
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider2, (ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider2, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider2, (ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onSuccess(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(succeededFutureProvider2, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onSuccess(ignore -> task.run()));
        Function<ContextInternal, Future<String>> failedFutureProvider1 = ctx -> ctx.failedFuture("failure");
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider1, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider1, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider1, (ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onFailure(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider1, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onFailure(ignore -> task.run()));
        Function<ContextInternal, Future<String>> failedFutureProvider2 = ctx -> {
            PromiseInternal promise = ctx.promise();
            promise.fail("failure");
            return promise.future();
        };
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider2, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider2, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onComplete(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider2, (ctx, task) -> ctx.runOnContext(v -> task.run()), (fut, task) -> fut.onFailure(ignore -> task.run()));
        this.testListenersReportFailureOnContextAfterCompletion(failedFutureProvider2, (ctx, task) -> new Thread((Runnable)task).start(), (fut, task) -> fut.onFailure(ignore -> task.run()));
    }

    private void testListenersReportFailureOnContextAfterCompletion(Function<ContextInternal, Future<String>> provider, BiConsumer<ContextInternal, Runnable> runner, BiConsumer<Future<String>, Runnable> subscriber) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        List caught = Collections.synchronizedList(new ArrayList());
        ctx.exceptionHandler(caught::add);
        runner.accept(ctx, () -> {
            Future future = (Future)provider.apply(ctx);
            try {
                subscriber.accept(future, () -> {
                    throw this.failure;
                });
            }
            catch (Exception e) {
                this.fail("Was not expecting exception to bubble up");
            }
        });
        FutureTest.waitUntil(() -> caught.size() == 1 && caught.get(0) == this.failure);
    }

    @Test
    public void testAndThenComplete() {
        this.waitFor(4);
        NoStackTraceThrowable throwable = new NoStackTraceThrowable("test");
        this.testAndThen((Future<Void>)Future.succeededFuture(), null, null);
        this.testAndThen((Future<Void>)Future.failedFuture((Throwable)throwable), null, (Throwable)throwable);
        Promise promiseToComplete = Promise.promise();
        this.testAndThen((Future<Void>)promiseToComplete.future(), null, null);
        promiseToComplete.complete();
        Promise promiseToFail = Promise.promise();
        this.testAndThen((Future<Void>)promiseToFail.future(), null, (Throwable)throwable);
        promiseToFail.fail((Throwable)throwable);
        this.await();
    }

    @Test
    @Repeat(times=50)
    public void testAndThenCompleteContextual() {
        this.waitFor(4);
        NoStackTraceThrowable throwable = new NoStackTraceThrowable("test");
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        this.testAndThen((Future<Void>)context.succeededFuture(), context, null);
        this.testAndThen((Future<Void>)context.failedFuture((Throwable)throwable), context, (Throwable)throwable);
        PromiseInternal promiseToComplete = context.promise();
        this.testAndThen((Future<Void>)promiseToComplete.future(), context, null);
        promiseToComplete.complete();
        PromiseInternal promiseToFail = context.promise();
        this.testAndThen((Future<Void>)promiseToFail.future(), context, (Throwable)throwable);
        promiseToFail.fail((Throwable)throwable);
        this.await();
    }

    private void testAndThen(Future<Void> fut, ContextInternal context, Throwable throwable) {
        AtomicBoolean invoked = new AtomicBoolean();
        fut.andThen(ar -> {
            this.assertTrue(invoked.compareAndSet(false, true));
            this.assertTrue(context == null || Vertx.currentContext() == context);
            this.assertTrue(throwable == null || ar.failed() && ar.cause() == throwable);
        }).onComplete(ar -> {
            this.assertTrue(invoked.get());
            this.assertTrue(context == null || Vertx.currentContext() == context);
            this.assertTrue(throwable == null || ar.failed() && ar.cause() == throwable);
            this.complete();
        });
    }

    @Test
    public void testAndThenCompleteHandlerWithError() {
        this.waitFor(4);
        RuntimeException runtimeException = new RuntimeException("test");
        Handler callback = ar -> {
            throw runtimeException;
        };
        Handler completion = ar -> {
            this.assertTrue(ar.failed() && ar.cause() == runtimeException);
            this.complete();
        };
        Future.succeededFuture().andThen(callback).onComplete(completion);
        Future.failedFuture((Throwable)new Throwable()).andThen(callback).onComplete(completion);
        Promise promiseToComplete = Promise.promise();
        promiseToComplete.future().andThen(callback).onComplete(completion);
        promiseToComplete.complete();
        Promise promiseToFail = Promise.promise();
        promiseToFail.future().andThen(callback).onComplete(completion);
        promiseToFail.fail(new Throwable());
        this.await();
    }

    @Test
    public void testAwaitFromPlainThread() {
        try {
            Future.await((Future)Promise.promise().future());
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void contextFutureTimeoutFires() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        Future fut = promise.future();
        this.futureTimeoutFires((Context)ctx, (Future<String>)fut);
    }

    @Test
    public void futureTimeoutFires() {
        this.disableThreadChecks();
        Promise promise = Promise.promise();
        Future fut = promise.future();
        this.futureTimeoutFires(null, (Future<String>)fut);
    }

    private void futureTimeoutFires(Context ctx, Future<String> fut) {
        Future timeout = fut.timeout(100L, TimeUnit.MILLISECONDS);
        timeout.onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof TimeoutException);
            this.assertSame(Vertx.currentContext(), ctx);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void contextFutureTimeoutExpires() throws Exception {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        this.futureTimeoutExpires((Context)ctx, (Promise<String>)promise);
    }

    @Test
    public void futureTimeoutExpires() throws Exception {
        this.disableThreadChecks();
        Promise promise = Promise.promise();
        this.futureTimeoutExpires(null, (Promise<String>)promise);
    }

    private void futureTimeoutExpires(Context ctx, Promise<String> promise) throws Exception {
        Future timeout = promise.future().timeout(10L, TimeUnit.SECONDS);
        timeout.onComplete(this.onSuccess(val -> {
            this.assertSame(Vertx.currentContext(), ctx);
            this.assertEquals("value", val);
            this.testComplete();
        }));
        Thread.sleep(100L);
        promise.complete((Object)"value");
        this.await();
    }

    @Test
    public void contextCompletedFutureTimeout() throws Exception {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        this.completedFutureTimeout((Context)ctx, (Future<String>)ctx.succeededFuture((Object)"value"));
    }

    @Test
    public void completedFutureTimeout() throws Exception {
        this.disableThreadChecks();
        this.completedFutureTimeout(null, (Future<String>)Future.succeededFuture((Object)"value"));
    }

    private void completedFutureTimeout(Context ctx, Future<String> future) throws Exception {
        Future timeout = future.timeout(10L, TimeUnit.SECONDS);
        timeout.onComplete(this.onSuccess(val -> {
            this.assertSame(Vertx.currentContext(), ctx);
            this.assertEquals("value", val);
            this.testComplete();
        }));
        this.await();
    }

    private static /* synthetic */ void lambda$testSucceedOnContext$64(Promise promise2, Object result, Void v) {
        promise2.complete(result);
    }

    private static /* synthetic */ void lambda$testSucceedOnContext$61(Promise promise1, Object result, CountDownLatch latch1, Void v) {
        promise1.complete(result);
        latch1.countDown();
    }

    private static /* synthetic */ Future lambda$null$31(Supplier s, Void v) {
        return (Future)s.get();
    }

    private static /* synthetic */ Future lambda$null$28(Supplier s, Void v) {
        return (Future)s.get();
    }
}

