/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.TypedOption;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.CLIConfigurator;
import io.vertx.core.cli.annotations.ConvertedBy;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.ParsedAsList;
import io.vertx.core.cli.converters.Person;
import io.vertx.core.cli.converters.Person2;
import io.vertx.core.cli.converters.Person3;
import io.vertx.core.cli.converters.Person4;
import io.vertx.core.cli.converters.Person4Converter;
import io.vertx.core.cli.impl.HelloClI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Test;

public class CLIConfiguratorTest {
    @Test
    public void testHelloCLIFromClass() {
        CLI command = CLIConfigurator.define(HelloClI.class);
        Assertions.assertThat((List)command.getOptions()).hasSize(1);
        TypedOption option = (TypedOption)this.find(command.getOptions(), "name");
        Assertions.assertThat((String)option.getLongName()).isEqualToIgnoringCase((CharSequence)"name");
        Assertions.assertThat((String)option.getShortName()).isEqualToIgnoringCase((CharSequence)"n");
        Assertions.assertThat((Class)option.getType()).isEqualTo(String.class);
        Assertions.assertThat((String)option.getArgName()).isEqualTo((Object)"name");
        Assertions.assertThat((String)option.getDescription()).isEqualToIgnoringCase((CharSequence)"your name");
        Assertions.assertThat((String)option.getDefaultValue()).isNull();
        Assertions.assertThat((boolean)option.acceptValue()).isTrue();
        Assertions.assertThat((boolean)option.isMultiValued()).isFalse();
        Assertions.assertThat((boolean)option.isRequired()).isTrue();
    }

    @Test
    public void testUsage() {
        CLI command = CLIConfigurator.define(HelloClI.class);
        StringBuilder builder = new StringBuilder();
        command.usage(builder);
        Assertions.assertThat((String)builder.toString()).containsIgnoringCase((CharSequence)"Usage: hello -n <name>").containsIgnoringCase((CharSequence)"A command saying hello.").containsIgnoringCase((CharSequence)"A simple cli to wish you a good day. Pass your name with `--name`").containsIgnoringCase((CharSequence)" -n,--name <name>   your name");
    }

    @Test
    public void testOptionsWithDefaultValue() {
        CLI cli = CLIConfigurator.define(CommandForDefaultValueTest.class);
        Assertions.assertThat((List)cli.getOptions()).hasSize(1);
        Assertions.assertThat((String)this.find(cli.getOptions(), "option").getDefaultValue()).isEqualTo((Object)"bar");
        Assertions.assertThat((String)this.find(cli.getOptions(), "option").getName()).isEqualTo((Object)"option");
    }

    @Test
    public void testOptionsWithDescription() {
        CLI cli = CLIConfigurator.define(CommandForDescriptionTest.class);
        Assertions.assertThat((List)cli.getOptions()).hasSize(1);
        Assertions.assertThat((String)this.find(cli.getOptions(), "option").getDescription()).isEqualTo((Object)"This option is awesome");
    }

    @Test
    public void testOptionsParsedAsList() {
        CLI command = CLIConfigurator.define(CommandForParsedAsList.class);
        Assertions.assertThat((List)command.getOptions()).hasSize(1);
        Assertions.assertThat((String)((TypedOption)this.find(command.getOptions(), "option")).getListSeparator()).isEqualTo((Object)":");
        Assertions.assertThat((boolean)this.find(command.getOptions(), "option").isMultiValued()).isTrue();
        Assertions.assertThat((Class)((TypedOption)this.find(command.getOptions(), "option")).getType()).isEqualTo(String.class);
    }

    @Test
    public void testTypeExtraction() {
        CLI command = CLIConfigurator.define(CommandForTypeExtractTest.class);
        Assertions.assertThat((List)command.getOptions()).hasSize(6);
        TypedOption model = (TypedOption)this.find(command.getOptions(), "list");
        Assertions.assertThat((Class)model.getType()).isEqualTo(String.class);
        Assertions.assertThat((boolean)model.isMultiValued()).isTrue();
        model = (TypedOption)this.find(command.getOptions(), "set");
        Assertions.assertThat((Class)model.getType()).isEqualTo(Character.class);
        Assertions.assertThat((boolean)model.isMultiValued()).isTrue();
        model = (TypedOption)this.find(command.getOptions(), "collection");
        Assertions.assertThat((Class)model.getType()).isEqualTo(Integer.class);
        Assertions.assertThat((boolean)model.isMultiValued()).isTrue();
        model = (TypedOption)this.find(command.getOptions(), "tree");
        Assertions.assertThat((Class)model.getType()).isEqualTo(String.class);
        Assertions.assertThat((boolean)model.isMultiValued()).isTrue();
        model = (TypedOption)this.find(command.getOptions(), "al");
        Assertions.assertThat((Class)model.getType()).isEqualTo(String.class);
        Assertions.assertThat((boolean)model.isMultiValued()).isTrue();
        model = (TypedOption)this.find(command.getOptions(), "array");
        Assertions.assertThat((Class)model.getType()).isEqualTo(Integer.TYPE);
        Assertions.assertThat((boolean)model.isMultiValued()).isTrue();
    }

    @Test
    public void testInjectionOfString() throws CLIException {
        HelloClI command = new HelloClI();
        CLI cli = CLIConfigurator.define(HelloClI.class);
        CommandLine evaluatedCLI = cli.parse(Arrays.asList("--name", "vert.x"));
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.run()).isEqualToIgnoringCase((CharSequence)"Hello vert.x");
        Assertions.assertThat((String)command.name).isEqualToIgnoringCase((CharSequence)"vert.x");
    }

    private CommandLine parse(CLI cli, String ... args) throws CLIException {
        return cli.parse(Arrays.asList(args));
    }

    @Test
    public void testSingleValueInjection() throws CLIException {
        CLIWithSingleValue command = new CLIWithSingleValue();
        CLI cli = CLIConfigurator.define(command.getClass());
        CommandLine evaluatedCLI = this.parse(cli, "--boolean", "--short=1", "--byte=1", "--int=1", "--long=1", "--double=1.1", "--float=1.1", "--char=c", "--string=hello");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((boolean)command.aBoolean).isTrue();
        Assertions.assertThat((boolean)command.acceptValueBoolean).isTrue();
        Assertions.assertThat((short)command.aShort).isEqualTo((short)1);
        Assertions.assertThat((byte)command.aByte).isEqualTo((byte)1);
        Assertions.assertThat((int)command.anInt).isEqualTo(1);
        Assertions.assertThat((long)command.aLong).isEqualTo(1L);
        Assertions.assertThat((double)command.aDouble).isEqualTo(1.1);
        Assertions.assertThat((float)command.aFloat).isEqualTo(1.1f);
        Assertions.assertThat((char)command.aChar).isEqualTo('c');
        Assertions.assertThat((String)command.aString).isEqualTo((Object)"hello");
        evaluatedCLI = this.parse(cli, "--boolean2", "--acceptValueBoolean=false", "--short2=1", "--byte2=1", "--int2=1", "--long2=1", "--double2=1.1", "--float2=1.1", "--char2=c", "--string=hello");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((Boolean)command.anotherBoolean).isTrue();
        Assertions.assertThat((boolean)command.acceptValueBoolean).isFalse();
        Assertions.assertThat((Short)command.anotherShort).isEqualTo((short)1);
        Assertions.assertThat((Byte)command.anotherByte).isEqualTo((byte)1);
        Assertions.assertThat((Integer)command.anotherInt).isEqualTo(1);
        Assertions.assertThat((Long)command.anotherLong).isEqualTo(1L);
        Assertions.assertThat((Double)command.anotherDouble).isEqualTo(1.1);
        Assertions.assertThat((Float)command.anotherFloat).isEqualTo(1.1f);
        Assertions.assertThat((Character)command.anotherChar).isEqualTo('c');
        Assertions.assertThat((String)command.aString).isEqualTo((Object)"hello");
        evaluatedCLI = this.parse(cli, "--acceptValueBoolean=xxx");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((boolean)command.acceptValueBoolean).isFalse();
        evaluatedCLI = this.parse(cli, "--acceptValueBoolean=true");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((boolean)command.acceptValueBoolean).isTrue();
        evaluatedCLI = this.parse(cli, "--state=NEW");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((Comparable)((Object)command.aState)).isEqualTo((Object)Thread.State.NEW);
        evaluatedCLI = this.parse(cli, "--person=vert.x");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.aPerson.name).isEqualTo((Object)"vert.x");
        evaluatedCLI = this.parse(cli, "--person2=vert.x");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.anotherPerson.name).isEqualTo((Object)"vert.x");
        evaluatedCLI = this.parse(cli, "--person3=vert.x");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.aThirdPerson.name).isEqualTo((Object)"vert.x");
        evaluatedCLI = this.parse(cli, "--person4=bob,morane");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.aFourthPerson.first).isEqualTo((Object)"bob");
        Assertions.assertThat((String)command.aFourthPerson.last).isEqualTo((Object)"morane");
    }

    @Test
    public void testMultiValuesInjection() throws CLIException {
        CLIWithMultipleValues command = new CLIWithMultipleValues();
        CLI cli = CLIConfigurator.define(command.getClass());
        CommandLine evaluatedCLI = this.parse(cli, "--persons=x", "--persons", "y", "z");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat(command.persons).hasSize(3);
        evaluatedCLI = this.parse(cli, "--persons2=x", "--persons2", "y", "z");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat(command.persons2).hasSize(3);
        evaluatedCLI = this.parse(cli, "--persons3=x", "--persons3", "y", "z");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat(command.persons3).hasSize(3);
        evaluatedCLI = this.parse(cli, "--persons4=x:y:z");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat(command.persons4).hasSize(3);
        evaluatedCLI = this.parse(cli, "--states=NEW", "--states", "BLOCKED", "RUNNABLE");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat(command.states).hasSize(3).containsExactly((Object[])new Thread.State[]{Thread.State.NEW, Thread.State.BLOCKED, Thread.State.RUNNABLE});
        evaluatedCLI = this.parse(cli, "--ints=1", "--ints", "2", "3");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat(command.ints).hasSize(3).containsExactly((Object[])new Integer[]{1, 2, 3});
        evaluatedCLI = this.parse(cli, "--shorts=1", "--shorts", "2", "3");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        ((AbstractListAssert)Assertions.assertThat(command.shorts).hasSize(3)).containsExactly((Object[])new Short[]{(short)1, (short)2, (short)3});
        evaluatedCLI = this.parse(cli, "--strings=a");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat(command.strings).hasSize(1).containsExactly((Object[])new String[]{"a"});
        evaluatedCLI = this.parse(cli, "--doubles=1", "--doubles", "2.2", "3.3");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((double[])command.doubles).hasSize(3).containsExactly(new double[]{1.0, 2.2, 3.3});
    }

    @Test
    public void testArgumentInjection() throws CLIException {
        CommandForArgumentInjectionTest command = new CommandForArgumentInjectionTest();
        CLI cli = CLIConfigurator.define(command.getClass()).setName("test");
        CommandLine evaluatedCLI = this.parse(cli, "foo");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.reference.get()).isEqualTo((Object)"foo");
    }

    @Test
    public void testArgumentInjectionWithConvertedByAndDefaultValue() throws CLIException {
        CommandForConvertedValueTest command = new CommandForConvertedValueTest();
        CLI cli = CLIConfigurator.define(command.getClass()).setName("test");
        CommandLine evaluatedCLI = this.parse(cli, "Bob,Morane");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.reference.get().first).isEqualTo((Object)"Bob");
        Assertions.assertThat((String)command.reference.get().last).isEqualTo((Object)"Morane");
        evaluatedCLI = this.parse(cli, new String[0]);
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.reference.get().first).isEqualTo((Object)"Bill");
        Assertions.assertThat((String)command.reference.get().last).isEqualTo((Object)"Balantine");
    }

    @Test
    public void testArgumentInjectionWithSeveralArguments() throws CLIException {
        CommandForMultipleArgumentTest command = new CommandForMultipleArgumentTest();
        CLI cli = CLIConfigurator.define(command.getClass()).setName("test");
        CommandLine evaluatedCLI = this.parse(cli, "foo", "1");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.x.get()).isEqualTo((Object)"foo");
        Assertions.assertThat((Integer)command.y.get()).isEqualTo(1);
    }

    @Test
    public void testArgumentWithDefaultValue() throws CLIException {
        CommandWithDefaultValueOnArgument command = new CommandWithDefaultValueOnArgument();
        CLI cli = CLIConfigurator.define(command.getClass()).setName("test");
        CommandLine evaluatedCLI = this.parse(cli, "foo");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)command);
        Assertions.assertThat((String)command.x.get()).isEqualTo((Object)"foo");
        Assertions.assertThat((Integer)command.y.get()).isEqualTo(25);
    }

    private Option find(List<Option> options, String name) {
        List match = options.stream().filter(c -> c.getLongName().equalsIgnoreCase(name)).collect(Collectors.toList());
        if (match.isEmpty()) {
            Fail.fail((String)("Cannot find option '" + name + "' in " + options.stream().map(Option::getLongName).collect(Collectors.toList())));
        }
        return (Option)match.get(0);
    }

    @Name(value="multi")
    private class CLIWithMultipleValues {
        List<Person> persons;
        List<Person> persons2;
        List<Person> persons3;
        Set<Thread.State> states;
        Collection<Integer> ints;
        Set<String> strings;
        List<Short> shorts;
        double[] doubles;
        List<Person> persons4;

        private CLIWithMultipleValues() {
        }

        @io.vertx.core.cli.annotations.Option(longName="doubles", shortName="ds")
        public void setDoubles(double[] doubles) {
            this.doubles = doubles;
        }

        @io.vertx.core.cli.annotations.Option(longName="ints", shortName="is")
        public void setInts(Collection<Integer> ints) {
            this.ints = ints;
        }

        @io.vertx.core.cli.annotations.Option(longName="persons2", shortName="ps2")
        public void setPersons2(List<Person> persons2) {
            this.persons2 = persons2;
        }

        @io.vertx.core.cli.annotations.Option(longName="persons3", shortName="ps3")
        public void setPersons3(List<Person> persons3) {
            this.persons3 = persons3;
        }

        @io.vertx.core.cli.annotations.Option(longName="persons4", shortName="ps4")
        @ParsedAsList(separator=":")
        public void setPersons4(List<Person> persons4) {
            this.persons4 = persons4;
        }

        @io.vertx.core.cli.annotations.Option(longName="persons", shortName="ps")
        public void setPersons(List<Person> persons) {
            this.persons = persons;
        }

        @io.vertx.core.cli.annotations.Option(longName="shorts", shortName="ss")
        public void setShorts(List<Short> shorts) {
            this.shorts = shorts;
        }

        @io.vertx.core.cli.annotations.Option(longName="states", shortName="sts")
        public void setStates(Set<Thread.State> states) {
            this.states = states;
        }

        @io.vertx.core.cli.annotations.Option(longName="strings", shortName="str")
        public void setStrings(Set<String> strings) {
            this.strings = strings;
        }
    }

    @Name(value="single")
    private class CLIWithSingleValue {
        String aString;
        Thread.State aState;
        boolean aBoolean;
        boolean acceptValueBoolean;
        Boolean anotherBoolean;
        byte aByte;
        Byte anotherByte;
        char aChar;
        Character anotherChar;
        double aDouble;
        Double anotherDouble;
        float aFloat;
        Float anotherFloat;
        int anInt;
        Integer anotherInt;
        long aLong;
        Long anotherLong;
        short aShort;
        Short anotherShort;
        Person aPerson;
        Person2 anotherPerson;
        Person3 aThirdPerson;
        Person4 aFourthPerson;

        private CLIWithSingleValue() {
        }

        @io.vertx.core.cli.annotations.Option(longName="boolean", shortName="Z", flag=true)
        public void setaBoolean(boolean aBoolean) {
            this.aBoolean = aBoolean;
        }

        @io.vertx.core.cli.annotations.Option(longName="acceptValueBoolean", flag=false, acceptValue=true)
        @DefaultValue(value="true")
        public void setAcceptValueBoolean(boolean acceptValueBoolean) {
            this.acceptValueBoolean = acceptValueBoolean;
        }

        @io.vertx.core.cli.annotations.Option(longName="byte", shortName="B")
        public void setaByte(byte aByte) {
            this.aByte = aByte;
        }

        @io.vertx.core.cli.annotations.Option(longName="char", shortName="C")
        public void setaChar(char aChar) {
            this.aChar = aChar;
        }

        @io.vertx.core.cli.annotations.Option(longName="double", shortName="D")
        public void setaDouble(double aDouble) {
            this.aDouble = aDouble;
        }

        @io.vertx.core.cli.annotations.Option(longName="float", shortName="F")
        public void setaFloat(float aFloat) {
            this.aFloat = aFloat;
        }

        @io.vertx.core.cli.annotations.Option(longName="long", shortName="J")
        public void setaLong(long aLong) {
            this.aLong = aLong;
        }

        @io.vertx.core.cli.annotations.Option(longName="int", shortName="I")
        public void setAnInt(int anInt) {
            this.anInt = anInt;
        }

        @io.vertx.core.cli.annotations.Option(longName="boolean2", shortName="AZ", flag=true)
        public void setAnotherBoolean(Boolean anotherBoolean) {
            this.anotherBoolean = anotherBoolean;
        }

        @io.vertx.core.cli.annotations.Option(longName="byte2", shortName="AB")
        public void setAnotherByte(Byte anotherByte) {
            this.anotherByte = anotherByte;
        }

        @io.vertx.core.cli.annotations.Option(longName="char2", shortName="AC")
        public void setAnotherChar(Character anotherChar) {
            this.anotherChar = anotherChar;
        }

        @io.vertx.core.cli.annotations.Option(longName="double2", shortName="AD")
        public void setAnotherDouble(Double anotherDouble) {
            this.anotherDouble = anotherDouble;
        }

        @io.vertx.core.cli.annotations.Option(longName="float2", shortName="AF")
        public void setAnotherFloat(Float anotherFloat) {
            this.anotherFloat = anotherFloat;
        }

        @io.vertx.core.cli.annotations.Option(longName="int2", shortName="AI")
        public void setAnotherInt(Integer anotherInt) {
            this.anotherInt = anotherInt;
        }

        @io.vertx.core.cli.annotations.Option(longName="long2", shortName="AJ")
        public void setAnotherLong(Long anotherLong) {
            this.anotherLong = anotherLong;
        }

        @io.vertx.core.cli.annotations.Option(longName="person2", shortName="p2")
        public void setAnotherPerson(Person2 anotherPerson) {
            this.anotherPerson = anotherPerson;
        }

        @io.vertx.core.cli.annotations.Option(longName="short2", shortName="AS")
        public void setAnotherShort(Short anotherShort) {
            this.anotherShort = anotherShort;
        }

        @io.vertx.core.cli.annotations.Option(longName="person", shortName="p")
        public void setaPerson(Person aPerson) {
            this.aPerson = aPerson;
        }

        @io.vertx.core.cli.annotations.Option(longName="person4", shortName="p4")
        @ConvertedBy(value=Person4Converter.class)
        public void setAFourthPerson(Person4 aPerson) {
            this.aFourthPerson = aPerson;
        }

        @io.vertx.core.cli.annotations.Option(longName="short", shortName="s")
        public void setaShort(short aShort) {
            this.aShort = aShort;
        }

        @io.vertx.core.cli.annotations.Option(longName="state", shortName="st")
        public void setaState(Thread.State aState) {
            this.aState = aState;
        }

        @io.vertx.core.cli.annotations.Option(longName="string", shortName="str")
        public void setaString(String aString) {
            this.aString = aString;
        }

        @io.vertx.core.cli.annotations.Option(longName="person3", shortName="p3")
        public void setaThirdPerson(Person3 aThirdPerson) {
            this.aThirdPerson = aThirdPerson;
        }
    }

    @Name(value="test")
    public static class CommandWithDefaultValueOnArgument {
        AtomicReference<String> x = new AtomicReference();
        AtomicReference<Integer> y = new AtomicReference();

        @Argument(index=0)
        public void setX(String s) {
            this.x.set(s);
        }

        @Argument(index=1, required=false)
        @DefaultValue(value="25")
        public void setY(int s) {
            this.y.set(s);
        }
    }

    @Name(value="test")
    public static class CommandForMultipleArgumentTest {
        AtomicReference<String> x = new AtomicReference();
        AtomicReference<Integer> y = new AtomicReference();

        @Argument(index=0)
        public void setX(String s) {
            this.x.set(s);
        }

        @Argument(index=1)
        public void setY(int s) {
            this.y.set(s);
        }
    }

    @Name(value="test")
    public class CommandForConvertedValueTest {
        AtomicReference<Person4> reference = new AtomicReference();

        @Argument(index=0, required=false)
        @DefaultValue(value="Bill,Balantine")
        @ConvertedBy(value=Person4Converter.class)
        public void setX(Person4 s) {
            this.reference.set(s);
        }
    }

    @Name(value="test")
    public static class CommandForArgumentInjectionTest {
        AtomicReference<String> reference = new AtomicReference();

        @Argument(index=0)
        public void setX(String s) {
            this.reference.set(s);
        }
    }

    @Name(value="test")
    public static class CommandForTypeExtractTest {
        @io.vertx.core.cli.annotations.Option(longName="list", shortName="l")
        public void setFoo(List<String> list) {
        }

        @io.vertx.core.cli.annotations.Option(longName="set", shortName="s")
        public void setFoo(Set<Character> set) {
        }

        @io.vertx.core.cli.annotations.Option(longName="collection", shortName="c")
        public void setFoo(Collection<Integer> collection) {
        }

        @io.vertx.core.cli.annotations.Option(longName="tree", shortName="t")
        public void setFoo(TreeSet<String> list) {
        }

        @io.vertx.core.cli.annotations.Option(longName="al", shortName="al")
        public void setFoo(ArrayList<String> list) {
        }

        @io.vertx.core.cli.annotations.Option(longName="array", shortName="a")
        public void setFoo(int[] list) {
        }
    }

    @Name(value="test")
    public static class CommandForParsedAsList {
        @io.vertx.core.cli.annotations.Option(longName="option", shortName="o")
        @ParsedAsList(separator=":")
        public void setFoo(List<String> foo) {
        }
    }

    @Name(value="test")
    public static class CommandForDescriptionTest {
        @io.vertx.core.cli.annotations.Option(longName="option", shortName="o")
        @Description(value="This option is awesome")
        public void setFoo(String foo) {
        }
    }

    @Name(value="test")
    public static class CommandForDefaultValueTest {
        @io.vertx.core.cli.annotations.Option(longName="option", shortName="o")
        @DefaultValue(value="bar")
        public void setFoo(String foo) {
        }
    }
}

