/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.ThreadingModel;
import io.vertx.core.http.HttpMetricsTestBase;
import io.vertx.core.http.HttpVersion;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class Http1xMetricsTest
extends HttpMetricsTestBase {
    public Http1xMetricsTest() {
        this(ThreadingModel.EVENT_LOOP);
    }

    protected Http1xMetricsTest(ThreadingModel threadingModel) {
        super(HttpVersion.HTTP_1_1, threadingModel);
    }

    @Test
    public void testAllocatedStreamResetShouldNotCallMetricsLifecycle() throws Exception {
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        CountDownLatch latch = new CountDownLatch(1);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setIdleTimeout(2));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.exceptionHandler(err -> latch.countDown());
            req.connection().close();
        }));
        this.awaitLatch(latch);
    }
}

