/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class RequestOptionsTest {
    @Test
    public void testDefaults() {
        RequestOptions options = new RequestOptions();
        Assert.assertEquals((Object)RequestOptions.DEFAULT_SERVER, (Object)options.getServer());
        Assert.assertEquals((Object)RequestOptions.DEFAULT_HTTP_METHOD, (Object)options.getMethod());
        Assert.assertEquals((Object)RequestOptions.DEFAULT_HOST, (Object)options.getHost());
        Assert.assertEquals((Object)RequestOptions.DEFAULT_PORT, (Object)options.getPort());
        Assert.assertEquals((Object)RequestOptions.DEFAULT_SSL, (Object)options.isSsl());
        Assert.assertEquals((Object)"/", (Object)options.getURI());
        Assert.assertEquals((Object)false, (Object)options.getFollowRedirects());
        Assert.assertEquals((long)-1L, (long)options.getTimeout());
        Assert.assertEquals((long)-1L, (long)options.getConnectTimeout());
        Assert.assertEquals((long)-1L, (long)options.getIdleTimeout());
    }

    @Test
    public void testCopy() {
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.PUT).setPort(Integer.valueOf(8443)).setSsl(Boolean.valueOf(true)).setFollowRedirects(Boolean.valueOf(true));
        RequestOptions copy = new RequestOptions(options);
        Assert.assertEquals((Object)options.getMethod(), (Object)copy.getMethod());
        Assert.assertEquals((Object)options.getPort(), (Object)copy.getPort());
        Assert.assertEquals((Object)options.isSsl(), (Object)copy.isSsl());
        Assert.assertEquals((Object)options.getFollowRedirects(), (Object)copy.getFollowRedirects());
    }

    @Test
    public void testToJson() {
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.PUT).setPort(Integer.valueOf(8443)).setSsl(Boolean.valueOf(true)).setFollowRedirects(Boolean.valueOf(true)).addHeader("key", "value").addHeader((CharSequence)"foo", Arrays.asList("bar", "baz"));
        JsonObject expected = new JsonObject().put("timeout", (Object)-1L).put("connectTimeout", (Object)-1L).put("idleTimeout", (Object)-1L).put("uri", (Object)"/").put("method", (Object)"PUT").put("port", (Object)8443).put("ssl", (Object)true).put("followRedirects", (Object)true).put("headers", (Object)new JsonObject().put("key", (Object)"value").put("foo", (Object)new JsonArray().add((Object)"bar").add((Object)"baz")));
        Assert.assertEquals((Object)expected, (Object)options.toJson());
    }

    @Test
    public void testFromJson() {
        JsonObject json = new JsonObject().put("method", (Object)"PUT").put("port", (Object)8443).put("ssl", (Object)true).put("followRedirects", (Object)true).put("headers", (Object)new JsonObject().put("key", (Object)"value").put("foo", (Object)new JsonArray().add((Object)"bar").add((Object)"baz")));
        RequestOptions options = new RequestOptions(json);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)options.getMethod());
        Assert.assertEquals((Object)8443, (Object)options.getPort());
        Assert.assertTrue((boolean)options.isSsl());
        Assert.assertTrue((boolean)options.getFollowRedirects());
        MultiMap headers = options.getHeaders();
        Assert.assertEquals((String)headers.toString(), (long)2L, (long)headers.size());
        Assert.assertEquals(Collections.singletonList("value"), (Object)headers.getAll("key"));
        Assert.assertEquals(Arrays.asList("bar", "baz"), (Object)headers.getAll("foo"));
    }

    @Test
    public void testHeaderNameValidation() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new RequestOptions().addHeader("=", "invalid header name"));
    }

    @Test
    public void testHeaderValueValidation() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new RequestOptions().addHeader("invalid-header-value", "\r"));
    }
}

