/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.ChannelHandlerContext;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.WebSocketClientImpl;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.http.ClientWebSocketInternal;
import io.vertx.core.internal.http.WebSocketInternal;
import io.vertx.core.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class ClientWebSocketImpl
implements ClientWebSocketInternal {
    private final WebSocketClientImpl client;
    private final AtomicReference<Promise<WebSocket>> connect = new AtomicReference();
    private volatile WebSocketInternal ws;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> shutdownHandler;
    private Handler<Void> drainHandler;
    private Handler<WebSocketFrame> frameHandler;
    private Handler<String> textMessageHandler;
    private Handler<Buffer> binaryMessageHandler;
    private Handler<Buffer> pongHandler;

    ClientWebSocketImpl(WebSocketClientImpl client) {
        this.client = client;
    }

    @Override
    public Future<WebSocket> connect(WebSocketConnectOptions options) {
        return this.connect(this.client.vertx().getOrCreateContext(), options);
    }

    @Override
    public Future<WebSocket> connect(Context context, WebSocketConnectOptions options) {
        return this.connect((ContextInternal)context, options);
    }

    private Future<WebSocket> connect(ContextInternal context, WebSocketConnectOptions options) {
        PromiseInternal<WebSocket> promise = context.promise();
        if (!this.connect.compareAndSet(null, promise)) {
            return context.failedFuture("Already connecting");
        }
        this.client.webSocket(context, options, promise);
        return promise.future().andThen(ar -> {
            if (ar.succeeded()) {
                WebSocketInternal w;
                this.ws = w = (WebSocketInternal)ar.result();
                w.handler((Handler)this.dataHandler);
                w.binaryMessageHandler((Handler)this.binaryMessageHandler);
                w.textMessageHandler((Handler)this.textMessageHandler);
                w.endHandler((Handler)this.endHandler);
                w.closeHandler((Handler)this.closeHandler);
                w.shutdownHandler((Handler)this.shutdownHandler);
                w.exceptionHandler((Handler)this.exceptionHandler);
                w.drainHandler((Handler)this.drainHandler);
                w.frameHandler((Handler)this.frameHandler);
                w.pongHandler((Handler)this.pongHandler);
                w.resume();
            }
        });
    }

    @Override
    public ClientWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.exceptionHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.handler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket pause() {
        this.delegate().pause();
        return this;
    }

    @Override
    public ClientWebSocket fetch(long amount) {
        this.delegate().fetch(amount);
        return this;
    }

    @Override
    public ClientWebSocket endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.endHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.delegate().channelHandlerContext();
    }

    @Override
    public ClientWebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate().setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public ClientWebSocket drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.drainHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.closeHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket shutdownHandler(Handler<Void> handler) {
        this.shutdownHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.shutdownHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.frameHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.frameHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public String binaryHandlerID() {
        return this.delegate().binaryHandlerID();
    }

    @Override
    public String textHandlerID() {
        return this.delegate().textHandlerID();
    }

    @Override
    public String subProtocol() {
        return this.delegate().subProtocol();
    }

    @Override
    public Short closeStatusCode() {
        return this.delegate().closeStatusCode();
    }

    @Override
    public String closeReason() {
        return this.delegate().closeReason();
    }

    @Override
    public MultiMap headers() {
        return this.delegate().headers();
    }

    @Override
    public Future<Void> writeFrame(WebSocketFrame frame) {
        return this.delegate().writeFrame(frame);
    }

    @Override
    public Future<Void> writeFinalTextFrame(String text) {
        return this.delegate().writeFinalTextFrame(text);
    }

    @Override
    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        return this.delegate().writeFinalBinaryFrame(data);
    }

    @Override
    public Future<Void> writeBinaryMessage(Buffer data) {
        return this.delegate().writeBinaryMessage(data);
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        return this.delegate().writeTextMessage(text);
    }

    @Override
    public Future<Void> writePing(Buffer data) {
        return this.delegate().writePing(data);
    }

    @Override
    public Future<Void> writePong(Buffer data) {
        return this.delegate().writePong(data);
    }

    @Override
    public ClientWebSocket textMessageHandler(@Nullable Handler<String> handler) {
        this.textMessageHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.textMessageHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket binaryMessageHandler(@Nullable Handler<Buffer> handler) {
        this.binaryMessageHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.binaryMessageHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket pongHandler(@Nullable Handler<Buffer> handler) {
        this.pongHandler = handler;
        WebSocketInternal w = this.ws;
        if (w != null) {
            w.pongHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public Future<Void> end() {
        return this.delegate().end();
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit, short statusCode, @Nullable String reason) {
        return this.delegate().close(statusCode, reason);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.delegate().remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.delegate().localAddress();
    }

    @Override
    public boolean isSsl() {
        return this.delegate().isSsl();
    }

    @Override
    public boolean isClosed() {
        return this.delegate().isClosed();
    }

    @Override
    public SSLSession sslSession() {
        return this.delegate().sslSession();
    }

    @Override
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.delegate().peerCertificates();
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.delegate().write(data);
    }

    @Override
    public boolean writeQueueFull() {
        return this.delegate().writeQueueFull();
    }

    private WebSocketInternal delegate() {
        WebSocketInternal w = this.ws;
        if (w == null) {
            throw new IllegalStateException("Not connected");
        }
        return w;
    }
}

