/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Completable;
import io.vertx.core.Expectation;
import io.vertx.core.VertxException;
import io.vertx.core.impl.future.Operation;
import io.vertx.core.internal.ContextInternal;

public class Expect<T>
extends Operation<T>
implements Completable<T> {
    private final Expectation<? super T> expectation;

    public Expect(ContextInternal context, Expectation<? super T> expectation) {
        super(context);
        this.expectation = expectation;
    }

    @Override
    public void complete(T result, Throwable failure) {
        if (failure == null) {
            try {
                if (!this.expectation.test(result) && (failure = this.expectation.describe(result)) == null) {
                    failure = new VertxException("Unexpected result: " + result, true);
                }
            }
            catch (Throwable e) {
                failure = e;
            }
        }
        this.handleInternal(result, failure);
    }
}

