/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.concurrent.Promise;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.internal.buffer.BufferInternal;

class WebSocketHandshakeInboundHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketClientHandshaker handshaker;
    private final Promise<HttpHeaders> upgrade;
    private ChannelHandlerContext chctx;
    private FullHttpResponse response;
    private ChannelFuture fut;

    WebSocketHandshakeInboundHandler(WebSocketClientHandshaker handshaker, Promise<HttpHeaders> upgrade) {
        this.handshaker = handshaker;
        this.upgrade = upgrade;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.chctx = ctx;
        this.fut = this.handshaker.handshake(this.chctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.upgrade.tryFailure((Throwable)new WebSocketHandshakeException("Connection closed while handshake in process"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse resp = (HttpResponse)msg;
            this.response = new DefaultFullHttpResponse(resp.protocolVersion(), resp.status());
            this.response.headers().add(resp.headers());
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            try {
                if (this.response != null) {
                    this.response.content().writeBytes(content.content());
                    if (msg instanceof LastHttpContent) {
                        this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                        ChannelPipeline pipeline = this.chctx.pipeline();
                        pipeline.remove((ChannelHandler)this);
                        ChannelHandler handler = pipeline.get(HttpContentDecompressor.class);
                        if (handler != null) {
                            ctx.pipeline().remove(handler);
                        }
                        this.fut.addListener(future -> {
                            if (future.isSuccess()) {
                                HttpHeaders headers;
                                try {
                                    headers = this.handshakeComplete(this.response);
                                }
                                catch (Exception e) {
                                    this.upgrade.setFailure((Throwable)e);
                                    return;
                                }
                                this.upgrade.setSuccess((Object)headers);
                            } else {
                                this.upgrade.setFailure(future.cause());
                            }
                        });
                    }
                }
            }
            finally {
                content.release();
            }
        }
    }

    private HttpHeaders handshakeComplete(FullHttpResponse response) throws UpgradeRejectedException, WebSocketHandshakeException {
        int sc = response.status().code();
        if (sc != 101) {
            String msg = "WebSocket upgrade failure: " + sc;
            ByteBuf content = response.content();
            throw new UpgradeRejectedException(msg, sc, new HeadersAdaptor(response.headers()), content != null ? BufferInternal.buffer(content) : null);
        }
        this.handshaker.finishHandshake(this.chctx.channel(), response);
        return response.headers();
    }
}

