/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.RecyclerPool;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.json.jackson.HybridJacksonPool;
import io.vertx.core.spi.json.JsonCodec;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonCodec
implements JsonCodec {
    static final JsonFactory factory = JacksonCodec.buildFactory();

    private static JsonFactory buildFactory() {
        TSFBuilder builder = JsonFactory.builder();
        builder.recyclerPool((RecyclerPool)HybridJacksonPool.getInstance());
        return builder.build();
    }

    @Override
    public <T> T fromString(String json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    @Override
    public <T> T fromBuffer(Buffer json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    @Override
    public <T> T fromValue(Object json, Class<T> toValueType) {
        throw new DecodeException("Mapping " + toValueType.getName() + "  is not available without Jackson Databind on the classpath");
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        BufferRecycler br = factory._getBufferRecycler();
        try {
            String string;
            SegmentedStringWriter sw = new SegmentedStringWriter(br);
            try {
                JsonGenerator generator = JacksonCodec.createGenerator((Writer)sw, pretty);
                JacksonCodec.encodeJson(object, generator);
                generator.close();
                string = sw.getAndClear();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        sw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EncodeException(e.getMessage(), e);
                }
            }
            sw.close();
            return string;
        }
        finally {
            br.releaseToPool();
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        BufferRecycler br = factory._getBufferRecycler();
        try {
            Buffer buffer;
            ByteArrayBuilder bb = new ByteArrayBuilder(br);
            try {
                JsonGenerator generator = JacksonCodec.createGenerator((OutputStream)bb, pretty);
                JacksonCodec.encodeJson(object, generator);
                generator.close();
                byte[] result = bb.toByteArray();
                bb.release();
                buffer = Buffer.buffer(result);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bb.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EncodeException(e.getMessage(), e);
                }
            }
            bb.close();
            return buffer;
        }
        finally {
            br.releaseToPool();
        }
    }

    public static JsonParser createParser(String str) {
        try {
            return factory.createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return factory.createParser((InputStream)new ByteBufInputStream(((BufferInternal)buf).getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(Writer out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(OutputStream out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public Object fromString(String str) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str), Object.class);
    }

    public Object fromBuffer(Buffer buf) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), Object.class);
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type) throws DecodeException {
        JsonToken remaining;
        Object res;
        try {
            parser.nextToken();
            res = JacksonCodec.parseAny(parser);
            remaining = parser.nextToken();
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage(), e);
        }
        finally {
            JacksonCodec.close((Closeable)parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        return JacksonCodec.cast(res, type);
    }

    private static Object parseAny(JsonParser parser) throws IOException, DecodeException {
        switch (parser.currentTokenId()) {
            case 1: {
                return JacksonCodec.parseObject(parser);
            }
            case 3: {
                return JacksonCodec.parseArray(parser);
            }
            case 6: {
                return parser.getText();
            }
            case 7: 
            case 8: {
                return parser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        throw new DecodeException("Unexpected token");
    }

    private static Map<String, Object> parseObject(JsonParser parser) throws IOException {
        String key1 = parser.nextFieldName();
        if (key1 == null) {
            return new LinkedHashMap<String, Object>(2);
        }
        parser.nextToken();
        Object value1 = JacksonCodec.parseAny(parser);
        String key2 = parser.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            return obj;
        }
        parser.nextToken();
        Object value2 = JacksonCodec.parseAny(parser);
        String key = parser.nextFieldName();
        if (key == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            obj.put(key2, value2);
            return obj;
        }
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put(key1, value1);
        obj.put(key2, value2);
        do {
            parser.nextToken();
            Object value = JacksonCodec.parseAny(parser);
            obj.put(key, value);
        } while ((key = parser.nextFieldName()) != null);
        return obj;
    }

    private static List<Object> parseArray(JsonParser parser) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            parser.nextToken();
            int tokenId = parser.currentTokenId();
            if (tokenId == 5) {
                throw new UnsupportedOperationException();
            }
            if (tokenId == 4) {
                return array;
            }
            Object value = JacksonCodec.parseAny(parser);
            array.add(value);
        }
    }

    static void close(Closeable parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void encodeJson(Object json, JsonGenerator generator) throws EncodeException {
        try {
            if (json instanceof JsonObject) {
                json = ((JsonObject)json).getMap();
            } else if (json instanceof JsonArray) {
                json = ((JsonArray)json).getList();
            }
            if (json instanceof Map) {
                generator.writeStartObject();
                for (Map.Entry e : ((Map)json).entrySet()) {
                    generator.writeFieldName((String)e.getKey());
                    Object value = e.getValue();
                    JacksonCodec.encodeJson0(value, generator);
                }
                generator.writeEndObject();
            } else if (json instanceof List) {
                generator.writeStartArray();
                for (Object item : (List)json) {
                    JacksonCodec.encodeJson0(item, generator);
                }
                generator.writeEndArray();
            } else if (!JacksonCodec.encodeSingleType(generator, json)) {
                throw new EncodeException("Mapping " + json.getClass().getName() + "  is not available without Jackson Databind on the classpath");
            }
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), e);
        }
    }

    private static void encodeJson0(Object json, JsonGenerator generator) throws EncodeException {
        try {
            if (json instanceof JsonObject) {
                json = ((JsonObject)json).getMap();
            } else if (json instanceof JsonArray) {
                json = ((JsonArray)json).getList();
            }
            if (json instanceof Map) {
                generator.writeStartObject();
                for (Map.Entry e : ((Map)json).entrySet()) {
                    generator.writeFieldName((String)e.getKey());
                    Object value = e.getValue();
                    JacksonCodec.encodeJson(value, generator);
                }
                generator.writeEndObject();
            } else if (json instanceof List) {
                generator.writeStartArray();
                for (Object item : (List)json) {
                    JacksonCodec.encodeJson(item, generator);
                }
                generator.writeEndArray();
            } else if (!JacksonCodec.encodeSingleType(generator, json)) {
                throw new EncodeException("Mapping " + json.getClass().getName() + "  is not available without Jackson Databind on the classpath");
            }
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), e);
        }
    }

    private static boolean encodeSingleType(JsonGenerator generator, Object json) throws IOException {
        if (json == null) {
            generator.writeNull();
        } else if (json instanceof String) {
            generator.writeString((String)json);
        } else if (json instanceof Number) {
            JacksonCodec.encodeNumber(generator, json);
        } else if (json instanceof Boolean) {
            generator.writeBoolean(((Boolean)json).booleanValue());
        } else if (json instanceof Instant) {
            generator.writeString(DateTimeFormatter.ISO_INSTANT.format((Instant)json));
        } else if (json instanceof byte[]) {
            generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString((byte[])json));
        } else if (json instanceof Buffer) {
            generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)json).getBytes()));
        } else if (json instanceof Enum) {
            generator.writeString(((Enum)json).name());
        } else {
            return false;
        }
        return true;
    }

    private static void encodeNumber(JsonGenerator generator, Object json) throws IOException {
        if (json instanceof Short) {
            generator.writeNumber(((Short)json).shortValue());
        } else if (json instanceof Integer) {
            generator.writeNumber(((Integer)json).intValue());
        } else if (json instanceof Long) {
            generator.writeNumber(((Long)json).longValue());
        } else if (json instanceof Float) {
            generator.writeNumber(((Float)json).floatValue());
        } else if (json instanceof Double) {
            generator.writeNumber(((Double)json).doubleValue());
        } else if (json instanceof Byte) {
            generator.writeNumber((short)((Byte)json).byteValue());
        } else if (json instanceof BigInteger) {
            generator.writeNumber((BigInteger)json);
        } else if (json instanceof BigDecimal) {
            generator.writeNumber((BigDecimal)json);
        } else {
            generator.writeNumber(((Number)json).doubleValue());
        }
    }

    private static <T> T cast(Object o, Class<T> clazz) {
        if (o instanceof Map) {
            if (!clazz.isAssignableFrom(Map.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonObject((Map)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof List) {
            if (!clazz.isAssignableFrom(List.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonArray((List)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof String) {
            String str = (String)o;
            if (clazz.isEnum()) {
                o = Enum.valueOf(clazz, str);
            } else if (clazz == byte[].class) {
                o = JsonUtil.BASE64_DECODER.decode(str);
            } else if (clazz == Buffer.class) {
                o = Buffer.buffer(JsonUtil.BASE64_DECODER.decode(str));
            } else if (clazz == Instant.class) {
                o = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(str));
            } else if (!clazz.isAssignableFrom(String.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o instanceof Boolean) {
            if (!clazz.isAssignableFrom(Boolean.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o == null) {
            return null;
        }
        Number number = (Number)o;
        if (clazz == Integer.class) {
            o = number.intValue();
        } else if (clazz == Long.class) {
            o = number.longValue();
        } else if (clazz == Float.class) {
            o = Float.valueOf(number.floatValue());
        } else if (clazz == Double.class) {
            o = number.doubleValue();
        } else if (clazz == Byte.class) {
            o = number.byteValue();
        } else if (clazz == Short.class) {
            o = number.shortValue();
        } else if (clazz != Object.class && !clazz.isAssignableFrom(Number.class)) {
            throw new DecodeException("Failed to decode");
        }
        return clazz.cast(o);
    }

    static {
        factory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

