/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientConnection;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnectOptions;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.EndpointKey;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientBase;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.SharedHttpClientConnectionGroup;
import io.vertx.core.http.impl.StatisticsGatheringHttpClientStream;
import io.vertx.core.http.impl.UnpooledHttpClientConnection;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.internal.net.endpoint.EndpointResolverInternal;
import io.vertx.core.internal.pool.ConnectionPool;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.resource.ResourceManager;
import io.vertx.core.net.Address;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.endpoint.Endpoint;
import io.vertx.core.net.endpoint.EndpointResolver;
import io.vertx.core.net.endpoint.ServerInteraction;
import io.vertx.core.net.endpoint.impl.EndpointResolverImpl;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;

public class HttpClientImpl
extends HttpClientBase
implements HttpClientInternal,
MetricsProvider {
    static final Pattern ABS_URI_START_PATTERN = Pattern.compile("^\\p{Alpha}[\\p{Alpha}\\p{Digit}+.\\-]*:");
    private final PoolOptions poolOptions;
    private final ResourceManager<EndpointKey, SharedHttpClientConnectionGroup> httpCM;
    private final EndpointResolverInternal endpointResolver;
    private volatile Function<HttpClientResponse, Future<RequestOptions>> redirectHandler = DEFAULT_REDIRECT_HANDLER;
    private long timerID;
    private volatile Handler<HttpConnection> connectionHandler;
    private final Function<ContextInternal, ContextInternal> contextProvider;

    public HttpClientImpl(VertxInternal vertx, EndpointResolver endpointResolver, HttpClientOptions options, PoolOptions poolOptions) {
        super(vertx, options);
        int eventLoopSize;
        this.endpointResolver = (EndpointResolverImpl)endpointResolver;
        this.poolOptions = poolOptions;
        this.httpCM = new ResourceManager();
        if (poolOptions.getCleanerPeriod() > 0 && ((long)options.getKeepAliveTimeout() > 0L || (long)options.getHttp2KeepAliveTimeout() > 0L)) {
            PoolChecker checker = new PoolChecker(this);
            ContextInternal timerContext = vertx.createEventLoopContext();
            this.timerID = timerContext.setTimer(poolOptions.getCleanerPeriod(), checker);
        }
        if ((eventLoopSize = poolOptions.getEventLoopSize()) > 0) {
            ContextInternal[] eventLoops = new ContextInternal[eventLoopSize];
            for (int i = 0; i < eventLoopSize; ++i) {
                eventLoops[i] = vertx.createEventLoopContext();
            }
            AtomicInteger idx = new AtomicInteger();
            this.contextProvider = ctx -> {
                int i = idx.getAndIncrement();
                return eventLoops[i % eventLoopSize];
            };
        } else {
            this.contextProvider = ConnectionPool.EVENT_LOOP_CONTEXT_PROVIDER;
        }
    }

    Function<ContextInternal, ContextInternal> contextProvider() {
        return this.contextProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkExpired(Handler<Long> checker) {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (!this.closeSequence.started()) {
                this.timerID = this.vertx.setTimer(this.poolOptions.getCleanerPeriod(), checker);
            }
        }
        this.httpCM.checkExpired();
        if (this.endpointResolver != null) {
            this.endpointResolver.checkExpired();
        }
    }

    private Function<EndpointKey, SharedHttpClientConnectionGroup> httpEndpointProvider() {
        return key -> {
            int maxPoolSize = Math.max(this.poolOptions.getHttp1MaxSize(), this.poolOptions.getHttp2MaxSize());
            ClientMetrics clientMetrics = this.metrics != null ? this.metrics.createEndpointMetrics(key.server, maxPoolSize) : null;
            PoolMetrics<?, ?> poolMetrics = this.metrics != null ? this.vertx.metrics().createPoolMetrics("http", key.server.toString(), maxPoolSize) : null;
            ProxyOptions proxyOptions = key.proxyOptions;
            if (proxyOptions != null && !key.ssl && proxyOptions.getType() == ProxyType.HTTP) {
                SocketAddress server = SocketAddress.inetSocketAddress(proxyOptions.getPort(), proxyOptions.getHost());
                key = new EndpointKey(key.ssl, key.sslOptions, proxyOptions, server, key.authority);
                proxyOptions = null;
            }
            HttpChannelConnector connector = new HttpChannelConnector(this, this.netClient, key.sslOptions, proxyOptions, clientMetrics, this.options.getProtocolVersion(), key.ssl, this.options.isUseAlpn(), key.authority, key.server, true);
            return new SharedHttpClientConnectionGroup(this.vertx, this, clientMetrics, poolMetrics, this.poolOptions.getMaxWaitQueueSize(), this.poolOptions.getHttp1MaxSize(), this.poolOptions.getHttp2MaxSize(), connector);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShutdown(Promise<Void> p) {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.httpCM.shutdown();
        super.doShutdown(p);
    }

    @Override
    protected void doClose(Promise<Void> p) {
        this.httpCM.close();
        super.doClose(p);
    }

    public void redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        if (handler == null) {
            handler = DEFAULT_REDIRECT_HANDLER;
        }
        this.redirectHandler = handler;
    }

    @Override
    public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
        return this.redirectHandler;
    }

    public void connectionHandler(Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
    }

    Handler<HttpConnection> connectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public Future<HttpClientConnection> connect(HttpConnectOptions connect) {
        SocketAddress server;
        Address addr = connect.getServer();
        Integer port = connect.getPort();
        String host = connect.getHost();
        if (addr == null) {
            if (port == null) {
                port = this.options.getDefaultPort();
            }
            if (host == null) {
                host = this.options.getDefaultHost();
            }
            server = SocketAddress.inetSocketAddress(port, host);
        } else if (addr instanceof SocketAddress) {
            server = (SocketAddress)addr;
            if (port == null) {
                port = connect.getPort();
            }
            if (host == null) {
                host = connect.getHost();
            }
            if (port == null) {
                port = server.port();
            }
            if (host == null) {
                host = server.host();
            }
        } else {
            throw new IllegalArgumentException("Only socket address are currently supported");
        }
        HostAndPort authority = HostAndPort.create(host, port);
        ClientSSLOptions sslOptions = this.sslOptions(connect);
        ProxyOptions proxyOptions = this.computeProxyOptions(connect.getProxyOptions(), server);
        ClientMetrics clientMetrics = this.metrics != null ? this.metrics.createEndpointMetrics(server, 1) : null;
        Boolean ssl = connect.isSsl();
        boolean useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        boolean useAlpn = this.options.isUseAlpn();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            return this.vertx.getOrCreateContext().failedFuture("Must enable ALPN when using H2");
        }
        this.checkClosed();
        HttpChannelConnector connector = new HttpChannelConnector(this, this.netClient, sslOptions, proxyOptions, clientMetrics, this.options.getProtocolVersion(), useSSL, useAlpn, authority, server, false);
        return connector.httpConnect(this.vertx.getOrCreateContext()).map(conn -> new UnpooledHttpClientConnection((HttpClientConnectionInternal)conn).init());
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions request) {
        Address addr = request.getServer();
        Integer port = request.getPort();
        String host = request.getHost();
        if (addr == null) {
            if (port == null) {
                port = this.options.getDefaultPort();
            }
            if (host == null) {
                host = this.options.getDefaultHost();
            }
            addr = SocketAddress.inetSocketAddress(port, host);
        } else if (addr instanceof SocketAddress) {
            SocketAddress socketAddr = (SocketAddress)addr;
            if (port == null) {
                port = request.getPort();
            }
            if (host == null) {
                host = request.getHost();
            }
            if (port == null) {
                port = socketAddr.port();
            }
            if (host == null) {
                host = socketAddr.host();
            }
        }
        return this.doRequest(addr, port, host, request);
    }

    private Future<HttpClientRequest> doRequest(Address server, Integer port, String host, RequestOptions request) {
        HostAndPort authority;
        boolean useSSL;
        if (server == null) {
            throw new NullPointerException();
        }
        HttpMethod method = request.getMethod();
        String requestURI = request.getURI();
        Boolean ssl = request.isSsl();
        MultiMap headers = request.getHeaders();
        long connectTimeout = 0L;
        long idleTimeout = 0L;
        if (request.getTimeout() >= 0L) {
            connectTimeout = request.getTimeout();
            idleTimeout = request.getTimeout();
        }
        if (request.getConnectTimeout() >= 0L) {
            connectTimeout = request.getConnectTimeout();
        }
        if (request.getIdleTimeout() >= 0L) {
            idleTimeout = request.getIdleTimeout();
        }
        Boolean followRedirects = request.getFollowRedirects();
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(requestURI, "no null requestURI accepted");
        boolean useAlpn = this.options.isUseAlpn();
        boolean bl = useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            return this.vertx.getOrCreateContext().failedFuture("Must enable ALPN when using H2");
        }
        this.checkClosed();
        if (host != null && port != null) {
            String peerHost = host;
            authority = HostAndPort.create(peerHost, port);
        } else {
            authority = null;
        }
        ClientSSLOptions sslOptions = this.sslOptions(request);
        return this.doRequest(request.getRoutingKey(), method, authority, server, useSSL, requestURI, headers, request.getTraceOperation(), connectTimeout, idleTimeout, followRedirects, sslOptions, request.getProxyOptions());
    }

    private Future<HttpClientRequest> doRequest(String routingKey, HttpMethod method, HostAndPort authority, Address server, boolean useSSL, String requestURI, MultiMap headers, String traceOperation, long connectTimeout, long idleTimeout, Boolean followRedirects, ClientSSLOptions sslOptions, ProxyOptions proxyConfig) {
        Future<Object> future;
        ContextInternal streamCtx = this.vertx.getOrCreateContext();
        if (this.endpointResolver != null) {
            PromiseInternal<Endpoint> promise = this.vertx.promise();
            this.endpointResolver.lookupEndpoint(server, promise);
            future = promise.future().map(endpoint -> endpoint.selectServer(routingKey)).compose(lookup -> {
                SocketAddress address = lookup.address();
                ProxyOptions proxyOptions = this.computeProxyOptions(proxyConfig, address);
                EndpointKey key = new EndpointKey(useSSL, sslOptions, proxyOptions, address, authority != null ? authority : HostAndPort.create(address.host(), address.port()));
                return this.httpCM.withResourceAsync(key, this.httpEndpointProvider(), (endpoint, created) -> {
                    Future<Lease<HttpClientConnectionInternal>> fut2 = endpoint.requestConnection(streamCtx, connectTimeout);
                    if (fut2 == null) {
                        return null;
                    }
                    ServerInteraction endpointRequest = lookup.newInteraction();
                    return fut2.andThen(ar -> {
                        if (ar.failed()) {
                            endpointRequest.reportFailure(ar.cause());
                        }
                    }).compose(lease -> {
                        HttpClientConnectionInternal conn = (HttpClientConnectionInternal)lease.get();
                        return conn.createStream(streamCtx).map(stream -> {
                            StatisticsGatheringHttpClientStream wrapped = new StatisticsGatheringHttpClientStream((HttpClientStream)stream, endpointRequest);
                            wrapped.closeHandler(v -> lease.recycle());
                            return new ConnectionObtainedResult(proxyOptions, wrapped);
                        });
                    });
                });
            });
        } else if (server instanceof SocketAddress) {
            ProxyOptions proxyOptions = this.computeProxyOptions(proxyConfig, (SocketAddress)server);
            EndpointKey key = new EndpointKey(useSSL, sslOptions, proxyOptions, (SocketAddress)server, authority);
            future = this.httpCM.withResourceAsync(key, this.httpEndpointProvider(), (endpoint, created) -> {
                Future<Lease<HttpClientConnectionInternal>> fut = endpoint.requestConnection(streamCtx, connectTimeout);
                if (fut == null) {
                    return null;
                }
                return fut.compose(lease -> {
                    HttpClientConnectionInternal conn = (HttpClientConnectionInternal)lease.get();
                    return conn.createStream(streamCtx).map(stream -> {
                        stream.closeHandler(v -> lease.recycle());
                        return new ConnectionObtainedResult(proxyOptions, (HttpClientStream)stream);
                    });
                });
            });
        } else {
            future = streamCtx.failedFuture("Cannot resolve address " + server);
        }
        if (future == null) {
            return streamCtx.failedFuture("Cannot resolve address " + server);
        }
        return future.map(res -> {
            RequestOptions options = new RequestOptions();
            options.setMethod(method);
            options.setHeaders(headers);
            options.setURI(requestURI);
            options.setProxyOptions(res.proxyOptions);
            options.setIdleTimeout(idleTimeout);
            options.setFollowRedirects(followRedirects);
            options.setTraceOperation(traceOperation);
            HttpClientStream stream = res.stream;
            return this.createRequest(stream.connection(), stream, options);
        });
    }

    HttpClientRequest createRequest(HttpConnection connection, HttpClientStream stream, RequestOptions options) {
        HttpClientRequestImpl request = new HttpClientRequestImpl(connection, stream);
        request.init(options);
        Function<HttpClientResponse, Future<RequestOptions>> rHandler = this.redirectHandler;
        if (rHandler != null) {
            request.setMaxRedirects(this.options.getMaxRedirects());
            request.redirectHandler((HttpClientResponse resp) -> {
                Future fut_ = (Future)rHandler.apply((HttpClientResponse)resp);
                if (fut_ != null) {
                    return fut_.compose(o -> {
                        o.setProxyOptions(options.getProxyOptions());
                        return this.request((RequestOptions)o);
                    });
                }
                return null;
            });
        }
        return request;
    }

    private static class ConnectionObtainedResult {
        private final ProxyOptions proxyOptions;
        private final HttpClientStream stream;

        public ConnectionObtainedResult(ProxyOptions proxyOptions, HttpClientStream stream) {
            this.proxyOptions = proxyOptions;
            this.stream = stream;
        }
    }

    private static class PoolChecker
    implements Handler<Long> {
        final WeakReference<HttpClientImpl> ref;

        private PoolChecker(HttpClientImpl client) {
            this.ref = new WeakReference<HttpClientImpl>(client);
        }

        @Override
        public void handle(Long event) {
            HttpClientImpl client = (HttpClientImpl)this.ref.get();
            if (client != null) {
                client.checkExpired(this);
            }
        }
    }
}

