/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.vertx.core.Completable;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.impl.clustered.NodeSelector;
import io.vertx.core.eventbus.impl.clustered.selector.NullRoundRobinSelector;
import io.vertx.core.eventbus.impl.clustered.selector.RoundRobinSelector;
import io.vertx.core.eventbus.impl.clustered.selector.SimpleRoundRobinSelector;
import io.vertx.core.eventbus.impl.clustered.selector.Weight;
import io.vertx.core.eventbus.impl.clustered.selector.WeightedRoundRobinSelector;
import io.vertx.core.spi.cluster.ClusteredNode;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultNodeSelector
implements NodeSelector {
    private ClusteredNode clusterManager;
    private final ConcurrentMap<String, Entry> entries = new ConcurrentHashMap<String, Entry>();

    @Override
    public void init(ClusteredNode clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Override
    public void selectForSend(String address, Completable<String> promise) {
        this.selectFor(address, Op.SEND, promise);
    }

    @Override
    public void selectForPublish(String address, Completable<Iterable<String>> promise) {
        this.selectFor(address, Op.PUBLISH, promise);
    }

    @Override
    public boolean wantsUpdatesFor(String address) {
        return this.entries.containsKey(address);
    }

    private <T> void selectFor(String address, Op<T> op, Completable<T> promise) {
        block3: {
            Entry entry;
            while (true) {
                if ((entry = (Entry)this.entries.get(address)) == null) {
                    WaiterEntry<T> head = new WaiterEntry<T>(promise, op);
                    Entry phantom = this.entries.putIfAbsent(address, head);
                    if (phantom != null) continue;
                    this.initialize(head, address, op);
                    break block3;
                }
                if (entry instanceof WaiterEntry) {
                    WaiterEntry<T> next = new WaiterEntry<T>(promise, op, (WaiterEntry)entry);
                    if (!this.entries.replace(address, entry, next)) continue;
                    break block3;
                }
                if (entry instanceof SelectorEntry) break;
            }
            SelectorEntry re = (SelectorEntry)entry;
            promise.succeed(op.selectWith(re.selector));
        }
    }

    private <T> void initialize(WaiterEntry<?> head, String address, Op<T> k) {
        Promise<List<RegistrationInfo>> getPromise = Promise.promise();
        this.clusterManager.getRegistrations(address, getPromise);
        getPromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                this.succeed(head, address, (List)ar.result(), k);
            } else {
                this.fail(head, address, ar.cause());
            }
        });
    }

    private void fail(WaiterEntry<?> head, String address, Throwable cause) {
        Entry entry = (Entry)this.entries.get(address);
        if (entry instanceof WaiterEntry) {
            WaiterEntry<?> tail = (WaiterEntry<?>)entry;
            if (tail.head == head && this.entries.remove(address, tail)) {
                while (tail != null) {
                    tail.waiter.fail(cause);
                    tail = tail.prev;
                }
            }
        }
    }

    private <T> void succeed(WaiterEntry<?> head, String address, List<RegistrationInfo> registrations, Op<T> k) {
        Entry entry;
        List<String> accessible = this.computeAccessible(registrations);
        RoundRobinSelector selector = this.data(accessible);
        while ((entry = (Entry)this.entries.get(address)) != null) {
            if (entry instanceof WaiterEntry) {
                WaiterEntry tail = (WaiterEntry)entry;
                if (tail.head != head) break;
                if (selector != null) {
                    if (!this.entries.replace(address, tail, WaiterEntry.NOOP)) continue;
                    DefaultNodeSelector.broadcastToWaiters(tail, selector);
                    if (this.entries.replace(address, WaiterEntry.NOOP, new SelectorEntry(selector))) break;
                    head = WaiterEntry.NOOP;
                    continue;
                }
                if (!this.entries.remove(address, tail)) continue;
                DefaultNodeSelector.broadcastToWaiters((WaiterEntry)entry, NullRoundRobinSelector.INSTANCE);
                break;
            }
            throw new UnsupportedOperationException("Does this case make sense " + String.valueOf(entry));
        }
    }

    private RoundRobinSelector data(List<String> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return null;
        }
        Map<String, Weight> weights = this.computeWeights(nodeIds);
        RoundRobinSelector selector = this.isEvenlyDistributed(weights) ? new SimpleRoundRobinSelector(new ArrayList<String>(weights.keySet())) : new WeightedRoundRobinSelector(weights);
        return selector;
    }

    private Map<String, Weight> computeWeights(List<String> nodeIds) {
        HashMap<String, Weight> weights = new HashMap<String, Weight>();
        for (String nodeId : nodeIds) {
            weights.compute(nodeId, (s, weight) -> weight == null ? new Weight(0) : weight.increment());
        }
        return weights;
    }

    private boolean isEvenlyDistributed(Map<String, Weight> weights) {
        if (weights.size() > 1) {
            Weight previous = null;
            for (Weight weight : weights.values()) {
                if (previous != null && previous.value() != weight.value()) {
                    return false;
                }
                previous = weight;
            }
        }
        return true;
    }

    private List<String> computeAccessible(List<RegistrationInfo> registrations) {
        if (registrations == null || registrations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(registrations.size());
        for (RegistrationInfo registration : registrations) {
            if (!this.isAccessible(registration)) continue;
            String nodeId = registration.nodeId();
            list.add(nodeId);
        }
        list.trimToSize();
        return list;
    }

    private boolean isAccessible(RegistrationInfo registrationInfo) {
        return !registrationInfo.localOnly() || this.clusterManager.getNodeId().equals(registrationInfo.nodeId());
    }

    @Override
    public void eventBusStarted() {
    }

    @Override
    public void registrationsUpdated(RegistrationUpdateEvent event) {
        Entry entry;
        String address = event.address();
        while ((entry = (Entry)this.entries.get(address)) != null) {
            if (entry instanceof WaiterEntry) {
                throw new UnsupportedOperationException("Is this case valid ?");
            }
            SelectorEntry re = (SelectorEntry)entry;
            List<String> accessible = this.computeAccessible(event.registrations());
            RoundRobinSelector selector = this.data(accessible);
            if (!(selector == null ? this.entries.remove(address, re) : this.entries.replace(address, re, new SelectorEntry(selector)))) continue;
            break;
        }
    }

    private static void broadcastToWaiters(WaiterEntry<?> lastWaiter, RoundRobinSelector selector) {
        ArrayList waiters = new ArrayList();
        WaiterEntry<?> e = lastWaiter;
        while (e != null) {
            waiters.add(e);
            e = e.prev;
        }
        for (int idx = waiters.size() - 1; idx >= 0; --idx) {
            ((WaiterEntry)waiters.get(idx)).complete(selector);
        }
    }

    private static class SelectorEntry
    extends Entry {
        private final RoundRobinSelector selector;

        private SelectorEntry(RoundRobinSelector selector) {
            this.selector = selector;
        }
    }

    private static class WaiterEntry<T>
    extends Entry {
        static final WaiterEntry<?> NOOP = new WaiterEntry<Object>((a, b) -> {}, Op.NOOP);
        private final Completable<T> waiter;
        private final WaiterEntry<?> prev;
        private final WaiterEntry<?> head;
        private final Op<T> op;

        private WaiterEntry(Completable<T> waiter, Op<T> op) {
            this.waiter = waiter;
            this.prev = null;
            this.op = op;
            this.head = this;
        }

        private WaiterEntry(Completable<T> waiter, Op<T> op, WaiterEntry<?> prev) {
            this.waiter = waiter;
            this.prev = prev;
            this.op = op;
            this.head = prev.head;
        }

        void complete(RoundRobinSelector selector) {
            this.waiter.succeed(this.op.selectWith(selector));
        }
    }

    private static abstract class Entry {
        private Entry() {
        }
    }

    private static interface Op<T> {
        public static final Op<String> SEND = RoundRobinSelector::selectForSend;
        public static final Op<Iterable<String>> PUBLISH = RoundRobinSelector::selectForPublish;
        public static final Op<Object> NOOP = selector -> null;

        public T selectWith(RoundRobinSelector var1);
    }
}

