/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.vertx.core.spi.context.storage.AccessMode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
public class AccessModeBenchmark {
    private int index;

    @Setup
    public void setup() {
        this.index = 0;
    }

    @Benchmark
    public Object getOld(FakeLocalStorage fakeLocalStorage) {
        return fakeLocalStorage.get(this.index, OldAccessMode.CONCURRENT);
    }

    @Benchmark
    public void putOld(FakeLocalStorage fakeLocalStorage) {
        fakeLocalStorage.put(this.index, Boolean.TRUE, OldAccessMode.CONCURRENT);
    }

    @Benchmark
    public Object getNew(FakeLocalStorage fakeLocalStorage) {
        return fakeLocalStorage.get(this.index, AccessMode.CONCURRENT);
    }

    @Benchmark
    public void putNew(FakeLocalStorage fakeLocalStorage) {
        fakeLocalStorage.put(this.index, Boolean.TRUE, AccessMode.CONCURRENT);
    }

    public static enum AccessModeType {
        OLD,
        NEW;

    }

    @State(value=Scope.Thread)
    public static class FakeLocalStorage {
        final Object[] locals = new Object[1];

        public Object get(int index, AccessMode accessMode) {
            return accessMode.get(this.locals, index);
        }

        public void put(int index, Object value, AccessMode accessMode) {
            accessMode.put(this.locals, index, value);
        }
    }

    private static interface OldAccessMode {
        public static final AccessMode CONCURRENT = new AccessMode(){
            final VarHandle LOCALS_UPDATER = MethodHandles.arrayElementVarHandle(Object[].class);

            public Object get(Object[] locals, int idx) {
                return this.LOCALS_UPDATER.getVolatile(locals, idx);
            }

            public void put(Object[] locals, int idx, Object value) {
                this.LOCALS_UPDATER.setRelease(locals, idx, value);
            }

            public Object getOrCreate(Object[] locals, int index, Supplier<Object> initialValueSupplier) {
                Object res;
                while ((res = this.LOCALS_UPDATER.getVolatile(locals, index)) == null) {
                    Object initial = initialValueSupplier.get();
                    if (initial == null) {
                        throw new IllegalStateException();
                    }
                    if (!this.LOCALS_UPDATER.compareAndSet(locals, index, null, initial)) continue;
                    res = initial;
                    break;
                }
                return res;
            }
        };
    }
}

