/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.VertxHttpRequestDecoder;
import io.vertx.core.http.impl.VertxHttpResponseEncoder;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.net.impl.VertxHandler;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class HttpServerHandlerBenchmark
extends BenchmarkBase {
    @Param(value={"1"})
    public int pipelining;
    ByteBuf requestsBytes;
    int readerIndex;
    int writeIndex;
    VertxInternal vertx;
    EmbeddedChannel vertxChannel;
    EmbeddedChannel nettyChannel;
    private static final CharSequence RESPONSE_TYPE_PLAIN = HttpHeaders.createOptimized((String)"text/plain");
    private static final String HELLO_WORLD = "Hello, world!";
    private static final Buffer HELLO_WORLD_BUFFER = Buffer.buffer((String)"Hello, world!");
    private static final CharSequence HEADER_SERVER = HttpHeaders.SERVER;
    private static final CharSequence HEADER_DATE = HttpHeaders.DATE;
    private static final CharSequence HEADER_CONTENT_TYPE = HttpHeaders.CONTENT_TYPE;
    private static final CharSequence HEADER_CONTENT_LENGTH = HttpHeaders.CONTENT_LENGTH;
    private static final CharSequence HELLO_WORLD_LENGTH = HttpHeaders.createOptimized((String)("" + "Hello, world!".length()));
    private static final CharSequence SERVER = HttpHeaders.createOptimized((String)"vert.x");
    private static final CharSequence DATE_STRING = HttpHeaders.createOptimized((String)DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(ByteBuf buf) {
    }

    @Setup
    public void setup() {
        this.vertx = (VertxInternal)Vertx.vertx((VertxOptions)new VertxOptions().setDisableTCCL(true));
        HttpServerOptions options = new HttpServerOptions().setStrictThreadMode(true);
        this.vertxChannel = new EmbeddedChannel(new ChannelHandler[]{new VertxHttpRequestDecoder(options), new VertxHttpResponseEncoder()});
        this.vertxChannel.config().setAllocator((ByteBufAllocator)new Alloc());
        ContextInternal context = this.vertx.contextBuilder().withThreadingModel(ThreadingModel.EVENT_LOOP).withEventLoop(this.vertxChannel.eventLoop()).withClassLoader(Thread.currentThread().getContextClassLoader()).build();
        MultiMap headers = HttpHeaders.headers().add(HEADER_CONTENT_TYPE, RESPONSE_TYPE_PLAIN).add(HEADER_SERVER, SERVER).add(HEADER_DATE, DATE_STRING).add(HEADER_CONTENT_LENGTH, HELLO_WORLD_LENGTH).copy(false);
        Handler app = request -> {
            HttpServerResponse response = request.response();
            response.headers().setAll(headers);
            response.end(HELLO_WORLD_BUFFER);
        };
        VertxHandler handler = VertxHandler.create(chctx -> {
            Http1xServerConnection conn = new Http1xServerConnection(ThreadingModel.EVENT_LOOP, () -> context, null, options, chctx, context, "localhost", null);
            conn.handler(app);
            return conn;
        });
        this.vertxChannel.pipeline().addLast("handler", (ChannelHandler)handler);
        this.nettyChannel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(options.getMaxInitialLineLength(), options.getMaxHeaderSize(), options.getMaxChunkSize(), false, options.getDecoderInitialBufferSize()){

            protected boolean isContentAlwaysEmpty(HttpMessage msg) {
                return false;
            }
        }, new HttpResponseEncoder(){

            public boolean acceptOutboundMessage(Object msg) throws Exception {
                if (msg.getClass() == DefaultFullHttpResponse.class) {
                    return true;
                }
                return super.acceptOutboundMessage(msg);
            }
        }, new ChannelInboundHandlerAdapter(){
            private final byte[] STATIC_PLAINTEXT = "Hello, World!".getBytes(CharsetUtil.UTF_8);
            private final int STATIC_PLAINTEXT_LEN = this.STATIC_PLAINTEXT.length;
            private final ByteBuf PLAINTEXT_CONTENT_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer().writeBytes(this.STATIC_PLAINTEXT));
            private final CharSequence PLAINTEXT_CLHEADER_VALUE = new AsciiString((CharSequence)String.valueOf(this.STATIC_PLAINTEXT_LEN));
            private final CharSequence TYPE_PLAIN = new AsciiString((CharSequence)"text/plain");
            private final CharSequence SERVER_NAME = new AsciiString((CharSequence)"Netty");
            private final CharSequence CONTENT_TYPE_ENTITY = HttpHeaderNames.CONTENT_TYPE;
            private final CharSequence DATE_ENTITY = HttpHeaderNames.DATE;
            private final CharSequence CONTENT_LENGTH_ENTITY = HttpHeaderNames.CONTENT_LENGTH;
            private final CharSequence SERVER_ENTITY = HttpHeaderNames.SERVER;
            private final DateFormat FORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z");
            private final CharSequence date = new AsciiString((CharSequence)this.FORMAT.format(new Date()));

            public void channelRead(ChannelHandlerContext ctx, Object o) {
                if (o == LastHttpContent.EMPTY_LAST_CONTENT) {
                    return;
                }
                if (o.getClass() == DefaultHttpRequest.class) {
                    this.writeResponse(ctx, (HttpRequest)((DefaultHttpRequest)o), this.PLAINTEXT_CONTENT_BUFFER.duplicate(), this.TYPE_PLAIN, this.PLAINTEXT_CLHEADER_VALUE);
                } else if (o instanceof HttpRequest) {
                    try {
                        this.writeResponse(ctx, (HttpRequest)o, this.PLAINTEXT_CONTENT_BUFFER.duplicate(), this.TYPE_PLAIN, this.PLAINTEXT_CLHEADER_VALUE);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)o);
                    }
                } else {
                    ReferenceCountUtil.release((Object)o);
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                ctx.flush();
            }

            private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, ByteBuf buf, CharSequence contentType, CharSequence contentLength) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf, false);
                io.netty.handler.codec.http.HttpHeaders headers = response.headers();
                headers.set(this.CONTENT_TYPE_ENTITY, (Object)contentType);
                headers.set(this.SERVER_ENTITY, (Object)this.SERVER_NAME);
                headers.set(this.DATE_ENTITY, (Object)this.date);
                headers.set(this.CONTENT_LENGTH_ENTITY, (Object)contentLength);
                ctx.write((Object)response, ctx.voidPromise());
            }
        }});
        this.nettyChannel.config().setAllocator((ByteBufAllocator)new Alloc());
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.pipelining; ++i) {
            s.append("GET / HTTP/1.1\r\n").append("\r\n");
        }
        this.requestsBytes = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])s.toString().getBytes()));
        this.readerIndex = this.requestsBytes.readerIndex();
        this.writeIndex = this.requestsBytes.writerIndex();
    }

    @Benchmark
    public Object vertx() {
        this.requestsBytes.setIndex(this.readerIndex, this.writeIndex);
        this.vertxChannel.writeInbound(new Object[]{this.requestsBytes});
        return this.vertxChannel.outboundMessages().poll();
    }

    @Fork(value=1, jvmArgsAppend={"-Dvertx.disableContextTimings=true", "-Dvertx.disableHttpHeadersValidation=true", "-Dvertx.disableMetrics=true", "-Dvertx.cacheImmutableHttpResponseHeaders=true", "-Dvertx.internCommonHttpRequestHeadersToLowerCase=true", "-Dio.netty.buffer.checkAccessible=false", "-Dio.netty.buffer.checkBounds=false"})
    @Benchmark
    public Object vertxOpt() {
        this.requestsBytes.setIndex(this.readerIndex, this.writeIndex);
        this.vertxChannel.writeInbound(new Object[]{this.requestsBytes});
        return this.vertxChannel.outboundMessages().poll();
    }

    @Fork(value=1, jvmArgsAppend={"-Dvertx.threadChecks=false", "-Dvertx.disableContextTimings=true", "-Dvertx.disableHttpHeadersValidation=true", "-Dvertx.disableMetrics=false", "-Dio.netty.buffer.checkAccessible=false", "-Dio.netty.buffer.checkBounds=false"})
    @Benchmark
    public Object vertxOptMetricsOn() {
        this.requestsBytes.setIndex(this.readerIndex, this.writeIndex);
        this.vertxChannel.writeInbound(new Object[]{this.requestsBytes});
        return this.vertxChannel.outboundMessages().poll();
    }

    @Benchmark
    public Object netty() {
        this.requestsBytes.setIndex(this.readerIndex, this.writeIndex);
        this.nettyChannel.writeInbound(new Object[]{this.requestsBytes});
        return this.nettyChannel.outboundMessages().poll();
    }

    public static class Alloc
    implements ByteBufAllocator {
        private final ByteBuf buf = Unpooled.buffer((int)512);
        private final int capacity = this.buf.capacity();

        public ByteBuf buffer() {
            this.buf.clear();
            return this.buf;
        }

        public ByteBuf buffer(int initialCapacity) {
            if (initialCapacity <= this.capacity) {
                return this.buffer();
            }
            throw new IllegalArgumentException("Invalid capacity " + initialCapacity + " > " + this.capacity);
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            if (initialCapacity <= this.capacity) {
                return this.buffer();
            }
            throw new IllegalArgumentException();
        }

        public ByteBuf ioBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeHeapBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeDirectBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectBufferPooled() {
            throw new UnsupportedOperationException();
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }
    }
}

