/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.core.spi.json.JsonCodec;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class JsonDecodeBenchmark
extends BenchmarkBase {
    private Buffer small;
    private Buffer wide;
    private Buffer deep;
    private String smallString;
    private String wideString;
    private String deepString;
    private JsonCodec jacksonCodec;
    private JsonCodec databindCodec;

    @Setup
    public void setup() {
        this.small = this.loadJsonAsBuffer("small_bench.json");
        this.wide = this.loadJsonAsBuffer("wide_bench.json");
        this.deep = this.loadJsonAsBuffer("deep_bench.json");
        this.smallString = this.small.toString();
        this.wideString = this.wide.toString();
        this.deepString = this.deep.toString();
        this.jacksonCodec = new JacksonCodec();
        this.databindCodec = new DatabindCodec();
    }

    private Buffer loadJsonAsBuffer(String filename) {
        Buffer buffer;
        block8: {
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream file = classLoader.getResourceAsStream(filename);
            try {
                String str = new BufferedReader(new InputStreamReader(file, StandardCharsets.UTF_8)).lines().collect(Collectors.joining());
                Buffer encoded = Buffer.buffer((String)str);
                buffer = Buffer.buffer().appendBuffer(encoded);
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            file.close();
        }
        return buffer;
    }

    @Benchmark
    public void smallStringJackson(Blackhole blackhole) {
        this.stringJackson(this.smallString, blackhole);
    }

    @Benchmark
    public void smallStringDatabind(Blackhole blackhole) throws Exception {
        this.stringDatabind(this.smallString, blackhole);
    }

    @Benchmark
    public void wideStringJackson(Blackhole blackhole) {
        this.stringJackson(this.wideString, blackhole);
    }

    @Benchmark
    public void wideStringDatabind(Blackhole blackhole) throws Exception {
        this.stringDatabind(this.wideString, blackhole);
    }

    @Benchmark
    public void deepStringJackson(Blackhole blackhole) {
        this.stringJackson(this.deepString, blackhole);
    }

    @Benchmark
    public void deepStringDatabind(Blackhole blackhole) throws Exception {
        this.stringDatabind(this.deepString, blackhole);
    }

    private void stringJackson(String str, Blackhole blackhole) {
        blackhole.consume((Object)new JsonObject(str));
    }

    private void stringDatabind(String str, Blackhole blackhole) {
        blackhole.consume(this.databindCodec.fromString(str, JsonObject.class));
    }

    @Benchmark
    public void smallBufferJackson(Blackhole blackhole) {
        this.bufferJackson(this.small, blackhole);
    }

    @Benchmark
    public void smallBufferDatabind(Blackhole blackhole) throws Exception {
        this.bufferDatabind(this.small, blackhole);
    }

    @Benchmark
    public void wideBufferJackson(Blackhole blackhole) {
        this.bufferJackson(this.wide, blackhole);
    }

    @Benchmark
    public void wideBufferDatabind(Blackhole blackhole) throws Exception {
        this.bufferDatabind(this.wide, blackhole);
    }

    @Benchmark
    public void deepBufferJackson(Blackhole blackhole) {
        this.bufferJackson(this.deep, blackhole);
    }

    @Benchmark
    public void deepBufferDatabind(Blackhole blackhole) throws Exception {
        this.bufferDatabind(this.deep, blackhole);
    }

    private void bufferJackson(Buffer buffer, Blackhole blackhole) {
        blackhole.consume((Object)new JsonObject(buffer));
    }

    private void bufferDatabind(Buffer buffer, Blackhole blackhole) throws Exception {
        blackhole.consume(this.jacksonCodec.fromBuffer(buffer, JsonObject.class));
    }
}

