/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.core.spi.json.JsonCodec;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class JsonEncodeBenchmark
extends BenchmarkBase {
    private JsonObject tiny;
    private JsonObject small;
    private JsonObject wide;
    private JsonObject deep;
    private JsonCodec jacksonCodec;
    private JsonCodec databindCodec;

    @Setup
    public void setup() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.tiny = new JsonObject(Map.of("message", "Hello, World!"));
        this.small = this.loadJson(classLoader.getResource("small_bench.json"));
        this.wide = this.loadJson(classLoader.getResource("wide_bench.json"));
        this.deep = this.loadJson(classLoader.getResource("deep_bench.json"));
        this.jacksonCodec = new JacksonCodec();
        this.databindCodec = new DatabindCodec();
    }

    private JsonObject loadJson(URL url) {
        try {
            return new JsonObject((Map)new ObjectMapper().readValue(url, Map.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    public String smallStringJackson() {
        return this.stringJackson(this.small);
    }

    @Benchmark
    public String smallStringDatabind() {
        return this.stringDatabind(this.small);
    }

    @Benchmark
    public String wideStringJackson() {
        return this.stringJackson(this.wide);
    }

    @Benchmark
    public String wideStringDatabind() {
        return this.stringDatabind(this.wide);
    }

    @Benchmark
    public String deepStringJackson() {
        return this.stringJackson(this.deep);
    }

    @Benchmark
    public String deepStringDatabind() {
        return this.stringDatabind(this.deep);
    }

    @CompilerControl(value=CompilerControl.Mode.INLINE)
    private String stringJackson(JsonObject jsonObject) {
        return this.jacksonCodec.toString((Object)jsonObject);
    }

    @CompilerControl(value=CompilerControl.Mode.INLINE)
    private String stringDatabind(JsonObject jsonObject) {
        return this.databindCodec.toString((Object)jsonObject);
    }

    @Benchmark
    public Buffer tinyBufferJackson() {
        return this.bufferJackson(this.tiny);
    }

    @Benchmark
    public Buffer smallBufferJackson() {
        return this.bufferJackson(this.small);
    }

    @Benchmark
    public Buffer smallBufferDatabind() {
        return this.bufferDatabind(this.small);
    }

    @Benchmark
    public Buffer deepBufferJackson() {
        return this.bufferJackson(this.deep);
    }

    @Benchmark
    public Buffer deepBufferDatabind() {
        return this.bufferDatabind(this.deep);
    }

    @Benchmark
    public Buffer wideBufferJackson() {
        return this.bufferJackson(this.wide);
    }

    @Benchmark
    public Buffer wideBufferDatabind() {
        return this.bufferDatabind(this.wide);
    }

    @CompilerControl(value=CompilerControl.Mode.INLINE)
    private Buffer bufferJackson(JsonObject jsonObject) {
        return this.jacksonCodec.toBuffer((Object)jsonObject);
    }

    @CompilerControl(value=CompilerControl.Mode.INLINE)
    private Buffer bufferDatabind(JsonObject jsonObject) {
        return this.databindCodec.toBuffer((Object)jsonObject);
    }
}

