/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.impl.buffer.VertxByteBufAllocator;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import org.junit.Assume;
import org.junit.Test;

public class TcpAllocationTest
extends VertxTestBase {
    @Test
    public void testByteBufOriginateFromDefaultByteBufAllocator() {
        this.testByteBufOriginateFromDefaultByteBufAllocator(null);
    }

    @Test
    public void testByteBufOriginateFromDefaultByteBufAllocatorWithJdkSsl() {
        this.testByteBufOriginateFromDefaultByteBufAllocator((SSLEngineOptions)new JdkSSLEngineOptions());
    }

    @Test
    public void testByteBufOriginateFromDefaultByteBufAllocatorWithOpenSsl() {
        Assume.assumeTrue((boolean)OpenSSLEngineOptions.isAvailable());
        this.testByteBufOriginateFromDefaultByteBufAllocator((SSLEngineOptions)new OpenSSLEngineOptions());
    }

    private void testByteBufOriginateFromDefaultByteBufAllocator(SSLEngineOptions sslEngineOptions) {
        NetServer server = this.vertx.createNetServer(new NetServerOptions().setSsl(sslEngineOptions != null).setSslEngineOptions(sslEngineOptions).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()));
        server.connectHandler(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.messageHandler(msg -> {
                try {
                    ByteBuf bbuf = (ByteBuf)msg;
                    this.assertSame(VertxByteBufAllocator.POOLED_ALLOCATOR, bbuf.alloc());
                }
                finally {
                    ReferenceCountUtil.release((Object)msg);
                }
                soi.write((Object)Buffer.buffer((String)"pong"));
            });
        });
        server.listen(1234, "localhost").await();
        NetClient client = this.vertx.createNetClient(new NetClientOptions().setSsl(sslEngineOptions != null).setTrustAll(true).setHostnameVerificationAlgorithm(""));
        NetSocketInternal soi = (NetSocketInternal)client.connect(1234, "localhost").await();
        soi.messageHandler(msg -> {
            try {
                ByteBuf bbuf = (ByteBuf)msg;
                this.assertSame(VertxByteBufAllocator.POOLED_ALLOCATOR, bbuf.alloc());
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
            this.testComplete();
        });
        soi.write((Object)Buffer.buffer((String)"ping"));
        this.await();
    }

    @Test
    public void testByteBufCopyAndRelease() {
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> so.handler(buff -> {
            ByteBuf byteBuf = ((BufferImpl)buff).byteBuf();
            this.assertFalse(byteBuf.isDirect());
            this.assertFalse(byteBuf.alloc().isDirectBufferPooled());
            this.testComplete();
        }));
        server.listen(1234, "localhost").await();
        NetClient client = this.vertx.createNetClient();
        NetSocket so2 = (NetSocket)client.connect(1234, "localhost").await();
        so2.write((Object)Buffer.buffer((String)"ping"));
        this.await();
    }
}

