/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.eventexecutor;

import io.vertx.core.Context;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.it.eventexecutor.CustomEventExecutorProvider;
import io.vertx.it.eventexecutor.CustomThread;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomEventExecutorTest {
    private Vertx vertx;
    private Context context;

    @Before
    public void before() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void after() {
        this.vertx.close();
    }

    @Test
    public void testCustomEventExecutor() throws Exception {
        CustomThread thread = new CustomThread(() -> {
            this.context = this.vertx.getOrCreateContext();
        });
        thread.start();
        thread.join();
        Assert.assertEquals((Object)ThreadingModel.EXTERNAL, (Object)this.context.threadingModel());
        int[] executions = new int[1];
        this.context.runOnContext(v -> {
            executions[0] = executions[0] + 1;
        });
        Assert.assertTrue((boolean)CustomEventExecutorProvider.hasNext());
        Runnable runnable = CustomEventExecutorProvider.next();
        runnable.run();
        Assert.assertFalse((boolean)CustomEventExecutorProvider.hasNext());
        Assert.assertEquals((long)1L, (long)executions[0]);
    }
}

