/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.json;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.http.HttpTestBase;
import org.junit.Test;

public class NoJacksonTest
extends VertxTestBase {
    @Test
    public void testJsonObject() {
        JsonObject obj = new JsonObject();
        obj.put("foo", (Object)"bar");
        try {
            obj.toString();
            this.fail();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.assertTrue(obj.containsKey("foo"));
        this.assertEquals(obj, obj.copy());
    }

    @Test
    public void testJsonArray() {
        JsonArray array = new JsonArray();
        array.add((Object)"foo");
        try {
            array.toString();
            this.fail();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.assertTrue(array.contains((Object)"foo"));
        this.assertEquals(array, array.copy());
    }

    @Test
    public void testHttp() {
        try (Vertx vertx = Vertx.vertx();){
            vertx.createHttpServer().requestHandler(req -> req.response().end("hello")).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(s -> {
                HttpClientAgent client = vertx.createHttpClient();
                client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
                    this.assertEquals("hello", body.toString());
                    this.testComplete();
                }));
            }));
            this.await();
        }
    }

    @Test
    public void testEventBus() {
        try (Vertx vertx = Vertx.vertx();){
            EventBus eb = vertx.eventBus();
            eb.consumer("the-address", msg -> {
                this.assertEquals("ping", msg.body());
                msg.reply((Object)"pong");
            });
            eb.request("the-address", (Object)"ping").onComplete(this.onSuccess(resp -> {
                this.assertEquals("pong", resp.body());
                this.testComplete();
            }));
            this.await();
        }
    }
}

