/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.metrics;

import io.vertx.core.Vertx;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.test.fakemetrics.FakeVertxMetrics;
import org.junit.Assert;
import org.junit.Test;

public class ServiceLoaderTest {
    @Test
    public void testMetricsFromServiceLoader() {
        this.testMetricsFromServiceLoader(true);
    }

    @Test
    public void testMetricsFromServiceLoaderDisabled() {
        this.testMetricsFromServiceLoader(false);
    }

    private void testMetricsFromServiceLoader(boolean enabled) {
        MetricsOptions metricsOptions = new MetricsOptions().setEnabled(enabled);
        VertxOptions options = new VertxOptions().setMetricsOptions(metricsOptions);
        Vertx vertx = Vertx.vertx((VertxOptions)options);
        VertxMetrics metrics = ((VertxInternal)vertx).metrics();
        if (enabled) {
            Assert.assertNotNull((Object)metrics);
            Assert.assertTrue((boolean)(metrics instanceof FakeVertxMetrics));
            Assert.assertEquals((Object)metricsOptions.isEnabled(), (Object)((FakeVertxMetrics)metrics).options().isEnabled());
        } else {
            Assert.assertNull((Object)metrics);
        }
    }

    @Test
    public void testSetMetricsInstanceTakesPrecedenceOverServiceLoader() {
        VertxMetrics metrics = new VertxMetrics(){};
        VertxBuilder builder = Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(options -> metrics);
        Vertx vertx = builder.build();
        Assert.assertSame((Object)metrics, (Object)((VertxInternal)vertx).metrics());
    }
}

