/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.net;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.http.HttpTestBase;
import org.junit.Test;

public class HAProxyTest
extends VertxTestBase {
    @Test
    public void testHttpWithoutHAProxyOnTheClassPath() {
        ClassLoader cl = Vertx.class.getClassLoader();
        try {
            cl.loadClass("io.netty.handler.codec.haproxy.HAProxyMessage");
            this.fail();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try (Vertx vertx = Vertx.vertx();){
            vertx.createHttpServer(new HttpServerOptions().setUseProxyProtocol(true)).requestHandler(req -> req.response().end("hello")).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(s -> {
                HttpClientAgent client = vertx.createHttpClient();
                client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
                    this.assertEquals("hello", body.toString());
                    this.testComplete();
                }));
            }));
            this.await();
        }
    }
}

