/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.netty;

import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import org.junit.Test;

public class NettyCompatTest
extends VertxTestBase {
    @Test
    public void testAddressResolver() {
        VertxInternal vertx = (VertxInternal)this.vertx;
        vertx.nameResolver().resolve("localhost").onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testHttp2() {
        this.vertx.createHttpServer(new HttpServerOptions().setUseAlpn(true).setSsl(true).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions()).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get())).requestHandler(req -> req.response().end("OK")).listen(8443, "localhost").onComplete(this.onSuccess(s -> {
            HttpClientAgent client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()));
            client.request(HttpMethod.GET, 8443, "localhost", "/somepath").compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(buff -> {
                this.assertEquals("OK", buff.toString());
                this.testComplete();
            });
        }));
        this.await();
    }
}

