/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.tls;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.test.tls.Cert;
import org.junit.Assert;
import org.junit.Test;

public class ConnectToTLSTrustedServerTest {
    @Test
    public void testHTTP1x() throws Exception {
        String val = this.testHTTP(new HttpServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()), new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_1_1));
        Assert.assertEquals((Object)"true/HTTP_1_1", (Object)val);
    }

    @Test
    public void testHTTP2() throws Exception {
        String val = this.testHTTP(new HttpServerOptions().setUseAlpn(true).setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()), new HttpClientOptions().setUseAlpn(true).setProtocolVersion(HttpVersion.HTTP_2));
        Assert.assertEquals((Object)"true/HTTP_2", (Object)val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testHTTP(HttpServerOptions serverOptions, HttpClientOptions clientOptions) throws Exception {
        try (Vertx vertx = Vertx.vertx();){
            HttpServer server = vertx.createHttpServer(serverOptions).requestHandler(req -> req.response().end(req.isSSL() + "/" + String.valueOf(req.version())));
            server.listen(8443, "localhost").await();
            HttpClientAgent client = vertx.createHttpClient(new HttpClientOptions().setUseAlpn(true).setProtocolVersion(HttpVersion.HTTP_2));
            Future fut = client.request(new RequestOptions().setAbsoluteURI("https://localhost:8443"));
            Future buff = fut.compose(req -> req.send().compose(HttpClientResponse::body));
            String string = ((Buffer)buff.await()).toString();
            return string;
        }
    }
}

