/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.spi.transport.Transport;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.FileDescriptorLeakDetectorRule;
import io.vertx.test.core.RepeatRule;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Rule;

public class VertxTestBase
extends AsyncTestBase {
    public static final io.vertx.core.transport.Transport TRANSPORT;
    public static final boolean USE_DOMAIN_SOCKETS;
    public static final boolean USE_JAVA_MODULES;
    private static final Logger log;
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    @Rule
    public FileDescriptorLeakDetectorRule fileDescriptorLeakDetectorRule = new FileDescriptorLeakDetectorRule();
    protected Vertx vertx;
    protected Vertx[] vertices;
    private List<Vertx> created;
    protected static final String[] ENABLED_CIPHER_SUITES;

    protected void vinit() {
        this.vertx = null;
        this.vertices = null;
        this.created = null;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vinit();
        VertxOptions options = this.getOptions();
        boolean nativeTransport = options.getPreferNativeTransport();
        this.vertx = this.vertx(options);
        if (nativeTransport && !this.vertx.isNativeTransportEnabled()) {
            if (!this.vertx.isNativeTransportEnabled()) {
                AssertionFailedError afe = new AssertionFailedError("Expected native transport");
                Throwable cause = this.vertx.unavailableNativeTransportCause();
                if (cause != null) {
                    afe.initCause(cause);
                }
                throw afe;
            }
            this.assertTrue(this.vertx.isNativeTransportEnabled());
        }
    }

    protected VertxTracer getTracer() {
        return null;
    }

    protected VertxMetricsFactory getMetrics() {
        return null;
    }

    protected VertxOptions getOptions() {
        return new VertxOptions();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.created != null) {
            this.close(this.created);
        }
        FakeClusterManager.reset();
        super.tearDown();
    }

    protected void close(List<Vertx> instances) throws Exception {
        CountDownLatch latch = new CountDownLatch(instances.size());
        for (Vertx instance : instances) {
            instance.close().onComplete(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to shutdown vert.x", ar.cause());
                }
                latch.countDown();
            });
        }
        Assert.assertTrue((boolean)latch.await(180L, TimeUnit.SECONDS));
    }

    protected final boolean isVirtualThreadAvailable() {
        return ((VertxInternal)this.vertx).isVirtualThreadAvailable();
    }

    protected Vertx vertx() {
        return this.vertx(new VertxOptions());
    }

    protected VertxBuilder createVertxBuilder(VertxOptions options) {
        VertxMetricsFactory metrics;
        VertxBuilder builder = Vertx.builder();
        VertxTracer tracer = this.getTracer();
        if (tracer != null) {
            builder.withTracer(o -> tracer);
            options = new VertxOptions(options).setTracingOptions(new TracingOptions());
        }
        if ((metrics = this.getMetrics()) != null) {
            builder.withMetrics(metrics);
            options = new VertxOptions(options).setMetricsOptions(new MetricsOptions().setEnabled(true));
        }
        builder.withTransport(TRANSPORT);
        return builder.with(options);
    }

    protected Vertx createVertx(VertxOptions options) {
        Vertx vertx = this.createVertxBuilder(options).build();
        if (TRANSPORT != io.vertx.core.transport.Transport.NIO && !vertx.isNativeTransportEnabled()) {
            this.fail(vertx.unavailableNativeTransportCause());
        }
        return vertx;
    }

    protected Vertx vertx(VertxOptions options) {
        return this.vertx(() -> this.createVertx(options));
    }

    protected Vertx vertx(Supplier<Vertx> supplier) {
        if (this.created == null) {
            this.created = Collections.synchronizedList(new ArrayList());
        }
        Vertx vertx = supplier.get();
        this.created.add(vertx);
        return vertx;
    }

    protected Future<Vertx> clusteredVertx(VertxOptions options) {
        return this.clusteredVertx(options, this.getClusterManager());
    }

    protected Future<Vertx> clusteredVertx(VertxOptions options, ClusterManager clusterManager) {
        if (this.created == null) {
            this.created = Collections.synchronizedList(new ArrayList());
        }
        if (clusterManager == null) {
            clusterManager = new FakeClusterManager();
        }
        return this.createVertxBuilder(options).withClusterManager(clusterManager).buildClustered().andThen(event -> {
            if (event.succeeded()) {
                this.created.add((Vertx)event.result());
            }
        });
    }

    protected ClusterManager getClusterManager() {
        return null;
    }

    protected void startNodes(int numNodes) {
        this.startNodes(numNodes, this.getOptions());
    }

    protected void startNodes(int numNodes, VertxOptions options) {
        this.startNodes(numNodes, options, this::getClusterManager);
    }

    protected void startNodes(int numNodes, Supplier<ClusterManager> clusterManagerSupplier) {
        this.startNodes(numNodes, new VertxOptions(), clusterManagerSupplier);
    }

    private void startNodes(int numNodes, VertxOptions options, Supplier<ClusterManager> clusterManagerSupplier) {
        CountDownLatch latch = new CountDownLatch(numNodes);
        this.vertices = new Vertx[numNodes];
        int i = 0;
        while (i < numNodes) {
            int index = i++;
            VertxOptions toUse = new VertxOptions(options);
            toUse.getEventBusOptions().setHost("localhost").setPort(0);
            this.clusteredVertx(toUse, clusterManagerSupplier.get()).onComplete(ar -> {
                try {
                    if (ar.failed()) {
                        ar.cause().printStackTrace();
                    }
                    this.assertTrue("Failed to start node", ar.succeeded());
                    this.vertices[index] = (Vertx)ar.result();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            this.assertTrue(latch.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            this.fail(e.getMessage());
        }
    }

    protected static void setOptions(TCPSSLOptions sslOptions, KeyCertOptions options) {
        sslOptions.setKeyCertOptions(options);
    }

    protected Context createWorker() throws Exception {
        final CompletableFuture fut = new CompletableFuture();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() throws Exception {
                fut.complete(this.context);
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER)).onComplete(ar -> {
            if (ar.failed()) {
                fut.completeExceptionally(ar.cause());
            }
        });
        return (Context)fut.get();
    }

    protected List<Context> createWorkers(int num) throws Exception {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (int i = 0; i < num; ++i) {
            contexts.add(this.createWorker());
        }
        return contexts;
    }

    protected void assertOnIOContext(Context context) {
        Context current = Vertx.currentContext();
        this.assertNotNull(current);
        this.assertSameEventLoop(context, current);
    }

    static {
        USE_DOMAIN_SOCKETS = Boolean.getBoolean("vertx.useDomainSockets");
        USE_JAVA_MODULES = VertxTestBase.class.getModule().isNamed();
        log = LoggerFactory.getLogger(VertxTestBase.class);
        io.vertx.core.transport.Transport transport = null;
        final String transportName = System.getProperty("vertx.transport");
        if (transportName != null) {
            String t;
            switch (t = transportName.toLowerCase(Locale.ROOT)) {
                case "jdk": {
                    transport = io.vertx.core.transport.Transport.NIO;
                    break;
                }
                case "kqueue": {
                    transport = io.vertx.core.transport.Transport.KQUEUE;
                    break;
                }
                case "epoll": {
                    transport = io.vertx.core.transport.Transport.EPOLL;
                    break;
                }
                case "io_uring": {
                    transport = io.vertx.core.transport.Transport.IO_URING;
                    break;
                }
                default: {
                    transport = new io.vertx.core.transport.Transport(){

                        public String name() {
                            return transportName;
                        }

                        public boolean available() {
                            return false;
                        }

                        public Throwable unavailabilityCause() {
                            return new RuntimeException("Transport " + transportName + " does not exist");
                        }

                        public Transport implementation() {
                            throw new IllegalStateException("Transport " + transportName + " does not exist");
                        }
                    };
                }
            }
            if (transport == null) {
                transport = new io.vertx.core.transport.Transport(){

                    public String name() {
                        return t;
                    }

                    public boolean available() {
                        return false;
                    }

                    public Throwable unavailabilityCause() {
                        return new IllegalStateException("Transport " + t + " not available");
                    }

                    public Transport implementation() {
                        return null;
                    }
                };
            }
        } else {
            transport = io.vertx.core.transport.Transport.NIO;
        }
        TRANSPORT = transport;
        String[] suites = new String[]{};
        try {
            suites = SSLContext.getDefault().getSocketFactory().getSupportedCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        ENABLED_CIPHER_SUITES = suites;
    }
}

