/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakedns;

import io.vertx.test.fakedns.DnsMessageEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.dns.io.encoder.ResourceRecordEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.protocol.DnsTcpDecoder;
import org.apache.directory.server.dns.protocol.DnsUdpDecoder;
import org.apache.directory.server.dns.protocol.DnsUdpEncoder;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public final class FakeDNSServer
extends DnsServer {
    public static final int PORT = 53530;
    public static final String IP_ADDRESS = "127.0.0.1";
    private String ipAddress = "127.0.0.1";
    private int port = 53530;
    private volatile RecordStore store;
    private List<IoAcceptor> acceptors;
    private final Deque<DnsMessage> currentMessage = new ArrayDeque<DnsMessage>();
    private static final ResourceRecordEncoder TestAAAARecordEncoder = new ResourceRecordEncoder(){

        protected void putResourceRecordData(IoBuffer ioBuffer, ResourceRecord resourceRecord) {
            if (!resourceRecord.get("apacheDnsIpAddress").equals("::1")) {
                throw new IllegalStateException("Only supposed to be used with IPV6 address of ::1");
            }
            ioBuffer.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        }
    };
    private final DnsMessageEncoder encoder = new DnsMessageEncoder();

    public static RecordStore A_store(Map<String, String> entries) {
        return questionRecord -> entries.entrySet().stream().map(entry -> FakeDNSServer.a((String)entry.getKey(), 100).ipAddress((String)entry.getValue())).collect(Collectors.toSet());
    }

    public static RecordStore A_store(Function<String, String> entries) {
        return questionRecord -> {
            String res = (String)entries.apply(questionRecord.getDomainName());
            if (res != null) {
                return Collections.singleton(FakeDNSServer.a(questionRecord.getDomainName(), 100).ipAddress(res));
            }
            return Collections.emptySet();
        };
    }

    public RecordStore store() {
        return this.store;
    }

    public FakeDNSServer store(RecordStore store) {
        this.store = store;
        return this;
    }

    public synchronized DnsMessage pollMessage() {
        return this.currentMessage.poll();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.getTransports()[0].getAcceptor().getLocalAddress();
    }

    public FakeDNSServer ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public FakeDNSServer port(int p) {
        this.port = p;
        return this;
    }

    public FakeDNSServer testResolveA(String ipAddress) {
        return this.testResolveA(Collections.singletonMap("vertx.io", ipAddress));
    }

    public FakeDNSServer testResolveA(Map<String, String> entries) {
        return this.store(FakeDNSServer.A_store(entries));
    }

    public FakeDNSServer testResolveA(Function<String, String> entries) {
        return this.store(FakeDNSServer.A_store(entries));
    }

    public FakeDNSServer testResolveAAAA(String ipAddress) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.aaaa("vertx.io", 100).ipAddress(ipAddress)));
    }

    public FakeDNSServer testResolveMX(int prio, String mxRecord) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.mx("vertx.io", 100).set("apacheDnsMxPreference", String.valueOf(prio)).set("apacheDnsDomainName", mxRecord)));
    }

    public FakeDNSServer testResolveTXT(String txt) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.txt("vertx.io", 100).set("apacheDnsCharacterString", txt)));
    }

    public FakeDNSServer testResolveNS(String ns) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.ns("vertx.io", 100).set("apacheDnsDomainName", ns)));
    }

    public FakeDNSServer testResolveCNAME(String cname) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.cname("vertx.io", 100).set("apacheDnsDomainName", cname)));
    }

    public FakeDNSServer testResolvePTR(String ptr) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.ptr("vertx.io", 100).set("apacheDnsDomainName", ptr)));
    }

    public FakeDNSServer testResolveSRV(String name, int priority, int weight, int port, String target) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.srv(name, 100).set("apacheDnsServicePriority", priority).set("apacheDnsServiceWeight", weight).set("apacheDnsServicePort", port).set("apacheDnsDomainName", target)));
    }

    public FakeDNSServer testResolveDNAME(String dname) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.dname("vertx.io", 100).set("apacheDnsDomainName", dname)));
    }

    public FakeDNSServer testResolveSRV2(int priority, int weight, int basePort, String target) {
        return this.store(questionRecord -> IntStream.range(0, 2).mapToObj(i -> FakeDNSServer.srv(target, 100).set("apacheDnsServicePriority", priority).set("apacheDnsServiceWeight", weight).set("apacheDnsServicePort", basePort + i).set("apacheDnsDomainName", "svc" + i + ".vertx.io.")).collect(Collectors.toSet()));
    }

    public static Record a(String domainName, int ttl) {
        return new Record(domainName, RecordType.A, RecordClass.IN, ttl);
    }

    public static Record aaaa(String domainName, int ttl) {
        return new Record(domainName, RecordType.AAAA, RecordClass.IN, ttl);
    }

    public static Record mx(String domainName, int ttl) {
        return new Record(domainName, RecordType.MX, RecordClass.IN, ttl);
    }

    public static Record txt(String domainName, int ttl) {
        return new Record(domainName, RecordType.TXT, RecordClass.IN, ttl);
    }

    public static Record ns(String domainName, int ttl) {
        return new Record(domainName, RecordType.NS, RecordClass.IN, ttl);
    }

    public static Record cname(String domainName, int ttl) {
        return new Record(domainName, RecordType.CNAME, RecordClass.IN, ttl);
    }

    public static Record ptr(String domainName, int ttl) {
        return new Record(domainName, RecordType.PTR, RecordClass.IN, ttl);
    }

    public static Record srv(String domainName, int ttl) {
        return new Record(domainName, RecordType.SRV, RecordClass.IN, ttl);
    }

    public static Record dname(String domainName, int ttl) {
        return new Record(domainName, RecordType.DNAME, RecordClass.IN, ttl);
    }

    public static Record record(String domainName, RecordType recordType, RecordClass recordClass, int ttl) {
        return new Record(domainName, recordType, recordClass, ttl);
    }

    public FakeDNSServer testLookup4(String ip) {
        return this.store(questionRecord -> {
            HashSet<Record> set = new HashSet<Record>();
            if (questionRecord.getRecordType() == RecordType.A) {
                set.add(FakeDNSServer.a("vertx.io", 100).ipAddress(ip));
            }
            return set;
        });
    }

    public FakeDNSServer testLookup6(String ip) {
        return this.store(questionRecord -> {
            HashSet<Record> set = new HashSet<Record>();
            if (questionRecord.getRecordType() == RecordType.AAAA) {
                set.add(FakeDNSServer.aaaa("vertx.io", 100).ipAddress(ip));
            }
            return set;
        });
    }

    public FakeDNSServer testLookupNonExisting() {
        return this.store(questionRecord -> null);
    }

    public FakeDNSServer testReverseLookup(String ptr) {
        return this.store(questionRecord -> Collections.singleton(FakeDNSServer.ptr(ptr, 100).set("apacheDnsDomainName", "vertx.io")));
    }

    public FakeDNSServer testResolveASameServer(String ipAddress) {
        return this.store(FakeDNSServer.A_store(Collections.singletonMap("vertx.io", ipAddress)));
    }

    public FakeDNSServer testLookup4CNAME(String cname, String ip) {
        return this.store(questionRecord -> {
            LinkedHashSet<Record> set = new LinkedHashSet<Record>();
            ResourceRecordModifier rm = new ResourceRecordModifier();
            set.add(FakeDNSServer.cname("vertx.io", 100).set("apacheDnsDomainName", cname));
            set.add(FakeDNSServer.a(cname, 100).ipAddress(ip));
            return set;
        });
    }

    public void start() throws IOException {
        DnsProtocolHandler handler = new DnsProtocolHandler(this, question -> {
            RecordStore actual = this.store;
            if (actual == null) {
                return Collections.emptySet();
            }
            return actual.getRecords(question);
        }){

            public void sessionCreated(IoSession session) {
                if (session.getTransportMetadata().isConnectionless()) {
                    session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TestDnsProtocolUdpCodecFactory()));
                } else {
                    session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TestDnsProtocolTcpCodecFactory()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageReceived(IoSession session, Object message) {
                if (message instanceof DnsMessage) {
                    FakeDNSServer fakeDNSServer = FakeDNSServer.this;
                    synchronized (fakeDNSServer) {
                        FakeDNSServer.this.currentMessage.add((DnsMessage)message);
                    }
                }
                super.messageReceived(session, message);
            }
        };
        UdpTransport udpTransport = new UdpTransport(this.ipAddress, this.port);
        udpTransport.getAcceptor().getSessionConfig().setReuseAddress(true);
        TcpTransport tcpTransport = new TcpTransport(this.ipAddress, this.port);
        tcpTransport.getAcceptor().getSessionConfig().setReuseAddress(true);
        this.setTransports(new Transport[]{udpTransport, tcpTransport});
        for (Transport transport : this.getTransports()) {
            IoAcceptor acceptor = transport.getAcceptor();
            acceptor.setHandler((IoHandler)handler);
            acceptor.bind();
        }
    }

    public void stop() {
        for (Transport transport : this.getTransports()) {
            transport.getAcceptor().dispose();
        }
    }

    private void encode(DnsMessage dnsMessage, IoBuffer buf) {
        if (dnsMessage.getAnswerRecords().size() == 1 && dnsMessage.getAnswerRecords().get(0) instanceof VertxResourceRecord) {
            VertxResourceRecord vrr = (VertxResourceRecord)dnsMessage.getAnswerRecords().get(0);
            DnsMessageModifier modifier = new DnsMessageModifier();
            modifier.setTransactionId(dnsMessage.getTransactionId());
            modifier.setMessageType(dnsMessage.getMessageType());
            modifier.setOpCode(dnsMessage.getOpCode());
            modifier.setAuthoritativeAnswer(dnsMessage.isAuthoritativeAnswer());
            modifier.setTruncated(dnsMessage.isTruncated());
            modifier.setRecursionDesired(dnsMessage.isRecursionDesired());
            modifier.setRecursionAvailable(dnsMessage.isRecursionAvailable());
            modifier.setReserved(dnsMessage.isReserved());
            modifier.setAcceptNonAuthenticatedData(dnsMessage.isAcceptNonAuthenticatedData());
            modifier.setResponseCode(dnsMessage.getResponseCode());
            modifier.setQuestionRecords(dnsMessage.getQuestionRecords());
            modifier.setAnswerRecords(dnsMessage.getAnswerRecords());
            modifier.setAuthorityRecords(dnsMessage.getAuthorityRecords());
            modifier.setAdditionalRecords(dnsMessage.getAdditionalRecords());
            modifier.setTruncated(vrr.isTruncated);
            dnsMessage = modifier.getDnsMessage();
        }
        this.encoder.encode(buf, dnsMessage);
        for (ResourceRecord record : dnsMessage.getAnswerRecords()) {
            if (record.getRecordType() != RecordType.AAAA) continue;
            try {
                TestAAAARecordEncoder.put(buf, record);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void addRecordsToStore(String domainName, String ... entries) {
        LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>();
        Function<String, ResourceRecord> createRecord = ipAddress -> new VertxResourceRecord(domainName, (String)ipAddress);
        for (String e : entries) {
            records.add(createRecord.apply(e));
        }
        this.store(x -> records);
    }

    private final class TestDnsProtocolTcpCodecFactory
    implements ProtocolCodecFactory {
        private TestDnsProtocolTcpCodecFactory() {
        }

        public ProtocolEncoder getEncoder(IoSession session) throws Exception {
            return new DnsUdpEncoder(){

                public void encode(IoSession session, Object message, ProtocolEncoderOutput out) {
                    IoBuffer buf = IoBuffer.allocate((int)1024);
                    buf.putShort((short)0);
                    FakeDNSServer.this.encode((DnsMessage)message, buf);
                    FakeDNSServer.this.encoder.encode(buf, (DnsMessage)message);
                    int end = buf.position();
                    short recordLength = (short)(end - 2);
                    buf.rewind();
                    buf.putShort(recordLength);
                    buf.position(end);
                    buf.flip();
                    out.write((Object)buf);
                }
            };
        }

        public ProtocolDecoder getDecoder(IoSession session) throws Exception {
            return new DnsTcpDecoder();
        }
    }

    private final class TestDnsProtocolUdpCodecFactory
    implements ProtocolCodecFactory {
        private TestDnsProtocolUdpCodecFactory() {
        }

        public ProtocolEncoder getEncoder(IoSession session) throws Exception {
            return new DnsUdpEncoder(){

                public void encode(IoSession session, Object message, ProtocolEncoderOutput out) {
                    IoBuffer buf = IoBuffer.allocate((int)1024);
                    FakeDNSServer.this.encode((DnsMessage)message, buf);
                    buf.flip();
                    out.write((Object)buf);
                }
            };
        }

        public ProtocolDecoder getDecoder(IoSession session) throws Exception {
            return new DnsUdpDecoder();
        }
    }

    public static class VertxResourceRecord
    implements ResourceRecord {
        private final String ipAddress;
        private final String domainName;
        private boolean isTruncated;

        public VertxResourceRecord(String domainName, String ipAddress) {
            this.domainName = domainName;
            this.ipAddress = ipAddress;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public VertxResourceRecord setTruncated(boolean truncated) {
            this.isTruncated = truncated;
            return this;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public RecordType getRecordType() {
            return RecordType.A;
        }

        public RecordClass getRecordClass() {
            return RecordClass.IN;
        }

        public int getTimeToLive() {
            return 100;
        }

        public String get(String id) {
            return "apacheDnsIpAddress".equals(id) ? this.ipAddress : null;
        }
    }

    public static class Record
    extends HashMap<String, String>
    implements ResourceRecord {
        private final String domainName;
        private final RecordType recordType;
        private final RecordClass recordClass;
        private final int ttl;

        public Record(String domainName, RecordType recordType, RecordClass recordClass, int ttl) {
            this.domainName = domainName;
            this.recordType = recordType;
            this.recordClass = recordClass;
            this.ttl = ttl;
        }

        public Record ipAddress(String ipAddress) {
            return this.set("apacheDnsIpAddress", ipAddress);
        }

        public Record set(String name, Object value) {
            this.put(name, String.valueOf(value));
            return this;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public RecordType getRecordType() {
            return this.recordType;
        }

        public RecordClass getRecordClass() {
            return this.recordClass;
        }

        public int getTimeToLive() {
            return this.ttl;
        }

        public String get(String id) {
            return (String)this.get((Object)id);
        }
    }
}

