/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakeloadbalancer;

import io.vertx.core.net.endpoint.InteractionMetrics;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.net.endpoint.ServerSelector;
import java.util.ArrayList;
import java.util.List;

public class FakeLoadBalancer
implements LoadBalancer {
    List<? extends ServerEndpoint> endpoints;

    public List<? extends ServerEndpoint> endpoints() {
        return this.endpoints;
    }

    public InteractionMetrics<?> newMetrics() {
        return new FakeLoadBalancerMetrics();
    }

    public ServerSelector selector(List<? extends ServerEndpoint> listOfServers) {
        this.endpoints = listOfServers;
        return LoadBalancer.ROUND_ROBIN.selector(listOfServers);
    }

    public static class FakeMetric {
        public long requestBegin;
        public long requestEnd;
        public long responseBegin;
        public long responseEnd;
        public Throwable failure;

        public long requestBegin() {
            return this.requestBegin;
        }

        public long requestEnd() {
            return this.requestEnd;
        }

        public long responseBegin() {
            return this.responseBegin;
        }

        public long responseEnd() {
            return this.responseEnd;
        }

        public Throwable failure() {
            return this.failure;
        }
    }

    public static class FakeLoadBalancerMetrics<E>
    implements InteractionMetrics<FakeMetric> {
        List<FakeMetric> metrics = new ArrayList<FakeMetric>();

        public List<FakeMetric> metrics2() {
            return this.metrics;
        }

        public FakeMetric initiateRequest() {
            FakeMetric metric = new FakeMetric();
            this.metrics.add(metric);
            return metric;
        }

        public void reportFailure(FakeMetric metric, Throwable failure) {
            metric.failure = failure;
        }

        public void reportRequestBegin(FakeMetric metric) {
            metric.requestBegin = System.currentTimeMillis();
        }

        public void reportRequestEnd(FakeMetric metric) {
            metric.requestEnd = System.currentTimeMillis();
        }

        public void reportResponseBegin(FakeMetric metric) {
            metric.responseBegin = System.currentTimeMillis();
        }

        public void reportResponseEnd(FakeMetric metric) {
            metric.responseEnd = System.currentTimeMillis();
        }
    }
}

