/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.HttpClientMetric;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EndpointMetric
implements ClientMetrics<HttpClientMetric, HttpRequest, HttpResponse> {
    public final AtomicInteger connectionCount = new AtomicInteger();
    public final AtomicInteger requestCount = new AtomicInteger();
    public final ConcurrentMap<HttpRequest, HttpClientMetric> requests = new ConcurrentHashMap<HttpRequest, HttpClientMetric>();

    public HttpClientMetric requestBegin(String uri, HttpRequest request) {
        this.requestCount.incrementAndGet();
        HttpClientMetric metric = new HttpClientMetric(this, request);
        this.requests.put(request, metric);
        return metric;
    }

    public void requestEnd(HttpClientMetric requestMetric, long bytesWritten) {
        if (requestMetric == null) {
            FakeHttpClientMetrics.registerFailure(new RuntimeException("Unexpected null request metric"));
            return;
        }
        requestMetric.requestEnded.incrementAndGet();
        requestMetric.bytesWritten.set(bytesWritten);
    }

    public void responseBegin(HttpClientMetric requestMetric, HttpResponse response) {
        if (requestMetric == null) {
            FakeHttpClientMetrics.registerFailure(new RuntimeException("Unexpected null request metric"));
            return;
        }
        if (response == null) {
            FakeHttpClientMetrics.registerFailure(new RuntimeException("Unexpected null response"));
            return;
        }
        requestMetric.responseBegin.incrementAndGet();
    }

    public void requestReset(HttpClientMetric requestMetric) {
        if (requestMetric == null) {
            FakeHttpClientMetrics.registerFailure(new RuntimeException("Unexpected null request metric"));
            return;
        }
        this.requestCount.decrementAndGet();
        requestMetric.failed.set(true);
        this.requests.remove(requestMetric.request);
    }

    public void responseEnd(HttpClientMetric requestMetric, long bytesRead) {
        requestMetric.bytesRead.set(bytesRead);
        this.requestCount.decrementAndGet();
        this.requests.remove(requestMetric.request);
    }
}

