/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.test.fakemetrics.EndpointMetric;
import io.vertx.test.fakemetrics.FakeTCPMetrics;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class FakeHttpClientMetrics
extends FakeTCPMetrics
implements HttpClientMetrics<HttpClientMetric, WebSocketMetric, SocketMetric> {
    private final String name;
    private final ConcurrentMap<WebSocketBase, WebSocketMetric> webSockets = new ConcurrentHashMap<WebSocketBase, WebSocketMetric>();
    private final ConcurrentMap<SocketAddress, EndpointMetric> endpoints = new ConcurrentHashMap<SocketAddress, EndpointMetric>();

    public FakeHttpClientMetrics(String name) {
        this.name = name;
    }

    public WebSocketMetric getMetric(WebSocket ws) {
        return (WebSocketMetric)this.webSockets.get(ws);
    }

    public HttpClientMetric getMetric(HttpClientRequest request) {
        for (EndpointMetric metric : this.endpoints.values()) {
            for (HttpRequest req : metric.requests.keySet()) {
                if (req.id() != request.streamId()) continue;
                return (HttpClientMetric)metric.requests.get(req);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> endpoints() {
        return this.endpoints.keySet().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public EndpointMetric endpoint(String name) {
        for (Map.Entry entry : this.endpoints.entrySet()) {
            if (!((SocketAddress)entry.getKey()).toString().equalsIgnoreCase(name)) continue;
            return (EndpointMetric)entry.getValue();
        }
        return null;
    }

    public Integer connectionCount(String name) {
        EndpointMetric endpoint = this.endpoint(name);
        return endpoint != null ? Integer.valueOf(endpoint.connectionCount.get()) : null;
    }

    public ClientMetrics<HttpClientMetric, HttpRequest, HttpResponse> createEndpointMetrics(final SocketAddress remoteAddress, int maxPoolSize) {
        EndpointMetric metric = new EndpointMetric(){

            public void close() {
                FakeHttpClientMetrics.this.endpoints.remove(remoteAddress);
            }
        };
        this.endpoints.put(remoteAddress, metric);
        return metric;
    }

    public void endpointConnected(ClientMetrics<HttpClientMetric, ?, ?> endpointMetric) {
        ((EndpointMetric)endpointMetric).connectionCount.incrementAndGet();
    }

    public void endpointDisconnected(ClientMetrics<HttpClientMetric, ?, ?> endpointMetric) {
        ((EndpointMetric)endpointMetric).connectionCount.decrementAndGet();
    }

    public WebSocketMetric connected(WebSocket webSocket) {
        WebSocketMetric metric = new WebSocketMetric((WebSocketBase)webSocket);
        this.webSockets.put((WebSocketBase)webSocket, metric);
        return metric;
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.webSockets.remove(webSocketMetric.ws);
    }
}

