/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.test.fakemetrics.FakeTCPMetrics;
import io.vertx.test.fakemetrics.HttpServerMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FakeHttpServerMetrics
extends FakeTCPMetrics
implements HttpServerMetrics<HttpServerMetric, WebSocketMetric, SocketMetric> {
    private final ConcurrentMap<String, WebSocketMetric> webSockets = new ConcurrentHashMap<String, WebSocketMetric>();
    private final Set<HttpServerMetric> requests = ConcurrentHashMap.newKeySet();

    public WebSocketMetric getWebSocketMetric(ServerWebSocket ws) {
        return (WebSocketMetric)this.webSockets.get(ws.path());
    }

    public HttpServerMetric getRequestMetric(HttpServerRequest request) {
        return this.requests.stream().filter(m -> m.uri.equals(request.uri())).findFirst().orElse(null);
    }

    public HttpServerMetric getResponseMetric(String uri) {
        return this.requests.stream().filter(m -> m.uri.equals(uri)).findFirst().orElse(null);
    }

    public HttpServerMetric requestBegin(SocketMetric socketMetric, HttpRequest request) {
        HttpServerMetric metric = new HttpServerMetric(request, socketMetric);
        this.requests.add(metric);
        return metric;
    }

    public void requestEnd(HttpServerMetric requestMetric, HttpRequest request, long bytesRead) {
        requestMetric.requestEnded.set(true);
        requestMetric.bytesRead.set(bytesRead);
    }

    public HttpServerMetric responsePushed(SocketMetric socketMetric, HttpMethod method, String uri, HttpResponse response) {
        HttpServerMetric requestMetric = new HttpServerMetric(uri, socketMetric);
        requestMetric.response.set(response);
        this.requests.add(requestMetric);
        return requestMetric;
    }

    public void requestReset(HttpServerMetric requestMetric) {
        requestMetric.failed.set(true);
        this.requests.remove(requestMetric);
    }

    public void responseBegin(HttpServerMetric requestMetric, HttpResponse response) {
        requestMetric.response.set(response);
    }

    public void responseEnd(HttpServerMetric requestMetric, HttpResponse response, long bytesWritten) {
        this.requests.remove(requestMetric);
        requestMetric.responseEnded.set(true);
        requestMetric.bytesWritten.set(bytesWritten);
    }

    public WebSocketMetric connected(SocketMetric socketMetric, HttpServerMetric requestMetric, ServerWebSocket serverWebSocket) {
        WebSocketMetric metric = new WebSocketMetric((WebSocketBase)serverWebSocket);
        if (this.webSockets.put(serverWebSocket.path(), metric) != null) {
            throw new AssertionError();
        }
        return metric;
    }

    public void disconnected(WebSocketMetric serverWebSocketMetric) {
        this.webSockets.remove(((ServerWebSocket)serverWebSocketMetric.ws).path());
    }

    public void exceptionOccurred(SocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    public void requestRouted(HttpServerMetric requestMetric, String route) {
        requestMetric.route.set(route);
    }
}

