/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class FakePoolMetrics
implements PoolMetrics<Object, Object> {
    private static final Map<String, FakePoolMetrics> METRICS = new ConcurrentHashMap<String, FakePoolMetrics>();
    private static final Object TASK_SUBMITTED = new Object();
    private static final Object TASK_BEGIN = new Object();
    private final String name;
    private final int maxSize;
    private final AtomicInteger pending = new AtomicInteger();
    private final AtomicInteger releaseCount = new AtomicInteger();
    private final AtomicInteger enqueueCount = new AtomicInteger();
    private final AtomicInteger inUse = new AtomicInteger();
    private final AtomicBoolean closed = new AtomicBoolean();

    public FakePoolMetrics(String name, int maxSize) {
        this.name = name;
        this.maxSize = maxSize;
        METRICS.put(name, this);
    }

    public synchronized Object enqueue() {
        this.pending.incrementAndGet();
        this.enqueueCount.incrementAndGet();
        return TASK_SUBMITTED;
    }

    public void dequeue(Object queueMetric) {
        assert (queueMetric == TASK_SUBMITTED);
        this.pending.decrementAndGet();
    }

    public Object begin() {
        this.inUse.incrementAndGet();
        return TASK_BEGIN;
    }

    public void end(Object t) {
        assert (t == TASK_BEGIN);
        this.inUse.decrementAndGet();
        this.releaseCount.incrementAndGet();
    }

    public String name() {
        return this.name;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int numberOfEnqueues() {
        return this.enqueueCount.get();
    }

    public int numberOfReleases() {
        return this.releaseCount.get();
    }

    public int pending() {
        return this.pending.get();
    }

    public int inUse() {
        return this.inUse.get();
    }

    public int available() {
        return this.maxSize - this.inUse.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        this.closed.set(true);
        METRICS.remove(this.name);
    }

    public static Map<String, FakePoolMetrics> getMetrics() {
        return METRICS;
    }

    public static FakePoolMetrics getMetrics(String name) {
        return METRICS.get(name);
    }
}

