/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.Vertx;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.test.fakemetrics.FakeDatagramSocketMetrics;
import io.vertx.test.fakemetrics.FakeEventBusMetrics;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.FakePoolMetrics;
import io.vertx.test.fakemetrics.FakeTCPMetrics;

public class FakeVertxMetrics
extends FakeMetricsBase
implements VertxMetrics {
    private final MetricsOptions options;
    private volatile Vertx vertx;

    public FakeVertxMetrics(MetricsOptions options) {
        this.options = options;
    }

    public FakeVertxMetrics() {
        this.options = new MetricsOptions();
    }

    public MetricsOptions options() {
        return this.options;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public boolean isMetricsEnabled() {
        return true;
    }

    public EventBusMetrics createEventBusMetrics() {
        return new FakeEventBusMetrics();
    }

    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
        return new FakeHttpServerMetrics();
    }

    public HttpClientMetrics<?, ?, ?> createHttpClientMetrics(HttpClientOptions options) {
        return new FakeHttpClientMetrics(options.getMetricsName());
    }

    public TCPMetrics<?> createNetServerMetrics(NetServerOptions options, SocketAddress localAddress) {
        return new FakeTCPMetrics();
    }

    public TCPMetrics<?> createNetClientMetrics(NetClientOptions options) {
        return new FakeTCPMetrics();
    }

    public DatagramSocketMetrics createDatagramSocketMetrics(DatagramSocketOptions options) {
        return new FakeDatagramSocketMetrics();
    }

    public PoolMetrics<?, ?> createPoolMetrics(String type, String name, int maxSize) {
        return new FakePoolMetrics(name, maxSize);
    }

    public void vertxCreated(Vertx vertx) {
        this.vertx = vertx;
    }
}

