/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakeresolver;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.net.Address;
import io.vertx.core.net.AddressResolver;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import io.vertx.test.fakeresolver.FakeAddress;
import io.vertx.test.fakeresolver.FakeEndpoint;
import io.vertx.test.fakeresolver.FakeState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class FakeEndpointResolver<B>
implements AddressResolver<FakeAddress>,
EndpointResolver<FakeAddress, FakeEndpoint, FakeState<B>, B> {
    private final ConcurrentMap<String, LazyFakeState> map = new ConcurrentHashMap<String, LazyFakeState>();

    public void registerAddress(String name, List<SocketAddress> endpoints) {
        this.registerAddress(name, () -> new Endpoint(endpoints, true));
    }

    public void registerAddress(String name, Supplier<Endpoint> supplier) {
        LazyFakeState lazy = this.map.computeIfAbsent(name, x$0 -> new LazyFakeState((String)x$0));
        lazy.endpointSupplier = supplier;
        FakeState prev = lazy.state.getAndSet(null);
        if (prev != null) {
            prev.isValid = false;
        }
    }

    public Set<String> addresses() {
        return this.map.keySet();
    }

    public List<FakeEndpoint> endpoints(String name) {
        LazyFakeState state = (LazyFakeState)this.map.get(name);
        if (state != null) {
            Iterator s1 = ((Iterable)state.state.get().endpoints).iterator();
            ArrayList<FakeEndpoint> list = new ArrayList<FakeEndpoint>();
            for (Object o : (Iterable)state.state.get().endpoints) {
                ServerEndpoint instance = (ServerEndpoint)o;
                list.add((FakeEndpoint)instance.unwrap());
            }
            return list;
        }
        return null;
    }

    public EndpointResolver<FakeAddress, ?, ?, ?> endpointResolver(Vertx vertx) {
        return this;
    }

    public FakeAddress tryCast(Address address) {
        return address instanceof FakeAddress ? (FakeAddress)address : null;
    }

    public Future<FakeState<B>> resolve(FakeAddress address, EndpointBuilder<B, FakeEndpoint> builder) {
        LazyFakeState state = (LazyFakeState)this.map.get(address.name());
        if (state != null) {
            FakeState blah = state.state.get();
            if (blah == null || !blah.isValid) {
                Endpoint endpoint = state.endpointSupplier.get();
                for (SocketAddress socketAddress : endpoint.addresses) {
                    builder = builder.addServer((Object)new FakeEndpoint(socketAddress));
                }
                state.state.set(new FakeState<Object>(state.name, builder.build(), endpoint.valid));
            }
            return Future.succeededFuture(state.state.get());
        }
        return Future.failedFuture((String)("Could not resolve " + String.valueOf(address)));
    }

    public B endpoint(FakeState<B> state) {
        return state.endpoints;
    }

    public boolean isValid(FakeState<B> state) {
        return state.isValid;
    }

    public SocketAddress addressOf(FakeEndpoint server) {
        return server.socketAddress;
    }

    public void dispose(FakeState<B> data) {
        this.map.remove(data.name);
    }

    public void close() {
    }

    class LazyFakeState {
        final String name;
        volatile Supplier<Endpoint> endpointSupplier;
        AtomicReference<FakeState<B>> state = new AtomicReference();

        LazyFakeState(String name) {
            this.name = name;
        }
    }

    public static class Endpoint {
        final List<SocketAddress> addresses;
        final boolean valid;

        public Endpoint(List<SocketAddress> addresses, boolean valid) {
            this.addresses = addresses;
            this.valid = valid;
        }
    }
}

