/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.proxy;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.WriteStream;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class HAProxy {
    private static final Logger log = LoggerFactory.getLogger(HAProxy.class);
    private static final String HOST = "localhost";
    private static final int PORT = 11080;
    private final SocketAddress remoteAddress;
    private final Buffer header;
    private NetServer server;
    private NetClient client;
    private SocketAddress connectionRemoteAddress;
    private SocketAddress connectionLocalAddress;

    public HAProxy(SocketAddress remoteAddress, Buffer header) {
        this.remoteAddress = remoteAddress;
        this.header = header;
    }

    public HAProxy(String host, int port, Buffer header) {
        this(SocketAddress.inetSocketAddress((int)port, (String)host), header);
    }

    public HAProxy start(Vertx vertx) throws Exception {
        NetServerOptions options = new NetServerOptions();
        options.setHost(HOST).setPort(11080);
        this.server = vertx.createNetServer(options);
        this.client = vertx.createNetClient();
        this.server.connectHandler(socket -> {
            socket.pause();
            this.client.connect(this.remoteAddress).onComplete(result -> {
                if (result.succeeded()) {
                    log.debug((Object)"connected, writing header");
                    NetSocket clientSocket = (NetSocket)result.result();
                    this.connectionRemoteAddress = clientSocket.remoteAddress();
                    this.connectionLocalAddress = clientSocket.localAddress();
                    clientSocket.write((Object)this.header).onSuccess(u -> {
                        log.debug((Object)"starting pump");
                        socket.closeHandler(v -> clientSocket.close());
                        clientSocket.closeHandler(v -> socket.close());
                        socket.pipeTo((WriteStream)clientSocket);
                        clientSocket.pipeTo((WriteStream)socket);
                        socket.resume();
                    }).onFailure(u -> {
                        log.error((Object)"exception writing header", result.cause());
                        socket.close();
                    });
                } else {
                    log.error((Object)"exception", result.cause());
                    socket.close();
                }
            });
        });
        CompletableFuture fut = new CompletableFuture();
        this.server.listen().onComplete(ar -> {
            if (ar.succeeded()) {
                fut.complete(null);
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        fut.get(10L, TimeUnit.SECONDS);
        log.debug((Object)"HAProxy server started");
        return this;
    }

    public void stop() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    public String getHost() {
        return HOST;
    }

    public int getPort() {
        return 11080;
    }

    public SocketAddress getConnectionRemoteAddress() {
        return this.connectionRemoteAddress;
    }

    public SocketAddress getConnectionLocalAddress() {
        return this.connectionLocalAddress;
    }

    public static Buffer createVersion1TCP4ProtocolHeader(SocketAddress remote, SocketAddress local) {
        return Buffer.buffer((String)String.format("PROXY TCP4 %s %s %d %d\r\n", remote.hostAddress(), local.hostAddress(), remote.port(), local.port()));
    }

    public static Buffer createVersion1TCP6ProtocolHeader(SocketAddress remote, SocketAddress local) {
        return Buffer.buffer((String)String.format("PROXY TCP6 %s %s %d %d\r\n", remote.hostAddress(), local.hostAddress(), remote.port(), local.port()));
    }

    public static Buffer createVersion1UnknownProtocolHeader() {
        return Buffer.buffer((String)"PROXY UNKNOWN\r\n");
    }

    public static Buffer createVersion2TCP4ProtocolHeader(SocketAddress remote, SocketAddress local) {
        return HAProxy.createIPv4IPv6ProtocolHeader((byte)17, remote, local);
    }

    public static Buffer createVersion2TCP6ProtocolHeader(SocketAddress remote, SocketAddress local) {
        return HAProxy.createIPv4IPv6ProtocolHeader((byte)33, remote, local);
    }

    public static Buffer createVersion2UDP4ProtocolHeader(SocketAddress remote, SocketAddress local) {
        return HAProxy.createIPv4IPv6ProtocolHeader((byte)18, remote, local);
    }

    public static Buffer createVersion2UDP6ProtocolHeader(SocketAddress remote, SocketAddress local) {
        return HAProxy.createIPv4IPv6ProtocolHeader((byte)34, remote, local);
    }

    public static Buffer createVersion2UnixStreamProtocolHeader(SocketAddress remote, SocketAddress local) {
        return HAProxy.createUnixStreamDatagramProtocolHeader((byte)49, remote, local);
    }

    public static Buffer createVersion2UnixDatagramProtocolHeader(SocketAddress remote, SocketAddress local) {
        return HAProxy.createUnixStreamDatagramProtocolHeader((byte)50, remote, local);
    }

    public static Buffer createVersion2UnknownProtocolHeader() {
        return HAProxy.createVersion2ProtocolHeader((byte)0, Buffer.buffer());
    }

    private static Buffer createUnixStreamDatagramProtocolHeader(byte protocolByte, SocketAddress remote, SocketAddress local) {
        Buffer addresses = Stream.of(remote.path(), local.path()).map(s -> {
            byte[] result = new byte[108];
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            System.arraycopy(bytes, 0, result, 0, Math.min(bytes.length, result.length));
            return result;
        }).reduce(Buffer.buffer(), Buffer::appendBytes, (b0, b1) -> b1);
        return HAProxy.createVersion2ProtocolHeader(protocolByte, addresses);
    }

    private static Buffer createIPv4IPv6ProtocolHeader(byte protocolByte, SocketAddress remote, SocketAddress local) {
        try {
            InetAddress remoteInetAddress = InetAddress.getByName(remote.hostAddress());
            InetAddress localInetAddress = InetAddress.getByName(local.hostAddress());
            return HAProxy.createVersion2ProtocolHeader(protocolByte, Buffer.buffer().appendBytes(remoteInetAddress.getAddress()).appendBytes(localInetAddress.getAddress()).appendUnsignedShort(remote.port()).appendUnsignedShort(local.port()));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Buffer createVersion2ProtocolHeader(byte protocolByte, Buffer address) {
        byte[] header = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10, 33, protocolByte, 0};
        return Buffer.buffer((byte[])header).appendByte((byte)address.length()).appendBuffer(address);
    }
}

