/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.addressresolver;

import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.CleanableHttpClient;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.net.Address;
import io.vertx.core.net.AddressResolver;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakeloadbalancer.FakeLoadBalancer;
import io.vertx.test.fakeresolver.FakeAddress;
import io.vertx.test.fakeresolver.FakeEndpoint;
import io.vertx.test.fakeresolver.FakeEndpointResolver;
import io.vertx.test.fakeresolver.FakeState;
import io.vertx.test.http.HttpTestBase;
import io.vertx.test.proxy.HttpProxy;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ResolvingHttpClientTest
extends VertxTestBase {
    private BiConsumer<Integer, HttpServerRequest> requestHandler;
    private List<HttpServer> servers;

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 s1.example.com\n127.0.0.1 s2.example.com\n"));
        return options;
    }

    private void startServers(int numServers) throws Exception {
        this.startServers(numServers, new HttpServerOptions());
    }

    private void startServers(int numServers, HttpServerOptions options) throws Exception {
        if (this.servers != null) {
            throw new IllegalStateException();
        }
        this.servers = new ArrayList<HttpServer>();
        for (int i = 0; i < numServers; ++i) {
            int val = i;
            HttpServer server = this.vertx.createHttpServer(options).requestHandler(req -> {
                BiConsumer<Integer, HttpServerRequest> handler = this.requestHandler;
                if (handler != null) {
                    handler.accept(val, (HttpServerRequest)req);
                } else {
                    req.response().setStatusCode(404).end();
                }
            });
            this.servers.add(server);
            this.awaitFuture(server.listen(HttpTestBase.DEFAULT_HTTP_PORT + i, "localhost"));
        }
    }

    @Test
    public void testResolveServers() throws Exception {
        int numServers = 2;
        this.waitFor(numServers * 2);
        this.startServers(numServers);
        this.requestHandler = (idx, req) -> req.response().end("server-" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost"), SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 1), (String)"localhost")));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver(resolver).build();
        Set responses = Collections.synchronizedSet(new HashSet());
        for (int i = 0; i < numServers * 2; ++i) {
            client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onSuccess(v -> {
                responses.add(v.toString());
                this.complete();
            }));
        }
        this.await();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("server-0", "server-1")), responses);
    }

    @Ignore
    @Test
    public void testShutdownServers() throws Exception {
        int numServers = 4;
        this.requestHandler = (idx, req) -> req.response().end("server-" + idx);
        this.startServers(numServers);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost"), SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 1), (String)"localhost"), SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 2), (String)"localhost"), SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 3), (String)"localhost")));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver(resolver).build();
        CountDownLatch latch = new CountDownLatch(numServers);
        for (int i = 0; i < numServers; ++i) {
            client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onSuccess(v -> latch.countDown()));
        }
        this.awaitLatch(latch);
        List<FakeEndpoint> endpoints = resolver.endpoints("example.com");
        for (int i = 0; i < this.servers.size(); ++i) {
            int expected = endpoints.size() - 1;
            this.awaitFuture(this.servers.get(i).close());
            ResolvingHttpClientTest.assertWaitUntil(() -> endpoints.size() == expected);
        }
        ResolvingHttpClientTest.assertWaitUntil(resolver.addresses()::isEmpty);
    }

    @Test
    public void testResolveToSameSocketAddress() throws Exception {
        this.requestHandler = (idx, req) -> req.response().end("server-" + idx);
        this.startServers(1);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        SocketAddress address = SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost");
        resolver.registerAddress("server1.com", List.of(address));
        resolver.registerAddress("server2.com", List.of(address));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver(resolver).build();
        Future result = client.request(new RequestOptions().setServer((Address)new FakeAddress("server1.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).compose(body -> client.request(new RequestOptions().setServer((Address)new FakeAddress("server2.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)));
        this.awaitFuture(result);
        this.awaitFuture(this.servers.get(0).close());
    }

    @Test
    public void testResolveToSameSocketAddressWithProxy() throws Exception {
        this.requestHandler = (idx, req) -> req.response().end("server-" + idx);
        this.startServers(1);
        HttpProxy proxy = new HttpProxy();
        proxy.start(this.vertx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost")));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver(resolver).build();
        RequestOptions request1 = new RequestOptions().setServer((Address)new FakeAddress("example.com"));
        RequestOptions request2 = new RequestOptions(request1).setProxyOptions(new ProxyOptions().setHost("localhost").setPort(proxy.defaultPort()).setType(ProxyType.HTTP));
        List<RequestOptions> requests = Arrays.asList(request1, request2);
        ArrayList<Buffer> responses = new ArrayList<Buffer>();
        for (RequestOptions request : requests) {
            Future result = client.request(request).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body));
            Buffer response = (Buffer)this.awaitFuture(result);
            responses.add(response);
        }
        this.assertNotNull(proxy.lastLocalAddress());
    }

    @Test
    public void testAcceptProxyFilter() throws Exception {
        this.testFilter(true);
    }

    @Test
    public void testRejectProxyFilter() throws Exception {
        this.testFilter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFilter(boolean accept) throws Exception {
        HttpProxy proxy = new HttpProxy();
        proxy.start(this.vertx);
        try {
            int numServers = 2;
            this.waitFor(numServers * 2);
            this.startServers(numServers);
            this.requestHandler = (idx, req) -> {
                boolean proxied = idx == 0 && accept;
                SocketAddress remote = req.connection().remoteAddress();
                this.assertEquals(proxied, proxy.localAddresses().contains(remote.host() + ":" + remote.port()));
                req.response().end("server-" + idx);
            };
            FakeEndpointResolver resolver = new FakeEndpointResolver();
            resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"s1.example.com"), SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 1), (String)"s2.example.com")));
            HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().with(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(proxy.port()))).withAddressResolver(resolver).build();
            ((HttpClientImpl)((CleanableHttpClient)client).delegate).proxyFilter(so -> accept && so.host().equals("s1.example.com"));
            Set responses = Collections.synchronizedSet(new HashSet());
            for (int i = 0; i < numServers * 2; ++i) {
                client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onSuccess(v -> {
                    responses.add(v.toString());
                    this.complete();
                }));
            }
            this.await();
            Assert.assertEquals(new HashSet<String>(Arrays.asList("server-0", "server-1")), responses);
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testResolveFailure() {
        final Exception cause = new Exception("Not found");
        FakeEndpointResolver lookup = new FakeEndpointResolver(){

            public Future<FakeState> resolve(FakeAddress address, EndpointBuilder builder) {
                return Future.failedFuture((Throwable)cause);
            }
        };
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver((AddressResolver)lookup).build();
        client.request(new RequestOptions().setServer((Address)new FakeAddress("foo.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onFailure(err -> {
            this.assertSame(cause, err);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUseInvalidAddress() {
        FakeEndpointResolver lookup = new FakeEndpointResolver();
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver(lookup).build();
        client.request(new RequestOptions().setServer(new Address(){})).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onFailure(err -> {
            this.assertTrue(err.getMessage().contains("Cannot resolve address"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testKeepAliveTimeout() throws Exception {
        this.startServers(1);
        this.requestHandler = (idx, req) -> req.response().end("server-" + idx);
        CountDownLatch closedLatch = new CountDownLatch(1);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost")));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().with(new HttpClientOptions().setKeepAliveTimeout(1)).withConnectHandler(conn -> conn.closeHandler(v -> closedLatch.countDown())).withAddressResolver(resolver).build();
        client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onSuccess(v -> {}));
        this.awaitLatch(closedLatch);
    }

    @Test
    public void testStatistics() throws Exception {
        this.startServers(1);
        this.requestHandler = (idx, req) -> this.vertx.setTimer(500L, id -> req.response().end());
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost")));
        FakeLoadBalancer lb = new FakeLoadBalancer();
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().with(new HttpClientOptions().setKeepAliveTimeout(1)).withAddressResolver(resolver).withLoadBalancer((LoadBalancer)lb).build();
        client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
        FakeLoadBalancer.FakeLoadBalancerMetrics endpoint = (FakeLoadBalancer.FakeLoadBalancerMetrics)lb.endpoints().get(0).metrics();
        FakeLoadBalancer.FakeMetric metric = endpoint.metrics2().get(0);
        this.assertTrue(metric.requestEnd() - metric.requestBegin() >= 0L);
        this.assertTrue(metric.responseBegin() - metric.requestEnd() >= 500L);
        this.assertTrue(metric.responseEnd() - metric.responseBegin() >= 0L);
    }

    @Test
    public void testStatisticsReportingFailure0() throws Exception {
        this.startServers(1);
        AtomicInteger count = new AtomicInteger();
        this.requestHandler = (idx, req) -> count.incrementAndGet();
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        FakeLoadBalancer lb = new FakeLoadBalancer();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost")));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().with(new HttpClientOptions().setKeepAliveTimeout(1)).withAddressResolver(resolver).withLoadBalancer((LoadBalancer)lb).build();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < 5; ++i) {
            Future fut = client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().compose(HttpClientResponse::body));
            futures.add(fut);
        }
        ResolvingHttpClientTest.assertWaitUntil(() -> count.get() == 5);
        try {
            this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com")).setTimeout(100L)));
        }
        catch (Throwable e) {
            this.assertTrue(e.getMessage().contains("timeout"));
        }
        FakeLoadBalancer.FakeLoadBalancerMetrics endpoint = (FakeLoadBalancer.FakeLoadBalancerMetrics)lb.endpoints().get(0).metrics();
        ResolvingHttpClientTest.assertWaitUntil(() -> endpoint.metrics2().size() == 6);
        FakeLoadBalancer.FakeMetric metric = endpoint.metrics2().get(5);
        this.assertNotNull(metric.failure);
    }

    @Test
    public void testStatisticsReportingFailure1() throws Exception {
        FakeLoadBalancer.FakeMetric metric = this.testStatisticsReportingFailure((fail, req) -> {
            if (fail.booleanValue()) {
                req.connection().close();
            } else {
                req.response().end();
            }
        }, req -> {
            req.setChunked(true);
            req.write("chunk");
            return req.response().compose(HttpClientResponse::body);
        });
        this.assertNotSame(0, metric.responseBegin());
        this.assertEquals(0L, metric.requestEnd());
        this.assertEquals(0L, metric.responseBegin());
        this.assertEquals(0L, metric.responseEnd());
        this.assertNotNull(metric.failure());
        this.assertTrue(metric.failure() instanceof HttpClosedException);
    }

    @Test
    public void testStatisticsReportingFailure2() throws Exception {
        FakeLoadBalancer.FakeMetric metric = this.testStatisticsReportingFailure((fail, req) -> {
            if (fail.booleanValue()) {
                req.connection().close();
            } else {
                req.response().end();
            }
        }, req -> req.send().compose(HttpClientResponse::body));
        this.assertTrue(metric.requestEnd() - metric.requestBegin() >= 0L);
        this.assertEquals(0L, metric.responseBegin());
        this.assertEquals(0L, metric.responseEnd());
        this.assertNotNull(metric.failure());
        this.assertTrue(metric.failure() instanceof HttpClosedException);
    }

    @Test
    public void testStatisticsReportingFailure3() throws Exception {
        FakeLoadBalancer.FakeMetric metric = this.testStatisticsReportingFailure((fail, req) -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true).write("chunk");
            this.vertx.setTimer(100L, id -> {
                if (fail.booleanValue()) {
                    req.connection().close();
                } else {
                    resp.end();
                }
            });
        }, req -> req.send().compose(HttpClientResponse::body));
        this.assertTrue(metric.requestEnd() - metric.requestBegin() >= 0L);
        this.assertTrue(metric.responseBegin() - metric.requestEnd() >= 0L);
        this.assertEquals(0L, metric.responseEnd());
        this.assertNotNull(metric.failure());
        this.assertTrue(metric.failure() instanceof HttpClosedException);
    }

    private FakeLoadBalancer.FakeMetric testStatisticsReportingFailure(BiConsumer<Boolean, HttpServerRequest> handler, Function<HttpClientRequest, Future<Buffer>> sender) throws Exception {
        this.startServers(1);
        AtomicBoolean mode = new AtomicBoolean();
        this.requestHandler = (idx, req) -> handler.accept(mode.get(), (HttpServerRequest)req);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost")));
        FakeLoadBalancer lb = new FakeLoadBalancer();
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().with(new HttpClientOptions().setKeepAliveTimeout(1)).withAddressResolver(resolver).withLoadBalancer((LoadBalancer)lb).build();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < 10; ++i) {
            Future fut = client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body));
            futures.add(fut);
        }
        this.awaitFuture(Future.join(futures));
        mode.set(true);
        try {
            this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(sender::apply));
        }
        catch (RuntimeException e) {
            this.assertTrue(e.getMessage().contains("Connection was closed"));
        }
        FakeLoadBalancer.FakeLoadBalancerMetrics endpoint = (FakeLoadBalancer.FakeLoadBalancerMetrics)lb.endpoints().get(0).metrics();
        ResolvingHttpClientTest.assertWaitUntil(() -> endpoint.metrics2().size() == 11);
        for (int i = 0; i < 10; ++i) {
            FakeLoadBalancer.FakeMetric metric = endpoint.metrics2().get(i);
            this.assertTrue(metric.requestEnd() - metric.requestBegin() >= 0L);
            this.assertTrue(metric.responseBegin() - metric.requestEnd() >= 0L);
            this.assertTrue(metric.responseEnd() - metric.responseBegin() >= 0L);
        }
        return endpoint.metrics2().get(10);
    }

    @Test
    public void testInvalidation() throws Exception {
        this.startServers(2);
        this.requestHandler = (idx, req) -> req.response().end("" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        SocketAddress addr1 = SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost");
        SocketAddress addr2 = SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 1), (String)"localhost");
        resolver.registerAddress("example.com", Arrays.asList(addr1));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver(resolver).build();
        String res = ((Buffer)this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)))).toString();
        this.assertEquals("0", res);
        resolver.registerAddress("example.com", List.of(addr2));
        try {
            this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)));
        }
        catch (Throwable e) {
            this.assertTrue(e.getMessage().startsWith("Cannot resolve address"));
        }
    }

    @Test
    public void testDelayedInvalidation() throws Exception {
        this.testInvalidation(false);
    }

    @Test
    public void testImmediateInvalidation() throws Exception {
        this.testInvalidation(true);
    }

    private void testInvalidation(boolean immediate) throws Exception {
        this.startServers(2);
        this.requestHandler = (idx, req) -> req.response().end("" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        SocketAddress addr1 = SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost");
        SocketAddress addr2 = SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 1), (String)"localhost");
        AtomicInteger accessCount = new AtomicInteger();
        resolver.registerAddress("example.com", () -> {
            accessCount.incrementAndGet();
            return new FakeEndpointResolver.Endpoint(List.of(addr1), !immediate);
        });
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withAddressResolver(resolver).build();
        String res = ((Buffer)this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)))).toString();
        this.assertEquals("0", res);
        this.assertEquals(1L, accessCount.get());
        res = ((Buffer)this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)))).toString();
        this.assertEquals("0", res);
        this.assertEquals(immediate ? 2L : 1L, accessCount.get());
        resolver.registerAddress("example.com", List.of(addr2));
        res = ((Buffer)this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)))).toString();
        this.assertEquals("1", res);
    }

    @Test
    public void testTimeExpiration() throws Exception {
        this.startServers(1);
        this.requestHandler = (idx, req) -> req.response().end("" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        SocketAddress addr1 = SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost");
        resolver.registerAddress("example.com", Arrays.asList(addr1));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().with(new HttpClientOptions().setKeepAliveTimeout(1)).withAddressResolver(resolver).build();
        String res = ((Buffer)this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)))).toString();
        this.assertEquals("0", res);
        ResolvingHttpClientTest.waitUntil(() -> resolver.endpoints("example.com") == null);
    }

    @Test
    public void testTimeRefreshExpiration() throws Exception {
        this.startServers(1);
        this.requestHandler = (idx, req) -> req.response().end("" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        SocketAddress addr1 = SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost");
        resolver.registerAddress("example.com", Arrays.asList(addr1));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().with(new HttpClientOptions().setKeepAliveTimeout(2)).withAddressResolver(resolver).build();
        int numRequests = 20;
        for (int i = 0; i < numRequests; ++i) {
            String res = ((Buffer)this.awaitFuture(client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)))).toString();
            this.assertEquals("0", res);
            Thread.sleep(200L);
        }
        this.assertNotNull(resolver.endpoints("example.com"));
        ResolvingHttpClientTest.waitUntil(() -> resolver.endpoints("example.com") == null);
    }

    @Test
    public void testSSL() throws Exception {
        this.testSSL(new RequestOptions().setMethod(HttpMethod.GET).setServer((Address)new FakeAddress("example.com")).setURI("/"), false, true);
    }

    @Test
    public void testSSLOverridePeer() throws Exception {
        this.testSSL(new RequestOptions().setMethod(HttpMethod.GET).setServer((Address)new FakeAddress("example.com")).setHost("example.com").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setURI("/"), true, true);
    }

    @Test
    public void testSSLOverridePeerNoVerify() throws Exception {
        this.testSSL(new RequestOptions().setMethod(HttpMethod.GET).setServer((Address)new FakeAddress("example.com")).setHost("example.com").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setURI("/"), false, false);
    }

    private void testSSL(RequestOptions request, boolean expectFailure, boolean verifyHost) throws Exception {
        this.startServers(1, new HttpServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()));
        this.requestHandler = (idx, req) -> req.response().end("" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        SocketAddress addr1 = SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost");
        resolver.registerAddress("example.com", Arrays.asList(addr1));
        HttpClientAgent client = this.vertx.httpClientBuilder().with(new HttpClientOptions().setSsl(true).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()).setVerifyHost(verifyHost)).withAddressResolver(resolver).build();
        try {
            String res = ((Buffer)this.awaitFuture(client.request(request).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)))).toString();
            this.assertFalse(expectFailure);
            this.assertEquals("0", res);
        }
        catch (Exception e) {
            this.assertTrue(expectFailure);
        }
    }

    @Test
    public void testConsistentHashing() throws Exception {
        int numServers = 4;
        int numClients = 10;
        int numRequests = 4;
        this.waitFor(numClients * numRequests);
        this.startServers(numServers);
        this.requestHandler = (idx, req) -> req.response().end("server-" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        List<SocketAddress> servers = IntStream.range(0, numServers).mapToObj(idx -> SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + idx), (String)"localhost")).collect(Collectors.toList());
        resolver.registerAddress("example.com", servers);
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withLoadBalancer(LoadBalancer.CONSISTENT_HASHING).withAddressResolver(resolver).build();
        ConcurrentHashMap responses = new ConcurrentHashMap();
        for (int i = 0; i < numClients * numRequests; ++i) {
            int idx2 = i % numClients;
            String hashingKey = "client-" + idx2;
            client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com")).setRoutingKey(hashingKey)).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onSuccess(v -> {
                responses.compute(idx2, (id, list) -> {
                    if (list == null) {
                        list = Collections.synchronizedList(new ArrayList());
                    }
                    return list;
                }).add(v.toString());
                this.complete();
            }));
        }
        this.await();
        responses.values().forEach(list -> {
            String resp = (String)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                Assert.assertEquals((Object)resp, list.get(i));
            }
        });
    }

    @Test
    public void testLyingLoadBalancer() throws Exception {
        int numServers = 2;
        this.startServers(numServers);
        this.requestHandler = (idx, req) -> req.response().end("server-" + idx);
        FakeEndpointResolver resolver = new FakeEndpointResolver();
        resolver.registerAddress("example.com", Arrays.asList(SocketAddress.inetSocketAddress((int)HttpTestBase.DEFAULT_HTTP_PORT, (String)"localhost"), SocketAddress.inetSocketAddress((int)(HttpTestBase.DEFAULT_HTTP_PORT + 1), (String)"localhost")));
        HttpClientInternal client = (HttpClientInternal)this.vertx.httpClientBuilder().withLoadBalancer(endpoints -> () -> endpoints.size() + 1).withAddressResolver(resolver).build();
        Set responses = Collections.synchronizedSet(new HashSet());
        client.request(new RequestOptions().setServer((Address)new FakeAddress("example.com"))).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onFailure(err -> {
            this.assertEquals("No results for ServiceName(example.com)", err.getMessage());
            this.testComplete();
        }));
        this.await();
    }
}

