/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.benchmark;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.vertx.benchmarks.HttpServerHandlerBenchmark;
import io.vertx.core.Handler;
import io.vertx.core.ThreadingModel;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.VertxHttpRequestDecoder;
import io.vertx.core.http.impl.VertxHttpResponseEncoder;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class Http1xServerConnectionTest
extends VertxTestBase {
    private static final String HELLO_WORLD = "Hello, world!";
    private static final Buffer HELLO_WORLD_BUFFER = Buffer.buffer((String)"Hello, world!");

    @Test
    public void testSimple() {
        Handler app = request -> {
            HttpServerResponse response = request.response();
            response.end(HELLO_WORLD_BUFFER);
        };
        VertxInternal vertx = (VertxInternal)this.vertx;
        HttpServerOptions options = new HttpServerOptions();
        EmbeddedChannel vertxChannel = new EmbeddedChannel(new ChannelHandler[]{new VertxHttpRequestDecoder(options), new VertxHttpResponseEncoder()});
        vertxChannel.config().setAllocator((ByteBufAllocator)new HttpServerHandlerBenchmark.Alloc());
        ContextInternal context = vertx.contextBuilder().withEventLoop(vertxChannel.eventLoop()).withClassLoader(Thread.currentThread().getContextClassLoader()).build();
        VertxHandler handler = VertxHandler.create(chctx -> {
            Http1xServerConnection conn = new Http1xServerConnection(ThreadingModel.EVENT_LOOP, () -> context, null, new HttpServerOptions(), chctx, context, "localhost", null);
            conn.handler(app);
            return conn;
        });
        vertxChannel.pipeline().addLast("handler", (ChannelHandler)handler);
        ByteBuf GET = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])"GET / HTTP/1.1\r\n\r\n".getBytes()));
        vertxChannel.writeInbound(new Object[]{GET});
        vertxChannel.outboundMessages().poll();
    }
}

