/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.buffer;

import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.buffer.impl.VertxHeapByteBuf;
import io.vertx.core.buffer.impl.VertxUnsafeHeapByteBuf;
import io.vertx.core.impl.buffer.VertxByteBufAllocator;
import io.vertx.core.internal.buffer.BufferInternal;
import org.junit.Assert;
import org.junit.Test;

public class VertxBufferTest {
    @Test
    public void testAllocateVertxBuffer() {
        BufferImpl buffer = new BufferImpl();
        ByteBuf byteBuf = buffer.byteBuf();
        Assert.assertTrue((byteBuf instanceof VertxHeapByteBuf || byteBuf instanceof VertxUnsafeHeapByteBuf ? 1 : 0) != 0);
    }

    @Test
    public void testUnreleasable() {
        BufferImpl buffer = new BufferImpl();
        ByteBuf byteBuf = buffer.byteBuf();
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        byteBuf.release();
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
    }

    @Test
    public void testDuplicate() {
        BufferImpl buffer = new BufferImpl();
        buffer.appendString("Hello World");
        ByteBuf byteBuf = buffer.byteBuf();
        ByteBuf duplicate = buffer.getByteBuf();
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        duplicate.release();
        Assert.assertEquals((long)1L, (long)duplicate.refCnt());
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        duplicate.readerIndex(3);
        Assert.assertEquals((long)3L, (long)duplicate.readerIndex());
        Assert.assertEquals((long)0L, (long)byteBuf.readerIndex());
        ByteBuf duplicateSlice = duplicate.slice(0, 5);
        duplicateSlice.release();
        Assert.assertEquals((long)1L, (long)duplicateSlice.refCnt());
        Assert.assertEquals((long)1L, (long)duplicate.refCnt());
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        duplicateSlice.readerIndex(1);
        Assert.assertEquals((long)1L, (long)duplicateSlice.readerIndex());
        Assert.assertEquals((long)3L, (long)duplicate.readerIndex());
        Assert.assertEquals((long)0L, (long)byteBuf.readerIndex());
    }

    @Test
    public void testSafeBuffer() {
        VertxBufferTest.assertCopyAndRelease(AdaptiveByteBufAllocator.DEFAULT.heapBuffer().writeByte(65));
        VertxBufferTest.assertCopyAndRelease(AdaptiveByteBufAllocator.DEFAULT.directBuffer().writeByte(65));
        VertxBufferTest.assertCopyAndRelease(PooledByteBufAllocator.DEFAULT.heapBuffer().writeByte(65));
        VertxBufferTest.assertCopyAndRelease(PooledByteBufAllocator.DEFAULT.directBuffer().writeByte(65));
        VertxBufferTest.assertCopyAndRelease((ByteBuf)new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, false, 10).writeByte(65));
        VertxBufferTest.assertWrap(Unpooled.buffer().writeByte(65));
        VertxBufferTest.assertWrap(VertxByteBufAllocator.DEFAULT.heapBuffer().writeByte(65));
        VertxBufferTest.assertWrap(VertxByteBufAllocator.DEFAULT.directBuffer().writeByte(65));
        VertxBufferTest.assertWrap(UnpooledByteBufAllocator.DEFAULT.heapBuffer().writeByte(65));
        VertxBufferTest.assertWrap(UnpooledByteBufAllocator.DEFAULT.directBuffer().writeByte(65));
    }

    private static void assertCopyAndRelease(ByteBuf bbuf) {
        BufferImpl buffer = (BufferImpl)BufferInternal.safeBuffer((ByteBuf)bbuf);
        Assert.assertNotSame((Object)bbuf, (Object)buffer.byteBuf());
        Assert.assertEquals((long)0L, (long)bbuf.refCnt());
    }

    private static void assertWrap(ByteBuf bbuf) {
        BufferImpl buffer = (BufferImpl)BufferInternal.safeBuffer((ByteBuf)bbuf);
        Assert.assertSame((Object)bbuf, (Object)buffer.byteBuf());
        Assert.assertEquals((long)1L, (long)bbuf.refCnt());
        bbuf.release();
    }
}

