/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.cluster;

import io.vertx.core.Completable;
import io.vertx.core.eventbus.impl.clustered.DefaultNodeSelector;
import io.vertx.core.spi.cluster.ClusteredNode;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class DefaultNodeSelectorTest {
    private static List<RegistrationInfo> registrations(String ... nodeIds) {
        return Stream.of(nodeIds).map(nodeId -> new RegistrationInfo(nodeId, 0L, false)).collect(Collectors.toList());
    }

    @SafeVarargs
    private static <T> void assertIterable(Iterable<T> iterable, T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T elt : iterable) {
            set.add(elt);
        }
        Assert.assertEquals(new HashSet<T>(Arrays.asList(elements)), set);
    }

    @Test
    public void testSerializeSelect() {
        DefaultNodeSelector ns = new DefaultNodeSelector();
        ClusterView view = new ClusterView();
        ns.init((ClusteredNode)view);
        ArrayList completions = new ArrayList();
        ns.selectForSend("the-address", (result, failure) -> {
            if (result != null) {
                completions.add("p1");
            }
        });
        ns.selectForSend("the-address", (result, failure) -> {
            if (result != null) {
                completions.add("p2");
            }
        });
        Assert.assertEquals((long)1L, (long)view.log.size());
        ClusterView.GetRegistrationsOp op = view.assertGetRegistration();
        Assert.assertEquals((Object)"the-address", (Object)op.address);
        Assert.assertEquals(List.of(), completions);
        op.succeed("node1");
        Assert.assertEquals(List.of("p1", "p2"), completions);
        view.assertEmpty();
    }

    @Test
    public void testSelectWhenBroadcasting() {
        DefaultNodeSelector ns = new DefaultNodeSelector();
        ClusterView view = new ClusterView();
        ns.init((ClusteredNode)view);
        ArrayList completions = new ArrayList();
        ns.selectForSend("the-address", (result1, failure1) -> {
            completions.add("p1");
            ns.selectForSend("the-address", (result2, failure2) -> completions.add("p3"));
        });
        ns.selectForSend("the-address", (result, failure) -> completions.add("p2"));
        Assert.assertEquals((long)1L, (long)view.log.size());
        ClusterView.GetRegistrationsOp op = view.assertGetRegistration();
        Assert.assertEquals((Object)"the-address", (Object)op.address);
        Assert.assertEquals(List.of(), completions);
        op.succeed("node1");
        Assert.assertEquals(List.of("p1", "p2", "p3"), completions);
        view.assertEmpty();
    }

    @Test
    public void testUpdateRegistration() {
        this.testRegistrationUpdate(true);
    }

    @Test
    public void testRemoveRegistration() {
        this.testRegistrationUpdate(false);
    }

    private void testRegistrationUpdate(boolean update) {
        DefaultNodeSelector ns = new DefaultNodeSelector();
        ClusterView view = new ClusterView();
        ns.init((ClusteredNode)view);
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < 16; ++i) {
            ns.selectForSend("the-address", (result, failure) -> {
                Assert.assertEquals((Object)"node1", (Object)result);
                count.incrementAndGet();
            });
        }
        ClusterView.GetRegistrationsOp get = view.assertGetRegistration();
        get.succeed("node1");
        Assert.assertEquals((long)16L, (long)count.get());
        ns.registrationsUpdated(new RegistrationUpdateEvent("the-address", update ? DefaultNodeSelectorTest.registrations("node2") : DefaultNodeSelectorTest.registrations(new String[0])));
        for (int i = 0; i < 16; ++i) {
            ns.selectForSend("the-address", (result, failure) -> {
                Assert.assertEquals((Object)"node2", (Object)result);
                count.incrementAndGet();
            });
        }
        if (update) {
            Assert.assertEquals((long)32L, (long)count.get());
        } else {
            get = view.assertGetRegistration();
            Assert.assertEquals((Object)"the-address", (Object)get.address);
        }
        view.assertEmpty();
    }

    @Test
    public void testGetRegistrationFailure() {
        DefaultNodeSelector ns = new DefaultNodeSelector();
        ClusterView view = new ClusterView();
        ns.init((ClusteredNode)view);
        AtomicInteger selects = new AtomicInteger();
        Exception cause = new Exception();
        for (int i = 0; i < 16; ++i) {
            ns.selectForSend("the-address", (result, failure) -> {
                Assert.assertSame((Object)cause, (Object)failure);
                selects.incrementAndGet();
            });
        }
        ClusterView.GetRegistrationsOp get = view.assertGetRegistration();
        view.assertEmpty();
        get.fail(cause);
        Assert.assertEquals((long)16L, (long)selects.get());
        ns.selectForSend("the-address", (result, failure) -> selects.incrementAndGet());
        view.assertGetRegistration();
        view.assertEmpty();
    }

    @Test
    public void testRegistrationUpdateBeforeGetResolution() {
        DefaultNodeSelector ns = new DefaultNodeSelector();
        ClusterView view = new ClusterView();
        ns.init((ClusteredNode)view);
        AtomicInteger status = new AtomicInteger();
        ns.selectForPublish("the-address", (result, failure) -> {
            DefaultNodeSelectorTest.assertIterable(result, "node1");
            status.compareAndSet(0, 1);
        });
        ClusterView.GetRegistrationsOp get = view.assertGetRegistration();
        ns.registrationsUpdated(new RegistrationUpdateEvent("the-address", DefaultNodeSelectorTest.registrations("node1", "node2")));
        ns.selectForPublish("the-address", (result, failure) -> {
            DefaultNodeSelectorTest.assertIterable(result, "node1", "node2");
            status.compareAndSet(1, 2);
        });
        view.assertEmpty();
        get.succeed("node1");
        Assert.assertEquals((long)2L, (long)status.get());
    }

    @Test
    public void testEmptyRegistrations() {
        DefaultNodeSelector ns = new DefaultNodeSelector();
        ClusterView view = new ClusterView();
        ns.init((ClusteredNode)view);
        AtomicInteger count1 = new AtomicInteger();
        ns.selectForSend("the-address", (result, failure) -> {
            Assert.assertNull((Object)result);
            count1.incrementAndGet();
        });
        AtomicInteger count2 = new AtomicInteger();
        ns.selectForPublish("the-address", (result, failure) -> {
            Assert.assertFalse((boolean)result.iterator().hasNext());
            count2.incrementAndGet();
        });
        ClusterView.GetRegistrationsOp get = view.assertGetRegistration();
        Assert.assertEquals((Object)"the-address", (Object)get.address);
        get.succeed(new String[0]);
        Assert.assertEquals((long)1L, (long)count1.get());
        Assert.assertEquals((long)1L, (long)count2.get());
        view.assertEmpty();
        ns.selectForSend("the-address", (result, failure) -> Assert.fail());
        get = view.assertGetRegistration();
        Assert.assertEquals((Object)"the-address", (Object)get.address);
        view.assertEmpty();
    }

    @Test
    public void testUpdateEventWhileBroadcastingSuccess() {
        AtomicInteger status = new AtomicInteger();
        DefaultNodeSelector ns = new DefaultNodeSelector();
        ClusterView view = new ClusterView();
        ns.init((ClusteredNode)view);
        ns.selectForPublish("the-address", (result1, failure) -> {
            DefaultNodeSelectorTest.assertIterable(result1, "node1");
            status.compareAndSet(0, 1);
            ns.registrationsUpdated(new RegistrationUpdateEvent("the-address", DefaultNodeSelectorTest.registrations("node1", "node2")));
            ns.selectForPublish("the-address", (result2, failure2) -> {
                DefaultNodeSelectorTest.assertIterable(result2, "node1", "node2");
                status.compareAndSet(2, 3);
            });
        });
        ns.selectForPublish("the-address", (result, failure) -> {
            DefaultNodeSelectorTest.assertIterable(result, "node1");
            status.compareAndSet(1, 2);
        });
        ClusterView.GetRegistrationsOp get = view.assertGetRegistration();
        get.succeed("node1");
    }

    private static class ClusterView
    implements ClusteredNode {
        private final Deque<Op> log = new ArrayDeque<Op>();

        private ClusterView() {
        }

        private GetRegistrationsOp assertGetRegistration() {
            Op op = this.log.poll();
            Assert.assertNotNull((Object)op);
            Assert.assertTrue((boolean)(op instanceof GetRegistrationsOp));
            return (GetRegistrationsOp)op;
        }

        private void assertEmpty() {
            Assert.assertEquals(null, (Object)this.log.poll());
        }

        public String getNodeId() {
            throw new UnsupportedOperationException();
        }

        public void getRegistrations(String address, Completable<List<RegistrationInfo>> promise) {
            this.log.add(new GetRegistrationsOp(address, promise));
        }

        public NodeInfo getNodeInfo() {
            throw new UnsupportedOperationException();
        }

        public void getNodeInfo(String nodeId, Completable<NodeInfo> promise) {
            throw new UnsupportedOperationException();
        }

        public List<String> getNodes() {
            throw new UnsupportedOperationException();
        }

        static class GetRegistrationsOp
        extends Op {
            private final String address;
            private final Completable<List<RegistrationInfo>> promise;

            GetRegistrationsOp(String address, Completable<List<RegistrationInfo>> promise) {
                this.address = address;
                this.promise = promise;
            }

            void succeed(String ... nodeIds) {
                this.promise.succeed(DefaultNodeSelectorTest.registrations(nodeIds));
            }

            void fail(Throwable cause) {
                this.promise.fail(cause);
            }
        }

        static class Op {
            Op() {
            }
        }
    }
}

