/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.cluster.selector;

import io.vertx.core.eventbus.impl.clustered.selector.SimpleRoundRobinSelector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SimpleRoundRobinSelectorTest {
    private final List<String> nodeIds;
    private final SimpleRoundRobinSelector selector;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Collections.singletonList("foo")}, {Arrays.asList("foo", "bar", "baz")});
    }

    public SimpleRoundRobinSelectorTest(List<String> nodeIds) {
        this.nodeIds = nodeIds;
        this.selector = new SimpleRoundRobinSelector(nodeIds);
    }

    @Test
    public void testSelectForSend() {
        List list = IntStream.range(0, this.nodeIds.size() * 10).mapToObj(i -> this.selector.selectForSend()).collect(Collectors.toList());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String nodeId : list) {
            Assert.assertTrue((boolean)this.nodeIds.contains(nodeId));
            counts.merge(nodeId, 1, Math::addExact);
        }
        Iterator<Object> iterator = counts.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            Assert.assertEquals((long)10L, (long)count);
        }
    }

    @Test
    public void testSelectForPublish() {
        for (int i = 0; i < 10; ++i) {
            Iterable iterable = this.selector.selectForPublish();
            List list = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
            Assert.assertTrue((boolean)this.nodeIds.containsAll(list));
            Assert.assertTrue((boolean)list.containsAll(this.nodeIds));
        }
    }
}

